package cn.quantgroup.qgblservice.repository.mybatis.entity.blacklist;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.*;


/**
 * -----------------------------------------------------------------------------<br>
 * 类描述: black_grey_list_result表实体 <br>
 * 创建人: yanhui.Hao <br>
 * 创建时间: 2020.04.14 20:43 <br>
 * 公司: 北京众信利民信息技术有限公司 <br>
 * -----------------------------------------------------------------------------
 */
@Data
public class BlackGreyListResult implements Serializable {

    private static final long serialVersionUID = 3504867579864272343L;

    private String rId;
    private String uuid;
    private String name;
    private String phoneNo;
    private String idNo;

    /**phoneNo md5加密*/
    private String phoneNoMd5;
    /**idNo md5加密*/
    private String idNoMd5;

    private String blackType;
    private String types;
    private String reasons;

    @JsonIgnore
    private Timestamp createdAt;
    @JsonIgnore
    private Timestamp updatedAt;



    public static Set<String> typesToSet(String oldTypesStr, String newType){
        Set<String> typesSet = null;
        try {
            if(StringUtils.isEmpty(oldTypesStr)) {
                typesSet = new HashSet<>();
            }else{
                String[] array = oldTypesStr.trim().split("[,]");
                typesSet = new HashSet<>(Arrays.asList(array));
            }
        }catch (Exception e){
            e.printStackTrace();
        }

        if(typesSet==null){
            typesSet = new HashSet<>();
        }
        typesSet.add(newType);
        return typesSet;
    }

    public static List<Reasons> reasonsToList(String oldJsonStr, String newReason, String newType){
        List<Reasons> reasonList = null;
        try {
            if(StringUtils.isNotEmpty(oldJsonStr)) {
                reasonList = JSONArray.parseArray(oldJsonStr, Reasons.class);
            }
        }catch (Exception e){
            e.printStackTrace();
        }

        if(reasonList==null){
            reasonList = new ArrayList<Reasons>();
        }

        int size = reasonList.size();
        if(size>=2){
            Reasons  back1 = reasonList.get(0);
            for(int i=1; i < size; i++){
                Reasons  tmp2 = reasonList.get(i);
                if(back1.getUtcTime() <= tmp2.getUtcTime()){
                    back1 = tmp2;
                }
            }
            reasonList = new ArrayList<Reasons>();
            reasonList.add(back1);
        }

        Reasons newObj = new Reasons();
        newObj.setReason(newReason);
        newObj.setType(newType);
        newObj.setUtcTime(System.currentTimeMillis());
        reasonList.add(newObj);
        return reasonList;
    }

}
