package cn.quantgroup.qgblservice.service.impl;

import cn.quantgroup.qgblservice.constant.Constant;
import cn.quantgroup.qgblservice.model.blacklist.BlackGreyListReasonConfig;
import cn.quantgroup.qgblservice.model.blacklist.ThirdPartBlackListConfigVo0;
import cn.quantgroup.qgblservice.repository.mybatis.entity.blacklist.BlackGreyListDetails;
import cn.quantgroup.qgblservice.repository.mybatis.entity.blacklist.BlackGreyListQueryVo;
import cn.quantgroup.qgblservice.repository.mybatis.entity.tidb.BlackListQueryTidbVo0;
import cn.quantgroup.qgblservice.repository.mybatis.entity.tidb.TmpBlackGreyList;
import cn.quantgroup.qgblservice.repository.mybatis.mapper.blacklist.BlackGreyListMapper;
import cn.quantgroup.qgblservice.response.GlobalResponse;
import cn.quantgroup.qgblservice.service.IBlackGreyListService;
import cn.quantgroup.qgblservice.service.IBlackListUpdateThreeEleService;
import cn.quantgroup.qgblservice.service.IThirdPartBlackListManagerService;
import cn.quantgroup.qgblservice.utils.MD5Util;
import cn.quantgroup.qgblservice.utils.blacklist.BlackListUtils;
import com.alibaba.fastjson.JSON;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

/**
 * 三方数据源黑名单管理保存
 *
 * @Author fengjunkai
 * @Date 2019-08-12 17:25
 */
@Slf4j
@Service
public class ThirdPartBlackListServiceImpl implements IThirdPartBlackListManagerService {

    @Autowired
    private JdbcTemplate blackListJdbcTemplate;
    @Autowired
    private IBlackListUpdateThreeEleService iBlackListUpdateThreeEleService;

    private static Map<String, String> thirdPartBlackListCacheConfigMap = new ConcurrentHashMap<>();
    private static Map<String, String> thirdPartBlackListMap = new ConcurrentHashMap<>();

    //2020.04.28 根据黑灰名单开源type，获取加入黑灰名单原因code
    public static Map<String, String> getReasonCodeByTypeMap = new ConcurrentHashMap<>();
    //2020.04.28 加入黑灰名单原因code，获取原因中文描述
    public static Map<String, String> getReasonExplainByReasonCodeMap = new ConcurrentHashMap<>();


    @Autowired
    private BlackGreyListMapper blackGreyListMapper;

    @Autowired
    private IBlackGreyListService blackGreyListService;

    @Override
    public GlobalResponse saveThirdPartBlackList(String uuid, String name, String phoneNo, String idCard, String type) {

        try {
            List<BlackListQueryTidbVo0> blackListQueryTidbVo0s = blackListJdbcTemplate.query(String.format(Constant.SQL.BLACK_LIST_NEW_QUERY_BY_UNIQUE_KEY_SQL,
                    phoneNo, name, idCard, thirdPartBlackListCacheConfigMap.get(type)), new BeanPropertyRowMapper<>(BlackListQueryTidbVo0.class));

            if (CollectionUtils.isNotEmpty(blackListQueryTidbVo0s)) {
                log.info("三方数据源黑名单已存在, uuid: {} , name: {} , phoneNo: {} , idCard: {} , size: {} ", uuid, name, phoneNo, idCard, blackListQueryTidbVo0s.size());
                for (int i = 0; i < blackListQueryTidbVo0s.size(); i++) {

                    BlackListQueryTidbVo0 blackListQueryTidbVo0 = blackListQueryTidbVo0s.get(i);
                    blackListQueryTidbVo0.setUpdatedAt(new Timestamp(System.currentTimeMillis()));
                    BlackListUtils.getOrUpdateBlackListLevel(blackListQueryTidbVo0, Constant.PARAM.BLACK_LIST_THIRD_PART);
                    blackListJdbcTemplate.update(String.format(Constant.SQL.BLACK_LIST_NEW_UPDATE_BLACK_LIST_LEVEL_SQL,  blackListQueryTidbVo0.getBlackLevel(), blackListQueryTidbVo0.getId()));

                }
                iBlackListUpdateThreeEleService.updateOrNoThreeElementsById(blackListQueryTidbVo0s, Constant.PARAM.BLACK_LIST_THIRD_PART);
            } else {
                saveThirdPartBlackListJdbc(uuid, name, phoneNo, idCard, type);
            }

            return GlobalResponse.success("保存成功");

        } catch (Exception e) {
            log.error("保存三方数据源黑名单异常, uuid: {} , name: {} , phoneNo: {} , idCard: {} ", uuid, name, phoneNo, idCard, e);
        }

        return GlobalResponse.error("保存异常");

    }


    public void saveThirdPartBlackListJdbc(String uuid, String name, String phoneNo, String idCard, String type) {

        Object param[] = new Object[12];
        param[0] = uuid;
        param[1] = name;
        param[2] = phoneNo;
        param[3] = idCard;
        param[4] = Constant.PARAM.BLACK_LIST_MAJAOR;
        param[5] = thirdPartBlackListCacheConfigMap.get(type);
        param[6] = Constant.PARAM.BLACK_LIST_LEVEL_D1;
        param[7] = thirdPartBlackListMap.get(type);
        param[8] = new Timestamp(System.currentTimeMillis());
        param[9] = new Timestamp(System.currentTimeMillis());
        //modify 2019.09.20 增加phone_no_md5、id_no_md5
        String phoneNo_md5 = null, idCard_md5 = null;
        if(StringUtils.isNotEmpty(phoneNo)){
            phoneNo_md5 = MD5Util.getMD5Digest(phoneNo);
        }
        if(StringUtils.isNotEmpty(idCard)){
            idCard_md5 = MD5Util.getMD5Digest(idCard);
        }
        param[10] = phoneNo_md5;
        param[11] = idCard_md5;

        //insert into `black_list_new` (`uuid`, `name`, `phone_no`, `id_no`, `major_type`, `type`, `black_level`, `join_black_reason`, `created_at`, `updated_at`,`phone_no_md5`,`id_no_md5`)
        // values (?, ?, ?, ?, ?, ?, ?, ?, ?, ? ,? ,?);
        int insert = blackListJdbcTemplate.update(Constant.SQL.BLACK_LIST_NEW_INSERT_THIRD_PART_BLACK_LIST_SQL, param);

        log.info("插入三方数据源黑名单结束, insert: {} , param: {} ", insert, JSON.toJSONString(param));
    }

    @PostConstruct
    public void initThirdPartBlackListConfig() {

        List<ThirdPartBlackListConfigVo0> thirdPartBlackListConfigVo0s = blackListJdbcTemplate.query(Constant.SQL.BLACK_LIST_NEW_QUERY_THIRD_PART_BLACK_LIST_CONFIG_SQL, new BeanPropertyRowMapper<>(ThirdPartBlackListConfigVo0.class));
        thirdPartBlackListCacheConfigMap = thirdPartBlackListConfigVo0s.stream().collect(Collectors.toMap(ThirdPartBlackListConfigVo0::getChannelType, ThirdPartBlackListConfigVo0::getType));
        thirdPartBlackListMap = thirdPartBlackListConfigVo0s.stream().collect(Collectors.toMap(ThirdPartBlackListConfigVo0::getChannelType, ThirdPartBlackListConfigVo0::getName));
        log.info("加载三方数据源黑名单配置完成, result: {} ", JSON.toJSONString(thirdPartBlackListCacheConfigMap));

        List<BlackGreyListReasonConfig> blackGreyListReasonConfigList = blackListJdbcTemplate.query(Constant.SQL.BLACK_GREY_LIST_REASON_CONFIG_SQL, new BeanPropertyRowMapper<>(BlackGreyListReasonConfig.class));
        getReasonCodeByTypeMap = blackGreyListReasonConfigList.stream().collect(Collectors.toMap(BlackGreyListReasonConfig::getType, BlackGreyListReasonConfig::getReasonCode));
        getReasonExplainByReasonCodeMap = blackGreyListReasonConfigList.stream().collect(Collectors.toMap(BlackGreyListReasonConfig::getReasonCode, BlackGreyListReasonConfig::getReasonExplain));
        log.info("加载三方数据源黑灰名单原因配置完成, map: {} ", JSON.toJSONString(getReasonCodeByTypeMap));
    }

    @Override
    public GlobalResponse saveThirdPartGreyList(String uuid, String name, String phoneNo, String idCard, String type) {

        //2020.04.26 历史黑名单继续写入，暂时未线下
        try {
            log.info("历史黑名单继续写入, uuid: {} , name: {} , phoneNo: {} , idCard: {} , type: {} ", uuid, name, phoneNo, idCard, type);
            saveThirdPartBlackList(uuid, name, phoneNo, idCard, type);
        }catch (Exception e){
            log.error("保存历史黑名单异常", e);
        }

        //根据三方数据源urlType获取黑灰名单来源type
        String typeCode = thirdPartBlackListCacheConfigMap.get(type);
        String reasonCode = getReasonCodeByTypeMap.get(typeCode);
        String reasonExplain = getReasonExplainByReasonCodeMap.get(reasonCode);
        log.info("插入黑灰名单入参, uuid: {} , name: {} , phoneNo: {} , idCard: {} , type: {} , typeCode: {} , reasonCode: {} , reasonExplain: {} ", uuid, name, phoneNo, idCard, type, typeCode, reasonCode, reasonExplain);
        if(org.apache.commons.lang3.StringUtils.isAnyEmpty(typeCode, reasonCode, reasonExplain)){
            log.error("插入黑灰名单时-未匹配到typeCode或reason! uuid: {} , name: {} , phoneNo: {} , idCard: {} , type: {} ", uuid, name, phoneNo, idCard, type);
            return GlobalResponse.error("参数type未匹配到typeCode!");
        }
        BlackGreyListQueryVo queryResultParam = BlackGreyListQueryVo.builder().name(name).idNo(idCard).phoneNo(phoneNo)
                .type(typeCode).status(0).build();

        //List<BlackGreyListDetails> detailsList = blackGreyListMapper.findBlackGreyListDetails(queryResultParam);
        List<BlackGreyListDetails> detailsList = blackGreyListMapper.findBlackGreyListDetailsBy3YS(queryResultParam);
        if(detailsList!=null && detailsList.size()>0){
            log.info("插入黑灰名单时-根据三要素及type查询明细表已存在,跳过插入! uuid: {} , name: {} , phoneNo: {} , idCard: {} , type: {} ", uuid, name, phoneNo, idCard, type);
        }else {

            TmpBlackGreyList blackGreyObj = new TmpBlackGreyList();
            blackGreyObj.setBlackType("2");//灰名单
            blackGreyObj.setType(typeCode);
            blackGreyObj.setReasonCode(reasonCode);
            blackGreyObj.setReasonExplain(reasonExplain);

            if(StringUtils.isNotEmpty(uuid)){
                blackGreyObj.setUuid(uuid);
            }
            if(StringUtils.isNotEmpty(name)){
                blackGreyObj.setName(name);
            }
            if(StringUtils.isNotEmpty(phoneNo)){
                blackGreyObj.setPhoneNo(phoneNo);
            }
            if(StringUtils.isNotEmpty(idCard)){
                blackGreyObj.setIdNo(idCard);
            }
            Timestamp createdAt = new Timestamp(System.currentTimeMillis());
            blackGreyObj.setCreatedAt(createdAt);
            blackGreyObj.setUpdatedAt(createdAt);

            try {
                List<TmpBlackGreyList> blackGreyList = new ArrayList<TmpBlackGreyList>();
                blackGreyList.add(blackGreyObj);
                int saveOkCount  = blackGreyListService.saveBlackGreyListByJdbc(blackGreyList);
                log.info("插入黑灰名单结束, uuid: {} , name: {} , phoneNo: {} , idCard: {} , type: {} , typeCode: {} , reasonCode: {} , reasonExplain: {} , insert: {} ", uuid, name, phoneNo, idCard, type, typeCode, reasonCode, reasonExplain, saveOkCount);
                return GlobalResponse.success("保存黑灰名单成功"+saveOkCount+"条");
            } catch (SQLException e) {
                log.error("保存黑灰名单数据异常", e);
            }
        }

        return GlobalResponse.error("保存异常");
    }

}
