package cn.quantgroup.qgblservice.controller;

import cn.quantgroup.qgblservice.response.GlobalResponse;
import cn.quantgroup.qgblservice.service.IBlackListImportService;
import cn.quantgroup.qgblservice.service.IBlackListManagerService;
import cn.quantgroup.qgblservice.service.IThirdPartBlackListManagerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 黑名单导入管理接口
 * black_type_list_new/black_type_idcard_new--->black_list
 *
 * @Author fengjunkai
 * @Date 2019-07-31 17:18
 */
@RestController
@RequestMapping("/")
public class BlackListImportManagerController {

    @Autowired
    private IBlackListImportService iBlackListImportManagerService;
    @Autowired
    private IBlackListManagerService iBlackListManagerService;
    @Autowired
    private IThirdPartBlackListManagerService iThirdPartBlackListManagerService;


    @RequestMapping("/phone_black_list_import_by_month")
    public GlobalResponse phoneBlackListImportByMonth(String startTime, String endTime) {
        return iBlackListImportManagerService.blackListPhoneImport(startTime, endTime);
    }

    @RequestMapping("/id_no_black_list_import_by_month")
    public GlobalResponse idNoBlackListImportByMonth(String startTime, String endTime){
        return iBlackListImportManagerService.blackListIdCardImport(startTime, endTime);
    }

    @RequestMapping("/third_part_black_list")
    public GlobalResponse thirdPartBlackList(String uuid, String name, String phoneNo, String idCard, String type){
        return iThirdPartBlackListManagerService.saveThirdPartBlackList(uuid, name, phoneNo, idCard, type);
    }

    @RequestMapping("/phone_black_list_test")
    public GlobalResponse phoneBlackListTest(String startTime, String endTime){
        iBlackListManagerService.blackListPhoneManagerByDay(startTime, endTime);
        return GlobalResponse.success();
    }

    @RequestMapping("/idcard_black_list_test")
    public GlobalResponse idcardBlackListTest(String startTime, String endTime){
        iBlackListManagerService.blackListIdCardManagerByDay(startTime, endTime);
        return GlobalResponse.success();
    }

    @RequestMapping("/black_list_real_time_test")
    public GlobalResponse blackListRealTimeTest(){
        iBlackListManagerService.blackListRealTimeManagerByDay();
        return GlobalResponse.success();
    }

    @RequestMapping("/manual_import_black_list")
    public GlobalResponse manualImport(String sourcePath){
        return iBlackListManagerService.manualImportBlackList(sourcePath);
    }

}
