#black_list_new 新黑名单表
CREATE TABLE `black_list_new` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `uuid` varchar(64) DEFAULT NULL COMMENT 'uuid',
  `name` varchar(60) DEFAULT NULL COMMENT '姓名',
  `phone_no` varchar(32) DEFAULT NULL COMMENT '手机号',
  `id_no` varchar(32) DEFAULT NULL COMMENT '身份证号',
  `major_type` varchar(4) DEFAULT NULL COMMENT '黑名单所属大类, 1.QG黑名单 2.P2P黑名单 3.机构黑名单 4.其他黑名单 5.白条黑名单',
  `type` varchar(4) DEFAULT NULL COMMENT '黑名单类型, 现金贷黑名单-1,白条黑名单-2,去哪儿黑名单-3,法院黑名单-4,线下黑名单-5,新颜套现黑名单-6,手机套现黑名单-8,环球黑卡黑名单-9,P2P黑名单-101,weshare黑名单-102,芝麻行业关注黑名单-103,其他小贷黑名单-104,企美黑名单-105,拿下分期黑名单-106,black_bank黑名单-201,考拉黑名单-202,black_car黑名单-203,前海黑名单-204,华融黑名单-205,人人信黑名单-206,同盾黑名单-207,大锤黑名单-208,国美黑名单-209,美借黑名单-210,快金黑名单-211,至诚阿福黑名单-218,算话黑名单-219,米么黑名单-212,手机贷黑名单-213,拍拍贷黑名单-214,掌众(闪电借款)黑名单-215,向前贷(明特量化)黑名单-216,齐立欣提供小贷渠道1黑名单-217,black_dispute黑名单-301,白条套现黑名单-401,马上闹事群众黑名单-501',
  `total_overdue_days` varchar(10) DEFAULT NULL COMMENT '首期逾期天数',
  `max_overdue_days` varchar(10) DEFAULT NULL COMMENT '最大逾期天数',
  `black_level` varchar(10) DEFAULT NULL,
  `join_black_reason` varchar(100) DEFAULT NULL COMMENT '加入黑名单原因',
  `status` tinyint(2) DEFAULT '1' COMMENT '当前黑名单是否生效, 1-生效 0-失效',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '加入黑名单时间',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '黑名单更新时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`,`phone_no`,`id_no`,`type`),
  KEY `index_uuid` (`uuid`),
  KEY `index_name` (`name`),
  KEY `index_phone_no` (`phone_no`),
  KEY `index_id_no` (`id_no`),
  KEY `index_created_at` (`created_at`),
  KEY `index_updated_at` (`updated_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='最新黑名单整合表';

#black_list_channel_expire_config 渠道黑名单有效期表
CREATE TABLE `black_list_channel_expire_config` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `type` varchar(10) NOT NULL DEFAULT '' COMMENT '黑名单渠道类型比如: 219-算话 218-至诚阿福',
  `channel_name` varchar(60) NOT NULL COMMENT '渠道名称',
  `expire_time` int(10) DEFAULT '20' COMMENT '渠道黑名单有效期, 默认20年',
  `status` tinyint(2) DEFAULT '1' COMMENT '当前黑名单是否生效, 1-生效 0-失效',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `index_uuid` (`type`),
  KEY `index_channel_name` (`channel_name`),
  KEY `index_expire_time` (`expire_time`),
  KEY `index_created_at` (`created_at`),
  KEY `index_updated_at` (`updated_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='黑名单渠道有效期配置表';
INSERT INTO `black_list_channel_expire_config` (`type`, `channel_name`, `expire_time`, `status`, `created_at`, `updated_at`)
VALUES
	('1', '现金分期黑名单', 20, 1, '2019-08-14 14:44:56', '2019-08-14 14:44:56'),
	('2', '白条黑名单', 20, 1, '2019-08-14 14:51:30', '2019-08-14 14:51:30'),
	('3', '去哪儿黑名单', 20, 1, '2019-08-14 14:51:40', '2019-08-14 14:51:40'),
	('4', '法院黑名单', 20, 1, '2019-08-14 14:51:50', '2019-08-14 14:51:50'),
	('5', '线下黑名单', 20, 1, '2019-08-14 14:52:00', '2019-08-14 14:52:00'),
	('6', '新颜套现黑名单', 20, 1, '2019-08-14 14:52:08', '2019-08-14 14:52:08'),
	('8', '手机套现黑名单', 20, 1, '2019-08-14 14:52:17', '2019-08-14 14:52:17'),
	('9', '环球黑卡黑名单', 20, 1, '2019-08-14 14:52:28', '2019-08-14 14:52:28'),
	('101', 'P2P黑名单', 20, 1, '2019-08-14 14:52:37', '2019-08-14 14:52:37'),
	('102', 'weshare黑名单', 20, 1, '2019-08-14 14:52:47', '2019-08-14 14:52:47'),
	('103', '芝麻行业关注黑名单', 20, 1, '2019-08-14 14:52:55', '2019-08-14 14:52:55'),
	('104', '其他小贷黑名单', 20, 1, '2019-08-14 14:53:03', '2019-08-14 14:53:03'),
	('105', '企美黑名单', 20, 1, '2019-08-14 14:53:11', '2019-08-14 14:53:11'),
	('106', '拿下分期黑名单', 20, 1, '2019-08-14 14:53:18', '2019-08-14 14:53:18'),
	('201', 'black_bank黑名单', 20, 1, '2019-08-14 14:53:28', '2019-08-14 14:53:28'),
	('202', '考拉黑名单', 20, 1, '2019-08-14 14:53:34', '2019-08-14 14:53:34'),
	('203', 'black_car黑名单', 20, 1, '2019-08-14 14:53:43', '2019-08-14 14:53:43'),
	('204', '前海黑名单', 20, 1, '2019-08-14 14:53:50', '2019-08-14 14:53:50'),
	('205', '华融黑名单', 20, 1, '2019-08-14 14:53:58', '2019-08-14 14:53:58'),
	('206', '人人信黑名单', 20, 1, '2019-08-14 14:54:06', '2019-08-14 14:54:06'),
	('207', '同盾黑名单', 20, 1, '2019-08-14 14:54:14', '2019-08-14 14:54:14'),
	('208', '大锤黑名单', 20, 1, '2019-08-14 14:54:21', '2019-08-14 14:54:21'),
	('209', '国美黑名单', 20, 1, '2019-08-14 14:54:28', '2019-08-14 14:54:28'),
	('210', '美借黑名单', 20, 1, '2019-08-14 14:54:35', '2019-08-14 14:54:35'),
	('211', '快金黑名单', 20, 1, '2019-08-14 14:54:42', '2019-08-14 14:54:42'),
	('218', '至诚阿福黑名单', 20, 1, '2019-08-14 14:54:49', '2019-08-14 14:54:49'),
	('219', '算话黑名单', 20, 1, '2019-08-14 14:54:56', '2019-08-14 14:54:56'),
	('212', '米么黑名单', 20, 1, '2019-08-14 14:55:02', '2019-08-14 14:55:02'),
	('213', '手机贷黑名单', 20, 1, '2019-08-14 14:55:09', '2019-08-14 14:55:09'),
	('214', '拍拍贷黑名单', 20, 1, '2019-08-14 14:55:17', '2019-08-14 14:55:17'),
	('215', '掌众(闪电借款)黑名单', 20, 1, '2019-08-14 14:55:29', '2019-08-14 14:55:29'),
	('216', '向前贷(明特量化)黑名单', 20, 1, '2019-08-14 14:55:39', '2019-08-14 14:55:39'),
	('217', '齐立欣提供小贷渠道1黑名单', 20, 1, '2019-08-14 14:55:58', '2019-08-14 14:55:58'),
	('301', 'black_dispute黑名单', 20, 1, '2019-08-14 14:56:06', '2019-08-14 14:56:06'),
	('401', '白条套现黑名单', 20, 1, '2019-08-14 14:56:11', '2019-08-14 14:56:11'),
	('501', '马上闹事群众黑名单', 20, 1, '2019-08-14 14:56:21', '2019-08-14 14:56:21');



#third_part_black_list_config 三方数据源黑名单配置表
CREATE TABLE `third_part_black_list_config` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `type` varchar(10) DEFAULT NULL COMMENT '渠道黑名单type比如算话218, 至诚阿福219...',
  `name` varchar(60) DEFAULT NULL COMMENT '渠道黑名单名称',
  `channel_type` varchar(255) DEFAULT NULL COMMENT '渠道类型, 三方数据源request_url_type',
  `status` tinyint(2) DEFAULT '1' COMMENT '当前黑名单是否生效, 1-生效 0-失效',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `index_channel_type` (`channel_type`),
  KEY `index_type` (`type`),
  KEY `index_created_at` (`created_at`),
  KEY `index_updated_at` (`updated_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='三方数据源黑名单渠道配置表';
INSERT INTO `third_part_black_list_config` (`name`, `channel_type`, `status`, `created_at`, `updated_at`)
VALUES
	('算话', 'SuanHuaRisk', 1, '2019-08-13 11:58:57', '2019-08-13 11:58:57'),
	('至诚阿福', 'ZhiChengAFuAntiFraud', 1, '2019-08-13 11:59:35', '2019-08-13 11:59:35');
