package cn.quantgroup.qgblservice.controller;

import cn.quantgroup.qgblservice.response.GlobalResponse;
import cn.quantgroup.qgblservice.service.IBlackListToolsManagerService;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableMap;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.management.StringValueExp;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

/**
 * -----------------------------------------------------------------------------<br>
 * 描述: 黑名单表操作工具类<br>
 * 作者：yanhui.Hao <br>
 * 时间：2019.09.19 <br>
 * 授权: (C) Copyright (c) 2017 <br>
 * 公司: 北京众信利民信息技术有限公司 <br>
 * -----------------------------------------------------------------------------
 */
@Slf4j
@RestController
@RequestMapping("/tools")
public class BlackListToolsManagerController {

    @Autowired
    private IBlackListToolsManagerService iBlackListToolsManagerService;

    /**
     * @param filePath 原文件地址
     * @param titleNames 表格的头部标题，已逗号分隔
     * @param haveTitle 非必传，默认true；是否有标题列
     * @param byColumnName 查询类别，目前可以传idcard或mobile；name暂不支持
     * @param columnDataType 非必传，默认空“明文数据”，或可传值"MD5"；Excel表格里的byColumn数据类别
     * @return
     */
    @RequestMapping("/compareByExcel")
    public GlobalResponse compareByExcel(String filePath,String titleNames, String haveTitle, String byColumnName,String columnDataType){
        return iBlackListToolsManagerService.compareByExcel(filePath,titleNames,haveTitle,byColumnName,columnDataType);
    }


    /**
     * @param privateKey 私钥
     * @param operatType 操作类型，支持all,byId,byCreatUtc
     * @param idArray operatType=byId时必传，多个以逗号分隔
     * @param gtCreatUtc operatType=byCreatUtc时必传
     * @return
     */
    @RequestMapping("/buildMd5Tools")
    public GlobalResponse buildMd5Tools(String privateKey,String operatType, String idArray, String gtCreatUtc){
        return iBlackListToolsManagerService.buildMd5Tools(privateKey,operatType,idArray,gtCreatUtc);
    }

    @RequestMapping("/cleanTableData")
    public GlobalResponse cleanTableData(String privateKey,String operatType){
        if(StringUtils.isNotEmpty(privateKey) && "aHVhdDI0V0JvT3hwTkJwQmk1d2Q4dz09".equals(privateKey)){
            if(StringUtils.isEmpty(operatType)){
                return GlobalResponse.error("cleanTableData参数为空！");
            }

            iBlackListToolsManagerService.cleanTableData(privateKey,operatType);
            return GlobalResponse.success("copyBlackList任务调度成功");
        }else{
            return GlobalResponse.error("cleanTableData私钥为空或不正确，请联系管理员！");
        }
    }

    @Autowired
    private RedisTemplate<String,String> redisTemplate;

    @RequestMapping("/deleteRedisKey")
    public Map<String,Object> deleteRedisKey(String key1, String key2, String key3){
        try{
            String full_rediskey = "";
            if (org.apache.commons.lang3.StringUtils.isNotEmpty(key1)) {
                full_rediskey += key1;
            }
            if (org.apache.commons.lang3.StringUtils.isNotEmpty(key2)) {
                full_rediskey += key2;
            }
            if (org.apache.commons.lang3.StringUtils.isNotEmpty(key3)) {
                full_rediskey += key3;
            }
            redisTemplate.delete(full_rediskey);
            log.info("删除RedisKey成功, key1: {} , key2: {} , key3: {} , full_rediskey: {} ", key1, key2, key3, full_rediskey);
            return ImmutableMap.of("code", 0, "msg", "手动删除redisKey成功");
        }catch(Exception e){
            return ImmutableMap.of("code", 1, "msg", "手动设置redisKey异常");
        }
    }

    @RequestMapping("/getRedisVal")
    public String getRedisVal(String key){
        try{
            Map<String,Object> map = new HashMap<>();
            map.put("key",key);
            if(org.apache.commons.lang3.StringUtils.isBlank(key)){
                return JSONObject.toJSONString(map);
            }
            try{
                String value = redisTemplate.opsForValue().get(key);
                Long expire = redisTemplate.getExpire(key);
                map.put("value",value);
                map.put("expire", expire);
            }catch (Exception e){
                log.error("获取redis里值异常, key: {} ", key, e);
            }
            return map.toString();
        }catch(Exception e){
            return "获取redis值异常";
        }
    }

    @RequestMapping("/setRedisVal")
    public String setRedisVal(String key, String value, String tmie){
        if(org.apache.commons.lang3.StringUtils.isAnyBlank(key, value, tmie)){
            return ImmutableMap.of("code", 1, "msg", "手动设置redisKey参数不能为空").toString();
        }
        try{
            redisTemplate.opsForValue().set(key, value, Long.parseLong(tmie), TimeUnit.MINUTES);
            return ImmutableMap.of("code", 0, "msg", "手动设置redisKey成功").toString();
        }catch (Exception e){
            log.error("获取redis里值异常, key: {} ", key, e);
            return ImmutableMap.of("code", 1, "msg", "手动设置redisKey异常").toString();
        }
    }

}
