package cn.quantgroup.qgblservice.job.blimport;

import cn.quantgroup.qgblservice.constant.Constant;
import cn.quantgroup.qgblservice.service.IBlackListManagerService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.util.concurrent.TimeUnit;

/**
 * 量化派黑名单导入整理至新表任务
 *
 * @Author fengjunkai
 * @Date 2019-07-31 17:13
 */
@Slf4j
@Component
public class BlackListImportManagerJob {

    @Autowired
    private RedisTemplate<String,String> redisTemplate;

    @Autowired
    private IBlackListManagerService iBlackListManagerService;

    @Scheduled(cron = "0 0 4 * * ?")
    public void blackListImportJob() {

        try {

            if(increment()){

                redisTemplate.expire(Constant.REDIS_KEY.BLACK_LSIT_JOB_INCREMENT_KEY, 10, TimeUnit.SECONDS);
                iBlackListManagerService.blackListRealTimeManagerByDay();
            }

        } catch (Exception e) {
            log.error("每天导入近5天逾期(15+)用户黑名单异常", e);
        }

    }

    public Boolean increment(){

        Long increment = redisTemplate.opsForValue().increment(Constant.REDIS_KEY.BLACK_LSIT_JOB_INCREMENT_KEY, 1);

        return increment <= 1;

    }

}
