package cn.quantgroup.qgblservice.config.xyqbuser;

import cn.quantgroup.qgblservice.config.blacklist.BlackListProperties;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

import javax.sql.DataSource;

/**
 * @Author fengjunkai
 * @Date 2019-07-02 11:58
 */
@Import({XyqbUserProperties.class})
@MapperScan(basePackages = XyqbUserSourceConfig.PACKAGE, sqlSessionFactoryRef = "xyqbUserSqlSessionFactory")
@Configuration
public class XyqbUserSourceConfig {

    static final String PACKAGE = "cn.quantgroup.qgblservice.repository.mybatis.mapper.xyqbuser";

    @Value("${xyqb.user.mapper-locations}")
    private String mapperLocations;
    @Value("${xyqb.user.type-aliases-package}")
    private String typeAliasesPackage;
    @Value("${xyqb.user.config-location}")
    private String configLocation;

    @Autowired
    private XyqbUserProperties xyqbUserProperties;

    @Bean(name = "dataSource")
    public DataSource xyqbUserDataSource() {
        HikariConfig config = new HikariConfig();
        config.setJdbcUrl(xyqbUserProperties.getJdbcUrl());
        config.setPassword(xyqbUserProperties.getPassword());
        config.setUsername(xyqbUserProperties.getUsername());
        config.setMaximumPoolSize(xyqbUserProperties.getMaxPoolSize());
        config.setMinimumIdle(xyqbUserProperties.getMinPoolSize());
        config.addDataSourceProperty("cachePrepStmts", "true");
        config.addDataSourceProperty("prepStmtCacheSize", "250");
        config.addDataSourceProperty("prepStmtCacheSqlLimit", "2048");
        return new HikariDataSource(config);
    }

    @Bean(name = "xyqbUserSqlSessionFactory")
    public SqlSessionFactory xyqbUserSqlSessionFactory(@Qualifier("dataSource") DataSource dataSource) throws Exception {
        final SqlSessionFactoryBean sessionFactory = new SqlSessionFactoryBean();
        sessionFactory.setDataSource(dataSource);
        sessionFactory.setMapperLocations(new PathMatchingResourcePatternResolver().getResources(mapperLocations));
        sessionFactory.setTypeAliasesPackage(typeAliasesPackage);
        sessionFactory.setConfigLocation(new PathMatchingResourcePatternResolver().getResource(configLocation));
        return sessionFactory.getObject();
    }

    @Bean(name = "xyqbUserSqlSessionTemplate")
    public SqlSessionTemplate xyqbUserSqlSessionTemplate(@Qualifier("xyqbUserSqlSessionFactory") SqlSessionFactory sqlSessionFactory) throws Exception {
        return new SqlSessionTemplate(sqlSessionFactory);
    }

}
