package cn.quantgroup.qgblservice.response;

/**
 * 统一输出实体
 *
 * @Author fengjunkai
 * @Date 2019-07-31 17:22
 */
public class GlobalResponse {

    private int code;
    private String businessCode;
    private String msg;
    private Object body;

    public GlobalResponse() {

    }

    private GlobalResponse(Object object) {
        body = object;
        code = 0;
        msg = "";
    }

    private GlobalResponse(int code, String msg, Object object) {
        this.body = object;
        this.code = code;
        this.msg = msg;
    }

    private GlobalResponse(int code, String businessCode, String msg, Object object) {
        this.code = code;
        this.businessCode = businessCode;
        this.msg = msg;
        this.body = object;
    }

    public static GlobalResponse success() {
        return new GlobalResponse(0, "success", null);
    }

    public static GlobalResponse success(String msg) {
        return new GlobalResponse(0, msg, null);
    }

    public static GlobalResponse success(Object data) {
        return new GlobalResponse(0, "success", data);
    }

    public static GlobalResponse create(String businessCode, String msg, Object object) {
        return new GlobalResponse(0, businessCode, msg, object);
    }

    public static GlobalResponse error(String msg) {
        return new GlobalResponse(1, msg, null);
    }

    public static GlobalResponse error(int code, Object data) {
        return new GlobalResponse(code, null, data);
    }

    public static GlobalResponse generate(Object o) {
        return new GlobalResponse(o);
    }

}
