package cn.quantgroup.qgblservice.service.impl;

import cn.quantgroup.qgblservice.constant.Constant;
import cn.quantgroup.qgblservice.repository.mybatis.entity.tidb.BlackListQueryByThreeEleParam0;
import cn.quantgroup.qgblservice.repository.mybatis.entity.tidb.BlackListQueryTidbParam0;
import cn.quantgroup.qgblservice.repository.mybatis.entity.tidb.BlackListQueryTidbVo0;
import cn.quantgroup.qgblservice.repository.mybatis.mapper.tidb.BlackListQueryTidbMapper;
import cn.quantgroup.qgblservice.service.IBlackListManagerService;
import cn.quantgroup.qgblservice.utils.jdbc.JdbcExecuters;
import com.alibaba.fastjson.JSON;
import com.google.common.base.Stopwatch;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

/**
 * @Author fengjunkai
 * @Date 2019-08-05 16:43
 */
@Slf4j
@Service
public class BlackListManagerServiceImpl implements IBlackListManagerService {

    @Autowired
    private BlackListQueryTidbMapper blackListQueryTidbMapper;
    @Autowired
    private JdbcTemplate blackListJdbcTemplate;

    @Override
    public void blackListPhoneManager(String startTime, String endTime) {

        Stopwatch queryPhoneStopwatch = Stopwatch.createStarted();
        List<BlackListQueryTidbVo0> blackListQueryTidbVo0s = blackListQueryTidbMapper.findBlackListPhoneByTime(BlackListQueryTidbParam0.builder().startTime(startTime).endTime(endTime).build());
        log.info("手机黑名单查询 {} --- {} 结果size: {} , 耗时: {} ", startTime, endTime, blackListQueryTidbVo0s.size(), queryPhoneStopwatch.stop().elapsed(TimeUnit.MILLISECONDS));

        blackListQueryTidbVo0s.forEach(blackListQueryTidbVo0 -> {
            List<BlackListQueryTidbVo0> blackListByPhone = blackListQueryTidbMapper.findBlackListByPhone(BlackListQueryByThreeEleParam0.builder().phone(blackListQueryTidbVo0.getPhoneNo()).build());
            updatedThreeElementsById(blackListByPhone, blackListQueryTidbVo0);
        });

        Stopwatch executeInsertPhoneStopwatch = Stopwatch.createStarted();
        JdbcExecuters.batchExecute(blackListQueryTidbVo0s, Constant.SQL.BATCH_INSERT_BLACK_PHONE_LIST_SQL, blackListJdbcTemplate);
        log.info("手机黑名单入库 {} --- {} 入库size: {} , 耗时: {} ", startTime, endTime, blackListQueryTidbVo0s.size(), executeInsertPhoneStopwatch.stop().elapsed(TimeUnit.MILLISECONDS));

    }

    @Override
    public void blackListIdCardManager(String startTime, String endTime) {

        Stopwatch queryStopwatch = Stopwatch.createStarted();
        List<BlackListQueryTidbVo0> blackListQueryTidbVo0s = blackListQueryTidbMapper.findBlackListPhoneByTime(BlackListQueryTidbParam0.builder().startTime(startTime).endTime(endTime).build());
        log.info("身份证黑名单查询 {} --- {} 结果size: {} , 耗时: {} ", startTime, endTime, blackListQueryTidbVo0s.size(), queryStopwatch.stop().elapsed(TimeUnit.MILLISECONDS));

        blackListQueryTidbVo0s.forEach(blackListQueryTidbVo0 -> {
            List<BlackListQueryTidbVo0> blackListByIdCard = blackListQueryTidbMapper.findBlackListByIdcard(BlackListQueryByThreeEleParam0.builder().idCard(blackListQueryTidbVo0.getIdNo()).build());
            updatedThreeElementsById(blackListByIdCard, blackListQueryTidbVo0);
        });

        Stopwatch executeInsertStopwatch = Stopwatch.createStarted();
        JdbcExecuters.batchExecute(blackListQueryTidbVo0s, Constant.SQL.BATCH_INSERT_BLACK_PHONE_LIST_SQL, blackListJdbcTemplate);
        log.info("身份证黑名单入库 {} --- {} 入库size: {} , 耗时: {} ", startTime, endTime, blackListQueryTidbVo0s.size(), executeInsertStopwatch.stop().elapsed(TimeUnit.MILLISECONDS));

    }

    public void updatedThreeElementsById(List<BlackListQueryTidbVo0> blackListByPhones, BlackListQueryTidbVo0 blackListQueryTidbVo0){

        if (CollectionUtils.isNotEmpty(blackListByPhones)) {
            for(int i=0;i<blackListByPhones.size();i++){

                BlackListQueryTidbVo0 blacklist = blackListByPhones.get(i);
                if(StringUtils.isAnyBlank(blacklist.getIdNo(), blacklist.getName(), blacklist.getPhoneNo())){

                    if (StringUtils.isBlank(blacklist.getIdNo()) && StringUtils.isNotBlank(blackListQueryTidbVo0.getIdNo())) {
                        blacklist.setIdNo(blackListQueryTidbVo0.getIdNo());
                    }

                    if (StringUtils.isBlank(blacklist.getName()) && StringUtils.isNotBlank(blackListQueryTidbVo0.getName())) {
                        blacklist.setName(blackListQueryTidbVo0.getName());
                    }

                    if(StringUtils.isBlank(blacklist.getUuid()) && StringUtils.isNotBlank(blackListQueryTidbVo0.getUuid())){
                        blacklist.setUuid(blackListQueryTidbVo0.getUuid());
                    }

                    blacklist.setCreatedAt(blackListQueryTidbVo0.getCreatedAt());
                    blacklist.setUpdatedAt(blackListQueryTidbVo0.getUpdatedAt());
                    blackListQueryTidbMapper.updateThreeElementsById(blacklist);
                }

            }
        }
    }

}
