package cn.quantgroup.qgblservice.job.blimport;

import cn.quantgroup.qgblservice.service.IBlackListManagerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

/**
 * 量化派黑名单导入整理至新表任务
 *
 * @Author fengjunkai
 * @Date 2019-07-31 17:13
 */
@Component
public class BlackListImportManagerJob {

    @Autowired
    private IBlackListManagerService iBlackListManagerService;

//    @Scheduled(cron = "0 0 6 * * ?")
    public void blackListImportJob(){

        String startTime = LocalDateTime.now().format(DateTimeFormatter.ISO_DATE);
        String endTime = LocalDateTime.now().minusDays(1).format(DateTimeFormatter.ISO_DATE);

        iBlackListManagerService.blackListPhoneManager(startTime, endTime);

        iBlackListManagerService.blackListIdCardManager(startTime, endTime);

    }

    public static void main(String[] args) {

    }

}
