package cn.quantgroup.report.service.common;

import cn.quantgroup.report.ApplicationContextHolder;
import cn.quantgroup.report.constant.TransactionCodeEnum;
import cn.quantgroup.report.response.GlobalResponse;
import cn.quantgroup.report.service.CommonSuperService;
import cn.quantgroup.report.service.common.model.CommonParams;
import cn.quantgroup.report.utils.IdUtils;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableMap;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.*;

/**
 * Created by fengjunkai on 2018/8/31 0031 上午 11:51
 **/
@Slf4j
@Service
public class CommonQueryService implements CommonSuperService {


    private ThreadPoolExecutor TASK_POOL = new ThreadPoolExecutor(50, 1000, 200L, TimeUnit.MILLISECONDS, new SynchronousQueue<>());


    @Deprecated
    public Object commonQuery(String source_types, String inUuid, String name, String phone, String identity, String backDate, String business_type, String order_id, boolean isReadCache) {
        log.info("三方数据源统一查询接口, 入参, inUuid: {} ,sourceType:{}, businessType:{} , orderId:{}, isReadCache: {} ", inUuid, source_types, business_type, order_id, isReadCache);

        String transactionId = IdUtils.getUuid();
        Map<String, Object> resultMap = new ConcurrentHashMap<>();
        try {
            if (StringUtils.isAnyBlank(source_types, inUuid) && StringUtils.isBlank(name) && StringUtils.isBlank(phone) && StringUtils.isBlank(identity)) {
                return ImmutableMap.of("transactionId", transactionId, "code", 201, "message", "参数不能为空" + "sourceType:" + source_types);
            }

            CommonParams commonParams = null;
            String uuid = "";
            Map<String, String> mapping = new ConcurrentHashMap<>();

            CountDownLatch countDownLatch = new CountDownLatch(mapping.size());
            CommonParams params = commonParams;
            mapping.forEach((methodName, serviceName) -> {
                log.info("TASK_POOL ActiveCount : {} , Task Queue size : {} ", TASK_POOL.getActiveCount(), TASK_POOL.getQueue().size());
                TASK_POOL.execute(() -> {
                    try {
                        String serviceNameO1 = serviceName.split(":")[0];
                        String keysO1 = serviceName.split(":")[1];
                        execute(transactionId, serviceNameO1, methodName, resultMap, params, keysO1, backDate, isReadCache);
                    } catch (Exception e) {
                        log.error("三方数据源统一查询接口, 异常, uuid: {} , sourceType:{}, keys:{}", uuid, serviceName.split(":")[0], serviceName.split(":")[1], e);
                    } finally {
                        countDownLatch.countDown();
                    }
                });
            });
            countDownLatch.await(60, TimeUnit.SECONDS);
            if (resultMap.size() > 0) {
                return ImmutableMap.of("code", 200, "message", "查询成功", "data", resultMap);
            } else {
                return ImmutableMap.of("code", 500, "message", "查询异常", "data", resultMap);
            }
        } catch (Exception e) {
            return ImmutableMap.of("code", 500, "message", "查询异常", "data", resultMap);
        }
    }


    private void execute(String transactionId, String serviceName, String methodName, Map<String, Object> resultMap, CommonParams userFullInfo, String keys, String backDate, boolean isReadCache) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        String uuid = userFullInfo.getUuid();
        CommonSuperService superService = ApplicationContextHolder.getBean(serviceName);
        Object resultObject = superService.getClass().getMethod(methodName, String.class, String.class, String.class, String.class, String.class, boolean.class)
                .invoke(superService, transactionId, userFullInfo.getIdNo(), userFullInfo.getPhoneNo(), userFullInfo.getName(), uuid, isReadCache);
        GlobalResponse globalResponse = (GlobalResponse) resultObject;
        Object object = globalResponse.getBody();
        boolean flag = globalResponse.getTransactionResult().stream().filter(o -> (o != null) && TransactionCodeEnum.Fail.equals(o.getTansactionCode())).count() > 0;

        if (object != null) {
            JSONObject jsonObject = (JSONObject) object;
            Integer riskScore = jsonObject.getIntValue("riskScore");
            Map<String, Object> bodyMap = new HashMap<>();
            bodyMap.put("value", riskScore);
            bodyMap.put("state", 200);
            resultMap.put("tencent_risk_ riskScore", bodyMap);
        } else {
           /* if (flag && !isReadCache) {
                putErrorBodyByserviceName(uuid, resultMap, serviceName, methodName);
            } else if (flag && isReadCache) {
                putTestErrorBody(resultMap, serviceName);
            } else {
                put400Body(resultMap, serviceName);
            }*/
        }
    }

}