package cn.quantgroup.report.mapper.baihang;

import cn.quantgroup.report.domain.baihang.ApplyLoanInfoZhuDai;
import cn.quantgroup.report.domain.baihang.BaiHangTimeRecord;
import cn.quantgroup.report.domain.baihang.FundingCorpInfo;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * -----------------------------------------------------------------------------<br>
 * 描述: 贷款申请信息查询mapper <br>
 * 作者：yanhui.Hao <br>
 * 时间：2019.11.06 <br>
 * 授权: (C) Copyright (c) 2017 <br>
 * 公司: 北京众信利民信息技术有限公司 <br>
 * -----------------------------------------------------------------------------
 */
@Repository
public interface ApplyLoanInfoMapper {

    //广达小贷-申请实时
    //List<ApplyLoanInfo> findApplyLoanInfo();

    //广达小贷-申请存量
    //List<ApplyLoanInfo> findStockApplyLoanInfo();




    /**
     * 描述: 百行-助贷申请存量数据 <br/>
     * 参数:  日期 BaiHangTimeRecord: startTime和endsTime <br/>
     * 返回值:   <br/>
     * 创建人: yanhui.Hao  <br/>
     * 创建时间: 2019.10.23  <br/>
     */
    @Deprecated
    List<ApplyLoanInfoZhuDai> queryStockApplyLoanInfoZhuDai(BaiHangTimeRecord baiHangTimeRecord);


    /**
     * 描述: 1.1百行助贷-非联合贷 实时申请 <br/>
     * 参数:  日期 BaiHangTimeRecord: startTime和endsTime <br/>
     * 返回值:   <br/>
     * 创建人: yanhui.Hao  <br/>
     * 创建时间: 2019.10.28  <br/>
     */
    List<ApplyLoanInfoZhuDai> findRealTimeApplyLoanZhuDai(BaiHangTimeRecord timeRecord);

    /**
     * 描述: 1.2百行助贷-联合贷 实时申请 <br/>
     * 参数:  日期 BaiHangTimeRecord: startTime和endsTime <br/>
     * 返回值:   <br/>
     * 创建人: yanhui.Hao  <br/>
     * 创建时间: 2019.10.28  <br/>
     */
    List<ApplyLoanInfoZhuDai> findRealTimeApplyLoanZhuDaiLh(BaiHangTimeRecord timeRecord);


    List<FundingCorpInfo> findFundingCorpInfo(List<Integer> list);


    List<ApplyLoanInfoZhuDai> findApplyInfoOfRefuse(BaiHangTimeRecord timeRecord);


    List<ApplyLoanInfoZhuDai> findApplyLoanZhuDai(BaiHangTimeRecord timeRecord);

}
