package cn.quantgroup.report.service.manualTool;


import cn.quantgroup.report.ApplicationContextHolder;
import cn.quantgroup.report.config.aop.DistributedLock;
import cn.quantgroup.report.config.aop.Monitor;
import cn.quantgroup.report.config.aop.MonitorType;
import cn.quantgroup.report.domain.baihang.*;
import cn.quantgroup.report.mapper.baihang.LoanInfoMapper;
import cn.quantgroup.report.mapper.master.RepaymentLoanInfoDbMapper;
import cn.quantgroup.report.response.GlobalResponse;
import cn.quantgroup.report.service.CommonSuperService;
import cn.quantgroup.report.service.baihang.util.TuoMinUtils;
import cn.quantgroup.report.utils.IdUtils;
import cn.quantgroup.report.utils.ReadOrWriteTxt;
import cn.quantgroup.report.utils.commonutil.AesCrypto;
import cn.quantgroup.report.utils.commonutil.Base64;
import cn.quantgroup.report.utils.commonutil.MD5Util;
import cn.quantgroup.report.utils.commonutil.RSAEncrypt;
import cn.quantgroup.report.utils.http.HttpRequestUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.*;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * -----------------------------------------------------------------------------<br>
 * 描述: <br>
 * 作者: Administrator <br>
 * 时间: 2019.09.24 10:34 <br>
 * 授权: (C) Copyright (c) 2017 <br>
 * 公司: 北京众信利民信息技术有限公司 <br>
 * -----------------------------------------------------------------------------
 */
@Slf4j
@Service
public class ManualToolService implements CommonSuperService {

    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");

    @Autowired
    private RepaymentLoanInfoDbMapper repaymentLoanInfoDbMapper;

    @Autowired
    private LoanInfoMapper loanInfoMapper;

    //@Autowired
    //private PinTaiCreditScoreService pinTaiCreditScoreService;


    private ShellUtils executeCommand = null;
    private static final String P1_48MD5_01 = "120a97b4b73c440413933351a2db2512fc7698f157b5c60d";
    private static final String P1_48MD5_02 = "85b61d877f6ce41c4cc72413f6766ae6876405f06b607b02";
    private static final String P2_48MD5 = "d4893490905d534e6fc1512ba6619d14df8c312362589342";
    private static final String P3_48MD5 = "57971a003213360c6fa09f4b257d5eb5441ba97a5450aa63";

    private static String RSA_PRIVATEKEY = null;

    static {
        RSA_PRIVATEKEY = readRSAPrivateKey("/manualTool/rsa_private_key.pem");
    }


    @Monitor({MonitorType.EXCEPTION, MonitorType.FEE, MonitorType.HIT, MonitorType.RESULT})
    @DistributedLock
    public GlobalResponse sendBaiHangData(String p1, String p2, String p3, String p4, String p5, String secretKey, String isSend,String errorCode) {
        StringBuffer resultMsg = new StringBuffer();
        log.info("ManualToolService.sendBaiHangData Start>>>>>>");
        String base_path = "/home/quant_group/risk-datasource/data";
        String base_url = "http://172.20.1.92:9020/ex/re_send";

        if (StringUtils.isBlank(RSA_PRIVATEKEY)) {
            return new GlobalResponse("1012", "参数错误");
        }
        if (StringUtils.isBlank(secretKey)) {
            return new GlobalResponse("1012", "参数错误");
        }
        if (StringUtils.isAnyBlank(p1, p2, p3)) {
            return new GlobalResponse("1012", "参数错误");
        }

        try {
            String aes_key = RSAEncrypt.decrypt(secretKey, RSA_PRIVATEKEY);//"!QAZ@WSX3edc4rfv"
            //p1:host, p2:name, p3:pass, p4:forword, p5:date, p6:根路径
            //p1,p2,p3 做AES和base64加密
            //p1为127.0.0.1时p4必须是ip，且和172.20.1.92的MDd一致校验
            p1 = AesCrypto.decrypt(Base64.decode(p1.trim()), aes_key).trim();
            if (!(MD5Util.verify48Md5(p1, P1_48MD5_01) || MD5Util.verify48Md5(p1, P1_48MD5_02))) {
                return new GlobalResponse("1012", "参数错误");
            }
            p2 = AesCrypto.decrypt(Base64.decode(p2.trim()), aes_key).trim();
            if (!MD5Util.verify48Md5(p2, P2_48MD5)) {
                return new GlobalResponse("1012", "参数错误");
            }
            p3 = AesCrypto.decrypt(Base64.decode(p3.trim()), aes_key).trim();
            if (!MD5Util.verify48Md5(p3, P3_48MD5)) {
                return new GlobalResponse("1012", "参数错误");
            }
            //不是127.0.0.1时,p4不能为空
            if (MD5Util.verify48Md5(p1, P1_48MD5_01)) {
                if (StringUtils.isBlank(p4)) {
                    return new GlobalResponse("1012", "参数错误");
                } else {
                    p4 = AesCrypto.decrypt(Base64.decode(p4.trim()), aes_key).trim();
                }
            }
        } catch (Exception e) {
            log.error("参数解析错误.");
            return new GlobalResponse("1012", "参数错误");
        }

        if (StringUtils.isEmpty(p5)) {
            p5 = sdf.format(System.currentTimeMillis());
        }
        boolean httpSend = false;
        if (StringUtils.isNotEmpty(isSend) && "true".equals(isSend)) {
            httpSend = true;
        }

        if (StringUtils.isEmpty(errorCode)) {
            /*"errorCode":"D2_009"
            "errorCode":"D3_035"
            "errorCode":"D3_036"
            "errorCode":"D3_041"
            "errorCode":"G_001"*/
            errorCode = "D3_035";
        }

        //还款信息D3,opCode:A>>>M,多条信息就回车存多行,中间不用逗号
        String json_hk_D3 = "";
        //放款信息D2,多条信息就回车存多行,中间不用逗号
        String json_fk_D2 = "";

        try {
            if (initShellConnect(executeCommand, p1, p2, p3)) {
                //获取远程日志中reqID
                String jsaonResult = getReqIdByRemoteLog(executeCommand, p4, p5, base_path);
                if (StringUtils.isNotBlank(jsaonResult)) {
                    List<String> reqIDList = new ArrayList<>();
                    List<String> loanIdList = new ArrayList<String>();

                    JSONArray jsonArray = JSONArray.parseArray(jsaonResult);
                    resultMsg.append("getReqIdByRemoteLog size=" + (jsonArray!=null ? jsonArray.size() : "null") );
                    resultMsg.append("|");
                    for (int i = 0; i < jsonArray.size(); i++) {
                        JSONObject jsonObj = jsonArray.getJSONObject(i);
                        boolean flag = false;
                        try{
                            JSONArray errorDetailArry = jsonObj.getJSONArray("errorDetail");
                            if(errorDetailArry!=null && errorDetailArry.size()>0){
                                JSONObject error = errorDetailArry.getJSONObject(0);
                                if(error.get("errorCode")!=null && errorCode.contains(error.getString("errorCode"))){ //D3_035,D3_036
                                    flag = true;
                                    reqIDList.add(jsonObj.getString("reqID"));
                                }
                            }
                        }catch (Exception e){
                            log.error("deal with reqIdByRemoteLog error!",e);
                        }finally {
                            if(!flag){
                                resultMsg.append("\n##OTHER ERRORCODE:" + jsonObj.toJSONString()+"##");
                                log.info("ManualToolService OTHER ERRORCODE:" + jsonObj.toJSONString());
                            }
                        }
                    }
                    resultMsg.append("\n|reqIDList size=" + reqIDList.size() );

                    if (reqIDList.size() > 0) {//还款
                        String[] recordIdArray = reqIDList.toArray(new String[reqIDList.size()]);
                        log.info("RepaymentLoanInfoDbMapper getReqIdByRemoteLog reqID to D3:" + JSON.toJSONString(recordIdArray));
                        List<RepaymentLoanInfoVo> repaymentLoanInfoList = repaymentLoanInfoDbMapper.findByRecordId(recordIdArray);

                        for (RepaymentLoanInfoVo bean : repaymentLoanInfoList) {
                            bean.setOpCode("M");
                            if (bean.getOverdueStatus() == null) {
                                bean.setOverdueStatus("");
                            }
                            loanIdList.add(bean.getLoanId());
                        }
                        resultMsg.append("|");
                        resultMsg.append("D3 List size=" + repaymentLoanInfoList.size());
                        json_hk_D3 = JSONArray.toJSONString(repaymentLoanInfoList);
                        json_hk_D3 = json_hk_D3.replace("[", "");
                        json_hk_D3 = json_hk_D3.replace("]", "");
                        json_hk_D3 = json_hk_D3.replace("},", "}\n");
                    }


                    if (loanIdList.size() > 0) {
                        List<LoanInfoVo> loanInfoVoList = new ArrayList<LoanInfoVo>();
                        String[] orderNoArray = loanIdList.toArray(new String[loanIdList.size()]);
                        List<String> loanApplicationHistoryIdList = loanInfoMapper.findHistoryIdByOrderNo(orderNoArray);

                        for (String historyId : loanApplicationHistoryIdList) {
                            LoanInfoVo infoVo = loanInfoMapper.findLoanInfoVoByHistoryId(historyId);
                            loanInfoVoList.add(infoVo);
                        }
                        resultMsg.append("|");
                        resultMsg.append("D2 List size=" + loanInfoVoList.size());
                        if (loanInfoVoList.size() > 0) {
                            json_fk_D2 = JSONArray.toJSONString(loanInfoVoList);
                            json_fk_D2 = json_fk_D2.replace("[", "");
                            json_fk_D2 = json_fk_D2.replace("]", "");
                            json_fk_D2 = json_fk_D2.replace("},", "}\n");
                        }
                    }


                    if (StringUtils.isNotBlank(json_fk_D2)) {
                        //ReadOrWriteTxt.writeTxt(base_path+"/baihang/D2/data.txt",json_fk_D2);
                        String cmd_res = writeJsonFileOnRemote(executeCommand, base_path + "/baihang/D2/data.txt", json_fk_D2);
                        log.info("RepaymentLoanInfoDbMapper.sendBaiHangData writ remote file ...baihang/D2/data.txt END,r:" + cmd_res);
                        resultMsg.append("|");
                        resultMsg.append("write D2 end.");
                        if (httpSend) {
                            Map<String, Object> params = new HashMap<String, Object>();
                            params.put("key", "b5140fb2-2c85-4b5a-abcf-3e97528014db");
                            String http_res = HttpRequestUtil.mySelfDoGet(base_url + "/mainLoanInfoSend", params);
                            log.info("RepaymentLoanInfoDbMapper.sendBaiHangData http request D2>>>mainLoanInfoSend END,r:" + http_res);
                            resultMsg.append("|");
                            resultMsg.append(http_res);
                        }
                    }else{
                        resultMsg.append("|");
                        resultMsg.append("放款D2 json_fk_D2 isEmpty.");
                    }
                    if (StringUtils.isNotBlank(json_hk_D3)) {
                        //ReadOrWriteTxt.writeTxt(base_path+"/baihang/D3/data.txt",json_hk_D3);
                        String cmd_res = writeJsonFileOnRemote(executeCommand, base_path + "/baihang/D3/data.txt", json_hk_D3);
                        log.info("RepaymentLoanInfoDbMapper.sendBaiHangData writ remote file ...baihang/D3/data.txt END,r:" + cmd_res);
                        resultMsg.append("|");
                        resultMsg.append("write D3 end.");
                        if (httpSend) {
                            Map<String, Object> params = new HashMap<String, Object>();
                            params.put("key", "b5140fb2-2c85-4b5a-abcf-3e97528014db");
                            String http_res = HttpRequestUtil.mySelfDoGet(base_url + "/mainRepaymentLoanInfo", params);
                            log.info("RepaymentLoanInfoDbMapper.sendBaiHangData http request D3>>>mainRepaymentLoanInfo END,r:" + http_res);
                            resultMsg.append("|");
                            resultMsg.append(http_res);
                        }

                    }else {
                        resultMsg.append("|");
                        resultMsg.append("还款D3 json_hk_D3 isEmpty.");
                    }
                    //退出登录
                    List<String> cmdList = new ArrayList<String>();
                    cmdList.add("echo '++CMD LAST++' \n\r");
                    cmdList.add("exit \n\r");
                    cmdList.add("exit \n\r");
                    executeCommand.execute(cmdList, false);

                    return GlobalResponse.generate(resultMsg);
                } else {
                    log.info("RepaymentLoanInfoDbMapper.getReqIdByRemoteLog redult isEmpty.");
                    return GlobalResponse.generate("百行征信手动报送,获取日志为空");
                }
            }
        } catch (Exception e) {
            log.error("ManualToolService.sendBaiHangData Error,", e);
            return new GlobalResponse("1001", "百行征信手动报送异常," + e.getMessage());
        } finally {
            if (executeCommand != null) {
                executeCommand.ioclose();
                executeCommand.closeChannelShell();
                executeCommand = null;
            }
            try {
                ShellUtils.LOCK.unlock();
            } catch (IllegalMonitorStateException e) {
                log.warn("锁已释放,无需重复释放." + e);
            }
        }
        log.info("ManualToolService.sendBaiHangData All END<<<<<<");
        return new GlobalResponse("1000", "百行征信手动报送失败");
    }

    /**
     * 描述: 初始化 ShellUtils  <br/>
     * 参数: [p1:host, p2:name, p3:pass]  <br/>
     * 返回值: java.lang.String  <br/>
     * 创建人: yanhui.Hao  <br/>
     * 创建时间: 2019.09.25  <br/>
     */
    private boolean initShellConnect(ShellUtils executeCommand, String p1, String p2, String p3) {
        try {
            ShellUtils.LOCK.lock();
            if (executeCommand == null) {
                executeCommand = new ShellUtils(p1, p2, p3);
                if (executeCommand.login()) {
                    executeCommand.initChannel(ShellUtils.CHANNEL_TYPE_SHELL);
                    this.executeCommand = executeCommand;
                    return true;
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
            log.error("ManualToolService.initShellConnect Error," + e.getMessage());
        } finally {
            ShellUtils.LOCK.unlock();
        }
        return false;
    }

    /**
     * 描述: 获取远程服务器的日志信息  <br/>
     * 参数: [p4:forword, p5:date, p6:根路径]  <br/>
     * 返回值: java.lang.String  <br/>
     * 创建人: yanhui.Hao  <br/>
     * 创建时间: 2019.09.25  <br/>
     */
    private String getReqIdByRemoteLog(ShellUtils executeCommand, String p4, String p5, String p6) {
        String result = null;
        try {
            ShellUtils.LOCK.lock();
            if (executeCommand != null) {
                log.info(".......>>>>start deal with cmd:1 outputStream execute Start.......");
                List<String> cmdList = new ArrayList<>();
                cmdList.add("ssh " + p4 + " \n\r");
                cmdList.add("/sbin/ifconfig  |grep \"inet addr\" \n\r");
                cmdList.add("cd " + p6 + " \n\r");
                cmdList.add("sh download_baihang_error_log.sh " + Integer.parseInt(p5) + " \n\r");
                executeCommand.execute(cmdList, true);
                //打印执行结果
                executeCommand.outCmdResult();
                log.info(".......>>>>start deal with cmd:1 inputStream getResult End.......");
                ShellUtils.LOCK.unlock();

                ShellUtils.LOCK.lock();
                cmdList = new ArrayList<>();
                log.info(".......>>>>start deal with cmd:2 outputStream execute Start.......");
                cmdList.add("cd " + p6 + "/" + p5 + " \n\r");
                cmdList.add("cat *_logicerror.log \n\r");
                executeCommand.execute(cmdList, true);
                //获取reqID结果
                result = executeCommand.getResult();
                log.info(".......>>>>start deal with cmd:2 inputStream getResult End.......result:\n" + result);
                ShellUtils.LOCK.unlock();
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            try {
                ShellUtils.LOCK.unlock();
            } catch (IllegalMonitorStateException e) {
                log.warn("锁已释放,无需重复释放." + e);
            }
        }
        return result;
    }


    /**
     * 描述: 往远程服务器写文件 <br/>
     * 参数: [p4:forword, p5:date, p6:根路径]  <br/>
     * 返回值: java.lang.String  <br/>
     * 创建人: yanhui.Hao  <br/>
     * 创建时间: 2019.09.25  <br/>
     */
    private String writeJsonFileOnRemote(ShellUtils executeCommand, String filePath, String context) {
        String result = null;
        try {
            ShellUtils.LOCK.lock();
            if (executeCommand != null) {
                log.info(".......>>>>start deal with cmd:3 outputStream execute Start.......");
                List<String> cmdList = new ArrayList<>();
                String path = filePath.substring(0, filePath.lastIndexOf("/"));
                cmdList.add("cd " + path + " \n\r");
                cmdList.add("pwd \n\r");
                cmdList.add("printf '" + context + "' >./data.txt \n\r");
                cmdList.add("cat data.txt |wc -l \n\r");
                executeCommand.execute(cmdList, true);
                //打印执行结果
                executeCommand.outCmdResult();
                log.info(".......>>>>start deal with cmd:3 inputStream getResult End.......");
                result = "写入成功:" + filePath;
                ShellUtils.LOCK.unlock();
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            try {
                ShellUtils.LOCK.unlock();
            } catch (IllegalMonitorStateException e) {
                log.warn("锁已释放,无需重复释放." + e);
            }
        }
        return result;
    }

    /**
     * 描述: 读取私钥 <br/>
     * 参数: [fileName]  <br/>
     * 返回值: java.lang.String  <br/>
     * 创建人: yanhui.Hao  <br/>
     * 创建时间: 2019.09.26  <br/>
     */
    private static String readRSAPrivateKey(String fileName) {
        InputStream isr = ManualToolService.class.getResourceAsStream(fileName);
        BufferedReader br = new BufferedReader(new InputStreamReader(isr));
        StringBuilder builder = new StringBuilder();
        try {
            boolean inKey = false;
            for (String line = br.readLine(); line != null; line = br.readLine()) {
                line = line.trim();
                if (!inKey) {
                    if (line.contains("BEGIN PRIVATE KEY")) {
                        inKey = true;
                    }
                    continue;
                } else {
                    if (line.contains("END PRIVATE KEY")) {
                        inKey = false;
                        break;
                    }
                    builder.append(line);
                }
            }
            br.close();
            isr.close();
        } catch (IOException e) {
            e.printStackTrace();
            log.error("读取:" + fileName + "异常", e);
        }
        return builder.toString();
    }



    @Monitor({MonitorType.EXCEPTION, MonitorType.FEE, MonitorType.HIT, MonitorType.RESULT})
    @DistributedLock
    public GlobalResponse buildLoanInfoD2(String jsonFile) {
        StringBuffer resultMsg = new StringBuffer();
        if(StringUtils.isEmpty(jsonFile)){
            return new GlobalResponse("1000", "百行征信手动报送失败");
        }
        //jsonFile = "C:\\Users\\Administrator\\Desktop\\百行历史数据报送实时放款数据D2(历史百行征信报送).json";
        String context = ReadOrWriteTxt.readTxt(jsonFile);

        JSONObject jSONObject = JSON.parseObject(context);
        JSONArray jsonArray = jSONObject.getJSONArray("RECORDS");
        for (int i = 0; i < jsonArray.size() ; i++) {
            JSONObject object = jsonArray.getJSONObject(i);
            Object reqID = object.get("reqID");
            if(reqID!=null){
                List<String> list = loanInfoMapper.findTargetRepaymentDayList(reqID.toString());
                if(list!=null && list.size()>0){
                    String[] strArry = list.toArray(new String[list.size()]);
                    object.put("targetRepayDateList",strArry);
                }else{
                    object.put("targetRepayDateList",new String[0]);
                }
            }
        }

        String json_fk_D2 = JSONArray.toJSONString(jsonArray);
        //json_fk_D2 = json_fk_D2.replace("[", "");
        //json_fk_D2 = json_fk_D2.replace("]", "");
        json_fk_D2 = json_fk_D2.replace("},", "}\n");


        String writeName = jsonFile.substring(0,jsonFile.lastIndexOf("\\"))+"\\d2.txt";
        ReadOrWriteTxt.writeTxt(writeName,json_fk_D2);
        System.out.print("放款信息 D2 写入文件OK:"+writeName);
        return new GlobalResponse("0", "放款信息 D2 写入文件OK:"+writeName);
    }


    @Monitor({MonitorType.EXCEPTION, MonitorType.FEE, MonitorType.HIT, MonitorType.RESULT})
    @DistributedLock
    public GlobalResponse testPTCreditScoreV1(String filePath,String p3,String secretKey) {
        StringBuffer resultMsg = new StringBuffer();
        if (StringUtils.isAnyBlank(RSA_PRIVATEKEY,filePath,p3,secretKey)) {
            return new GlobalResponse("1012", "参数错误");
        }
        try {
            String aes_key = RSAEncrypt.decrypt(secretKey, RSA_PRIVATEKEY);//"!QAZ@WSX3edc4rfv"
            String tmp = AesCrypto.decrypt(Base64.decode(p3.trim()), aes_key).trim();
            if (!MD5Util.verify48Md5(tmp, P3_48MD5)) {
                return new GlobalResponse("1012", "参数错误");
            }
        } catch (Exception e) {
            log.error("参数解析错误.");
            return new GlobalResponse("1012", "参数错误");
        }
        long start = System.currentTimeMillis();
        List<String> contextList = ReadOrWriteTxt.readTxtList(filePath);
        StringBuffer resultBuff = new StringBuffer();
        if(contextList!=null && contextList.size()>0){
            for(int i =0; i<contextList.size(); i++){
                long startUtc = System.currentTimeMillis();
                String context = contextList.get(i);
                String value = "";
                try{
                    //唯一ID|name|id_no|phone
                    String[] strArry = context.split("[|]");
                    String transactionId = IdUtils.getUuid();
                    CommonSuperService superService = ApplicationContextHolder.getBean("pinTaiCreditScoreService");
                    Object resultObject = superService.getClass().getMethod("pinTaiCreditScoreV1Query", String.class, String.class, String.class, String.class, String.class, boolean.class)
                            .invoke(superService, transactionId, strArry[0], strArry[1],strArry[2],strArry[3], false);
                    GlobalResponse globalResponse = (GlobalResponse) resultObject;
                   //// GlobalResponse globalResponse = pinTaiCreditScoreService.pinTaiCreditScoreV1Query(transactionId, strArry[0], strArry[1], strArry[2], strArry[3], false);
                    Object object = globalResponse.getBody();

                    if(object!=null){
                        JSONObject jsonObject = ((JSONObject) object).getJSONObject("content");
                        if(jsonObject!=null && jsonObject.containsKey("S2070101")){
                            value = jsonObject.getString("S2070101");
                        }
                    }
                    resultBuff.append(context.replace("|","\t"));
                    resultBuff.append("\t");
                    resultBuff.append(value);
                    resultBuff.append("\n");

                    Thread.sleep(1000);

                }catch (Exception e){
                    log.error("品钛高德分查询异常,context="+context,e);
                }
                log.info("查询"+i+":value="+value+",cost="+(System.currentTimeMillis()-startUtc));
            }
        }
        String writeName = filePath.substring(0,filePath.lastIndexOf("\\"))+"\\result.txt";
        ReadOrWriteTxt.writeTxt(writeName,resultBuff.toString());
        log.info("品钛高德分测试数据写入文件OK, total cost="+(System.currentTimeMillis()-start)+", writeName="+writeName);

        return GlobalResponse.generate("品钛高德分测试数据写入文件OK, total cost="+(System.currentTimeMillis()-start)+", writeName="+writeName);
    }


    //@Monitor({MonitorType.EXCEPTION, MonitorType.FEE, MonitorType.HIT, MonitorType.RESULT})
    //@DistributedLock
    public boolean checkSecretKey(String p3,String secretKey) {
        StringBuffer resultMsg = new StringBuffer();
        if (StringUtils.isAnyBlank(RSA_PRIVATEKEY,p3,secretKey)) {
            return false;
        }
        try {
            String aes_key = RSAEncrypt.decrypt(secretKey, RSA_PRIVATEKEY);//"!QAZ@WSX3edc4rfv"
            String tmp = AesCrypto.decrypt(Base64.decode(p3.trim()), aes_key).trim();
            if (!MD5Util.verify48Md5(tmp, P3_48MD5)) {
                return false;
            }
        } catch (Exception e) {
            log.error("参数解析错误.");
            return false;
        }
        return true;
    }


    public GlobalResponse dealWithExcelData(String filePath,String type) {
        if(StringUtils.isAnyBlank(filePath,type)){
            return new GlobalResponse("1000", "百行征信手动报送失败");
        }
        List<Object> jsonArray = new ArrayList<Object>();

        List<String> lineList = ReadOrWriteTxt.readTxtList(filePath);

        String[] titleKeys = lineList.get(0).split("\t");

        StringBuffer jsonStr = new StringBuffer();
        DateFormat df_uploadTs = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        for (int i = 1; i < lineList.size() ; i++) {
            String[] datas = lineList.get(i).split("\t");
            JSONObject json = new JSONObject();

            for (int k=0; k<titleKeys.length; k++){
                json.put(titleKeys[k].trim(), (datas[k]!=null ? datas[k].toString().trim() :null));
            }

            if("A1".equals(type)){
                //ApplyLoanInfoZhuDai bean = new Gson().fromJson(json.toJSONString(), new TypeToken<ApplyLoanInfoZhuDai>(){}.getType());
                ApplyLoanInfoZhuDai bean = JSONObject.toJavaObject(json, ApplyLoanInfoZhuDai.class);
                String uploadTs = df_uploadTs.format(new Date());
                bean.setUploadTs(uploadTs.replace(" ","T"));

                jsonArray.add(bean);

                jsonStr.append(JSON.toJSONString(bean));
                jsonStr.append("\n");

            }else if("D2".equals(type)){
                //LoanInfoZhuDaiVo bean = new Gson().fromJson(json.toJSONString(), new TypeToken<LoanInfoZhuDaiVo>(){}.getType());
                //FinTechAgencyBusinessZhuDai finTechAgencyBusiness = new Gson().fromJson(json.toJSONString(), new TypeToken<FinTechAgencyBusinessZhuDai>(){}.getType());
                //bean.setFinTechAgencyBusiness(finTechAgencyBusiness);

                LoanInfoZhuDai bean = JSONObject.toJavaObject(json, LoanInfoZhuDai.class);
                String uploadTs = df_uploadTs.format(new Date());
                bean.setUploadTs(uploadTs.replace(" ","T"));

                jsonArray.add(bean);

                jsonStr.append(JSON.toJSONString(bean));
                jsonStr.append("\n");

            }else if("D3".equals(type)){
                //RepaymentInfoZhuDai bean = new Gson().fromJson(json.toJSONString(), new TypeToken<RepaymentInfoZhuDai>(){}.getType());
                RepaymentInfoZhuDai bean = JSONObject.toJavaObject(json, RepaymentInfoZhuDai.class);
                String uploadTs = df_uploadTs.format(new Date());
                bean.setUploadTs(uploadTs.replace(" ","T"));
                jsonArray.add(bean);

                jsonStr.append(JSON.toJSONString(bean));
                jsonStr.append("\n");

            }else{
                log.error("其他类型type:"+type);
                jsonArray.add(json);

                jsonStr.append(JSON.toJSONString(json));
                jsonStr.append("\n");
            }
        }

        //String jsonStr = JSONArray.toJSONString(jsonArray);

        String writeName = filePath.substring(0,filePath.lastIndexOf("\\"));
        writeName = writeName + "\\build\\";
        writeName = writeName + filePath.substring(filePath.lastIndexOf("\\")+1, filePath.length());
        ReadOrWriteTxt.writeTxt(writeName,jsonStr.toString());
        log.info("处理后数据入文件OK:"+writeName);
        return new GlobalResponse("0", "处理后数据入文件OK:"+writeName);
    }




    public static void main11(String[] args) {
       /* for (int i=0; i<12; i++){
            String id = UUID.randomUUID().toString().replaceAll("-", "");
            System.out.println(id);
        }*/


       //修改D3中的reqID
       /*DateFormat df_uploadTs = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
       int rr = 1009823900;
        List<String> lineList = ReadOrWriteTxt.readTxtList("C:\\Users\\Administrator\\Desktop\\测试\\文件测试\\build\\tmp3.txt");
        for(int i=0;i<lineList.size();i++){
            RepaymentInfoZhuDai repaymentLoanInfo = new Gson().fromJson(lineList.get(i), new TypeToken<RepaymentInfoZhuDai>(){}.getType());
            //String id = UUID.randomUUID().toString().replaceAll("-", "");
            rr++;
            String uploadTs = df_uploadTs.format(new Date());
            repaymentLoanInfo.setReqID(rr+"");
            //repaymentLoanInfo.setUploadTs(uploadTs.replace(" ","T"));
            System.out.println(JSON.toJSONString(repaymentLoanInfo));
        }
        System.err.println(rr);*/


        //将D2中FinTechAgencyBusinessZhuDai变成树形结构
       /* List<String> lineD2List = ReadOrWriteTxt.readTxtList("C:\\Users\\Administrator\\Desktop\\测试\\文件测试\\build\\tmp2.txt");
        for(int i=0;i<lineD2List.size();i++){
            LoanInfoZhuDaiVo loanInfo = JSONObject.parseObject(lineD2List.get(i), LoanInfoZhuDaiVo.class);
            FinTechAgencyBusinessZhuDai finTechAgencyBusiness = JSONObject.parseObject(lineD2List.get(i), FinTechAgencyBusinessZhuDai.class);
            loanInfo.setFinTechAgencyBusiness(finTechAgencyBusiness);
            System.out.println(JSON.toJSONString(loanInfo));
        }
        System.err.println("build D2 finTechAgencyBusiness end.");*/


       //-----------------------------------------------
        //A1
       //String[] err_inp_reqIDs = {"1630e4c8dc0b4b4ba857679a761bb67d", "5abcd79f47e344c49936935c150a6dc0", "8e2d360d38674734b969c15ac4ff596c", "555c299a46014f4fbd879ae4f8ab0b36", "ea9de6475aaa4e098f178fa1dd5768fd", "e3b056b6263c4be282b1ead6bb327969", "c20ba517aed740a6b2a75a3ea2b262e6", "cf501fb6ccab49e982b44d99137af9aa", "70d008893b6c4dd0988b346a4b4a2522", "e480a9f0e750446e8dc50f5131de5a5c", "009f3857026544ceb9299372d14b372e", "20331cfd9f7246b395f65126760052f1", "884d2eb64cdf44149a0e91e37335122c", "caa0bebfdffd46e8b2959be28e509412", "a263e4056df64ce8ad6b0fe3e5c0e1d9", "0fb50fc2c7c64886bcb6e32936f8b745", "315aae5a1474444db41d5280b668944c", "b32c46011fbc4acab7bffa46f99e456f", "d75ebcb39f514255876a23701878a388", "7616ce3ea0324f8cbb57cc9f3ca1c807", "bdf6c638f6af4e90be69eaa0997e5288", "847f97de392945cf8eb00b1b0331ad59", "0928d9d694ea48a6960942192b359570", "94085563f5604cc3b59398d61ab40318", "89559a5b18084360b79a439dd183de2f", "85b697dfafb14a499c420a7c7921ae02", "11aec469297a4ac8af97fe4c8259a872", "25a49736e92c4891a25fa3c0dbf8f938", "78582564458a4afbaff517068db8b8e7", "4d4ae736dfda433b8c984eddeb5e4c6d", "f6dc32256f314bfbad9520f87dc45294", "3b4a1dc129f7454c8bf932a8cc768f13", "8da87b04a62c49918ccb658d093d9514", "31b5ffc9ed9249caa4b8c22dbad63d83", "8fbff7dd9589461dab8e2ee4b3d3f36f", "3271de67c2c14cf2a8e4d502971cecd3", "58e5cae6a9b8413ea15e98867be9943f", "654f0b5af0e74c9b80c11fed88883c11", "5fddda52bc2d40a792f165a84f029137", "4ec46b81eeee401194b201782e4a8434", "6c930c3cd0794881bf0b80504bd9e187", "d2018a9c6e274a22a8c8870e54e2d3cc", "490e9b68890140a39923845c3e710fda", "34313c8376604afe90327f88add4ec75", "368950fd61164cf1bbb161df04a06318", "30dfc098ef354db7822cc8db28f6f948", "36acc626adae4c91903c1c1a1be5ae87", "84cf0a6600ea4f5aa06101eb6ccad89b", "220de678357942a79f3e5aa916deb14c", "be18fc64290747949d605f67d3302dce", "03ec6d6de02e4911ae6ce3d9eced874e", "83249fecf3bc47129a2e9aa1fabb117b", "ce1db78c7d9f4e0da16804f15eb5b204", "777b01b68c1846919ab97ff1e9acab7c", "8211d816ba2e4c2f99233ab059030883", "56036e2781fa4d6c91ab379549f8e0e1", "0ae50255ce0a427d9cdc870e13e7d2dd", "1ce1616ab3e3461891ae188c95e95827", "9e51375b59464a7aa7838ee2a74f3fce", "f66d731016394591b0f44f1b221cc0f1", "f4fcc8d939f34d0a90125d60fdad2fd7", "4f9a9249acf54f5da031ae0e86d87913", "1a596f1f448f43f7b8b42bdaba74bb7c", "54a3c84b97c147ae9e51904b8364d539", "707e2bf84d4540fe967c4c332b9dd643", "30a7a9763acf4cc6a9b8b395dfff91a1", "c17037f7937944f99da78ebe7042855f", "555122e329634fc88a546997baacb5ec", "0dc4c99dfaaa47b7b141a1a99a2d2ae3", "3b5e5d158b964a65aae65c550b4a41dc", "11528da053bf422b85948e4993d94503", "7a66040517c7405fb09e7bae83b6d78d", "342433abbcb5424d84df3eb8f74accb1", "94449500b61745a782a04bc60f94d732", "36e1bfb2983a470c94ae15958f1a16e9", "94ffaefa98e546c58e7002dd7c799488", "e77183b5a1944df0b270f76fa03d09cf", "3e25eb18667e410cbd7101d4ecc3cdfd", "67a330585f8f41c0b26275e7ee95f284", "4db46714746d428481a619cbeb61a78e", "cee7f9f17f294eea8a939ffd367f1857", "8458928526744e7bbf73c5232bff0957", "d52e81a8f6ae44609f9998f8fc6b5ff3", "c074e89f8a57479fa7394d3ad6f9c19f", "43adecdcc7284d0384fcb1c5a10e6b7f", "5f525cf9a4574d5888c802c5065e6987", "4b32b2ef8fc04e0584e3b582e683b80a", "51ae195c3b4544489db0fa8b1abaf2ed", "f9e7ecd1c45443d899f609b06137537b", "70ddcc68ce1349adb0442cf574eb0738", "b471960128444409a466b1ca98632a88", "a9f8ef6629984938ba6120c91434813d", "7c771dcd1f95484fa180d963562fb09d", "1ad1edbd361b4fa0846da0bb7b9c7a86", "5c4dbe70614b4173a6ebaec6c479f435", "eb01270f44a34607a11c142abc5d8b15", "f0fefb9ea9be49a69613fa7dcbe9a3e6", "b9ad972c2f55462eb5375367d9ab91e2", "ba36093db7214aee91e84d4335055617", "a48c8bfe5eba4ab99666bf4c0d7316c4", "9983eb29674d43589b939886b866853c", "b8537a249a69434987d1dedf316b4181", "4992f971c32d48999825a94d3a245102", "f1c2f08bd6b547109f4c780ae4bd2047", "a94c8f81a0834c51a8b7be202da4cec0", "abf547dc068d4f478b7ec6b4947f2aa1", "a44506c34b4e49dba6d86b541536309b", "025b1fd1083e42dfa126880dac1ef89a", "d09770fa8424444597366571633a17d1", "cecae95aba404d6d97d0cd52a3364f79", "e8779f8b708b4a3892c48ef080cc48b1", "3467bbffe60540bc91b09a6922cb3232", "3f8740cdba1e4e468739efddbd06cb9d", "7fa581cb5aa54d72ab7798558e73fba6", "e07ab496035548a08027a8b2c0052ca8", "7b552cb2c0fe4e568dd8957e379cc00c", "1613b60e90864e61a2fafa9eff90974f", "13a8e5cf43d8470285fa1e1e19b6f5a2", "0413a276b62247e38755d183b6af1f9e", "3e05f4d6486f42aeb6d7193106de0b0c", "7929064a0bf3446595413a6b3828d974", "2504ab540d5846cea9872546b3775821", "ba4d27762c8b45d2b461b785865b02b0", "1df7fd4a893c4122b4fa8b3f914c9d69", "433a5613276f4bff99785662016454d6", "9d301a6fcedf4d2caceef26f90a04d0a", "87a1c40d8a384d24a369c8ad8cfdb0d3", "2b8b97082f764cd8a881c340ee88d13e", "236f84fd93ee433b8fca8ed524d8b0f4", "e673e097b9594ae68fcf9e8654c498ad", "b0a7bc4d638b41c899d08b95ee24096b", "2e356f636ce742438afd8bb804cda702", "22fcc3e26124450e8964bb401c4cf2b9", "f4c90bc54aaf47b8a79e45cd9372092f", "bcde43277fa54e6ea2276a9b5c6ee86a", "838867bb1ccc49a29a5b4726cf95280b", "a768e937d93848aeb8739f8e2a8f5b64", "441844584cd746369a337b6bf7a13f86", "5093b229ba054364b5c3e4a119d4f076", "a61328380f4b4c369e207366cbc1f372", "63950a7139ec4156879500c5b81e61b8", "3521cd2f674146fa8e896f7b76511352", "f4d0dfe4c2ea4f81930a973c2e94aecf", "4f553617fd1941a3a914def6198093e1", "0045f0a5d3434fffa620d01f963f5206", "63c5ba8972704bbdbbb8a351ad854b50", "bf1501992167411d8e9f8f7291e6ec34", "5a4fe7cf6cd24f4bbd0a126a6c0930c6", "1a6c64f4806e4121842658560dd77d1a", "0700c68d59c445a1aa5b805a5c1e94e7", "c84ecc575a9248188cdadbb52799f4f9", "0cf283d7e2ce457d8a1baf06f6bf580a", "359994ab8f80439bae9cc80e4c553f2f", "5833e302288b47549361fb8bd0cbc97c", "38c11dc38bd34cb8b17261cf421bbf0e", "ab16f757a0a24f05a20a9991ffcce2b5", "7ba757a5abba40f19914979a232b3b6e", "b2b22ef4dc17447082a9e23a22ab1133", "0f55aa1b601e4977b2c382334fdb2739", "bfe88329b37942d9b65137b814db805f", "34c46309c28e4915bc62c2d418fea042", "1ec9280723f54b759c09d66bb1a413b7", "2014e4d8c7de44b780290563b0218c4c", "8bd4c37725e64711b2898fa0dbbe8553", "7fa4f004b90548cf9453caf053231dc0", "cd6a71cbacb84eee9a854ec1f5fe0734", "9bbfe8a4198748a2bbdaf102a4bf2229", "7ce2d307417141dcaa98b4ce988997ea", "c6209624d09b4cc0bc0abcbee06e2ecb", "938b09e300a44b4b8ea08640074af964", "5fe21db460d54f87875becb24751f9a9", "bb1c5f896ac24806a36fbe02a4836250", "e0ecb7f21d724d5c82d58fdf077bbc8e", "d85081266d8740548400eac26598f740", "2c9e19c121b744a9977aa810f6c3f500", "6157afb1c29c4f3eb4ee3b8068e8a0ab", "8128022ebc9442fb978d12e2efd0130f", "a1283fc267794e64b897bcec3bd14ec2", "67564f4e4ce940868973bc3718f144fb", "ffaaeed7f27b473f84013c2653fae144", "e519df89c3604f1198326eb633273d37", "7decd9f1a5ad42038eaf4407e12ceffe", "9ea6dce9c3cd4b7296562b13a155fc49", "40fa0a2c3f334308867ba950b68c20e4", "112497ab0bb34d3c94a9f7ba924d3304", "d02a339eb64f46a1af0923106aa9372d", "91e736df7e9a4bf38c40b2536c6ae345", "55c0c46356444fdcaae503396d27d459", "27b261848d654f6cba406f0c1233a175", "0b093895e9a44863845bfede4de787b3", "fb4693a7fc344ee5806017177829a16f", "0de621ce6ea745c0bd6ce1a65409574e", "a0d7f3f1c3314ae892389c25fcdb04a1", "2d827d5a0e854a70b6cfda33ea16cd23", "614964c6d57e48cc8000645cc38b3fcf", "a55cf63871b04dee84ab2edba028a57a", "ddf4b5518dd64f98ad3a40d626407adb", "acaec16ce8304188b5631073e163c5a4", "f96ed92100b2417ea3eccaaee6bc08b1", "fef772194aec4a53aa55edc5cf86f335", "be121c42b8a14ff8888b43adcfc0fb4d", "4796ffeefb3d42e4b72b09d15692e5be", "0cca0eb9b18e4e71b7e2d37469e5f415", "67776b571bce427d95935a13020d1671", "34893333f4a54b67be2c668abf73d534", "460a2dd8ff5d46b0b5d21bbc13f9f150", "4d9089a6752a419494f054e3fadcb2f3", "1777c57f607c44399272bbe0ee54c28a", "d7d915bba43244b9bfb301dd23398886", "4249a81287a84f759c541530667d412f", "7a9cbba58efa4a78b5db9e28b2483dd5", "7a0ec77d2e594f63961f4973c1a68b98", "625a13281dbc4e6abbaf2d3f8dd03824", "99770b6475324be98062ae77c262b21b", "271147ab6ab846ddb46056ab3e9d3375", "34e3875f55384c688b0e9a3f9ed1a604", "9513428e1a0c4bb3b05a5a9417c389da", "3e15178cd566487fb4c671c173054f2d", "6efde6c08a6b4b4d95ebf427f40d780e", "bfd6bdf94ad9403e9ac910a9c4b8ac9c", "9a8145dc4ade4a45a05663881f918d62", "160f3624137b489f8d13b81d2286a768", "b3b4a35656964f9e825ecc22ae69f7ca", "993690ba8c9a4199bf8498c0469638af", "d7aab6f63fb94c5584560f68c113df81", "58e27733be4f4faebb95a6e56ffbd3c7", "ca9263e030c140fca1ef1a91b87d0938", "858a6fbf926e487e9dfe55e0f83e9358", "a641cf98e3554ab9b4b7bd27c6b2d30a", "341e4a78bdf043f6803ac66674bf8611", "27a7bf5badc0468b88b828631c4733bd", "a82f82d0ddf049eb9093fddd2a6e293f", "e96bdda5f5594f42826412439b570bc6", "762c6c575af243659d41752191995cfd", "e6d12242f1f543968480ef541347c091", "2d0e58e20c414733a9b66c47461e3fd6", "8e0e62fac8214d2f85669007dbf9b934", "db4a84ab760b49329afcd0c043da2776", "e75a4f3488b94ee09723bd1414323f6e", "36a6f7320acd44da9b153bda2bd9c413", "0bb8e123a4954ded9a7e5542b2af5231", "0ce30845c38d44329d80a227bf7bd968", "e7f0a2deb7cc4a3eb7f784e6a5be7f32", "deea4d2638ab41379d31b4dfc0e1b37e", "4c0bbb1c4cbe4e58af43ef280684459d", "27953f7aaefa4fd99baa9ab61e73a5a1", "fe21bcc7c756412fb9e51622e848862b", "7704176cffde4d5f9c03d629893b1528", "63b4dafd266c4422bd4a6e54c0b9cb7f", "5c9967c565cc4204be70ee22c81d3d48", "7a12566e22fb40999c3e347da9ca763b", "d0f5098ad39a4922ab2b09ef73e9a3b9", "b01a0aaebd1449fbbc7efc0d37492c69", "73372ee0b0f6472290652ccec2cc0598"};
        String[] err_inp_reqIDs = {"823d231cf7d242a297c4d05ec7d5fa11","a308639c82a44858afa8ddd753e88b91","232e02f5dcef494fb2f7986efbab5c3d","b15388dbff404fb48a4ead830d4997a6","f1e0f47eb14b489695b7e3fd9a288e6a","7f1d9bfd3c9547a49ea765b66fffe4f7","c1451e022aea4b2297cd83964688bc45","94426a510d3f4ff2b6fece4bf59fb21f","d07c11193c08420c8e48de12d4da8270","a48d657b4bb04cc48fd3fb0f99126c2b","ceeb059d7567485cb33f1f1b4a8bd6fc","a6ff8b0099a4408f8d93587f3f60461f","967984dda45b4b249fc33970ecac4653","204ab92e32054fa98068d2f9802b1676","1fb29fa7aaf44231abb33ee6dc9a9ae5","cd57561995994aad802f2b9c3ee84af3","3ac9889a2b4f4e569ec44ae9daba1a7b","9c39d735067344ec976ec5c8a3f166cc","c0d92f11f62b4a24adac9707f23c6ea6","5924c24964c5423591d32f1dc782718f","8c96f3a583804dbda5fcea6dc7335bee","552c9cc2b3fb4074a745a173b36f6db0","f8f3503cbb54483aad4abe83bb4fcd1f","4b36e7b5826143e8b022f2f25fdc3f7a","95d4792ffa444d41ba874332f1920959","9f880da744e94a7ebef9b8bb18dabe4e","736805aedd954709b8bab9ca63313158","e2456249c414460faae5aee194a5c09c","9e06f618b4544bbea9087bbc9e4cf6e3","2668b865eedb43f29cc715256577f5de","cedebc77c12b4d9f9b0c797d899ca8c8","3dee8ef8956341429a78c0b6b9a42314","63c8b611768e40848845a77ec1928148","2c8f6f662ea84907a100fcf02a7134fb","53044da4f5844f4eb5098fb44d3e95ce","e32417463a554b09907cbf20bfcc49c4","3019ec25a1a043fa85d5c15af1cc3de1","df70f35c800d499595d0c5eeb7455bbc","374c19d34bf3428284489ac4cc49b431","66cee92aed5a4dc19fce3e412ca86b0e","3c79ea60ef1e44c4b0f96a2a27c51c0a","ac5cf31254404c62b14ce221cf780d23","519fbf7b913e41bba0beca60da50e4c4","ca5bf98854ff484a9617c064133c1fd1","2cda465d3d5345908985702d8ae5621c","d4a742f80d5a40eab886662facfd5397","169683e586ac459e91598addd44979e1","fdc55a2cb00649bb9af253c4600c31dd","acebccb261fc4685be390c12017be94a","5fb372042007494bb5c4b1e2efb25728","e166eb1dcd85489b9e34efd46c8c4955","69e90cd6f53441ef87aa364c1f4ff968","dd5040ddf5434cb4925050542695a09e","102866da6df64a96b72dc9e98e3abe94","6e296e844bc94ce59732c801a7706492","c1a8006d71f54a13bbb125efba74bcf6","26ad3c884db8438e8dede0b291660302","fdfd237c21574b6ebc7f8faf82ae1cfc","b731a90533404a73a9d8a17f34d3d9fb","c01423e691cb4e539206f7cfe37e8854","00bebd01b57841fea99af05ebf673c06","5f4da64d01104a77859ba1d5de59a35d","da4286b914a440498ab2638b5cc68b60","570390f3e19c4f25b67f2a71bf3fa58a","086020e11b5f48afb844ad43d04cdbec","00d9971903484465a09573d869c2bd11","d9181daaf980403190ba0ab09b0691ed","5ae41dd2d7ee49f7ae249b4913c4c557","fe9f3a43cb0e470cb2e0e7261b85103c","4db71adf43dc491da9f30118d61c1eb6","51b7c6a01cf74b5184d25f1e71f68128","870a12865f2840cda69a4d9a7e99416e","6adf7301349d49cf9354c5eb5cbdd790","b806ca08c9b84b5a8afa4941bf045649","d0257cf08a644eea8aa09a9f9348c170","4599e91cf10b4b60b1e0f56970ee02a2","46971ae0663a4f4096f57c3836d8c543","27bece6f625f40ce9cb240cda1551368","e41e8dc867cc49e38975c379a06e989c","0b11e72245c94a3bbd28ba0abeb0d311","d5fa8be2c1de42489d9bfe33c2ecc164","99dd9444c1634b6793b97cc7ae4ca26e","53342012026445c1abfe48f3545978e5","51acbf396e424fa0bed8281449362343","7f81c943ebce47c6bcda60aa403889ac","f2fe8925ff0c4938820ec93cf15bb58b","e15bd148c2f047f4a0905f439bd6c259","b13536748b5947b49c8ae4b2b5930f9b","e67c473bf358404e841474e327615ea0","44dcb060592142458e222dde30c41318","5b64cfd77cdf40f7a78ae85efaf28a8a","419e20e0f17748c8837ff608be2c6b92","1b176f0c16d04400a7ca506f6e6b3580","a26cb9cdccee4af3938a5348a0b67052","1a6283158a364d1ca9139b84bdb3ec7e","8c62d81d74144c43a315f40b3ec892dd","0aa67805757f46a0ba60f88d4474fa57","df74d07d058e4978939f74183b5b73a4","946c895795de433ba739e9bf667e2349","496fc1605411482ca5e2eaff9e285573","34185fa83b6043239ed5e591ebeee353","5e7a64128ecd410f911ef0d87982a8aa","2b68b8900fef4a0797e84d961e206083","2b6b6d2086ec437faaf061882221ef2c","3f0216d42a4f49a99cf2fa1423293fdc","ea3e2d8ffc5448b48d31c6e3b10c86de","81198279254a4aef93b5ddf7edbbecf7","17679ccbf475463e998b185f8933676b","65c6292b840e4441a9ced2c9daa837b0","69b46e581e43477aab72036d331d2660","ddf7672012d146bcb638387405f5564a","8e557b3228884235b24a27822dc0f408","aa540b6ff3f248dc93f85604fac3c9d0","f4aade50c2be45b883054a59c32a997d","2666401170bd4690b4c7ec56c0b0ad27","748da698f416499a97ef6648e21c0d18","38f3cbabf3a646c380863ea8e2392866","d115d91d44d840e68ffa5f1a70779d7d","6604bc07d5e64d37ba07ee0e9bf6b2f4","73e2b288dfca4e469beb74efc7b092a8","4bd1836d2b3c4b1f85640d06f271e307","bc761a95a7ab4d49ac07d3b8550b941a","58d76cf54cba42f88fb564606d25efa6","8e916eb02a5846c1b82d780ffe82f7ae","5e44b602745a421faf8ab38db13f8318","1b699bfd40564d00a837cf042958d7d7","f0b069411e3b47629e322134aac09288","ab95e3e942b144f296402d8ecfd8c57d","eecdee362dab486abde92c803b7a5ff2","6118e96536314844b3b87cb946c26d0a","583e8d6421ec47d087792ed663e262f5","726977d22c84487483ad78dbfaf3f631","dc773b132b014db38644e22f18f53653","b9cac5ebcc4e490aa866cc690eada30c","e8a06a66f41a4392a8a92bc1c7935b93","d842df8611cd4b20b083a1bd48b8c355","597d6e754e294f96b673f8f7a084f6c7","ae1dc96f36304ed4b452d11f1aa2b4ad","8d105dbf4c3c4f8c9e6635e3047b5aef","68eb5323af1041a689340ee014184cfa","46311bdf495842e284213b3698469d8a","8f3c933d47bd430985a620b7e6038862","f10fe686ca2c43508e630aa8bbd711c3","cf46e81c9f38470f9402081aad9c5c49","c38f131789f24bef939378e78a4e99e3","7d2c3776df34487b9362ed104b364aa4","b2bcec3a823c43d795d39b2469f585b8","11582c7b3ab3433bb61248945f9297c5","7720adfd2e044c1c9507b8a7b77f6999","2c2e649268fa4b71b0022541b1657350","9fc0956470844c0e87fc44a837784648","5235ac28585a43759e278f63ecc2c4a0","22dedfb6861f4697bb51817641b6a43a","a35890989dbc42f0b7c0d98997ab7539","5b20efb98475420c8e60d062bbf8e927","dd4a61f909db4656a656eb9688c0925f","93817b3541cb46f0ac775feacae09b23","4cd6233f2c4c4218b51b49a712dc667f","9aee48f031384f8aa62a747d8f4e6149","a798a46f1f9a4b269fbc7b50b9aff8cb","e4efd190fd6b4545a08e627a160a0e18","a66a7d15c10f49cc96ac642a6e145c1a","040a934779e64d648097ad123cb18171","cab3064b5f3844328581adbf56409dcc","afbfffa69af648649ad78e99b2df4948","17d4814a5fd945b18e8229bb4b887ef9","47e4ef46dc3b4a61b63e4223f16612b7","984835595da64cd0ab37e25748aed3f2","6381dfec2d9140aca8f6ee2864685fa8","9791c5388f6f41d6ad094030bc4a5369","9436bd60df6844c3a38a9c1907772e81","3faa7c41c42c4bc89098fefc726022d8","8db2fadbd96b4b9f85ea48aed0713201","82aafc857ada43d88cfa4837f9cdf988","a55f3446d90a487587871f48dd59a250","f4e1d0b5294c4807bd473d42e4f8c7c8","0f4c956acaa74552af7f3d3a075ca74b","fc74de3ed96a4d00a8d1082841c56e6a","e7012969879341bdadda88d7be33e434","c9b441502f4d477d8f6a00559fc843ef","2bde698746cc493485cd0db52db11130","8577e4a280df48ac889af63e1b90e226","d0b3e66c909c4b4396f1c9252dbbe13a","41c31d9581d54013b56e74bbaf908cf7","23908df8096a4856a34fe42bafe7073b","bb8b8687519f41d2b7b2661613e26862","5629916b3be84113821a1d5957fd14ca","9247b38663a045998444b6f807617cd6","9f59495d49f3414fa21a532ed018318b","624fc472609a4eaaa5e5145441ecf8bb","e839f36af3e149c48417cdcca27097d0","438997f5ebf24ad08a44b96dcf2ff83b","fec98448efd244c3b0754cd183efe93a","090803445e5848c182744b9148df84b4","1ec3b73cd98a41fbb3766ab428d4c7ad","98394155a58a42e8a1dc4f5f53729738","062630e92c9b44a49fcb5c5a9c5c85a2","fa48c8457fe14d3d944db2c51243f619","2959b15c72ec4e11959ff1fbf49d89be","2c68fe95523c4036b988dede6959fa51","8f9c9f058ebb40ffa169d569933edb00","66d8e4f18cee4b36b2137e9a94ba7f98","59388cf44c1c4cb1a13f9b19bbfffd16","6afb8ce17c9540219ce10124e7960470","e7c80a468b85483e9b3b49d64f218be7","2cdfd7bca22e485e80eb464e85215db6","8ae1b3a1da6740cabfd3856dd78575dc","252d50defc3f4bf196fc07b458f4af95","7702b18ed0434cf1900e5e229cb4066f","baf924c30cae4888a2e56b9f4acf0602","7635760c420f46ac9953c9c9d0e7e631","f09bf67635ca4f82950b93286b46df6a","24a00957a4974499b7ae74b4a724f4b2","1f364b9dd50744468bfaf2363857d279","9977defc7a024d54992ce2e72232fc72","dd926ad0d7f6451ea8caa87b38025350","5e0114dc096949e19a4b8914ffec89c2","ae600e22fd254072ad6e84871132a399","0dc8fdc751e04939b492cc549511090c","e71f0b33d15548dda8de99163babe63c","214dc36783a14288b02620df4389ea6a","36fd87a434e744dea71a0cdb840dd69f","1300cb2a9e4542f88c57189804d19765","3c812a2635e842359c0e7a91c529fce1","e4eb1484d9bc48168673aac4ab3eb69c","e37aaea6b5364b90862c837ae1d2a3b1","bf6232b49eb2419f881628db5fe9a9a0","f8b390a09f9c45f0a634cb0953131af1","067b74954997414a97b6bcb340264cf9","8717283834b1452ca0b8bce8b33d1b4f","36666136c22541d694227ce02c1fa102","f54392fe7137414bb494385e7d0ea617","01cad016a1b3463a9c4c9f86fc6070a9","3bcf5ce2fb064a20869704d712a9cad0","a7385523baf5463cbde06b95c10dc5b8","ae82de808abc4451af0b59b0412e6c53","7e0b249c0c7d41eb9556ad228f44e647","0ef7dcbf1cc44d408bf248e068f07d5e","be36bdc602c64c48b0d0452a01a8129d","fce97030b7f64e7a949ce2ad2c6f6882","42d85fad6e3840fb904e28051e8a2b78","75f65e0a366e48c0a7481f8da147d662","604daf098fa64de792b9823c5f24651d","0a0b082addc249a3818d0fc40ff6e39d","21106d46ee3846c3975dcafeae0a4413","7667f1a1bf934d938cfbb4c41294c117","620a19efda0e4f888e0cd55e14992e59","636a042a8afd4c7aa6a65a48402e66b8","94740cb083fb4e5397520e330b990c85","235652e2d3b34271b2dc3164aeed67dd","b26f199232244aaf914814868fb0b555","b602db4850694a8f83d3f4be7eaf8b05","7ceda123a94d4a71bdcb072691d66c58","6c60c9f8e6df43d2a847536ac5be2956","ffffb2ebe6bb411cbffbad9eed601799","1096d4b79aa44b11b1dc94673577daab","e371bdd55ac740d59c83b03ff8249c92","ff0ea144e600405490d0eccd540f8cd0","336b205ab6ad48419a2f7cf1d5f40974","0bfaa34a1c204168ae0fef43ea60a530","7a8963312ad945609b91098b51a19661","054bdd65f0404a30863c9127440735db","6ce4704428574343818751fe42365b1a","1b6bf53aff1547d1b11c9976356dac94","7022297546764f6387e46563e2336ab3","a42181d146914723bc9750ca3af37ce5","5548aca247e34cc8965c61a227fbef87","5bd2068d87204e6b923eea221d0aaed9","e2f90e0946bd42149eb380ab07676074","30cf7c2dffdb498f84ac4092644ec347","a8d019879ea74dd0becf984bd9d68c43","60d5b23e36c94efd8e129d497b1d3252","97235fbfb8e545aba22ac6108e215ceb","c62a0fe903be4cc09527590ff86127d2","978358d03fec4e418127822a2fc0a554","06059d4f51c64ea7a03e5020e195b0a5","21235aa314e8459d9c28a46debdd8902","34a99c4bd57f48929cc18b92011259f4","99688c964e404c93b24cdf066b94fa60","f648bd06a3d546518c1bfedc27e8f136","4f74fa3839e54e61995d658989a287ad","d7e2c821eca9457faacda76ae3d44678","7e74b82f82434b19ad779dc716a3c679","7f3268b6efa44566ad6ef21fc8a705d8","bc62e634630841d88cd775dfe1a2cc04","6640354df12442f989c0739eaf831eac","3e5064cc2687458f88237d7dda6aaec4","b3356fb3862e4c98ad546cc052e6dded","50e7c0efe53c4a329b680061c4a7a6d1","c4f411d41fe44c15ab7b1ad2187edc36","a8eeecfd68dd4cf1b997045953ea0934","b42a141313754b9d895dc58a2d5d5e8c","998b2173fe8a4aae836c6c8efeacb269","8112817317144431808b7c493cda2a8d","bfb90e5cec394a65a87cad2b107102f2","0a5662855733414c96474ba4b1067213","a000be5c91bf4a8a967943cb3bd54562","8d53d30ee39a4a4892074762b6f05a95","442c6448fe9a4c67b7bfda8df70d7bfe","975b409f055449e783383c2a9143d8fd","05d4b383dd6d4fe1877482bf3bf7800c","f089021c22a54bca826b727c68804583","905f0d98fe404d498ea11d74a5221924","311fc46996c24d24aa07d5ad9ad54fb2","1969ab4634154edd850f658c6af73870","2797eb7f135f470894f9b45c26a231b0","068f1cf349c7443088d83c68bbe8fb25","2be56e2e58904c5eafa5442d1ee22e96","e10a803ae41f46cdbf568f28522438bf","908654ecd92b479d85013db65591f74b","5f7f500e22374622aab2d05e8b61cf55","693e7eea3c804ec89f34ce5d50249309","aab2983a25d94a688fc4ff54e5d75d6d","cfa3866c2b084c77a3149cac51376482","9cde97c6c8cc46b0af82d505a8f41703","31ac276718ed47cebbd58295eb1266db","b4958933b99e41fcbbb6b596d0629029","951c91bb601e4762b88cc681d188a375","ef1c97ca9ba54ede9be3bdfed7065e73","e1c388134b624b11bf9da8533cd10a08","5baa980e32064cce8eb36311b7021dae","f7de99b8f2c74e60ae2cbe93ec48dfdf","b3a5502eeb914a1c87706204419345ff","4853c53dd8634533b61e0a00d17cf720","6c7396f826a642238a4f53785ae8c018","ca747c2911c342a4b6822938e2ace32f","d86ec41d185147729a655a1723f6a07f","eba0fcfd8995490ba01a9232528c8b10","0dd084c38e9d4e59bf0dec86d24e67e2","496d13567c9548ec88db130214e9c1ec","afd5d8c6a8d140dda18fa8a50aeadc94","1674d6c188cd436fa149130a8a7424cd","d40a23e9eb244cb594045e747ff62772","77559185a9c440f2bff080f401cbb374","9ed035b15a884eed8375799b55368c17","0db31c779a9f4b649c44722c112dfe67","829f6809a4554c19bf6e661a4f95121c","8a17d8c4b4564eb7a06bef7d6ce2e8e9","bb336cd5fcae49d98b89207afdddf67f","4aaabf791e2c49319c6be8b85ff7b67e","178c4c94303746c1bd256a1dab522db2","4aa52a173f354c078ad1d118c00cdab8","26d126c7b24b414fa8df2959cca4b7ab","478061ff78ec477bad1319b5b3749cc2","d302b68de77b445d87840ead7bbd9b2c","5f7085782e3a40aaaae8f15aea55b7aa","65c64b6d5c314a0f92797791e2422593","95e939da1edc4ff08b6908afeabe32df","33891710358e470e82551206533a98d3","7149c53b312844f7ba1cad999007a087","b548da8a665e43cbb77af375c784f859","9b0b94c461b845bea2daf856bad41749","233ff30b1fa542679be14eb50df8bb3a","e23279b7f4a8417cbbeefc7cb7b11f02","104e8306c6ab4786b8e5814d4d03498f","cfa8675cb40f48c3a44b0c9c032190e8","3376fdeb53a64839baad01662e14b57c","ff74e277ae66471ca8a44cd8225e20f2","1953bd441f524fde988a697e49875541","010f91b3f8244a34bec02e1c6538c4f8","b4a76238f5da40aea2ee294e8cf8630f","583efc03543c447f9c414b53b2b4a4ab","eba17b3b54f848c8ab615641f01d87fd","068419623ca7480da978a6a1cdd027b6","94d1b1134d3649a98d2ebbd8cd33c40c","c795d571d97c4a888d87d342e5ac557a","12482b8bd72f4034a2a42ebeddd32b93","6930ae7515b8444d816718f1ec02a603","6c685f59c25b459684204bbf448f7d2c","d1ace5cb3cdd4a2ba41e1adf4d3e5b44","7b292d7200cb4c8ea0a5236154136b2e","fd070c7e4ea74832a6fb0aa29ba6f1bd","62e148ae0107439ab1a64a36d0d20ca6","fd5aa206c04447418f77b8ffb7732c66","ec58abd9290d4e0b9b8ca97cbcd1af1f","408e44970bd54d2d8d996859558c85f0","752b430cd19a4c528a517367c917021a","56d09ef3e10342b68ff50cb3311f933f","5b7b2437c7c8459e8bbf238d612c5fd4","f8c72a9d085b45dab5f8db279d1e6340","d004d6e9913b4602b3b46b4da9cc06bd","2dca4a68a655495aafff51d53527f89a","3e57eca95a7e487ea7086809c8294775","5caeda0b08af41a0afde64d6be0d1e1a","d938c98dd0b8431fae0fd32aecaea4db","d689b8aa7156495f990b7b27509db714","742386e75ada480fa4638bd88649bfa9","21a685c9e72245af8b1516f37661cb5d","0f8938ccd402484a82873fde2e52b208","a9201c6911d844419e623ec7defae5f8","ec8b48933fd649d4af48c9762454c0a6","cfdf47d800be41b1982bfcfd1e7a99c7","586e6f46d1b043b784b2dbf2c85d0a05","b381408e512a4c2db07b3488cf4d2063","39e8cdf14411439bae6cbbb1bbc14942","4850534111464e5b84232a49b97cfb87","c3c35eba795f4609b431626731a112a5","96d1a616e929446dbfc2e535d3233d03","edfbee84144941cc864f0abb9b0eb83c","cd40d465fda64843a76aa0284c725ec4","472d1529a1414b7098d7ccbaac542516","d2a03440f2db427b9555a10f007ca8c9","0cfa394a17cc4825a81f7266e15013c3","732e437df7d248c3afbe60a1462b2be4","834b0fa82c304c278b6b7473fd64b7f9","74741608680249a9aafce3ddaf5ac3d5","027e3e1210254bb89fbe01ba1826682f","21f6f879b7b7462facf432d2ac5fbfa6","68fd0a531fca4f4aab7d9bd2f4c2face","718f479a4b15441392ee97f5a4468749","d509cb2c6e0546e5a7b4031481165a0b","a18c3b05eea942159e41bcca1b6c8a29","8a60f28cf94b44628884bd836d8aa6b2","4d5c63bab10d4c1d98dff4891d50200d","8b20bead59a04a5fa668e742235fa7a4","3dedf93416dc4cb3a40b8ebf5223f96b","3ba254c1d5f24ac59c4127830c66e043","f610c6c66d184679ab99659fec486f11","e050112005f543ab90213b62221bd78c","a25d01226f1e4f159960c1495d5c3155","1e9512ccbce34d34bd22ad20277cc805","8608d442cbdb4f56921bda9730b9d402","bdef7135927a4da7b074d9117d08c34d","6885163278ed411a8ec9bf1bf6e1276d","a60c54b055b24f0e96748b25a69ff0d0","24be29986b0440bcb30de8bface5efcd","2028d33f91674733bd57435ac6626b98","b1bf6d81ee824a3baf0590805fc63915","f921bbf7e8574b65a9472de8a05605f4","aaa09a06ce7543a1a26a123837df2bc4","7402ab92d6e64297898a276fdda566c6","4c0976a6152b42d6ba16e616e323980e","8de0c96c101549f2864a1de479e3615d","112dd62d8c40484abd6ac1aa0423450e","9085a644ca4e4266aa8c03df199f7f42","e022f738078b4171bf55b289e5b6ecf2","83cddb0457564efba5caeed97016b26d","9449186871dc454abe7ddefc8a88b92c","4ee098fb3c5949acb83a71f4bcb58bc8","245e9de77bbc49c5ad559c928bd3f04d","1002c331449e4b7e8d5a720ae1d0b122","9a4c5cd28385469e9ea9cffeeb6be948","d059c074d1ab4975aa0f0963b3a79871","e46257a77cfb42a8a625594894c4789b","42ea227db9c84f109fbc080fc83de1eb","efe7b430abf24eb5bb44a6a78943d0af","e6ccfae48d4348d48847a50e13ba9db3","601321133082464a8c269cd53a845717","bb19714fcd504094ab3c7d1d92241001","02c2729852624507a18c0fd2b0031d08","bcb5f62d8f09449680bbde66251ecdf4","1b6b5fd4c27b4086b19bed18099401b7","77512075ab8a4869af3944cc6d64b127","95bcda5446f34c01b881f0938e7e1c1c","401e803091a5464988afc41d82a5cc17","f177e9bb7c38454db93ea8c6e661ba37","a006593d2c734a03bc216b530c0531b4","d14530d734ec4f2c93a1c2979e7c2fad","f1c51b686f8a4e88add393642a944135","741118e5593d4017a83a3151ef772fdf","fbdca2fd2ca543aabb5ce994770dfa0d","a0ac7f8373ba4931be991a6f6f8ae040","c5bb98dab438456793acf220e07fd522","21520f8828f34e5f955d10e30ae98680","8fb18e0e690445dda7cc43bbc79ab258","25df0693dd4d4c179d8863b097a981e4","2f86a40657c9401ba65b4d7ab3d6a766","42a736aadf4f4b62b6a17c3c11441d47","578bf98e9fa548ae84dc679a45609ba3","3d380ccb01e5494ea3da0ae9c8f9246c","89ff2a810671434a8f4749124cc67b79","3445c8e6567a434fbd62829ede5b3bb9","e125ee334420484583626a87c45b06fb","a30d4c6283724ab1be0de021c9527898","ecd62529cd6d4a488f8927e85367c55b","c8c544d4d9a245a189e2fa62909e2dcb","e7bc192b5c6a4b2986b85b98b9b30e9e","8a3938f3d9984985a19e9a21ac39743d","5639edeef4be4141ae5da218d651ea3a","2e0ce38073334479aae8d521769ae9aa","e3118676e911431092ad558d690c2c2a","baa520fb5b3645e6b68275ae3eac520e","390d9b0b356e45e29f959c36ed7c7d46","0386b4d7542a4619bc6bdbbbd487a8bc","b4db7173e43d494ca833e926718f64b0","c1113d346a19449fb2abff9f50854961","29671e6f77f44bb298b4175dd64ed93f","630430e1eebd42ad95699f533703417e","daa16c4c1b0d474f94e325afece49f16","e5f901480f774bb382ee1757de3fbfb3","3ab2cd0dd11e4e1a94b5db7c075f243d","0dc92612cd6c4e4899f7aa415136a26b","13fd6b96a3ad4873a0972a095a015653","a821954c5b754a49a854a8d7cf665f63","e9ee964b54954c6b82f76199dc822877","7cf36eebea93469c9a5da4ff1c01af8b","86d42b988fdc453293dbc70408ea974f","54ce64f25b6c4c079b3b4e3ffbe24a54","58f17e012be24358a0770685e5742708","3d43b743180e4981a5197eae04f2bccb","e977645b798d49e5b012a90d3d17fde2","f3b60198a28448cd82633bed380ccad8","d14ef05664604bd780646ef44a88d23b","a2c8d896ba484ce2bd7f6340728780d2","e8e5441e1056435498e7fbb4851bf56f","b1fcfc3e5e8142daa887755bdf0215df","269daceb9b2944119b641583f8967d4d","d26db66da87b4ae1aa4700cea862ac5b","29cda193d1a64549ab5fec70c694401f","f86eb9a37e5549008e3b770998328cc7","91d4ef1fecb844b682dd92dedebb1d25","36c2255881e540aba03b25d606b46547","8465aea335f842a389be0bd58e0cd8de","2c511352a87041dca6e0a48489deeb2f","40a09a4d61ff498d812da255e1b2c08b","bba57bae6fb8404d82205f14b8a643ed","24a97e11752e4da394289bbe43b91ef7","16a7b838ad6a47269b9e18830968d2bf","563470e796c5496483de96d40837c5cc","206d9f76e1314dc896ef753a913a3633","5f95807f439147969aa6b11d68cf3808","49d039568322475cbb3ae69e72e7746b","605f1644789c477c85ec2c64ec820b15","acab1b976d624405ac22e2544c10dbb6","a104368ddca24eb581c2fc236ba2e8e2","65192ebb70624db5ab53c33d756a1f2b","f0f6fd8f5bd7403987fa8314dd53bbb4","34caddae62ca476e84449e726c9c0a23","5d528f28b8d34843a486bdf95c02ace7","13edde71305f4a06bb6a67135b57c29d","877d09bc0156473ebc0a4cfaf39ef6ee","7c2d51b13bd24480a4c9e696954b6978","265ea697dfd04945b88c2fbcd03e4d28","c0bf78696cff48dfa5ddd0bcd89073cf","7cff3a66fcc64bacbd712fa1350b5fd9","ff6c62df65ba4bc89d41e82990ff94cd","a89de189104f48deaa51d4fbc04d2348","809562d0e4834ca29348a9a9c62427b0","868d8042ce2a4cf8b8288e112d4a1c54","d240f85d746c430fa25e8aaf60d08119","3ba84d2a657c43e48c0ff66b6ae1f07a","8cdf6a9a17c144bc99c2fd2af7060a04","d2a2f270898e48868c947e1d87a55af6","bae0d9f47ba6497292d8f24be1ba4016","50362280596f4beb88c820318fbdac19","6f08a33c01c849baa8d0e4f4c94e4a2f","5f2ad8c2bce146bcaccb680450f2c630","1bd3f1647e4c4d1a9bd7cd31a7dd79e9","fe35d8013175490b9e547c7d0b4ec4f1","88b2c8e2cbe34ffb81f60723bde83c45","854ee9ee20464b65b0cc4c8c0ab6e642","9499be2d9f4b4dcfafc20dd7e6c7855a","93808964cf6e4050b5307ed4e20b8998","ac6eb82eef2f472cbf7343fd08a175e2","f7c21749107941e3b683f287dd42f1e2","d8535e5123d244b581104d22cd65c8fa","61ffa487ea7c4e64a4a1b04afbde65e7","a5ea97e0b6ef4fef9f923af0757c8d57","acc7672d7f5945deb6a37336dd850b3c","cf5db1e4769d4de887ae1443ac8f0b18","fea931a461e14aea9a1aeed356853def","bab18a1c8170430682c16138c25e129f","d7c9869aaabf4eb4b474273a89456c74","db5790de57494335b224be1bb76509ad","b02d8b6dee0948528e89a79449e414f3","61f4ef133ce3497a8d56c71585578b0e","7872a3e36551451280cf2fc8d81ecc7d","83c91f4cb3b14d9db99f8a08479a4e53","8d48114809324915962807b7836766ac","097af87877d749bcb3196c2d7e83bb50","4f7d6ad99b2940288a5eb59f6236be88","4ae54760409f44af801cdf96cb8d6777","fff5e6c47d7a478eac898d69b9dd4d03","fffc64bd9ee2435fbdd1bca5f4a2d814","e5fc538e5841438ca584ecac6bba50f5","a19f1dab5ef441bcac66635896c8ed11","800a68302c5e4800b13d7ab4b8184417","1fcd38884fc946a09815d00c82bde0ae","6c4506fb8bb3479888b8216a0983591d","28277a34bd68403fb8adeb4d394e83a5","934df9314def4732b201923db2b05764","b234f45c9c1842dea428dc430b491dac","60833ebbd5e14071b222adaec365def5","b64fde57732a4bcd8f04879135781080","4cead31aa6204cf197b112295206c2bf","676c7657ae9f4996b38709846a44a70b","7e035ba67e76431a8bd3be40cffde814","358c6b2d6d1e4014925b58a723366a5b","e82d1619f1e448eaae936b1c93cdf3cd","e4f6896374864050b2c3b4f0f15b0325","d1991e42e7fb4863a99009b7f6c373ef","d4faa0eed1ff45bcb7dfd9a9274f355c","df04a51b4b2646f584edad9bcd9f9800","6557604d8885432f8feb2d4b318f49de","7f42b44e62b94bc498de87facd8baba4","2af06b8e5d394f0d9a788e53fc9f2918","499c08b7076f47d193f91b95c9f78922","b7781a122cd942ffab75b2da2ea0ad6d","128b5d6f5c074ca3a7e1da6f5c691199","c076f982afa74e97baab89cb557083b0","4a8d8ac0e0e64bb79051ecb1654b6a80","3f055d36846e4178a8791dd04b13590a","7ffebcc6c5e74e2abbffbd7b34bb9b25","ef8d7708c3c2423ba2bbce8697c88941","55452f9377774eb18f909ae200c41266","0069a30be9694b5c86253b6ed373050b","d6aab597aa934e16a722a470380ef310","59e2140db3e140e0ae3fa4d1b2d6d78b","aa24e8e547b94d609b8be9e1eeeb3eca","7e01cdccde284938acb788d0f4249338","e70409dff278429086df2b4ed24c9bbd","9e23532fa3d443eea190ee74cd0e03a2","bfdf89c4ca9445e380f45021fb2a38ea","9f17f70838a64b06b51876bb91747076","cf3b7afb34754d94a51acac50c7be63f","e49e0ad2be9646dc971883e39eb7b9ce","964423753e9542328159af9865aa6b97","f809ca559d0d4e778c5668e9c69e0c37","3145af091e944c768b13f5bf14d85f9e","26c2e4bc29b046e39f197fef24169875","e13ca473f2a64f2c9d0026669a033a27","5db00c4f11ea470c872a0597c99c637c","c0895001c09942eca71eeb8b8385ce79","a3330cabd1a042919b37c3bf9543ca8c","e590b65cd65442c684310b1d6b98c5ec","58c5b47cd7ef49b68c0db56d47312bc1","5c395ac2143946e7b5d917dc92cb4da3","41083358321e449e8479ecc1f4a2b85f","ff049e60ff7a4eedadb43aa811051e39","f1194861f20349d789a84b6ddd8b28c2","548d432eb79c44099295c1ff121f7db6","f0896d62653e41a5bd1b93c073abeaf9","543bc61986b94720bf822124345c0829","4a56cc8e015a4b369e72c385786c2b74","cf7d901bc79e4db883e5353cd84374c3","c52c4e757fac466a94422b8ef4f14247","02bac49ec54e418583122957b3861d3a","44a639fb2faa43aebe15df9c47182550","b22331ce7b5c40bd97441b556e3fb7e8","7bede79a1cc4449f99af339ff84e6a5d","9b59fcf7306240eda73c55d0a3730dae","7269f94e209841d5b7f4a2a3aa8400e7","4cf80b7cf5044144b37299fa2be6aca5","e5e58af1a8154c5ba4cc9da30889495d","ec4ae3238aa147328d352ad6039307e3","b5786dc852ae41f68f4b3e444ed8c877","ab60a48c2e43414380a123ae34e456b7","0390a14395ea45f697d2dbe27574b137","aedeb45a48e14157802df44433bd5b2c","22ea9ec76db449c8b676eee5d4d34888","17866dc904094d85821ce42a95ad4d46","d21b0ac7471c4660b9bbba249d83bedf","cf944e639602465ea6eae155dd4b524a","ad9742cb214f4b3bba967997b07472e9","59dbdcc974d54a6cb9987dfb2c9fa754","47792ffb22c14aadaf02605e2357f684","aa82622a886a4ae893149c8c37712540","1abbda88e7a64ef0881b93cc746ac99b","96334fa84b15484581ee964466d14414","7188dabac936451182fe8c678ba39bd5","d5a88c2aa0a64441bfc9afdf9a91832b","3fd62ce42b55469ba1c54591f454d8f8","b24cf51f2dff4ee2bb79f648e2efac84","d495788df144462a9fd6e6e622a6d1cc","0bf28b570b684090b0c411ea8cc6c38e","c9071c27d8fa426497a39ecb577fa515","11e6077d4a65401dbad34e2e508bbcea","bad5095cea7d44da89461e23c08b3067","04d67060ebe24d4f98fa1d99300d57b9","9e4b093eaa5a4d2ebee29a8c9b69e86b","982198230c9c49cb9dc3a356b9d20d39","57e32804e69a4121a9cd2db41e50adfd","54558b05c74c46588f113d19f54acb3c","cee19a7a00564e3ea68089494c85e378","841664659951409c826fd2416d3c2f12","9994ac85c3094830b4190345c6e3c15c","4fcb56f556c44e3ea201db02fa7d0dde","5d7eb8b2f4064f8dbb51030411a301ac","a637876f102846089d32ea3bc0d1853e","74275aca35db4d5899f9e43973cc80a6","473896cd1262460a9de1fd861ed7f34c","586a22e8a05746d8b010f4b801630a18","9d1f90df10cd45c5a2fa026cd78a0d78","903575bf009f45b8bca7ab969c027091","540c14619cb44a779ce5b4d6a29e280e","50a04f01bcb145e1b9ef00637fe495c4","9294068de194482da3b18328317a416b","eaef27ca83fc46bb9c3b5bc0f72e04d1","f5af4cf177c849fabae3a75a5b81cf3d","73ce01bfaca447319053a3ea035b86b8","3a09b556bc2c4167954608eea10d37aa","63a5530862c448b3b19601c6aae68b8e","217f37c3411a4319a82edb515f0e3cbb","115fd8c5356a440185e96eb6ccfd8db2","25153fbd002b4e22b1850fdbfde3887f","ceb5cf24f1034af48fc3276e73ef2678","b0c9c9d8ed924b3bbb5926a9b0d42269","816f44363ad647f192cfa09d03e5bd05","fedbcb28b33345e3b2641bfb40f6ad20","56fb3e554aa945f4a5cc371e72fcf204","4805f64790be4fb18c2f4489a3ad91f6","7aa68c8c1e1b4ce08125f29c1e53f265","99b0eeb5fb164712ac87743f139b24e3","d2fea5847475431eb1206d24f7aa36bf","62398d2367e54139b60cfe6f70c05ed2","56f41eee9b784a9085e0caf9a56e44c3","111d5c2aec2e42ae922a5e25f1e2482e","8ad59d77882f4261876048a594d43b19","a73c6a7cc612416e82fe9ac62faee699","9901955883ca4b3389fb39f558947cce","3da1387058b7429ab62fa469249cabe8","9d20df1da29d4cb2ba899e256ca5f9ae","2320734781a54d36ad0f7c57fbfa3c03","4f27a313383743eebe09877716df7cf8","40dbe2c63a564f12a99bc607434ebc28","43ce48a80aea4e7c8f4f44c6894ab65c","d0d85ae17bbd4e189ee1829ebc7db990","aca0f6defe274ba8860db1a163fff32f","ee9c323b8a964788b5f1ac058347dae1","9e3e403a4d474a6b920eb1af91ca6c08","52397774633c4ec48a2e9b43814d7c67","be701a4af31c412ca5fb72d4935b84ad","79f16fbd0fe740ca86ffd86b30b8ca9e","8cce6ca9519047d78a8f5e57a35d0560","f5f373ab03c24364b475797e9459e16d","7eccd257b0834cb8938b97a40116b5a9","74b41049960b4c1e85b18dfc83270232","00572623851f4a27a8678857c4abcb2a","d2e37e52961a438186fdc98f0375b1ce","7653b10aa48e499cb920065a3de61673","6847487239d84971a57dc2de317ac118","7639064cf02542a4b0fc31c25d19bebf","093d30a6cc7b460eb939bf7f44f1f7fc","572b3da8d7604ab294beeef4d5ad7515","1b785e084ee04e33b21cc499627199e8","80b6c5cd600f462992d6d143b58f8158","2747fc75cf2447cfa3cb7dc517d33fa4","83e0321f91c74a6d93bd0eb4182ea836","5f27eb1083154af796f1afd98764030b","a4acc6c67c0447b28335ad3cb66c3bd8","6fab8cb5ba864ee1b96f3ed84eb34aee","54a9e7b9ec574d36b887a25957333b74","54440b82f93c463dbbfe3ee56fef879c","56bb094af16a4cdd8b6d6a3359528440","b68146da410b4fe5ba04e923f4a70595","90cb7a9573794d84a824103e817cc35a","4f338050e5a040eea2bce1d8a909416e","b6ea4a4f2bb649dd96c808759948cfb5","f8b9c2034b3c445881a17f3162e030f1","c86871f8584e4c9599f9f5d0a7d503e6","3b5ada1785c3441ea592f95878fc3130","771f5a63a71e486daa0ff2aedf205803","825b1f6920224652991b519e00a0c1b5","98bff7338c154371bf6cd8d05781c358","3768812f75bf40e6b9223b7b0d4fab63","c23b045519f8413ea02e2d63099649df","bbab9dba922b4f4cae3ab49e6fa242c2","7e4c8451a5ed4e01ba80c5020879558e","f58868cfa84c44dcb7b011260b13295a","26549ca6f48f4a94b4a6cc082b34f32a","ff51690df9a84e9cb226e139c9177546","639d6a418a8245bb81dea2e2dd081dce","52aa5243aaaf4feab8a81789cf6818a0","ea6590a960f74b35842c67816573d876","ddcc36bdd49841c48d561ac615d23918","3d630b67b8f24f6787743b4afc616289","512ce6e3c1574822910245c72e588ce9","b8dba35c19714abfa8d1199646ad3937","5363c075381343759e5723733cc91323","a39dc1e3ee5441f7b363bf4d274b48ff","d165939e69114f72b084c4fbaaeecf70","320bd5964f30459db27dd65123218a3e","e3944916a8ca44449b160c55ca9ed198","7beedaaa893848a092bf0ffeb953fa3c","2ce0f0ef681549f3b4cb47ff25057cc5","d80bc0dbff5d4fa895ea5a1dd79035cf","861a736f8b254810858d3d84fe346c0a","cae5e01948174be29ca8fd34bb12cd66","1150d83b08644784989a00470d5cbacd","db7f6e43b11a48358fc24387436bb592","2be3e04477de4c8eae77644cfefb05fa","7cbe1cc64a2a454aa51ea0815ced44e1","f15b71756c394bfe97fe7b32f09f1817","71c56f0e5097400db9f76bad7534a1c5","1da029e5d8ea42c09a4b3c3b059cf6c8","5d62d5c08d1c422e92b4a05274c1de38","c9f6e82c64b34093a7a8edf90ea30426","fe84c0366be945cfa734f4b4f20b8959","2348088e5b634b898498efb94ca2c510","e244589b3d394e39a4e1c091f2f87d76","442cfd07842b48e4a787b57f367e2e76","aa7a8c6c421d4f9f847822b2adcf336c","20bfaa00955f4e0298abae2f4e81afe7","42b65b06bf83443ab097ce6076932bd9","5e00fd58df624f31a4d40da88daab9d4","c1e0f6a8cdab43adb6a3316065214428","20e118b88cb344688041fbb8bbdafd97","986aeaca4e7048989351e463e44de10c","e5a737fbffee4da4a2c3324cb5bc4bf5","aa8f0c4452ad43f98a8677f2f3492445","2d18bf67088847deb4ef75a8c9acc4dc","3634ab3aa1594b2aa841c3f9e040c750","229a84299f344193acc358f7a80aa87a","2f90f18ebef34d93b7bdadc164a22c1c","07c5c936d4f041119bb48269c891e966","0f698aec44b34eadbe05cc9251639a0d","2116e22f335841e5a485087299928efe","db48f3e7f6444f7f910e7ce7f43a14d7","186fddb8527a45a6bf7fd87a5e13966c","337c7d3cfaa14e3fb75f302e761fd090","c727b01e55c248d88e8d8f9a12aa797c","32d8874c02a44eb4bacc284869053205","c6641e7d226d4b48b65aa4feedcdaa0b","450b0b9d6208447d93d14bca1bcb60bc","e1658ab42d284d39b593a684a66e51f3","d9ef9a25d14b42f8aa890b243bb59025","4edcae564ee1431d8f182f1fd08a5e4b","64d1104fd18a4c6ebfd144fc7e75587c","ab2461020f7c4479be62ff609a8f9903","f49e1a035348488c8d1b61530868e03d","680c3596c93b4ea6a3bcaf311a5d7fae","c7a998c47d674316980151dac913e0a7","cf09cec0a3574d79ab46a49eb308d8e9","af3cf35f297d493382043642c25e5784","1a451531ca1e4633a8693f89bf4c007f","8dac7009e2094728b4c492282e6225b7","64c3b6b324ca4be8b078e221ebd74d27","bd3738e9aa06489c8bde9a967b36e62a","b646b6ef36b54e1d859ba2f64e997aee","db54bfe5c9e246c2b36d106d13847623","2b8999f0bcbf44ba8b16d57a778fec17","325b48f6b4f8428780d96c69741a61b8","452302dbb09c4bafb62a503eb6b2931a","2436aa7783184a8d98c926534bb298d5","25ab2200598f4cb385196ca5819deb6d","23cefe8b43f646319f95b1d6fe3e320b","5b86c4079bf749b3acca261b874f7e4d","fb0698d1e3f549d5854a46e3f666f670","006729d8c58f47b9a08ecad3f00b9ecd","a1a999263d394ae08bf13fc1eec17512","0b08b832d9e146648c89609f4acd6408","2e84d08130884a2c9b6d08061a85d6b4","164d75fac37d45e99cf4f5bce046aaf1","50a41f0b0d33459aa978ff0db9d245ac","2a5f7aa05fa64e489e6fbc41d7e252b2","02214818d27e4e379f80a6bcb0197df0","bf1f1d0054c04280b84aa05ec9caa2b4","a17061aa5e3a44538e86e2cde4dd2d42","4c4daebb4ec44d95924db4779d886fe5","1b1cbe35a0534ebd98d6af37ffc580fb","61c6263c80fb4e688bd6bf5da5e343d5","e78b68fec3664eb29f9b468669048969","c01b0bbe12a14144873c71161b2d0a31","4cb42b9dedde43e0b5f045212554d991","101141a552d14f7295f1ab728a4de1c3","43d3ebbc67ee463abbe45927f4705d68","0b3ca2d656a7450bb373d6f2390b580d","21d89818200d44e6a3ac37077e3a81a7","1819410d17b840e4baf3a3d87bb9bde7","f97adf2f66f44e8a91cf1105fd7eaabe","8f68c859c6fa42f2bfe29d4b40b4e614","d74b5c3758f049e0ba1e4bfa99c7f8fe","016f893d676047b78379e03cb2cb696b","97717af8bb0448af9d7f89a4ed465027","9e46b68f819e44669be647d01770ebbf","abef67eef5b74972abb321cd4bd6fc78","1845b9cf6c4b414fb63d7e79c44ae080","2576198045844ec3bae475dfcdf97182","ee76f58ff8b342368e97471f6130c183","9cd85b4c0256456d8906a5ff721157e3","728172530d8b44ceb146f8399d497b35","64da6af3f762467c8e0c6e46e0537f0b","fa2da455fbce4fa583fbe3e1936c91c8","652105a2446f4984aab10fbaa79dd4d3","571191c8378a4a69ae8c6542f036e266","d4a09a8536634d40a675af7cfce3c68b","41bc89b60cb94ca5b8c428029649325f","ef1b2c6218d14a02bdd77b1523ee206f","f6442ec14f494e94b7d61a4566a15734","426fa5468d374cadb1fc4b2b3bafacd1","1424c417e9034777a44e3535e55df5f6","ad21d1f95ad84235ae95110ad3d9d9af","44ade40b83d7450f8fc8b6dc34b901f6","c9a36a951e4049f88f210b6df24dcfb0","92194a42246f4eeebe65ea7743cdb167","7c9aca95a6844daf9a936b69a485755c","ed7d7f7d8c224d25b5ea16b3d2c2c0c8","89872d9327a64690a318201cab63d6a9","8f94d4af005342938b1b4912ac327c01","b2f9d0e6e4a64821b1e81d1dfc00534a","4eb3e61030f24f9aaa125a3635695de3","298bdcab4adc4fbb93d00beb6da41563","df7f36aa540a4d95b80c40cc49628903","0df6468b4c44458998914aa9242e699e","1d93e2bb0b33487e86a2fcf7355f854e","57b8145d6b17477f9956bb65cbb1d22d","b124e6cf8d9541109889d5c620d0dc2d","85ae81fc274948a6957626324a71138d","9dfdfa02b93241799821df8513e5a5dc","9f9e80ef5e904d3983f46d0ba43ea359","43094b59cb7d4e978a50e4c67c18d0cf","c39f36e4565a4b46bad531df1e5055ee","a3aa93dc3965443ba48b2bbc52d2e8a8","fcdcf2d83c704a3abbfba9309e09f615","17d0d7f5d8314e3ca323fe428354752c","02bf8cbff5c2461eaa4d380a9cff4a37","43fbda1f6f2d4b4da3dd031c20267077","13a3bcfda69f406ea1cbf2224790b189","3af55ed6aa174718a26839084a134eb0","073033e98c6c4c868c968fd8b7a8f618","dc4808a499ab41d48157b3447f561ad0","4d6a9d77ce6c42f19919ed760cf4345d","5340d8b603ef431abbce531892fb0d22","3ecdf442874248fc9a6885d2bab579db","f80ce27026244e24a8e2830bb91d0baa","e73cc86a63eb4efaabb588b5e16230d2","bf98efc9e8c5496daf89ea0aee19745f","09f96fdfe779425499048b9a80e9a423","da1db9dc7f5545aeb842b16997677c93","43bb136122104527969535724a53f27c","ff68a1d8b10a434898b2834e59168afe","4f1bff2a9b9147dbbde4e841784a9efe","4bbdfbf7610440169be0b465e1525170","a216327010fd4594908694b785d12343","a8760b2541c346fbabb419c1c3e6845a","269f24a7eef3486a98bbd9be3e9fd1ae","6acb96f449e64efbaa761d5f9aded9bf","06c9376142194f74ad365e8d58168b60","3fbddb34334146eebd4f9b58496c41f6","d7a97e54a9834d8fb6d3c1223588996e","631ee3b5570d46a191a27a7b39fb58e9","ab94b22b698e4bb3b08716e10406002a","d01e59b3dd1d4ca7b4395225e8e25a8d","0ad8f0866c004dac86a81a5d4efc2d1f","5077c72717ad48cb97158967a311cfd4","b15c3ad772b54a1b9bc13a84db022c2e","cc609ca975664ba89eb5be4137d120e2","9a423f320ba04a0aa4d7b2027cee06cb","8ff98d890962465eac9d0a9f1769fe8e","91f3423b72b7462f827ddd7933778e27","d41855b1e7e14a579fe4626822f3db75","82304f3b00f348f6aa5af1a4c51760b0","067b6230c6964d2995cecdb5fdaa2213","615fed68a4e64a5cbddd1ce66b3d806f","b5e488513feb47bfa297868a0d6043ef","b809904222704979a77561cb503e46e5","8969e825c6614e42a29820fb8b6bdbc0","4bc6914141314b83a1fe9cd3c67b7d85","d604c19a6f244697b9c89e44ddb08e55","a82e8ae3c0b9401897fce03a15909138","f220632ebcf24e6b91bdc7c1ef23a640","ed9a72d5c23f4be3b04201a182fbcecb","ae0811838e5141ffa5e819950accba38","699ac20bb8304b29839d264a692d87a8","7ae1b5f1e89c42629dbb67c2835c836f","f475bdfca6cc48d0a10fe131910fdcaa","b1ec9782aa674c45b0ba28826144a96e","a11ec62bbaa74dfb9119224a6c10147f","3a9e521bb2f8445fb3cd4324f815477f","b87c9e0f9f4c412aa724ae2b8ec5ab2e","fdd68e4672f64bbd8ce96f336d875999","61ad4ddc268e47a6995f1ac499afd540","a368b5e69e4a48528dc5320a025e054f","6c188409e3d64aa69af3a6c85c5a7821","eb765d93825a4937a737d1a147429a08","b847d15a3c384fe7afcddcfb48473567","d93ef8958dcb42a6bf0b1a66698c4385","c32c2f2cd2964d3796695ad06a6faf2a","f7b1fadba3d14b67aea50d136fe29c11","4e47cdfa7b2c468589dac8bf74529299","0e463a593c45460291d7d617d2cc75c8","b392220174284bbea83a9280b64ccf53","800ebd5c96204eb89e052bbf539fe192","15cf31d2ea2944b5a2bc8cedec6c7c01","5a158ac1896f4235ae80e8560a6c11fc","20d4eab747b348fc82d77a4e5ff6df9a","8341e683d97f479892cdfe0d9ef07d3e","1d55523727244214827e614d05372d61","9a8245bee9a34d4589b10158a5822f34","9d7df81985624f84bd3ee0ddc310a14e","42ccd4b32e1c47c18891ee6f7a362e4a","b67c26ef40004ee28d8d0f4670471e09","9941d460da0e4198bcd66bd3ce3c922e","23739c1f0ed24d02ab6c61816daf329c","d47403009fce46fa9a6b0bf13d99dd69","f7cdadd427714d9cb43baea79ccbdecf","22984c663f72477188021baf41fa6faf","c40934ca61a841e2a7403b0b5c7ea2b5","e9743868dd6a44dab389af01d9affec8","63082f12c57740b88a31360b62a64a60","a3466c16e3a94902b24b394b699f19bf","b74621f29a134c3386447e12eb1572a0","6b01db126b7940ad8cc04bcd4046cbb0","b091332a19784130b814afd56f079e71","e70b8ed04a474b488da6244f8db3a207","3c59d26cf22745ea92ab8295db8c3c0f","0dd7d455304443f4a508f6f41ae908a4","ed131185d8874baca47effa5b419e4df","06b015fe4d764ad3ac9e97e14b2e2887","6330099e5c484de9b1721ff1cdcc240d","45bc07149f664c1fb6992c4c8ba84b86","07ea74f893e448ea9aa76cf72b0d7b11","0f25751057274931a1908f9a7fd6c61b","946e069dd8a84ede840191e7561923e3","1358ebff0ea5430e8b7e0576de0fcc7b","1f8cac9dde394a958d64a8c7088bcc61","b4c79398498c42dd87d29469f523921d","311b174ba8b54a43a82dfb642b374095","c0288b895aed4e518458095dd428db66","3171836721704b05b2bbbfe40a136792","8dd33b0fc0c04a57a7acea610b0aeefc","0f3820682ee147c6a611332213c98eca","c04ca842457b44299892f311d9399d83","512c554b4d50412a9dbe5fca82b3671c","ed1a2a64ca814acb912b588237dd0036","3043180f4c704e5384b84bc1e9dde932","061209b68a574c4896c782a5c93fe2ea","c235e0fe1d1a46d1a5cce5fee23238f2","c9bd12c6f9f64012a1b786d52a76bca7","e448c694a40f4689aa1cf17a15ac0c4c","a4dafc97828e47458a9e5efdc33b2abe","0f920e1d959546e981d3946fa82b4f08","56cdb30f116d4c6e8bc9fabec82898c0","f1401ec61fc04dd59844089a1acc3c1c","f439f694a2bd4966966439d4bda7018a","296f2bb1aa3f4be99d2aa5535533cfc5","e25aade715594a1f9e0047daf0a94b47","cf82fb6e817c499c988270de57cdc0ce","4f42d6a5ffc94da09f72529c3ab9c9b2","b031835634604e8c8fed808cbb90581c","e4c14f6ab6f740378ff75b35da123852","af614563530f4f3fb2450f91188c5676","6a7b7daa999047db9e53bcb053b7741a","98799747fda449799cce39d382fce41c","5dd57572002e4a1cba1e606723279234","8bbef9cd0fcf4c928a41f727a96e812a","10d0f2e17b6544aeaf074c6c6c6b0215","23f6a23187354441a8cccb9156c086c4","1197d705444f4fd5bf8b196116185ffb","fc0c3014174b46809c0973f3f34c7842","54a8dfda89fe4e71954403b3f607d63d","6edaf266b4714f06bd8aa8f5f2a5240a","55167a0a70e747eab05596fb7847b774","b4d3189a4723496e9011e67b7190a887","91c4a4c8a0234d88947760e6fe243401","1a345bee9cfa4e3fa9dfed616f38ac4b","034c18e694574eaabab5156806cbe0c1","b26b6b88dfcf48a6b3fa62f3f8cfa987","0fe24fa97d8f43c9a6dbdd3ad19b6cca","5d690085acfe40bf88faaa85e3032133","a4f6f24a30404b31ab5d10f17f5cda67","6547cdacd9a642f68480352c0f76c88a","28c71b2babcf4b3e901306dc2e5357fe","2fefafd5f7a04abc85d06dfc3f48e042","93ae72324d4f4f91bf689a437cbf6907","bc62375db8eb43f1a1fb323fcb5f7330","c440bd4cf3ff428bb0c293f318f2903c","d47f7e1cb03d46b289b9f88d2ebf0228","2f06d4e08c4149d3bfb558fc72c4b064","52b645d695954387ad87a53179ed4893","6b353b0dcc0c4fd0aa2f0a8d666d9232","bd8a857ecf744f39980be183217b1fd3","ba6e615cc5e84eff9b7ec3d1e994395a","c7deb94bae714336bb3cea0462b6f079","267265b94ad9441ebc2e8bec540d3911","6e53e7cc259a467e84323dc820095586","00e8b87ef93244358a94ad42dd492e82","21bbb9b5c6c746968656e0b379ff30ee","b3fa44ec34644b7b9b573e4d7daaa0eb","62e5a85c369e4b6dad3a1ddb3fcc45bf","5e38ff36e6c04500bd8212d2cb651019","93baace8d1ff4ad9b9eab9d31c53cb79","a9e2f0c438114381b805896b309b7eeb","592b3121ad6f42cfad4a920f11c0f568","100ca9d74ec14d8490de90239030c895","e4b04ef1363a4276a133b37a8abe4397","68b2f795f541479f97603b60f98822c4","d651da27970e46a0a0e706c99dcbc67e","e5aba4cb979e455cb1b119a764f19c99","82f9cc2d42b346798888d5a585e10347","fd1572d1d7ee4a4e9aef6c4c37a10833","7f909fa52a1547ce9024747501d3d9ea","3299094242a34367beaa09ff8552c475","15aef3a058004b5daec8f21ea560b31a","77b52c7345a6472791e5fc4f97d5a497","80d084ab212d4780a05edd44bf2af185","cfdcd5db761b440bbe28815d638d420e","5f386e960536494a828710fab715108b","57653ba9ae414fc3af97e1f3b3a85a87","02836952006a4c15b48bd35a8af4997d","fee12c2b401f474e9862666e6b155a5b","5970db2e031147b99cdccc893ea27699","21dc185fdd92494f86c75fd852536445","798c7f7a12ee4e3b9cb5c56d733365e1","c2730de4630741f58faead4e89a9ea1d","e90cc69a894b4e0993f9155b87ad4d7a","c8578d083b5542bb86460e77d48cb79c","a388251c4e9a4ae7acc69b3d3d7c1fa3","8787e3b5d901413699fb66d262f8e96f","1b04fe801cc84bd688022c441ed3dcaa","afc33062e9d44d73ae18a6f58b398e66","b09b7178a8b04f44b72a2fee453997f6","c805d48500c8403d87281fb87f3413b9","045e2b6a95084198a65c1669e8d45d18","835fa091307a4cf08749cf4ed34a1a62","a7bafa097e634332990157d989503baa","222b551df51b4b2c827e879108bc0ab9","cb7580717c8542bfa4b7e5e06fc3ac32","bcca4d0978044e0abed8d270391931d8","b93a07da97a44db9a1016546fbb541ac","2517101b631b47afb2e1df70f016b7b9","c285c812690d4c2582935bee7d651444","ca692f3479e840b0ae86c22b2cb7bb7a","101d4142cfd740b3a5933a16c13be655","2c985869dd914140853f78505ab5a20f","80358023abe343c096a4e39f830ad2b4","43def3fa66944a6c8a538cc89ab004b5","81218f13bc7f4678b19e16a1bdaf6334","5006242095f64fd89435aa27e6e77a6c","f4bfb24c9b544f76b4fc8c5c258837fa","9fb2e4cbad1f4808aa481e407112485d","7d4236bf238d48faba8d368d178a358f","5152ea6942a4453d993652a35d7cac91","4f02eae61d4748e3a7466c439f5b9fc8","5c40851a02f246b8beba5990cc72e6a5","150876705bc441d1b220fe29681362b6","dac5e379ca3a41b5a12d01ea3670a5df","033dba6d20174c7caa911642c3cfa36e","39b9a2be871b47df964116d4856b3825","c2f2558d66034f2291ae953db03dab07","8710835b294f43498f2e0d3cd31a46e1","4148616effa24059b23829a1f1a4ebc8","b0cc6309378b4cf78393cb660650a79d","c9a45d83e881472e9d12af4af3798f4d","af5e601e0b0442f8a9b25a36fb42e5d1","5356dd570b4844d6a0e159d13b773a0b","eae2fd44da854c7ea69fc80a4511ccc0","71b4af5355cd417db93e27cfdd44fc5b","2163afe8f43c406081339d05539eff6f","d087aea4cc824b13ae47c9f5eb873b96","a8a13c087116458a95372fd44d2acc02","bdcb6dc1ec0e4a37aed3999f7ed6ed13","bc6e5b859b504266964105883040a2e6","866e560c4fea4cd184c90c0aec311702","f8e4728c015447e9948c981d5d70f52a","fad0af71102c4fcea8861158e9fad982","3726f8365e154e7e8bb0419512f6c565","0032cd25bcc4441c94d8600ccbe4ec95","009f505db953424dab64e45e2fd11b87","f8b38ff1f00949e7bcf27ae41690d100","e2ba1e2f74b04244b51565b6242d8362","4d5fe74b7fa2461fb248e9f887cdfd2b","e0e2e0d152ea443c892731dd278f5f8e","d50989b4a78b47b58675c4c8738bc42e","d72c242d02104898a228f7b618b4f535","4693ca49b43e416086a64618b778582e","b6db94a0170d4edbb1204d57f307b156","3118288c9c3c405d909c6fe0f0f1b537","17f4a753295840a4889ab3aacc40abf6","ad24fe588813466d81fe28437e3c7b46","80a572ba365244d6957a16166d654039","4464f20c46cc4edbbe1ba0e8523d2e9d","55ee73838e8742c7acacab510f95522f","92922cf5627d430eb126e1a474898461","1dd2561f28c64ee2a4a3334499239b0a","b95eb01ea5fd4f5580864fff6d15c1d0","78fadae4bbf64f8c9a1e85cd2ff78dac","2ba996c48c9a489eaa92d1af3685696d","941c1d7df42c4b4ea4246ea996d3783a","b1ff4eca77314392aa1781adde6409da","c6f195f98497411f814cd560714578cf","57bc374282764a9da6527aa827ad0a93","30e7cbbc90eb444b863df446188a2263","e45d25b0bf474ebd94177fa40731e4b9","4db9913baa6049228e7d85ec1f6edb14","e47d479522df4ce3824e01cb6a7e3e3d","135665b916b342cdb25f888201a2c121","b10768aead744688958ea83226a25f35","82fffc9cdae34518a1fb0ae8ce49afd6","536fb1dafb9f41158991fa14fca126b0","f7a47c9828c44bddb796fa95b14a47eb","0c280d48f25f441391ff204b7d854b25","6da2812f2cc74a3a8b226acdcaec3c8f","4cea5ecc69fd43de93f2a55be02d4a13","a359c66b69e34232a094f24b600db54e","c0cefdcb28014d469c05efd5641a7eb9","13f7aa49b7144a2a8dda6174830cf69a","98b3e7ccaa2446e5918d5c4f3adcd609","f035dc27dddd45a9ab3885305ea6ce72","0aa46e9aa0a3403397939f05005c1145","0454e22cd2e14545ad1c2ceee7c36a1e","cd4a4d7564b34db9acbc80ea7e0f903f","6a46ae5d2888484eb79edaafa9140262","ac8a9ccbf9eb4d3dba5c3b80bfd4b2a0","21e656fb34a54fbda00a94dd57ffee30","6c85b9ff2cc94557a48286239ba2fa88","5fbc9003474b4e07a169361a97302e09","e465c35e83944cdc88a8721d7f21f78e","9f4c8c0dae6e49a09b9ff210047e3409","c9cac4aebc0341648fb4e37ae58264f2","213a02bee60444a69379a165af86f581","f497eaa73e2d4cdc93994f2a7a5a2c46","3457631848ef4329a7c8e742f2f7374b","abc0e4e7f71b42d8896b3b8f167b7fd1","ff7c1aa9f3c8460782c4189b40f89d2f","91e2376754a4462096d033572ae01bbb","cdbc9a2a7b104c25b04242752439e30f","54650eed46f44060909f946f7c62b3fe","14b4a9f758074bfdb1ecc92444c3725c","2af69974a0bc4c9ebc6dd6cc2e26b346","da5a39ec23b743a7a60e76a1dfc1a061","a9f872aaee4443cab7caa3df396e5913","ff8e8144486a47268025702b16c1684a","5f8abe8583934f3bac5e09dcaa122048","2103e1fee0614250a9e95cab98145191","68d2ffaf6a6749ad9163b5f030d59cf5","b78ecbfbfb104f73a873d0a532749e9d","86a20342ec764285acbf9d1e8bf1dc97","7f56a418f4bc466aabc90e40acd5504c","998ecec7fb264af88327062bc5d8dec5","e2128ef258b047b4b1c0b0c9d4175c56","5bb7a34e848a41ff8cab5d461b343ec4","831612d6c26b4e619da5710b15d4446a","59d7e95864d74298bfe0b6d839d97293","416c0bd420704adf9c0c9e5b6588f045","aa9f107bd7f0476da8a183d48ec50955","9309edcd1dd749d9b52eed784a4c1a92","6f45a1b26c054035bb5c380816128569","a759e94f880042df9da18c200ae6fa24","f87b34870e394258820ccbe5ce0f6c94","fb4ffda524c742e3a9c2a5ca7d747774","855a506b875a4b42b77b11dd5f735d05","e3c01968e08e4f25b452cb68beec6a63","d732738847484c9ab021fe125d3c0412","4d19099c7bd14c568338aaf9336bbbe4","ddc778c594a14ca197291c7e21473254","10a5354729e649478cba7509b491ac3e","dc176b91d3fd4994bbe121bf4ad1b7d1","11b2cc77995647e299e5743e499cd928","f830102cec514dd2b4e14b5226ba78ab","8d7f43341d0241cfbb3574700a401fe0","a397d1b7b0794f5ca42118f820f87f62","b00cc570e3324bb78de8c667b17e4d99","4e60d9e4e1e040d681df473f93de7160","35adcdac7e39424eb2ff134786b17c55","358a08b80b8c4a839e55ece444853148","d61df26ac6ac48d2ad8c9acb15a2d144","07119d766530498a89d0303e30e5c41d","eeb283d4e1bc49a89b82dfb2d3167d7b","69538225963c434aadb63d9fdf378e7a","195fccfd14d543818676174ca912fac4","2e45df918ebd4728b152a7d8ea5ee425","cf1590cdb997403c8e379653a80847b3","580ca19e72e04758bdf8dec6341c8673","7e5575ce3a564be4bb606f17f4bdfd3e","96b30ddccdb24c79afdc19bb80869efd","92f2af15f0174c21b2f4b1bae5bb7870","f5be3d984f424192ba385ea172f640bf","2e7cd9aca96f46cb9d2c3e508bbd8a48","9db33a180bb14a8eac486e28e428a2b7","fc5a34c076dc41cca2b819774395e807","ee043893a91841d8922c304d106f178b","31fde0bd3cb44a2ea55e8558fca6ea5d","9ed53489734444c690def02151f6d0bc","08b636f96030495a92e0c18e5dbb4906","33391d9949964b7092c72f9fb88eacd9","e3f735721f4b4f6e9ccd82c3292b2ae2","b9f01ba2986749d5b3b1619f736d8b03","25c0d7f999db4ce88947f3eab89fa0ab","87f99b2e890d4053b47b064ae110050c","48721e3c6c82426f935cfa5366afb423","50287a5e50c04143bd8ab8757856bd09","9c5666eeaa1245d998147c8159d729b6","dc60d653f8e74cc2ae5a5a66e82e9f06","1da779c9f40a4fa19265fbe010a17445","7e04c57039fb4423957d82b45289c869","7f60832b762c46eaab2b39f71e65709a","ae2a902273c84b15ba4cc2feee625ee6","52197e33555348c1b31d0d7f98c53b33","0a064eb6c5524fa6b49a33d9a4f3b274","c5c8f54c7f214dd3bf1f9472bd27f5f5","5e46e4e97cf044a39ea9a7f4813020ad","f3ccf0f0fc2f43e997315bb983d41e6a","381db2e3eb6d4e50bf0226d8c322edda","de2f775e2a904f9491f41746741d470e","59bd73f74a924651a58affcd49b4713d","9c0df71c6fa84ac79f369252c5513633","75cfe95385cc47acaabc001048e21977","9530b22a45074b6cadf20c3cda69b338","6b6855546ca4418992af41b3c244250d","7348ce0cea9c4044b362e32c5f21e08b","3c2867e50f8e491dac7c7cc6745faaff","facb983e185f4d8a9414c10e5d10d065","0aeabd212650407abd2de32baf4fbb39","586d57997ed04e05b1eef13a4ff088cd","93eaf8650c6147d0817cad94746213e0","4e54e63b449446b18db518c1652151c4","1494017b65f64c05aa7eb64c1652e2ba","cfdee12bd79840c9ad7df8b345ae2963","d5ce996bd30d40ac92fdbd8d32b16cce","38f3532d36bc4f4b8a54264adbb7292e","25a462020a634c25a7d391f995aaa611","072d9c87d6014117a634e3d6b1977d15","9212e86583a246ab8f2ba78aa929a7db","e17b444049ae44a7820bf3944985cf71","d1eab643a3654cb69e5ead2017d43496","314db16cae9440e2b14ee430179daef4","aabdc8656b5a4b4f955c50251439e59c","5f186e623a78432cb5fa1932c3896700","4cd6ad36a3b4408fa3d027b484ee06e7","d64fe3e507ec4ea8be5f22b07aa2b08d","8ad04b8f8cfa49ce93dbbdfd31ff569e","c7d40adafb124f6f88fd6d2cb248b87b","cbb22190e2b84094aeb2caabd281844a","e36c0240f7b84833abe206ec861f8c9f","296e0800d26f4252a94567fe7396b0c0","46aafa0be1044e23b5218b6c201854a9","3fc359d79c7048df837ac874329bed44","b518a2837f084f42b47ab6cade347e98","36458764667d4454b4fe5430b859fff7","563f54a9020e4addab65289bde8dd8e7","1a68b53fe08947ed8a76724951aabeee","1bc7993b70e94e718718db8151e353e2","21cbeb569f3243c0a3b0624be4a3768e","ba6d8377174d44089ae1a7fc49426904","f5977ee5ed934d81a0210322373f4dfd","6b8e6d8e70694db297d7fb336f249140","8e53d0f3c2824459b6de716fe3df1f07","e24d44e037934c829c0f3d56bb1a9c46","cac84cc9ba1845ab95f499997b446522","0122b207005d42a18e8b1fef2194b905","f40d9443163f49e789a0004991de1662","9237c97f66b3402bb1f9cc8a7554768a","136aebad3ec74eb79787650a25225758","06fa7bada83043f08c3af520e4ec6835","23698d8f980d4bf0a9b63460e90537f2","18d942b5acf04b2e9d2cebbe49561b9e","8eba4c057865466eb61ef67a21610a90","6a70743e69d64bf887e758f89ff03522","60b2ce894c904dda932980b884b29485","d073c051adff42bba00c63979e48e610","f86e6dd437d04e0bbfa8224619d582ff","1143a652a95d40089e86d18a5e797557","3b3c66493e594634bbc988feee1aa34e","82111cfc670241de8f0fb43d276c5c86","8130136eba684ddc93cd9c923df72d4b","e10ef4274f194b03a380facd44efe57a","f60af430525f424b91cd5983696798b0","a42f225e928a4e179a599366fe065718","5110c26b2fbc46c7a987f01d87155dc8","faa476f3d5d84194afa19533d073d201","f27835b54e1445df8eaaa971e3fcd0a1","8640fe9c1e6b441b8e33ce7b0c54371f","41b2be32d9464640befc183de504a135","ee5f07b30c8f48dda7a5ff27df6cc939","d3b39d25964147389ff0318de58d1d5e","c5deed3a4eeb49c79b9bc903ac5cc3b1","b73fa00ab1904cc787d097c5ad1dc876","cbe939eca3ee4433bb0d02ecadbfc38d","6e81af863021473ba78e0598f0a5f0ba","9ed7ba21263c4c58b974770427c7c0fd","2c771c99a477461bb8b1001dac6988b5","6da3c7f3150a4290bf261394540dcf47","a4ed494da6c844fdbd8d5e00387c85ef","8fc6e7fc760642eb8ba8989c734a4ff5","83644d36a1e949ebbe8c80dba5aa9311","b44023a1c31047a1b4fab8961d55e0e1","ccb98c9ed70d446c8148ff574789d9a0","ecaacec3ef9143e28ce74b3c26f1a6a5","de3df124721b49e7ad603308de2f95e0","dd8b41d4db13456d827e51aff522bcc9","13b80338daf845d6a3d42b0ebb17a332","297bafca5f344c2da179ef53caae53d3","25f9f6ad4b7647d693612fff3cb1221e","d0e68b794d69439caae92e425ef09a0f","8cf04158a7884a5884fe360c7ea58528","b60c085fc7c347cd8b8406f34fa6603c","4847e0e7c1924f5bbd946c90b3b9b2fa","369f2091a11645d0847343faba362ed3","f0cd8669fd7042a6bf86bd77ab4b4511","66d6d8b8695e4db6b847043acdcb26a1","5b83cf999e4f44cf9d3582610cad5dc2","b0f9fb069a3b4a9cb5c18b27feb42973","4e621f77485a468f99ee9ae18b95e1e0","f02f8725ad954db0a1a1d4a98246e3cf","2c150d2eb84e4bd8928f47cd853027a5","c262daceb5834d6ab400b6084299858c","99235966179e42e291909f1a6441bfac","909b390a13e84d2199f6c20462d7184b","dcc703ddcbb64121a959856b4e223f08","ff20b55ec7cf444fb14099376ed5bf1e","7956c60efcdc4fb58b9a749e03e5e7ed","82014b3323ef4b43b265fb3eadf6f32e","9e85fb466ba041569a36a54c36c153fc","bee96107a97e4053b92dc0ac9dab30b4","17f00e84b7fd46dd963e5528d9f829e7","ff492de90ee14d6b942fe1026dd5725a","f293eb32f5774ff693950e7304458491","4e0a9ef0e17948489d001a4645baa101","e6cb73530c0d46fd82d1176fcc2ac83f","675eeef8efdf4331842ee9c2d651b8ab","9aafd31426a34af59431e46355cbbe0b","4dc1a78fadb94703a5537c8f1ea5f5df","253eb4eee4e04606bf25ff00a6a2025d","bc45473b4a7b4a3495a3b9f8455ae314","90faa1a65dfa4d9d80bf4c70da4c031c","f407a4499f3140f0b27ba3647f2122cb","38f2aefd4ed842639fc08b00ce15a978","fd0dfe7f66884867b2682e49a212c504","8ae4f885df9b47dcb7f9963a2cc97402","7b8e77e7c5c4419db1d1e152caecfdf3","190d5e549ed74ce9ab5cbafa8a040d05","91e983bad51a4041be94b65badf26c6a","a0d01af739e94d55a66a8500956d2520","f478af4c41a84f2a93865dd6c9e0d709","9faaf981dd13431a8f2daa327555b08b","f13875b4162a40819ba83b571efc5f64","b337cf21dcfc45e29cfd7deea1490ec6","74aef966e9464c77bc5a0dd6733da99e","99397fe2e0e24079ab64af8c35949a37","23a8a7180c724fd19b04534406955536","de2e1715723a4fd98502560cd385b1c9","53bddf7d2ad1416eaf37686f8bb15da5","75b91e301b9d47258d8d7354f0cdd6ea","96a9c1c9c0364607a21c47daea20d583","ec9ac5be655743ecba40eea3d7422987","ab7d527956704cc1a136c41f736c4f03","78c32ae20969485ba8df93cc38816a4c","666ec0db5a57437a87d76142f0721115","4349b540e3e44821bd964b625f22e7c6","e4f6874348eb424696d3ed889fa49e83","f6777df9d8b846719a3c5d0cd880ee32","f74bbaeba8534f6bbdd6aa5fa31fbb50","aec6c8c48b534c73851c56a4ae1b5466","aa87b632861e435a97d38fadfc010193","eaf5b80144c64c4abcf376ba56815a0d","51937659928147a0945709c7d4d691d5","6533ee6a3b1a4e03b51e7d55b9ac72c3","67bbe6c81665405e97de9728a76f6676","d51b8d504d8f4572af5b595628fd423e","3dfd6af94e5441ea998b4f0ef122653b","c5273fa5a5c7489b91f1dcde1d4ecae0","3c1343130f964dd0b2e6f21a6a2ab37b","94098070e2724fd882ef9493df6dfe82","2dd30133d1114d80b6d4def9dbfd992d","959dd00925394a58b12260880aedd1b1","3a8fd820f3f94a09ae269d00ce8b2b5f","6d8ae762c9ee4989afb65a2ed506372e","bbab89595b1f4cba8a5ea1319a3ea0a9","73ceb15dc1234a3bbfad5d519c5255eb","4448e9c64aef4096afb921185bd1044c","04695caecf8b4590bb9f5e296524ddc9","a01531e024f24bd78e85614266ba3ba1","92137f93800b4ed99e9d729bccdf9023","1e7b3a2fd1e1473fa03cd431d96e2add","27832513f241405886d402fc0667c6c7","56fc7f11e4b94f479808ae825f9b6338","1d2bc9665877484a9aabc2f6f7ae925d","1415494b1fcc482a9c33bd9ab86e6d22","fb753fd000af42dfbec21c3b62d188f7","74b01f230af44d8eb0d945d8ac7a376d","cb81c664d2d04cc58f76d52b692ac022","9f62235019fc454d98b3d21676408c61","364b650589534e659c5396b7a17c327f","fa5e20582ae9445385646570ba5ae045","de0d200af4a64b42a8d87853bc3df795","bc9d133deff34f708a760e92e8b666a9","84f3970823a54a06b33df01ffbb9dfec","d5b6ebf02be14ab5a8a387aa13df3c7b","028b7f36c89347e180d97b76320ef43a","9ba657966c81483f9916193fe447cc3e","a6621b45cce44ffdbdd694fe1be53398","f9622981c64b4f4db1d535110187456b","1500a80501bb40c8a29908cf092b013b","db59cd3aacf648a6adf56c0f8d071a06","ffd7494d127b4eb099de4574259d5e2e","fbc66d6a38c04a519096a7e3384e2810","b801dc85d29a4bc9a232e86b6f545ffc","f5d7910796f346d09013d0c8c211a6c4","2ec0cc6bbbaa4d82b6bdd36913d043c2","e22cea7ea4d54357b185998775568de4","bc6dcd91d15c4d50baa11196ea0c3c34","f5baa4bddfdb40ac9e58e9496b4e1a02","1034b6051a8a4ad59cff5446fc1e6b64","db2d59ffae5e45af856a6c9d86f58106","f8e859b2664a47979317f30651c978b4","dfa61a1873d24c1aa7089a16b30bb48c","0eb4efaa5bb043d98b5938823ce6e561","b723fadcc50743e19f7e67f09705b89b","dfae425162094983b684ec084fa040fd","dd4fae91f5394fb19e7b57a171d4220a","d7f4fc124a884ae39911c4630c6e4a3f","bb3aba9914584b2bb9ba6d33093fd130","5f730f91d05d4e479f7fdc73904d8b49","5650d8b47f974ed1a0f21ea8c99f7856","b8bed01f4acd4e26a63263c62a36bc07","bccf1ebdf9c04ac1821acae0738a2657","b637535797a24c359eb2b5daa8b8669a","d9cb3169b49e4af3be856c0e18c3df41","012695287f344912b35bf73f3a362a04","257a0a5db21242599cf87c3e04ce9e0d","fe64aac2c4264b93a7f9f64ec10a02b7","8ae724ad00e24addb4576eb81d5676f5","f6961fd343ac40c0b9a3966bcdd3c5a7","1658fec61b744ee985bc2eacec8c6225","69d322ff34064b919ee977e07a9c03a2","776cb9b21b3c493490e1e79efc86dbed","63dbb284e0cd4e47aad78b32ca0c32f7","458ccb4664f441fb8862af48ce2a6d07","cf2a9f431bd74f7fb5e8614c1496ec05","cc9b8c99b84c472ab30c6dc1e709957b","4c18f9d086af47188078f3ec7e2fcb5c","991bb8df6a554774ab2615eb13b6c4c3","c00e3006aaa044baba2d5ffe81ce7556","3cdebc6ac70b487187da76d8c17b56f2","1cebf578ac8e459185b2f836a1819b51","0524b78bc3ee4316bfcfd4ab1b60e015","56395cfe0a1e415e9e9be34752d80ac4","6e66248891184ca180f1529b85f8b480","c55da4ca4f114023ab19621601045e94","13bbcb32c8b945e0b5e9eb7aa97d8696","cce1a9b6e3174c88b03272d40875d802","401403228b7e44f6b94f5bb2f313a791","9a0a576050ad4c7caabb66698f019ffa","36ef27cf276c4d068ee181e09cd186d3","f63955c0fa044973b526fefcf0fed4db","5bd55e3917e442c6be9bb0e0067578a0","a89fe53070a042808a500171c9b5fa30","1340905265814d7d9cc764d5f8a95211","a08ffd11232140e18ed7f6fe6cedd62e","ae9560a316fc4407a71de627490c63d3","54c9e9d6a16845a387a5203c05c02dba","6999335bc32a469d92d7ec8b7fc4b694","028f4ffd115e493498b34e4c63c55506","7d852835b8bf4293b6975bdad190e281","669a4f83cff44eb6a1098fb78fab81ac","63d1056ef5ea47bba80b45af16cf22e1","229b1ba226f74102871157965834b407","a5fef24112a544f2828dbc024a645553","b643a642f1624404a86714ab90071069","090c494ca1f94e0698d6d08e985a6bf3","cca28d432a8b494d8b285f12ea3ccb20","58e8550bc1714fb984344ca35cfa459a","3fd0d8b29c454ce6b467253793534728","b5383b8c4b48442899ad1fa681d21aca","e066e2e2823a472fb398f9055a2fe2f1","f80398ea607a48cd9011cdf3901a9e92","91540f92b6da49bba1d3868b35bf2b3c","9996ea2beb9248c6bcdebcc44f10d5f2","dc0fe4ee08e345eaab68205e7a145529","ca4e710eb1054a0981d4755b271f408e","80cf46da811a4fa3b56f94f34082cf26","250e5146a9be4f68962ceb1fce539229","c09dc3208f0346d8afb883552101b3da","ecfed519751648c192fb1584eba9c610","3ac0159d06ef4c879edccfff28e586c3","028c019d76764cffa5e1d29600915730","fe3dfd2ae8ed4f759ec79af37b3ea215","310e3c74639b4597ac558c937117682f","7798501f51a445a5a2fc67a7bec913b3","720c713762504ad4aea35ddbd6b65965","f3c04a98e57b4aabb50d4c86c9dc35df","6e14416ddb4f4eb999adf5aeee0b522c","117804ca1ab349be8131aaa10ae4fc3c","f61ce0d0e5994b7fbf8238086a71e097","cdf3d2bb6d4c4ff187b488eb6434876f","3c82ff2ff8a14790a45fa9bd14f023a5","3f7b7f9dfa5846babf2aed2dbeb49e73","08f80a25b8d04692976b84dc0538b52e","f7b14d9b605e4e9c9b3958287daf3ace","6251bdd958df4778be700a65b6a3ee87","391da880ac8946ceaafa3341386ae8f3","3c08b31beae743558c91600cd3995e37","fc38b0ece5514877ac81650a6dbf26c2","3972f7b079904d218350ac9b3363a6e0","c9589583baac407fb032a526f28375d6","c9cb8c94f9c246a78e9fe36bf1db591b","3b4f671e9e0b45918242d45086bbd608","d981d7d0150d4fa89b8e9cfaa631eaaa","697c6419ea0843cb93b28432ab825406","0a8f7c6176764ab08ace8f3dc1d11183","4bcd126bfa9941ef93df451ed7bf235f","e36a6305d398425aaaf0dcc4d0277cb3","8c26e3ddf52f4862a345c1afb1b2f903","05700be32679479e8b109e265b297426","bbf34cdf007d46a1923c06d6192b38a9","a7199140a6084038ba9a4468176e6106","db29f5dd40f94ee5be89b21d3c742854","59df51070e514b2f98c5314943240807","1fbe7efa01234f13b100467b172b573b","162e3e0f5d9f4a109012241aa38b429b","5d46e384b67c449f8775c1150d8074e4","94e1655664a54ad4a97c800fb3556b2b","4d929b7c83084ecaa062ff309a6a9505","3bdf808e77104e3bb54d5088642cac8e","2385c08b047c47ccb51b3dad007f21c4","effed6ad1d8440718aafab41f1c67509","5f2082e7f704412ea280ccffbfda87b9","67e9cf5b24a84f22b3281dc5c2dcdc54","b9cc6c8b00244d6e8faf518049aea16e","fb0a5d24d7364df8b609a7de47d6de1f","dd091ed8059a46a58e09389a43763ec7","d4ea71fa9b224b72a231a6d5ffac1788","f281cd80ed3a4f2a8eb9166508f8339e","037d738ded7f42d081c3e7cb430fd064","bae69315e9104a4f858939492ee7f6c2","5fd4e433ef7d433f8e44348a35b895f8","74c7859c8f8e4dd58d13171139d85f8f","9ffb6dca25794cbc99de10c5ed399a55","8b98433a62614a5795f3b221a31944cf","d12b2f4b031b4402b22b60a022e2dc41","9fc0e3ff447a4edbba6a43a546253f0b","ebec484288764afbb99b58fe1113653d","ecfe0861a13e4ea8abd05f24231b8d44","5ce09e7219b84b0cba539b9bfc52fa71","35a75e67950747a4a561a04c685f08c2","03145538866e4d3d829637053426e32d","f26d6262cf744082ad4c03ade9859b8b","9840ce4263f94411b44ae8c5687dd476","a5309f11bbc1407a860e29caf0265adc","bcbc616b31b943e79ffe882754044da7","f476e48433d74726acd1f79c93ef7d8c","f2fdb5661b6648579de5e3847a89ba72","f95fe9144f8a42e4a1f0e9d49b06f8df","d53c12a30a0741f9985678bb743ad28c","571276a6352d4f58a6f35ce7cbe47ff5","f29a790e36664f36adca36a1a837b0cc","fbcfcc4200af40de8843f52f463733df","a359e578a99f415095658e2841372bc4","b7ce6c9279e94656b0075e5347fbce6c","ae9a7da999d94cffad55634e37d6433c","ff38963aa93a4ecb9054e49a4c5c7582","388fdf2aa05f458dbb38256502296111","2e18d29497184c6698c146963cafb2fc","eda84f7ec2e64027a28e8bb335a58f00","5630ef14214947f6b6375592887a9814","76c00ccb2e2f40b6b7e126beb81aa175","f3db0894f5dd4eeeb8c9cf923df50a4c","2e404fd3e7e94708816afe3e3ae96fd7","4c270c97c38d4a278763b775e4196dc6","c6d0917346064059923a45f1fb95186a","349a6b212cc846c797ca11dcf1e13700","95446967941546e98e405b91663c708e","89b2a7e959ef44a897165dc9bf98e043","cdc7436ed8b74a1e9d9abfbed12117f9","81fd5ec160da4ca9847a2c61a5ac1d47","1e943fbaae2149058e3d430299211706","b1082653ce9243408b35c0b614d4c719","ec56f27ed7b14767974cb1cab5ad9f93","31067398f0564b32b111a2568545188f","3b1c542d711a4bb79c1908e11523d0f7","1c2400e6ad50470c883dc3647c306f87","9d45a9dc289c4caea17b4b2571eb0eff","2a6970c9aba641348390f726172c37e0","72d785321af34bbfb8d62adc125b3d87","c85d884efb264965ac490a68100694f8","9f4db2ed87684ae8bf411eb6bff4b99d","316adf58d19f45569143df31fb3b50f1","ed70cd4d511940c4bafd3a8ad0759b20","e7acc69c9a494cc593e1aac5e47337a8","d4d63c399a274f078e7367e4e5bc4f76","26779c763f364353b0462b1d5e23ecd1","e219e73cb53b4263b895fd4a3176c8d6","34ef1fb549d949dc86baad2bf1261ff3","55f75050f94841dda061bf492f8dcf7a","817808dd31134ae38209c6273c58e746","ee0c602f83e74dbd87b2cdba5149202c","5569dc9f7fa84dbcb36d6e6cd3bdc71a","022cf591a51d4287bb05161489d6aa36","b951e70b93444f3496bd3710c1aceea3","fe7fae7fe6df4ea293023254449ac79f","9e8b7a6acf684e069a65de1a44b18c56","32502230f5fe4e8ca8e71257a49e38e7","f706d080bfea4add875802d2d3d90c97","370a414b6d9349b4a5f52fc68148ddf6","44addfabf755467e9cc08ffefae310d3","57b69293d7a242f5873c8bf2f84a9c07","e3e846aeacec44faa35d2143161e0fe7","cf2a2fb4642f465eae78e3733f022590","1ece4dc3a039459cb1581f1629340e08","285791d9d32847879394aa457c3acf5a","3ff14f5cd4ae4e42926e3cef073ad64f","68f7d7051b214e219646b3ceee4483a9","fc68d695c8874cb99ccb6303ac0d28c9","44f11828888a4008be7c54b9bd63a5eb","c5f918262fbc4b9d83bf6541a1f266ba","03d64b143040400c99fdc145d4ccbe67","0a28fe8fae96492fb3eefdad23c354d7","169366fda41e49599ad78431332ab8eb","2e47ecc865dc465292ed090376b8040f","941663eded2845f39af788a69a496073","0166755b4b7f4bbba8525bf50b66d09d","66d4cf4b3723407db7aaf2bf81be6ffd","f9a03c1d15a9486b8bc7fc643dae8865","094827a9aad94eada2f991cada9a2574","d70b1ded29534602aee04c4d3f947001","76633b1b689a45fda0dce7546f0b5d35","73763c3edcf448caa5fc2b7a78104571","7f6c99954aba436b946e8032e1baa6ea","d9876890f3c64c2dbe667909b8899f9e","856878c30c064523af1b1e1d2d453a36","c13328c79f7e42dda63aa08a867d4451","7faefb7637a04a8ebb0625f87631e4ec","2bfa692ea15844b98c0520ca0653b3c0","c0f4b975cecb4a1e9769766b26f98261","8e5811b56fa747f9982ff1fe90781bbb","5617ea3cb4014757b611757d4852e258","cb8b84024b27443a976d6378d799f0ba","e6f0c559b603408386ad5bd2891b8cf0","9ea149fbdc004aa286bc392404667a84","efd7ff5250e04ad3a6a2cc6b88b4add5","5c6362f67a154b3e8bf56dc2cf219b22","e25e62cafe8f477e9692c1f7bcc50a39","c55b85fec4dd47faae3b4dd95e5c40ca","bb9fd2cb05194245b2597ab1fb50e463","030873c0e5bb451989a261cfb76f343f","e53f2026df2d4736bc9b45ee33436fc0","acbf4845ae10419e90c477501e93a8a7","ff2fe2912452428dba06cbbae43fa1d8","4bbdfb0d81fd4b258fa2b5b7de207c23","cceeead0148244a28edbd9a7c4497df7","64c47e7a59d5454c844e8454dd865d6f","765552dd8a924931aaa5012f2827a50d","7a80c9da3a404dd981fa15a5c6369b0d","767632fc7ae348c6bdb95e4f3c18f7e6","2d6020218bf543168bf8f8480822fa93","e89405ace2c44c8b8c51b131f5f17908","cc27813e2dff498b9d26c331d9c074fb","181cdd5e6eaa4f90b2e15bd21112cb92","e49c33cc6567471a8461edc2b78e1588","3f5ceb724c4449f488aeba356ee72715","06abb65de6cb4b5daf324d8edb260ef6","f589fa71b21145149d7c82151e04ce38","dfb50adf812140709394faee0b438589","771c2c3c62f2439e851542e0d1b505a9","f815f1c9eabd4671b69cefbce297c99b","7654b26fc6a249eebd0b8b3ebadebc52","0191d9b5211444fa8cad721270b0b54d","2fdb4f5368ee4d088da77527cbe5b06f","872570368ce74214bdb57557b13fc915","66585f1e98eb4d71a3914ad3e175fd06","e7c528251a194bb69b61a73a5b4eeba5","bf672e1099404a38af7b1eb66ca3c0d7","0be58dd37e9d46f485964659de0e6b48","590d009de52a48cc9673a6a2e00aced8","df4483c5d2924518b228186e7bf844a6","7dc91e6213a04436974ac8102e4a6263","e7186ec776174613ab73fada27d4d076","59f4fddd66f948ac98d4c6530f830864","058633dd60ea4f76948317b7c2fcd32e","371880989f5742d4a2faffcfc36fe83b","5d3085dcdafe47c9aee23df53a6c2b1a","efaeadf50a824012a697f74f0b1d8b88","4764edd9ef644210948fcf1a2f24acbe","d1d56f3273eb4f60a114a53b4578200a","9ccdbccc0c9841ffb1ef0a099433b66c","ee3f23e2cb1343468bd87aca48d8f901","dd9ada9335ee4c2894c2e377f7b363ae","8a977d61470a448a8b1c8de6da64aad6","3e7338e2253347a4bdbf917d11203f6d","ac2883457dc34398974398cd8aa7ae28","b79f3ca27ef84de3a2d54831b9f9946f","4c196a9a279e4765ad3281f3b21fa693","c0ff88f8518f466198a67f4d63f5aede","9d8c98d05a58404db8cfe46dfec32d70","d7aaedc5aded45b88f949c5ff995ccf9","70f84d799b514bbfb3aa64d6853aed13","853333ea86414bb99912556e86857596","4e355540780a409a9c6c5bda8e235893","03edb7f1c34e4d898e3503aeedf74a24","0c53416c4e2a423d98e52cfd76b88cd1","93517525ce2d4e1db27d2513a0addcb9","20615db287b94c3e8c2e6a9c0c23a554","359a25a838744533940a36f520098ba3","28380dcf513549d486886d607257fe35","710e63926fb74266ade104c63ef58e94","c5865ffee5d544b6b5a349b51e6cb3c0","c4305ec5a3a3473d84d24addae866c84","c46aee66ae5741789a3ed634f9e1dc2f","e06a23bddf014a1b989afce5127f69ad","89997fa88c7a40a8bfca1f8b9afffcfc","68cf079c02ee4a869a01b1bb210f5de6","931d34fccb224a5998c1ed41cefa4cf6","590495d12907460faed6c26bff0b80c7","e4f01c14983e477b9f4b8dcef6e69030","5c869bdd8f5340b2bd19639b1100de2c","1726260336c545c0a69236409817f058","b7312e6135d04bea8bc50c451f01363d","6420643e44234105a449182370c6b79d","ade157da0a33484d966a3fd576d831f1","389118ac1d884c778d9107658d1bf281","65d54ffa85ed41378ad8a7960cafda03","5ebc21c096b342cfbbfda7b1a9c94bda","7200925e79964b119c8fc6b8610f3362","97d2050c88b04640802a964661f7c324","26dad6a699b14e00a0f2726fe93158f8","9271372a449e40afa800760d47626991","557ca72213104c98b8f99d6a4be94b19","3a62841f7af94709a60414647a2ca9d5","03f49210e70044c7a1b1345571e8e13d"};

       Map<String,String> err_inp_reqIDMap = new HashMap<>(err_inp_reqIDs.length);
       for (String tmp1 :err_inp_reqIDs){
           err_inp_reqIDMap.put(tmp1,"err_inp");
       }
       System.out.println("err_inp_reqIDMap大小:"+err_inp_reqIDMap.size());

        //A1
        //String[] err_log_reqIDs = {"986af677071e4f0aa8763688e02e6e81","c305c77631d34ad78db6a2fdae01520e"};
        String[] err_log_reqIDs = {"57844b269b6649fe9a5e158cd5c97c10","40d9f1a6f26743cda30c2c87ce355481","43c54d432e744619bc96ec590686109d","3515fdadf6ff4d6b807e37d662fe3c87","56985b6b687749b3ba10285d432212a7","ab79eff039974529b2ceb13f2987866b","8aa294edf7cd478591f4b18e6ba8efec","4fb182a5b6e649daa7641b2b233ae5f3","60f333676c4e447996967cc2b1e3a616","f1c1b185a8a0411aa037392aeba6d923","eafc3e242ee340ce824c1fc545241a9b","2398fe0bee7a41d1b10d9fd785321ff6","3a02163e803943309fd96bddc8731563","b3ea444f9c544259b6d90da0ac267986","2786e5abf6574aa48ce0224a3f7bb824","79e28b553abf46f6bf775de17010ef75","f0ef0862f741420fa6b5c8d89742279a","94e8d2a385ef43f38873c0a1e48cb214","7b1e9cd00ec14d588bbb31b181f14ab2","c0e5447f89ed4c1e926e6e4fae14951a","f5ab717d367049ac84e45446d1014f45","4d29bc60a9184d0f8712d0916ce748f9","743e704157b94deca6be0e015917a3a8","36d405b5be7c45329d6f59480de6ec4e","3c74bef561d34d4ca5927fefa165780d","e6ea83a66b7146dda9d24ef081c85a96","abd01441db1c4ffbae8ee9707b387f91","1393c0bbfb2b4a26ac04ccdf55cefc22","ca3817b2c9e645bea7d37834fc2aafed","414c0289bb2e41e0970b734f941640b4","cc4834ccd5e746008610f4468c0ffd08","857e13f3ecdb47ca8b913f550c7a2321","9058bc0fb8994e5bbdb5f927babfcf12","bbb27fe1440046179e77823791947eae","fc99cb58b0dc4d4d815b6e13e312412e","5b4e52f6686049f7b90d9074a9fd405c","8466d6558cbf4c3d8d62f0cc4de708f1","a4da148e6cb24ba28728c8fb0d0d0189","7c1d74da6b9e4d0d859d988683b455b0","2ac66e9f833a488b99203d988047c166","5785e78a79b143ee9d3c84e6f3f974a6","9b895385499747d0aa5302afdd04668d","04352b76815748febd5c1a2828f70ad6","2052f2ff465646d2bc84c91eaf104163","e769c9ecd53840aeab6b1c443ffc4375","61e5de3ba4b4449d98f717bc986e6058","9332995c4dfe4c62bb9dc4a8fe8c3cba","aee37ffa58a4460ca9262e7806c27cd0","0d12336183214614b912458a6d682a57","fe228f2899684da1a5b6c5ac3e3b4833","31f40f0f16ac4739baab13435c4991fc","4c0563a7d515485aa8ab8f0109c54384","d39f976494d744cd8450632972670507","3dbdd147e36140a6856c663c1a46f2dd","5ee5d7b3fb244b8bb3a1c16974673915","aef36f5964cf413595e53e2474301b6f","98bd1e20ec904460810a4cf62cea7c48","2b7514f450bc48f39969d0940b1cde4a","99c77303a2894f0b94710e72b12c568e","44d4d70cb3134b1e96df96dd5f64816f","96e3dff5ab764291988f962ca29b5deb","16693f15ca6b401dbc2607837ff9dd20","6b026e988b704e89a9d2144a7f43bd34","167fe6b806dd438389e4142f83bf4df7","7d0528a3b3b14a98b300b94bff121248","c49fd988b60b4548b1b2cf65c912eeb2","80bdbdc03cb14aecbe3f26a02ee479ce","c9a7d146fc0444299ff617b97fc32b93","2ee035da88904a7caf5e5236ac741add","348390596c2c415b91766bcaa98266d3","ae963fbad8e54bf0b20e59be24e91665","492ccc1de1114529bf67c63dd766ed3c"};



        Map<String,String> err_log_reqIDMap = new HashMap<>(err_log_reqIDs.length);
        for (String tmp2 : err_log_reqIDs){
            err_log_reqIDMap.put(tmp2,"err_log");
        }
        System.out.println("err_log_reqIDMap大小:"+err_log_reqIDMap.size());
        //-------------------------


       //List<String> lineList = ReadOrWriteTxt.readTxtList("D:\\用户目录\\Downloads\\lhp_A1_20170209_20191025_TEST_01.txt");
        List<String> lineList = ReadOrWriteTxt.readTxtList("D:\\用户目录\\Downloads\\lhp_D2_20170209_20191025_TEST_01.txt");

       System.out.println("lineList:"+lineList.size());

       StringBuffer inp_buff = new StringBuffer();
       StringBuffer log_buff = new StringBuffer();

        for(int i=0;i<lineList.size();i++){
            int flag = 0;
            //ApplyLoanInfoZhuDai applyInfo_A1 = JSONObject.parseObject(lineList.get(i), ApplyLoanInfoZhuDai.class);
            String str = lineList.get(i);
            if(str.length() < 30 ){//#applyInfo   #singleLoanAccountInfo
                continue;
            }
            JSONObject jsonObj= JSONObject.parseObject(str);

            if(err_inp_reqIDMap.containsKey(jsonObj.getString("reqID"))){
                inp_buff.append(jsonObj.toJSONString());
                inp_buff.append("\n");

                flag++;
            }
            if(err_log_reqIDMap.containsKey(jsonObj.getString("reqID"))){
                log_buff.append(jsonObj.toJSONString());
                log_buff.append("\n");

                flag++;
            }

            if(flag>=2){
                System.err.println("发现两个错误类别都存在:"+jsonObj.getString("reqID"));
            }

            /*LoanInfoZhuDaiVo loanInfo = JSONObject.parseObject(lineList.get(i), LoanInfoZhuDaiVo.class);
            FinTechAgencyBusinessZhuDai finTechAgencyBusiness = JSONObject.parseObject(lineD2List.get(i), FinTechAgencyBusinessZhuDai.class);
            loanInfo.setFinTechAgencyBusiness(finTechAgencyBusiness);
            System.out.println(JSON.toJSONString(loanInfo));*/
        }
        System.err.println("build data finTechAgencyBusiness end.");


//        System.out.println("----------inputerror.log data------");
//        System.out.println(inp_buff.toString());
//        System.out.println("\n");
//
//        System.out.println("----------logicerror.log data------");
//        System.out.println(log_buff.toString());*/
//
//        /*String fileName = "D:\\用户目录\\Downloads\\D2_M.txt";
//        try {
//            FileUtils.write(new File(fileName), "----------inputerror.log data------"+"\r\n", "UTF-8", true);
//            FileUtils.write(new File(fileName), inp_buff.toString()+"\r\n", "UTF-8", true);
//
//            FileUtils.write(new File(fileName), "----------logicerror.log data------"+"\r\n", "UTF-8", true);
//            FileUtils.write(new File(fileName), log_buff.toString()+"\r\n", "UTF-8", true);
//
//        } catch (IOException e) {
//            e.printStackTrace();
//            System.err.println(e);
//        }
//        System.err.println("write file end.");


    }

    public static void writeLog(String msg) {
        System.out.println(msg);
        try {
            String fileName = "D:\\JavaTeam\\D3_build\\out_log.txt";
            FileUtils.write(new File(fileName), msg+"\r\n", "UTF-8", true);
        } catch (IOException e) {
            e.printStackTrace();
            System.err.println("writeLog Error."+e);
        }
    }

    public static void buildA1() {
        //A1
        String[] err_inp_reqIDs = {"1630e4c8dc0b4b4ba857679a761bb67d", "5abcd79f47e344c49936935c150a6dc0", "8e2d360d38674734b969c15ac4ff596c", "555c299a46014f4fbd879ae4f8ab0b36", "ea9de6475aaa4e098f178fa1dd5768fd", "e3b056b6263c4be282b1ead6bb327969", "c20ba517aed740a6b2a75a3ea2b262e6", "cf501fb6ccab49e982b44d99137af9aa", "70d008893b6c4dd0988b346a4b4a2522", "e480a9f0e750446e8dc50f5131de5a5c", "009f3857026544ceb9299372d14b372e", "20331cfd9f7246b395f65126760052f1", "884d2eb64cdf44149a0e91e37335122c", "caa0bebfdffd46e8b2959be28e509412", "a263e4056df64ce8ad6b0fe3e5c0e1d9", "0fb50fc2c7c64886bcb6e32936f8b745", "315aae5a1474444db41d5280b668944c", "b32c46011fbc4acab7bffa46f99e456f", "d75ebcb39f514255876a23701878a388", "7616ce3ea0324f8cbb57cc9f3ca1c807", "bdf6c638f6af4e90be69eaa0997e5288", "847f97de392945cf8eb00b1b0331ad59", "0928d9d694ea48a6960942192b359570", "94085563f5604cc3b59398d61ab40318", "89559a5b18084360b79a439dd183de2f", "85b697dfafb14a499c420a7c7921ae02", "11aec469297a4ac8af97fe4c8259a872", "25a49736e92c4891a25fa3c0dbf8f938", "78582564458a4afbaff517068db8b8e7", "4d4ae736dfda433b8c984eddeb5e4c6d", "f6dc32256f314bfbad9520f87dc45294", "3b4a1dc129f7454c8bf932a8cc768f13", "8da87b04a62c49918ccb658d093d9514", "31b5ffc9ed9249caa4b8c22dbad63d83", "8fbff7dd9589461dab8e2ee4b3d3f36f", "3271de67c2c14cf2a8e4d502971cecd3", "58e5cae6a9b8413ea15e98867be9943f", "654f0b5af0e74c9b80c11fed88883c11", "5fddda52bc2d40a792f165a84f029137", "4ec46b81eeee401194b201782e4a8434", "6c930c3cd0794881bf0b80504bd9e187", "d2018a9c6e274a22a8c8870e54e2d3cc", "490e9b68890140a39923845c3e710fda", "34313c8376604afe90327f88add4ec75", "368950fd61164cf1bbb161df04a06318", "30dfc098ef354db7822cc8db28f6f948", "36acc626adae4c91903c1c1a1be5ae87", "84cf0a6600ea4f5aa06101eb6ccad89b", "220de678357942a79f3e5aa916deb14c", "be18fc64290747949d605f67d3302dce", "03ec6d6de02e4911ae6ce3d9eced874e", "83249fecf3bc47129a2e9aa1fabb117b", "ce1db78c7d9f4e0da16804f15eb5b204", "777b01b68c1846919ab97ff1e9acab7c", "8211d816ba2e4c2f99233ab059030883", "56036e2781fa4d6c91ab379549f8e0e1", "0ae50255ce0a427d9cdc870e13e7d2dd", "1ce1616ab3e3461891ae188c95e95827", "9e51375b59464a7aa7838ee2a74f3fce", "f66d731016394591b0f44f1b221cc0f1", "f4fcc8d939f34d0a90125d60fdad2fd7", "4f9a9249acf54f5da031ae0e86d87913", "1a596f1f448f43f7b8b42bdaba74bb7c", "54a3c84b97c147ae9e51904b8364d539", "707e2bf84d4540fe967c4c332b9dd643", "30a7a9763acf4cc6a9b8b395dfff91a1", "c17037f7937944f99da78ebe7042855f", "555122e329634fc88a546997baacb5ec", "0dc4c99dfaaa47b7b141a1a99a2d2ae3", "3b5e5d158b964a65aae65c550b4a41dc", "11528da053bf422b85948e4993d94503", "7a66040517c7405fb09e7bae83b6d78d", "342433abbcb5424d84df3eb8f74accb1", "94449500b61745a782a04bc60f94d732", "36e1bfb2983a470c94ae15958f1a16e9", "94ffaefa98e546c58e7002dd7c799488", "e77183b5a1944df0b270f76fa03d09cf", "3e25eb18667e410cbd7101d4ecc3cdfd", "67a330585f8f41c0b26275e7ee95f284", "4db46714746d428481a619cbeb61a78e", "cee7f9f17f294eea8a939ffd367f1857", "8458928526744e7bbf73c5232bff0957", "d52e81a8f6ae44609f9998f8fc6b5ff3", "c074e89f8a57479fa7394d3ad6f9c19f", "43adecdcc7284d0384fcb1c5a10e6b7f", "5f525cf9a4574d5888c802c5065e6987", "4b32b2ef8fc04e0584e3b582e683b80a", "51ae195c3b4544489db0fa8b1abaf2ed", "f9e7ecd1c45443d899f609b06137537b", "70ddcc68ce1349adb0442cf574eb0738", "b471960128444409a466b1ca98632a88", "a9f8ef6629984938ba6120c91434813d", "7c771dcd1f95484fa180d963562fb09d", "1ad1edbd361b4fa0846da0bb7b9c7a86", "5c4dbe70614b4173a6ebaec6c479f435", "eb01270f44a34607a11c142abc5d8b15", "f0fefb9ea9be49a69613fa7dcbe9a3e6", "b9ad972c2f55462eb5375367d9ab91e2", "ba36093db7214aee91e84d4335055617", "a48c8bfe5eba4ab99666bf4c0d7316c4", "9983eb29674d43589b939886b866853c", "b8537a249a69434987d1dedf316b4181", "4992f971c32d48999825a94d3a245102", "f1c2f08bd6b547109f4c780ae4bd2047", "a94c8f81a0834c51a8b7be202da4cec0", "abf547dc068d4f478b7ec6b4947f2aa1", "a44506c34b4e49dba6d86b541536309b", "025b1fd1083e42dfa126880dac1ef89a", "d09770fa8424444597366571633a17d1", "cecae95aba404d6d97d0cd52a3364f79", "e8779f8b708b4a3892c48ef080cc48b1", "3467bbffe60540bc91b09a6922cb3232", "3f8740cdba1e4e468739efddbd06cb9d", "7fa581cb5aa54d72ab7798558e73fba6", "e07ab496035548a08027a8b2c0052ca8", "7b552cb2c0fe4e568dd8957e379cc00c", "1613b60e90864e61a2fafa9eff90974f", "13a8e5cf43d8470285fa1e1e19b6f5a2", "0413a276b62247e38755d183b6af1f9e", "3e05f4d6486f42aeb6d7193106de0b0c", "7929064a0bf3446595413a6b3828d974", "2504ab540d5846cea9872546b3775821", "ba4d27762c8b45d2b461b785865b02b0", "1df7fd4a893c4122b4fa8b3f914c9d69", "433a5613276f4bff99785662016454d6", "9d301a6fcedf4d2caceef26f90a04d0a", "87a1c40d8a384d24a369c8ad8cfdb0d3", "2b8b97082f764cd8a881c340ee88d13e", "236f84fd93ee433b8fca8ed524d8b0f4", "e673e097b9594ae68fcf9e8654c498ad", "b0a7bc4d638b41c899d08b95ee24096b", "2e356f636ce742438afd8bb804cda702", "22fcc3e26124450e8964bb401c4cf2b9", "f4c90bc54aaf47b8a79e45cd9372092f", "bcde43277fa54e6ea2276a9b5c6ee86a", "838867bb1ccc49a29a5b4726cf95280b", "a768e937d93848aeb8739f8e2a8f5b64", "441844584cd746369a337b6bf7a13f86", "5093b229ba054364b5c3e4a119d4f076", "a61328380f4b4c369e207366cbc1f372", "63950a7139ec4156879500c5b81e61b8", "3521cd2f674146fa8e896f7b76511352", "f4d0dfe4c2ea4f81930a973c2e94aecf", "4f553617fd1941a3a914def6198093e1", "0045f0a5d3434fffa620d01f963f5206", "63c5ba8972704bbdbbb8a351ad854b50", "bf1501992167411d8e9f8f7291e6ec34", "5a4fe7cf6cd24f4bbd0a126a6c0930c6", "1a6c64f4806e4121842658560dd77d1a", "0700c68d59c445a1aa5b805a5c1e94e7", "c84ecc575a9248188cdadbb52799f4f9", "0cf283d7e2ce457d8a1baf06f6bf580a", "359994ab8f80439bae9cc80e4c553f2f", "5833e302288b47549361fb8bd0cbc97c", "38c11dc38bd34cb8b17261cf421bbf0e", "ab16f757a0a24f05a20a9991ffcce2b5", "7ba757a5abba40f19914979a232b3b6e", "b2b22ef4dc17447082a9e23a22ab1133", "0f55aa1b601e4977b2c382334fdb2739", "bfe88329b37942d9b65137b814db805f", "34c46309c28e4915bc62c2d418fea042", "1ec9280723f54b759c09d66bb1a413b7", "2014e4d8c7de44b780290563b0218c4c", "8bd4c37725e64711b2898fa0dbbe8553", "7fa4f004b90548cf9453caf053231dc0", "cd6a71cbacb84eee9a854ec1f5fe0734", "9bbfe8a4198748a2bbdaf102a4bf2229", "7ce2d307417141dcaa98b4ce988997ea", "c6209624d09b4cc0bc0abcbee06e2ecb", "938b09e300a44b4b8ea08640074af964", "5fe21db460d54f87875becb24751f9a9", "bb1c5f896ac24806a36fbe02a4836250", "e0ecb7f21d724d5c82d58fdf077bbc8e", "d85081266d8740548400eac26598f740", "2c9e19c121b744a9977aa810f6c3f500", "6157afb1c29c4f3eb4ee3b8068e8a0ab", "8128022ebc9442fb978d12e2efd0130f", "a1283fc267794e64b897bcec3bd14ec2", "67564f4e4ce940868973bc3718f144fb", "ffaaeed7f27b473f84013c2653fae144", "e519df89c3604f1198326eb633273d37", "7decd9f1a5ad42038eaf4407e12ceffe", "9ea6dce9c3cd4b7296562b13a155fc49", "40fa0a2c3f334308867ba950b68c20e4", "112497ab0bb34d3c94a9f7ba924d3304", "d02a339eb64f46a1af0923106aa9372d", "91e736df7e9a4bf38c40b2536c6ae345", "55c0c46356444fdcaae503396d27d459", "27b261848d654f6cba406f0c1233a175", "0b093895e9a44863845bfede4de787b3", "fb4693a7fc344ee5806017177829a16f", "0de621ce6ea745c0bd6ce1a65409574e", "a0d7f3f1c3314ae892389c25fcdb04a1", "2d827d5a0e854a70b6cfda33ea16cd23", "614964c6d57e48cc8000645cc38b3fcf", "a55cf63871b04dee84ab2edba028a57a", "ddf4b5518dd64f98ad3a40d626407adb", "acaec16ce8304188b5631073e163c5a4", "f96ed92100b2417ea3eccaaee6bc08b1", "fef772194aec4a53aa55edc5cf86f335", "be121c42b8a14ff8888b43adcfc0fb4d", "4796ffeefb3d42e4b72b09d15692e5be", "0cca0eb9b18e4e71b7e2d37469e5f415", "67776b571bce427d95935a13020d1671", "34893333f4a54b67be2c668abf73d534", "460a2dd8ff5d46b0b5d21bbc13f9f150", "4d9089a6752a419494f054e3fadcb2f3", "1777c57f607c44399272bbe0ee54c28a", "d7d915bba43244b9bfb301dd23398886", "4249a81287a84f759c541530667d412f", "7a9cbba58efa4a78b5db9e28b2483dd5", "7a0ec77d2e594f63961f4973c1a68b98", "625a13281dbc4e6abbaf2d3f8dd03824", "99770b6475324be98062ae77c262b21b", "271147ab6ab846ddb46056ab3e9d3375", "34e3875f55384c688b0e9a3f9ed1a604", "9513428e1a0c4bb3b05a5a9417c389da", "3e15178cd566487fb4c671c173054f2d", "6efde6c08a6b4b4d95ebf427f40d780e", "bfd6bdf94ad9403e9ac910a9c4b8ac9c", "9a8145dc4ade4a45a05663881f918d62", "160f3624137b489f8d13b81d2286a768", "b3b4a35656964f9e825ecc22ae69f7ca", "993690ba8c9a4199bf8498c0469638af", "d7aab6f63fb94c5584560f68c113df81", "58e27733be4f4faebb95a6e56ffbd3c7", "ca9263e030c140fca1ef1a91b87d0938", "858a6fbf926e487e9dfe55e0f83e9358", "a641cf98e3554ab9b4b7bd27c6b2d30a", "341e4a78bdf043f6803ac66674bf8611", "27a7bf5badc0468b88b828631c4733bd", "a82f82d0ddf049eb9093fddd2a6e293f", "e96bdda5f5594f42826412439b570bc6", "762c6c575af243659d41752191995cfd", "e6d12242f1f543968480ef541347c091", "2d0e58e20c414733a9b66c47461e3fd6", "8e0e62fac8214d2f85669007dbf9b934", "db4a84ab760b49329afcd0c043da2776", "e75a4f3488b94ee09723bd1414323f6e", "36a6f7320acd44da9b153bda2bd9c413", "0bb8e123a4954ded9a7e5542b2af5231", "0ce30845c38d44329d80a227bf7bd968", "e7f0a2deb7cc4a3eb7f784e6a5be7f32", "deea4d2638ab41379d31b4dfc0e1b37e", "4c0bbb1c4cbe4e58af43ef280684459d", "27953f7aaefa4fd99baa9ab61e73a5a1", "fe21bcc7c756412fb9e51622e848862b", "7704176cffde4d5f9c03d629893b1528", "63b4dafd266c4422bd4a6e54c0b9cb7f", "5c9967c565cc4204be70ee22c81d3d48", "7a12566e22fb40999c3e347da9ca763b", "d0f5098ad39a4922ab2b09ef73e9a3b9", "b01a0aaebd1449fbbc7efc0d37492c69", "73372ee0b0f6472290652ccec2cc0598"};
        //D2
        //String[] err_inp_reqIDs = {"823d231cf7d242a297c4d05ec7d5fa11","a308639c82a44858afa8ddd753e88b91","232e02f5dcef494fb2f7986efbab5c3d","b15388dbff404fb48a4ead830d4997a6","f1e0f47eb14b489695b7e3fd9a288e6a","7f1d9bfd3c9547a49ea765b66fffe4f7","c1451e022aea4b2297cd83964688bc45","94426a510d3f4ff2b6fece4bf59fb21f","d07c11193c08420c8e48de12d4da8270","a48d657b4bb04cc48fd3fb0f99126c2b","ceeb059d7567485cb33f1f1b4a8bd6fc","a6ff8b0099a4408f8d93587f3f60461f","967984dda45b4b249fc33970ecac4653","204ab92e32054fa98068d2f9802b1676","1fb29fa7aaf44231abb33ee6dc9a9ae5","cd57561995994aad802f2b9c3ee84af3","3ac9889a2b4f4e569ec44ae9daba1a7b","9c39d735067344ec976ec5c8a3f166cc","c0d92f11f62b4a24adac9707f23c6ea6","5924c24964c5423591d32f1dc782718f","8c96f3a583804dbda5fcea6dc7335bee","552c9cc2b3fb4074a745a173b36f6db0","f8f3503cbb54483aad4abe83bb4fcd1f","4b36e7b5826143e8b022f2f25fdc3f7a","95d4792ffa444d41ba874332f1920959","9f880da744e94a7ebef9b8bb18dabe4e","736805aedd954709b8bab9ca63313158","e2456249c414460faae5aee194a5c09c","9e06f618b4544bbea9087bbc9e4cf6e3","2668b865eedb43f29cc715256577f5de","cedebc77c12b4d9f9b0c797d899ca8c8","3dee8ef8956341429a78c0b6b9a42314","63c8b611768e40848845a77ec1928148","2c8f6f662ea84907a100fcf02a7134fb","53044da4f5844f4eb5098fb44d3e95ce","e32417463a554b09907cbf20bfcc49c4","3019ec25a1a043fa85d5c15af1cc3de1","df70f35c800d499595d0c5eeb7455bbc","374c19d34bf3428284489ac4cc49b431","66cee92aed5a4dc19fce3e412ca86b0e","3c79ea60ef1e44c4b0f96a2a27c51c0a","ac5cf31254404c62b14ce221cf780d23","519fbf7b913e41bba0beca60da50e4c4","ca5bf98854ff484a9617c064133c1fd1","2cda465d3d5345908985702d8ae5621c","d4a742f80d5a40eab886662facfd5397","169683e586ac459e91598addd44979e1","fdc55a2cb00649bb9af253c4600c31dd","acebccb261fc4685be390c12017be94a","5fb372042007494bb5c4b1e2efb25728","e166eb1dcd85489b9e34efd46c8c4955","69e90cd6f53441ef87aa364c1f4ff968","dd5040ddf5434cb4925050542695a09e","102866da6df64a96b72dc9e98e3abe94","6e296e844bc94ce59732c801a7706492","c1a8006d71f54a13bbb125efba74bcf6","26ad3c884db8438e8dede0b291660302","fdfd237c21574b6ebc7f8faf82ae1cfc","b731a90533404a73a9d8a17f34d3d9fb","c01423e691cb4e539206f7cfe37e8854","00bebd01b57841fea99af05ebf673c06","5f4da64d01104a77859ba1d5de59a35d","da4286b914a440498ab2638b5cc68b60","570390f3e19c4f25b67f2a71bf3fa58a","086020e11b5f48afb844ad43d04cdbec","00d9971903484465a09573d869c2bd11","d9181daaf980403190ba0ab09b0691ed","5ae41dd2d7ee49f7ae249b4913c4c557","fe9f3a43cb0e470cb2e0e7261b85103c","4db71adf43dc491da9f30118d61c1eb6","51b7c6a01cf74b5184d25f1e71f68128","870a12865f2840cda69a4d9a7e99416e","6adf7301349d49cf9354c5eb5cbdd790","b806ca08c9b84b5a8afa4941bf045649","d0257cf08a644eea8aa09a9f9348c170","4599e91cf10b4b60b1e0f56970ee02a2","46971ae0663a4f4096f57c3836d8c543","27bece6f625f40ce9cb240cda1551368","e41e8dc867cc49e38975c379a06e989c","0b11e72245c94a3bbd28ba0abeb0d311","d5fa8be2c1de42489d9bfe33c2ecc164","99dd9444c1634b6793b97cc7ae4ca26e","53342012026445c1abfe48f3545978e5","51acbf396e424fa0bed8281449362343","7f81c943ebce47c6bcda60aa403889ac","f2fe8925ff0c4938820ec93cf15bb58b","e15bd148c2f047f4a0905f439bd6c259","b13536748b5947b49c8ae4b2b5930f9b","e67c473bf358404e841474e327615ea0","44dcb060592142458e222dde30c41318","5b64cfd77cdf40f7a78ae85efaf28a8a","419e20e0f17748c8837ff608be2c6b92","1b176f0c16d04400a7ca506f6e6b3580","a26cb9cdccee4af3938a5348a0b67052","1a6283158a364d1ca9139b84bdb3ec7e","8c62d81d74144c43a315f40b3ec892dd","0aa67805757f46a0ba60f88d4474fa57","df74d07d058e4978939f74183b5b73a4","946c895795de433ba739e9bf667e2349","496fc1605411482ca5e2eaff9e285573","34185fa83b6043239ed5e591ebeee353","5e7a64128ecd410f911ef0d87982a8aa","2b68b8900fef4a0797e84d961e206083","2b6b6d2086ec437faaf061882221ef2c","3f0216d42a4f49a99cf2fa1423293fdc","ea3e2d8ffc5448b48d31c6e3b10c86de","81198279254a4aef93b5ddf7edbbecf7","17679ccbf475463e998b185f8933676b","65c6292b840e4441a9ced2c9daa837b0","69b46e581e43477aab72036d331d2660","ddf7672012d146bcb638387405f5564a","8e557b3228884235b24a27822dc0f408","aa540b6ff3f248dc93f85604fac3c9d0","f4aade50c2be45b883054a59c32a997d","2666401170bd4690b4c7ec56c0b0ad27","748da698f416499a97ef6648e21c0d18","38f3cbabf3a646c380863ea8e2392866","d115d91d44d840e68ffa5f1a70779d7d","6604bc07d5e64d37ba07ee0e9bf6b2f4","73e2b288dfca4e469beb74efc7b092a8","4bd1836d2b3c4b1f85640d06f271e307","bc761a95a7ab4d49ac07d3b8550b941a","58d76cf54cba42f88fb564606d25efa6","8e916eb02a5846c1b82d780ffe82f7ae","5e44b602745a421faf8ab38db13f8318","1b699bfd40564d00a837cf042958d7d7","f0b069411e3b47629e322134aac09288","ab95e3e942b144f296402d8ecfd8c57d","eecdee362dab486abde92c803b7a5ff2","6118e96536314844b3b87cb946c26d0a","583e8d6421ec47d087792ed663e262f5","726977d22c84487483ad78dbfaf3f631","dc773b132b014db38644e22f18f53653","b9cac5ebcc4e490aa866cc690eada30c","e8a06a66f41a4392a8a92bc1c7935b93","d842df8611cd4b20b083a1bd48b8c355","597d6e754e294f96b673f8f7a084f6c7","ae1dc96f36304ed4b452d11f1aa2b4ad","8d105dbf4c3c4f8c9e6635e3047b5aef","68eb5323af1041a689340ee014184cfa","46311bdf495842e284213b3698469d8a","8f3c933d47bd430985a620b7e6038862","f10fe686ca2c43508e630aa8bbd711c3","cf46e81c9f38470f9402081aad9c5c49","c38f131789f24bef939378e78a4e99e3","7d2c3776df34487b9362ed104b364aa4","b2bcec3a823c43d795d39b2469f585b8","11582c7b3ab3433bb61248945f9297c5","7720adfd2e044c1c9507b8a7b77f6999","2c2e649268fa4b71b0022541b1657350","9fc0956470844c0e87fc44a837784648","5235ac28585a43759e278f63ecc2c4a0","22dedfb6861f4697bb51817641b6a43a","a35890989dbc42f0b7c0d98997ab7539","5b20efb98475420c8e60d062bbf8e927","dd4a61f909db4656a656eb9688c0925f","93817b3541cb46f0ac775feacae09b23","4cd6233f2c4c4218b51b49a712dc667f","9aee48f031384f8aa62a747d8f4e6149","a798a46f1f9a4b269fbc7b50b9aff8cb","e4efd190fd6b4545a08e627a160a0e18","a66a7d15c10f49cc96ac642a6e145c1a","040a934779e64d648097ad123cb18171","cab3064b5f3844328581adbf56409dcc","afbfffa69af648649ad78e99b2df4948","17d4814a5fd945b18e8229bb4b887ef9","47e4ef46dc3b4a61b63e4223f16612b7","984835595da64cd0ab37e25748aed3f2","6381dfec2d9140aca8f6ee2864685fa8","9791c5388f6f41d6ad094030bc4a5369","9436bd60df6844c3a38a9c1907772e81","3faa7c41c42c4bc89098fefc726022d8","8db2fadbd96b4b9f85ea48aed0713201","82aafc857ada43d88cfa4837f9cdf988","a55f3446d90a487587871f48dd59a250","f4e1d0b5294c4807bd473d42e4f8c7c8","0f4c956acaa74552af7f3d3a075ca74b","fc74de3ed96a4d00a8d1082841c56e6a","e7012969879341bdadda88d7be33e434","c9b441502f4d477d8f6a00559fc843ef","2bde698746cc493485cd0db52db11130","8577e4a280df48ac889af63e1b90e226","d0b3e66c909c4b4396f1c9252dbbe13a","41c31d9581d54013b56e74bbaf908cf7","23908df8096a4856a34fe42bafe7073b","bb8b8687519f41d2b7b2661613e26862","5629916b3be84113821a1d5957fd14ca","9247b38663a045998444b6f807617cd6","9f59495d49f3414fa21a532ed018318b","624fc472609a4eaaa5e5145441ecf8bb","e839f36af3e149c48417cdcca27097d0","438997f5ebf24ad08a44b96dcf2ff83b","fec98448efd244c3b0754cd183efe93a","090803445e5848c182744b9148df84b4","1ec3b73cd98a41fbb3766ab428d4c7ad","98394155a58a42e8a1dc4f5f53729738","062630e92c9b44a49fcb5c5a9c5c85a2","fa48c8457fe14d3d944db2c51243f619","2959b15c72ec4e11959ff1fbf49d89be","2c68fe95523c4036b988dede6959fa51","8f9c9f058ebb40ffa169d569933edb00","66d8e4f18cee4b36b2137e9a94ba7f98","59388cf44c1c4cb1a13f9b19bbfffd16","6afb8ce17c9540219ce10124e7960470","e7c80a468b85483e9b3b49d64f218be7","2cdfd7bca22e485e80eb464e85215db6","8ae1b3a1da6740cabfd3856dd78575dc","252d50defc3f4bf196fc07b458f4af95","7702b18ed0434cf1900e5e229cb4066f","baf924c30cae4888a2e56b9f4acf0602","7635760c420f46ac9953c9c9d0e7e631","f09bf67635ca4f82950b93286b46df6a","24a00957a4974499b7ae74b4a724f4b2","1f364b9dd50744468bfaf2363857d279","9977defc7a024d54992ce2e72232fc72","dd926ad0d7f6451ea8caa87b38025350","5e0114dc096949e19a4b8914ffec89c2","ae600e22fd254072ad6e84871132a399","0dc8fdc751e04939b492cc549511090c","e71f0b33d15548dda8de99163babe63c","214dc36783a14288b02620df4389ea6a","36fd87a434e744dea71a0cdb840dd69f","1300cb2a9e4542f88c57189804d19765","3c812a2635e842359c0e7a91c529fce1","e4eb1484d9bc48168673aac4ab3eb69c","e37aaea6b5364b90862c837ae1d2a3b1","bf6232b49eb2419f881628db5fe9a9a0","f8b390a09f9c45f0a634cb0953131af1","067b74954997414a97b6bcb340264cf9","8717283834b1452ca0b8bce8b33d1b4f","36666136c22541d694227ce02c1fa102","f54392fe7137414bb494385e7d0ea617","01cad016a1b3463a9c4c9f86fc6070a9","3bcf5ce2fb064a20869704d712a9cad0","a7385523baf5463cbde06b95c10dc5b8","ae82de808abc4451af0b59b0412e6c53","7e0b249c0c7d41eb9556ad228f44e647","0ef7dcbf1cc44d408bf248e068f07d5e","be36bdc602c64c48b0d0452a01a8129d","fce97030b7f64e7a949ce2ad2c6f6882","42d85fad6e3840fb904e28051e8a2b78","75f65e0a366e48c0a7481f8da147d662","604daf098fa64de792b9823c5f24651d","0a0b082addc249a3818d0fc40ff6e39d","21106d46ee3846c3975dcafeae0a4413","7667f1a1bf934d938cfbb4c41294c117","620a19efda0e4f888e0cd55e14992e59","636a042a8afd4c7aa6a65a48402e66b8","94740cb083fb4e5397520e330b990c85","235652e2d3b34271b2dc3164aeed67dd","b26f199232244aaf914814868fb0b555","b602db4850694a8f83d3f4be7eaf8b05","7ceda123a94d4a71bdcb072691d66c58","6c60c9f8e6df43d2a847536ac5be2956","ffffb2ebe6bb411cbffbad9eed601799","1096d4b79aa44b11b1dc94673577daab","e371bdd55ac740d59c83b03ff8249c92","ff0ea144e600405490d0eccd540f8cd0","336b205ab6ad48419a2f7cf1d5f40974","0bfaa34a1c204168ae0fef43ea60a530","7a8963312ad945609b91098b51a19661","054bdd65f0404a30863c9127440735db","6ce4704428574343818751fe42365b1a","1b6bf53aff1547d1b11c9976356dac94","7022297546764f6387e46563e2336ab3","a42181d146914723bc9750ca3af37ce5","5548aca247e34cc8965c61a227fbef87","5bd2068d87204e6b923eea221d0aaed9","e2f90e0946bd42149eb380ab07676074","30cf7c2dffdb498f84ac4092644ec347","a8d019879ea74dd0becf984bd9d68c43","60d5b23e36c94efd8e129d497b1d3252","97235fbfb8e545aba22ac6108e215ceb","c62a0fe903be4cc09527590ff86127d2","978358d03fec4e418127822a2fc0a554","06059d4f51c64ea7a03e5020e195b0a5","21235aa314e8459d9c28a46debdd8902","34a99c4bd57f48929cc18b92011259f4","99688c964e404c93b24cdf066b94fa60","f648bd06a3d546518c1bfedc27e8f136","4f74fa3839e54e61995d658989a287ad","d7e2c821eca9457faacda76ae3d44678","7e74b82f82434b19ad779dc716a3c679","7f3268b6efa44566ad6ef21fc8a705d8","bc62e634630841d88cd775dfe1a2cc04","6640354df12442f989c0739eaf831eac","3e5064cc2687458f88237d7dda6aaec4","b3356fb3862e4c98ad546cc052e6dded","50e7c0efe53c4a329b680061c4a7a6d1","c4f411d41fe44c15ab7b1ad2187edc36","a8eeecfd68dd4cf1b997045953ea0934","b42a141313754b9d895dc58a2d5d5e8c","998b2173fe8a4aae836c6c8efeacb269","8112817317144431808b7c493cda2a8d","bfb90e5cec394a65a87cad2b107102f2","0a5662855733414c96474ba4b1067213","a000be5c91bf4a8a967943cb3bd54562","8d53d30ee39a4a4892074762b6f05a95","442c6448fe9a4c67b7bfda8df70d7bfe","975b409f055449e783383c2a9143d8fd","05d4b383dd6d4fe1877482bf3bf7800c","f089021c22a54bca826b727c68804583","905f0d98fe404d498ea11d74a5221924","311fc46996c24d24aa07d5ad9ad54fb2","1969ab4634154edd850f658c6af73870","2797eb7f135f470894f9b45c26a231b0","068f1cf349c7443088d83c68bbe8fb25","2be56e2e58904c5eafa5442d1ee22e96","e10a803ae41f46cdbf568f28522438bf","908654ecd92b479d85013db65591f74b","5f7f500e22374622aab2d05e8b61cf55","693e7eea3c804ec89f34ce5d50249309","aab2983a25d94a688fc4ff54e5d75d6d","cfa3866c2b084c77a3149cac51376482","9cde97c6c8cc46b0af82d505a8f41703","31ac276718ed47cebbd58295eb1266db","b4958933b99e41fcbbb6b596d0629029","951c91bb601e4762b88cc681d188a375","ef1c97ca9ba54ede9be3bdfed7065e73","e1c388134b624b11bf9da8533cd10a08","5baa980e32064cce8eb36311b7021dae","f7de99b8f2c74e60ae2cbe93ec48dfdf","b3a5502eeb914a1c87706204419345ff","4853c53dd8634533b61e0a00d17cf720","6c7396f826a642238a4f53785ae8c018","ca747c2911c342a4b6822938e2ace32f","d86ec41d185147729a655a1723f6a07f","eba0fcfd8995490ba01a9232528c8b10","0dd084c38e9d4e59bf0dec86d24e67e2","496d13567c9548ec88db130214e9c1ec","afd5d8c6a8d140dda18fa8a50aeadc94","1674d6c188cd436fa149130a8a7424cd","d40a23e9eb244cb594045e747ff62772","77559185a9c440f2bff080f401cbb374","9ed035b15a884eed8375799b55368c17","0db31c779a9f4b649c44722c112dfe67","829f6809a4554c19bf6e661a4f95121c","8a17d8c4b4564eb7a06bef7d6ce2e8e9","bb336cd5fcae49d98b89207afdddf67f","4aaabf791e2c49319c6be8b85ff7b67e","178c4c94303746c1bd256a1dab522db2","4aa52a173f354c078ad1d118c00cdab8","26d126c7b24b414fa8df2959cca4b7ab","478061ff78ec477bad1319b5b3749cc2","d302b68de77b445d87840ead7bbd9b2c","5f7085782e3a40aaaae8f15aea55b7aa","65c64b6d5c314a0f92797791e2422593","95e939da1edc4ff08b6908afeabe32df","33891710358e470e82551206533a98d3","7149c53b312844f7ba1cad999007a087","b548da8a665e43cbb77af375c784f859","9b0b94c461b845bea2daf856bad41749","233ff30b1fa542679be14eb50df8bb3a","e23279b7f4a8417cbbeefc7cb7b11f02","104e8306c6ab4786b8e5814d4d03498f","cfa8675cb40f48c3a44b0c9c032190e8","3376fdeb53a64839baad01662e14b57c","ff74e277ae66471ca8a44cd8225e20f2","1953bd441f524fde988a697e49875541","010f91b3f8244a34bec02e1c6538c4f8","b4a76238f5da40aea2ee294e8cf8630f","583efc03543c447f9c414b53b2b4a4ab","eba17b3b54f848c8ab615641f01d87fd","068419623ca7480da978a6a1cdd027b6","94d1b1134d3649a98d2ebbd8cd33c40c","c795d571d97c4a888d87d342e5ac557a","12482b8bd72f4034a2a42ebeddd32b93","6930ae7515b8444d816718f1ec02a603","6c685f59c25b459684204bbf448f7d2c","d1ace5cb3cdd4a2ba41e1adf4d3e5b44","7b292d7200cb4c8ea0a5236154136b2e","fd070c7e4ea74832a6fb0aa29ba6f1bd","62e148ae0107439ab1a64a36d0d20ca6","fd5aa206c04447418f77b8ffb7732c66","ec58abd9290d4e0b9b8ca97cbcd1af1f","408e44970bd54d2d8d996859558c85f0","752b430cd19a4c528a517367c917021a","56d09ef3e10342b68ff50cb3311f933f","5b7b2437c7c8459e8bbf238d612c5fd4","f8c72a9d085b45dab5f8db279d1e6340","d004d6e9913b4602b3b46b4da9cc06bd","2dca4a68a655495aafff51d53527f89a","3e57eca95a7e487ea7086809c8294775","5caeda0b08af41a0afde64d6be0d1e1a","d938c98dd0b8431fae0fd32aecaea4db","d689b8aa7156495f990b7b27509db714","742386e75ada480fa4638bd88649bfa9","21a685c9e72245af8b1516f37661cb5d","0f8938ccd402484a82873fde2e52b208","a9201c6911d844419e623ec7defae5f8","ec8b48933fd649d4af48c9762454c0a6","cfdf47d800be41b1982bfcfd1e7a99c7","586e6f46d1b043b784b2dbf2c85d0a05","b381408e512a4c2db07b3488cf4d2063","39e8cdf14411439bae6cbbb1bbc14942","4850534111464e5b84232a49b97cfb87","c3c35eba795f4609b431626731a112a5","96d1a616e929446dbfc2e535d3233d03","edfbee84144941cc864f0abb9b0eb83c","cd40d465fda64843a76aa0284c725ec4","472d1529a1414b7098d7ccbaac542516","d2a03440f2db427b9555a10f007ca8c9","0cfa394a17cc4825a81f7266e15013c3","732e437df7d248c3afbe60a1462b2be4","834b0fa82c304c278b6b7473fd64b7f9","74741608680249a9aafce3ddaf5ac3d5","027e3e1210254bb89fbe01ba1826682f","21f6f879b7b7462facf432d2ac5fbfa6","68fd0a531fca4f4aab7d9bd2f4c2face","718f479a4b15441392ee97f5a4468749","d509cb2c6e0546e5a7b4031481165a0b","a18c3b05eea942159e41bcca1b6c8a29","8a60f28cf94b44628884bd836d8aa6b2","4d5c63bab10d4c1d98dff4891d50200d","8b20bead59a04a5fa668e742235fa7a4","3dedf93416dc4cb3a40b8ebf5223f96b","3ba254c1d5f24ac59c4127830c66e043","f610c6c66d184679ab99659fec486f11","e050112005f543ab90213b62221bd78c","a25d01226f1e4f159960c1495d5c3155","1e9512ccbce34d34bd22ad20277cc805","8608d442cbdb4f56921bda9730b9d402","bdef7135927a4da7b074d9117d08c34d","6885163278ed411a8ec9bf1bf6e1276d","a60c54b055b24f0e96748b25a69ff0d0","24be29986b0440bcb30de8bface5efcd","2028d33f91674733bd57435ac6626b98","b1bf6d81ee824a3baf0590805fc63915","f921bbf7e8574b65a9472de8a05605f4","aaa09a06ce7543a1a26a123837df2bc4","7402ab92d6e64297898a276fdda566c6","4c0976a6152b42d6ba16e616e323980e","8de0c96c101549f2864a1de479e3615d","112dd62d8c40484abd6ac1aa0423450e","9085a644ca4e4266aa8c03df199f7f42","e022f738078b4171bf55b289e5b6ecf2","83cddb0457564efba5caeed97016b26d","9449186871dc454abe7ddefc8a88b92c","4ee098fb3c5949acb83a71f4bcb58bc8","245e9de77bbc49c5ad559c928bd3f04d","1002c331449e4b7e8d5a720ae1d0b122","9a4c5cd28385469e9ea9cffeeb6be948","d059c074d1ab4975aa0f0963b3a79871","e46257a77cfb42a8a625594894c4789b","42ea227db9c84f109fbc080fc83de1eb","efe7b430abf24eb5bb44a6a78943d0af","e6ccfae48d4348d48847a50e13ba9db3","601321133082464a8c269cd53a845717","bb19714fcd504094ab3c7d1d92241001","02c2729852624507a18c0fd2b0031d08","bcb5f62d8f09449680bbde66251ecdf4","1b6b5fd4c27b4086b19bed18099401b7","77512075ab8a4869af3944cc6d64b127","95bcda5446f34c01b881f0938e7e1c1c","401e803091a5464988afc41d82a5cc17","f177e9bb7c38454db93ea8c6e661ba37","a006593d2c734a03bc216b530c0531b4","d14530d734ec4f2c93a1c2979e7c2fad","f1c51b686f8a4e88add393642a944135","741118e5593d4017a83a3151ef772fdf","fbdca2fd2ca543aabb5ce994770dfa0d","a0ac7f8373ba4931be991a6f6f8ae040","c5bb98dab438456793acf220e07fd522","21520f8828f34e5f955d10e30ae98680","8fb18e0e690445dda7cc43bbc79ab258","25df0693dd4d4c179d8863b097a981e4","2f86a40657c9401ba65b4d7ab3d6a766","42a736aadf4f4b62b6a17c3c11441d47","578bf98e9fa548ae84dc679a45609ba3","3d380ccb01e5494ea3da0ae9c8f9246c","89ff2a810671434a8f4749124cc67b79","3445c8e6567a434fbd62829ede5b3bb9","e125ee334420484583626a87c45b06fb","a30d4c6283724ab1be0de021c9527898","ecd62529cd6d4a488f8927e85367c55b","c8c544d4d9a245a189e2fa62909e2dcb","e7bc192b5c6a4b2986b85b98b9b30e9e","8a3938f3d9984985a19e9a21ac39743d","5639edeef4be4141ae5da218d651ea3a","2e0ce38073334479aae8d521769ae9aa","e3118676e911431092ad558d690c2c2a","baa520fb5b3645e6b68275ae3eac520e","390d9b0b356e45e29f959c36ed7c7d46","0386b4d7542a4619bc6bdbbbd487a8bc","b4db7173e43d494ca833e926718f64b0","c1113d346a19449fb2abff9f50854961","29671e6f77f44bb298b4175dd64ed93f","630430e1eebd42ad95699f533703417e","daa16c4c1b0d474f94e325afece49f16","e5f901480f774bb382ee1757de3fbfb3","3ab2cd0dd11e4e1a94b5db7c075f243d","0dc92612cd6c4e4899f7aa415136a26b","13fd6b96a3ad4873a0972a095a015653","a821954c5b754a49a854a8d7cf665f63","e9ee964b54954c6b82f76199dc822877","7cf36eebea93469c9a5da4ff1c01af8b","86d42b988fdc453293dbc70408ea974f","54ce64f25b6c4c079b3b4e3ffbe24a54","58f17e012be24358a0770685e5742708","3d43b743180e4981a5197eae04f2bccb","e977645b798d49e5b012a90d3d17fde2","f3b60198a28448cd82633bed380ccad8","d14ef05664604bd780646ef44a88d23b","a2c8d896ba484ce2bd7f6340728780d2","e8e5441e1056435498e7fbb4851bf56f","b1fcfc3e5e8142daa887755bdf0215df","269daceb9b2944119b641583f8967d4d","d26db66da87b4ae1aa4700cea862ac5b","29cda193d1a64549ab5fec70c694401f","f86eb9a37e5549008e3b770998328cc7","91d4ef1fecb844b682dd92dedebb1d25","36c2255881e540aba03b25d606b46547","8465aea335f842a389be0bd58e0cd8de","2c511352a87041dca6e0a48489deeb2f","40a09a4d61ff498d812da255e1b2c08b","bba57bae6fb8404d82205f14b8a643ed","24a97e11752e4da394289bbe43b91ef7","16a7b838ad6a47269b9e18830968d2bf","563470e796c5496483de96d40837c5cc","206d9f76e1314dc896ef753a913a3633","5f95807f439147969aa6b11d68cf3808","49d039568322475cbb3ae69e72e7746b","605f1644789c477c85ec2c64ec820b15","acab1b976d624405ac22e2544c10dbb6","a104368ddca24eb581c2fc236ba2e8e2","65192ebb70624db5ab53c33d756a1f2b","f0f6fd8f5bd7403987fa8314dd53bbb4","34caddae62ca476e84449e726c9c0a23","5d528f28b8d34843a486bdf95c02ace7","13edde71305f4a06bb6a67135b57c29d","877d09bc0156473ebc0a4cfaf39ef6ee","7c2d51b13bd24480a4c9e696954b6978","265ea697dfd04945b88c2fbcd03e4d28","c0bf78696cff48dfa5ddd0bcd89073cf","7cff3a66fcc64bacbd712fa1350b5fd9","ff6c62df65ba4bc89d41e82990ff94cd","a89de189104f48deaa51d4fbc04d2348","809562d0e4834ca29348a9a9c62427b0","868d8042ce2a4cf8b8288e112d4a1c54","d240f85d746c430fa25e8aaf60d08119","3ba84d2a657c43e48c0ff66b6ae1f07a","8cdf6a9a17c144bc99c2fd2af7060a04","d2a2f270898e48868c947e1d87a55af6","bae0d9f47ba6497292d8f24be1ba4016","50362280596f4beb88c820318fbdac19","6f08a33c01c849baa8d0e4f4c94e4a2f","5f2ad8c2bce146bcaccb680450f2c630","1bd3f1647e4c4d1a9bd7cd31a7dd79e9","fe35d8013175490b9e547c7d0b4ec4f1","88b2c8e2cbe34ffb81f60723bde83c45","854ee9ee20464b65b0cc4c8c0ab6e642","9499be2d9f4b4dcfafc20dd7e6c7855a","93808964cf6e4050b5307ed4e20b8998","ac6eb82eef2f472cbf7343fd08a175e2","f7c21749107941e3b683f287dd42f1e2","d8535e5123d244b581104d22cd65c8fa","61ffa487ea7c4e64a4a1b04afbde65e7","a5ea97e0b6ef4fef9f923af0757c8d57","acc7672d7f5945deb6a37336dd850b3c","cf5db1e4769d4de887ae1443ac8f0b18","fea931a461e14aea9a1aeed356853def","bab18a1c8170430682c16138c25e129f","d7c9869aaabf4eb4b474273a89456c74","db5790de57494335b224be1bb76509ad","b02d8b6dee0948528e89a79449e414f3","61f4ef133ce3497a8d56c71585578b0e","7872a3e36551451280cf2fc8d81ecc7d","83c91f4cb3b14d9db99f8a08479a4e53","8d48114809324915962807b7836766ac","097af87877d749bcb3196c2d7e83bb50","4f7d6ad99b2940288a5eb59f6236be88","4ae54760409f44af801cdf96cb8d6777","fff5e6c47d7a478eac898d69b9dd4d03","fffc64bd9ee2435fbdd1bca5f4a2d814","e5fc538e5841438ca584ecac6bba50f5","a19f1dab5ef441bcac66635896c8ed11","800a68302c5e4800b13d7ab4b8184417","1fcd38884fc946a09815d00c82bde0ae","6c4506fb8bb3479888b8216a0983591d","28277a34bd68403fb8adeb4d394e83a5","934df9314def4732b201923db2b05764","b234f45c9c1842dea428dc430b491dac","60833ebbd5e14071b222adaec365def5","b64fde57732a4bcd8f04879135781080","4cead31aa6204cf197b112295206c2bf","676c7657ae9f4996b38709846a44a70b","7e035ba67e76431a8bd3be40cffde814","358c6b2d6d1e4014925b58a723366a5b","e82d1619f1e448eaae936b1c93cdf3cd","e4f6896374864050b2c3b4f0f15b0325","d1991e42e7fb4863a99009b7f6c373ef","d4faa0eed1ff45bcb7dfd9a9274f355c","df04a51b4b2646f584edad9bcd9f9800","6557604d8885432f8feb2d4b318f49de","7f42b44e62b94bc498de87facd8baba4","2af06b8e5d394f0d9a788e53fc9f2918","499c08b7076f47d193f91b95c9f78922","b7781a122cd942ffab75b2da2ea0ad6d","128b5d6f5c074ca3a7e1da6f5c691199","c076f982afa74e97baab89cb557083b0","4a8d8ac0e0e64bb79051ecb1654b6a80","3f055d36846e4178a8791dd04b13590a","7ffebcc6c5e74e2abbffbd7b34bb9b25","ef8d7708c3c2423ba2bbce8697c88941","55452f9377774eb18f909ae200c41266","0069a30be9694b5c86253b6ed373050b","d6aab597aa934e16a722a470380ef310","59e2140db3e140e0ae3fa4d1b2d6d78b","aa24e8e547b94d609b8be9e1eeeb3eca","7e01cdccde284938acb788d0f4249338","e70409dff278429086df2b4ed24c9bbd","9e23532fa3d443eea190ee74cd0e03a2","bfdf89c4ca9445e380f45021fb2a38ea","9f17f70838a64b06b51876bb91747076","cf3b7afb34754d94a51acac50c7be63f","e49e0ad2be9646dc971883e39eb7b9ce","964423753e9542328159af9865aa6b97","f809ca559d0d4e778c5668e9c69e0c37","3145af091e944c768b13f5bf14d85f9e","26c2e4bc29b046e39f197fef24169875","e13ca473f2a64f2c9d0026669a033a27","5db00c4f11ea470c872a0597c99c637c","c0895001c09942eca71eeb8b8385ce79","a3330cabd1a042919b37c3bf9543ca8c","e590b65cd65442c684310b1d6b98c5ec","58c5b47cd7ef49b68c0db56d47312bc1","5c395ac2143946e7b5d917dc92cb4da3","41083358321e449e8479ecc1f4a2b85f","ff049e60ff7a4eedadb43aa811051e39","f1194861f20349d789a84b6ddd8b28c2","548d432eb79c44099295c1ff121f7db6","f0896d62653e41a5bd1b93c073abeaf9","543bc61986b94720bf822124345c0829","4a56cc8e015a4b369e72c385786c2b74","cf7d901bc79e4db883e5353cd84374c3","c52c4e757fac466a94422b8ef4f14247","02bac49ec54e418583122957b3861d3a","44a639fb2faa43aebe15df9c47182550","b22331ce7b5c40bd97441b556e3fb7e8","7bede79a1cc4449f99af339ff84e6a5d","9b59fcf7306240eda73c55d0a3730dae","7269f94e209841d5b7f4a2a3aa8400e7","4cf80b7cf5044144b37299fa2be6aca5","e5e58af1a8154c5ba4cc9da30889495d","ec4ae3238aa147328d352ad6039307e3","b5786dc852ae41f68f4b3e444ed8c877","ab60a48c2e43414380a123ae34e456b7","0390a14395ea45f697d2dbe27574b137","aedeb45a48e14157802df44433bd5b2c","22ea9ec76db449c8b676eee5d4d34888","17866dc904094d85821ce42a95ad4d46","d21b0ac7471c4660b9bbba249d83bedf","cf944e639602465ea6eae155dd4b524a","ad9742cb214f4b3bba967997b07472e9","59dbdcc974d54a6cb9987dfb2c9fa754","47792ffb22c14aadaf02605e2357f684","aa82622a886a4ae893149c8c37712540","1abbda88e7a64ef0881b93cc746ac99b","96334fa84b15484581ee964466d14414","7188dabac936451182fe8c678ba39bd5","d5a88c2aa0a64441bfc9afdf9a91832b","3fd62ce42b55469ba1c54591f454d8f8","b24cf51f2dff4ee2bb79f648e2efac84","d495788df144462a9fd6e6e622a6d1cc","0bf28b570b684090b0c411ea8cc6c38e","c9071c27d8fa426497a39ecb577fa515","11e6077d4a65401dbad34e2e508bbcea","bad5095cea7d44da89461e23c08b3067","04d67060ebe24d4f98fa1d99300d57b9","9e4b093eaa5a4d2ebee29a8c9b69e86b","982198230c9c49cb9dc3a356b9d20d39","57e32804e69a4121a9cd2db41e50adfd","54558b05c74c46588f113d19f54acb3c","cee19a7a00564e3ea68089494c85e378","841664659951409c826fd2416d3c2f12","9994ac85c3094830b4190345c6e3c15c","4fcb56f556c44e3ea201db02fa7d0dde","5d7eb8b2f4064f8dbb51030411a301ac","a637876f102846089d32ea3bc0d1853e","74275aca35db4d5899f9e43973cc80a6","473896cd1262460a9de1fd861ed7f34c","586a22e8a05746d8b010f4b801630a18","9d1f90df10cd45c5a2fa026cd78a0d78","903575bf009f45b8bca7ab969c027091","540c14619cb44a779ce5b4d6a29e280e","50a04f01bcb145e1b9ef00637fe495c4","9294068de194482da3b18328317a416b","eaef27ca83fc46bb9c3b5bc0f72e04d1","f5af4cf177c849fabae3a75a5b81cf3d","73ce01bfaca447319053a3ea035b86b8","3a09b556bc2c4167954608eea10d37aa","63a5530862c448b3b19601c6aae68b8e","217f37c3411a4319a82edb515f0e3cbb","115fd8c5356a440185e96eb6ccfd8db2","25153fbd002b4e22b1850fdbfde3887f","ceb5cf24f1034af48fc3276e73ef2678","b0c9c9d8ed924b3bbb5926a9b0d42269","816f44363ad647f192cfa09d03e5bd05","fedbcb28b33345e3b2641bfb40f6ad20","56fb3e554aa945f4a5cc371e72fcf204","4805f64790be4fb18c2f4489a3ad91f6","7aa68c8c1e1b4ce08125f29c1e53f265","99b0eeb5fb164712ac87743f139b24e3","d2fea5847475431eb1206d24f7aa36bf","62398d2367e54139b60cfe6f70c05ed2","56f41eee9b784a9085e0caf9a56e44c3","111d5c2aec2e42ae922a5e25f1e2482e","8ad59d77882f4261876048a594d43b19","a73c6a7cc612416e82fe9ac62faee699","9901955883ca4b3389fb39f558947cce","3da1387058b7429ab62fa469249cabe8","9d20df1da29d4cb2ba899e256ca5f9ae","2320734781a54d36ad0f7c57fbfa3c03","4f27a313383743eebe09877716df7cf8","40dbe2c63a564f12a99bc607434ebc28","43ce48a80aea4e7c8f4f44c6894ab65c","d0d85ae17bbd4e189ee1829ebc7db990","aca0f6defe274ba8860db1a163fff32f","ee9c323b8a964788b5f1ac058347dae1","9e3e403a4d474a6b920eb1af91ca6c08","52397774633c4ec48a2e9b43814d7c67","be701a4af31c412ca5fb72d4935b84ad","79f16fbd0fe740ca86ffd86b30b8ca9e","8cce6ca9519047d78a8f5e57a35d0560","f5f373ab03c24364b475797e9459e16d","7eccd257b0834cb8938b97a40116b5a9","74b41049960b4c1e85b18dfc83270232","00572623851f4a27a8678857c4abcb2a","d2e37e52961a438186fdc98f0375b1ce","7653b10aa48e499cb920065a3de61673","6847487239d84971a57dc2de317ac118","7639064cf02542a4b0fc31c25d19bebf","093d30a6cc7b460eb939bf7f44f1f7fc","572b3da8d7604ab294beeef4d5ad7515","1b785e084ee04e33b21cc499627199e8","80b6c5cd600f462992d6d143b58f8158","2747fc75cf2447cfa3cb7dc517d33fa4","83e0321f91c74a6d93bd0eb4182ea836","5f27eb1083154af796f1afd98764030b","a4acc6c67c0447b28335ad3cb66c3bd8","6fab8cb5ba864ee1b96f3ed84eb34aee","54a9e7b9ec574d36b887a25957333b74","54440b82f93c463dbbfe3ee56fef879c","56bb094af16a4cdd8b6d6a3359528440","b68146da410b4fe5ba04e923f4a70595","90cb7a9573794d84a824103e817cc35a","4f338050e5a040eea2bce1d8a909416e","b6ea4a4f2bb649dd96c808759948cfb5","f8b9c2034b3c445881a17f3162e030f1","c86871f8584e4c9599f9f5d0a7d503e6","3b5ada1785c3441ea592f95878fc3130","771f5a63a71e486daa0ff2aedf205803","825b1f6920224652991b519e00a0c1b5","98bff7338c154371bf6cd8d05781c358","3768812f75bf40e6b9223b7b0d4fab63","c23b045519f8413ea02e2d63099649df","bbab9dba922b4f4cae3ab49e6fa242c2","7e4c8451a5ed4e01ba80c5020879558e","f58868cfa84c44dcb7b011260b13295a","26549ca6f48f4a94b4a6cc082b34f32a","ff51690df9a84e9cb226e139c9177546","639d6a418a8245bb81dea2e2dd081dce","52aa5243aaaf4feab8a81789cf6818a0","ea6590a960f74b35842c67816573d876","ddcc36bdd49841c48d561ac615d23918","3d630b67b8f24f6787743b4afc616289","512ce6e3c1574822910245c72e588ce9","b8dba35c19714abfa8d1199646ad3937","5363c075381343759e5723733cc91323","a39dc1e3ee5441f7b363bf4d274b48ff","d165939e69114f72b084c4fbaaeecf70","320bd5964f30459db27dd65123218a3e","e3944916a8ca44449b160c55ca9ed198","7beedaaa893848a092bf0ffeb953fa3c","2ce0f0ef681549f3b4cb47ff25057cc5","d80bc0dbff5d4fa895ea5a1dd79035cf","861a736f8b254810858d3d84fe346c0a","cae5e01948174be29ca8fd34bb12cd66","1150d83b08644784989a00470d5cbacd","db7f6e43b11a48358fc24387436bb592","2be3e04477de4c8eae77644cfefb05fa","7cbe1cc64a2a454aa51ea0815ced44e1","f15b71756c394bfe97fe7b32f09f1817","71c56f0e5097400db9f76bad7534a1c5","1da029e5d8ea42c09a4b3c3b059cf6c8","5d62d5c08d1c422e92b4a05274c1de38","c9f6e82c64b34093a7a8edf90ea30426","fe84c0366be945cfa734f4b4f20b8959","2348088e5b634b898498efb94ca2c510","e244589b3d394e39a4e1c091f2f87d76","442cfd07842b48e4a787b57f367e2e76","aa7a8c6c421d4f9f847822b2adcf336c","20bfaa00955f4e0298abae2f4e81afe7","42b65b06bf83443ab097ce6076932bd9","5e00fd58df624f31a4d40da88daab9d4","c1e0f6a8cdab43adb6a3316065214428","20e118b88cb344688041fbb8bbdafd97","986aeaca4e7048989351e463e44de10c","e5a737fbffee4da4a2c3324cb5bc4bf5","aa8f0c4452ad43f98a8677f2f3492445","2d18bf67088847deb4ef75a8c9acc4dc","3634ab3aa1594b2aa841c3f9e040c750","229a84299f344193acc358f7a80aa87a","2f90f18ebef34d93b7bdadc164a22c1c","07c5c936d4f041119bb48269c891e966","0f698aec44b34eadbe05cc9251639a0d","2116e22f335841e5a485087299928efe","db48f3e7f6444f7f910e7ce7f43a14d7","186fddb8527a45a6bf7fd87a5e13966c","337c7d3cfaa14e3fb75f302e761fd090","c727b01e55c248d88e8d8f9a12aa797c","32d8874c02a44eb4bacc284869053205","c6641e7d226d4b48b65aa4feedcdaa0b","450b0b9d6208447d93d14bca1bcb60bc","e1658ab42d284d39b593a684a66e51f3","d9ef9a25d14b42f8aa890b243bb59025","4edcae564ee1431d8f182f1fd08a5e4b","64d1104fd18a4c6ebfd144fc7e75587c","ab2461020f7c4479be62ff609a8f9903","f49e1a035348488c8d1b61530868e03d","680c3596c93b4ea6a3bcaf311a5d7fae","c7a998c47d674316980151dac913e0a7","cf09cec0a3574d79ab46a49eb308d8e9","af3cf35f297d493382043642c25e5784","1a451531ca1e4633a8693f89bf4c007f","8dac7009e2094728b4c492282e6225b7","64c3b6b324ca4be8b078e221ebd74d27","bd3738e9aa06489c8bde9a967b36e62a","b646b6ef36b54e1d859ba2f64e997aee","db54bfe5c9e246c2b36d106d13847623","2b8999f0bcbf44ba8b16d57a778fec17","325b48f6b4f8428780d96c69741a61b8","452302dbb09c4bafb62a503eb6b2931a","2436aa7783184a8d98c926534bb298d5","25ab2200598f4cb385196ca5819deb6d","23cefe8b43f646319f95b1d6fe3e320b","5b86c4079bf749b3acca261b874f7e4d","fb0698d1e3f549d5854a46e3f666f670","006729d8c58f47b9a08ecad3f00b9ecd","a1a999263d394ae08bf13fc1eec17512","0b08b832d9e146648c89609f4acd6408","2e84d08130884a2c9b6d08061a85d6b4","164d75fac37d45e99cf4f5bce046aaf1","50a41f0b0d33459aa978ff0db9d245ac","2a5f7aa05fa64e489e6fbc41d7e252b2","02214818d27e4e379f80a6bcb0197df0","bf1f1d0054c04280b84aa05ec9caa2b4","a17061aa5e3a44538e86e2cde4dd2d42","4c4daebb4ec44d95924db4779d886fe5","1b1cbe35a0534ebd98d6af37ffc580fb","61c6263c80fb4e688bd6bf5da5e343d5","e78b68fec3664eb29f9b468669048969","c01b0bbe12a14144873c71161b2d0a31","4cb42b9dedde43e0b5f045212554d991","101141a552d14f7295f1ab728a4de1c3","43d3ebbc67ee463abbe45927f4705d68","0b3ca2d656a7450bb373d6f2390b580d","21d89818200d44e6a3ac37077e3a81a7","1819410d17b840e4baf3a3d87bb9bde7","f97adf2f66f44e8a91cf1105fd7eaabe","8f68c859c6fa42f2bfe29d4b40b4e614","d74b5c3758f049e0ba1e4bfa99c7f8fe","016f893d676047b78379e03cb2cb696b","97717af8bb0448af9d7f89a4ed465027","9e46b68f819e44669be647d01770ebbf","abef67eef5b74972abb321cd4bd6fc78","1845b9cf6c4b414fb63d7e79c44ae080","2576198045844ec3bae475dfcdf97182","ee76f58ff8b342368e97471f6130c183","9cd85b4c0256456d8906a5ff721157e3","728172530d8b44ceb146f8399d497b35","64da6af3f762467c8e0c6e46e0537f0b","fa2da455fbce4fa583fbe3e1936c91c8","652105a2446f4984aab10fbaa79dd4d3","571191c8378a4a69ae8c6542f036e266","d4a09a8536634d40a675af7cfce3c68b","41bc89b60cb94ca5b8c428029649325f","ef1b2c6218d14a02bdd77b1523ee206f","f6442ec14f494e94b7d61a4566a15734","426fa5468d374cadb1fc4b2b3bafacd1","1424c417e9034777a44e3535e55df5f6","ad21d1f95ad84235ae95110ad3d9d9af","44ade40b83d7450f8fc8b6dc34b901f6","c9a36a951e4049f88f210b6df24dcfb0","92194a42246f4eeebe65ea7743cdb167","7c9aca95a6844daf9a936b69a485755c","ed7d7f7d8c224d25b5ea16b3d2c2c0c8","89872d9327a64690a318201cab63d6a9","8f94d4af005342938b1b4912ac327c01","b2f9d0e6e4a64821b1e81d1dfc00534a","4eb3e61030f24f9aaa125a3635695de3","298bdcab4adc4fbb93d00beb6da41563","df7f36aa540a4d95b80c40cc49628903","0df6468b4c44458998914aa9242e699e","1d93e2bb0b33487e86a2fcf7355f854e","57b8145d6b17477f9956bb65cbb1d22d","b124e6cf8d9541109889d5c620d0dc2d","85ae81fc274948a6957626324a71138d","9dfdfa02b93241799821df8513e5a5dc","9f9e80ef5e904d3983f46d0ba43ea359","43094b59cb7d4e978a50e4c67c18d0cf","c39f36e4565a4b46bad531df1e5055ee","a3aa93dc3965443ba48b2bbc52d2e8a8","fcdcf2d83c704a3abbfba9309e09f615","17d0d7f5d8314e3ca323fe428354752c","02bf8cbff5c2461eaa4d380a9cff4a37","43fbda1f6f2d4b4da3dd031c20267077","13a3bcfda69f406ea1cbf2224790b189","3af55ed6aa174718a26839084a134eb0","073033e98c6c4c868c968fd8b7a8f618","dc4808a499ab41d48157b3447f561ad0","4d6a9d77ce6c42f19919ed760cf4345d","5340d8b603ef431abbce531892fb0d22","3ecdf442874248fc9a6885d2bab579db","f80ce27026244e24a8e2830bb91d0baa","e73cc86a63eb4efaabb588b5e16230d2","bf98efc9e8c5496daf89ea0aee19745f","09f96fdfe779425499048b9a80e9a423","da1db9dc7f5545aeb842b16997677c93","43bb136122104527969535724a53f27c","ff68a1d8b10a434898b2834e59168afe","4f1bff2a9b9147dbbde4e841784a9efe","4bbdfbf7610440169be0b465e1525170","a216327010fd4594908694b785d12343","a8760b2541c346fbabb419c1c3e6845a","269f24a7eef3486a98bbd9be3e9fd1ae","6acb96f449e64efbaa761d5f9aded9bf","06c9376142194f74ad365e8d58168b60","3fbddb34334146eebd4f9b58496c41f6","d7a97e54a9834d8fb6d3c1223588996e","631ee3b5570d46a191a27a7b39fb58e9","ab94b22b698e4bb3b08716e10406002a","d01e59b3dd1d4ca7b4395225e8e25a8d","0ad8f0866c004dac86a81a5d4efc2d1f","5077c72717ad48cb97158967a311cfd4","b15c3ad772b54a1b9bc13a84db022c2e","cc609ca975664ba89eb5be4137d120e2","9a423f320ba04a0aa4d7b2027cee06cb","8ff98d890962465eac9d0a9f1769fe8e","91f3423b72b7462f827ddd7933778e27","d41855b1e7e14a579fe4626822f3db75","82304f3b00f348f6aa5af1a4c51760b0","067b6230c6964d2995cecdb5fdaa2213","615fed68a4e64a5cbddd1ce66b3d806f","b5e488513feb47bfa297868a0d6043ef","b809904222704979a77561cb503e46e5","8969e825c6614e42a29820fb8b6bdbc0","4bc6914141314b83a1fe9cd3c67b7d85","d604c19a6f244697b9c89e44ddb08e55","a82e8ae3c0b9401897fce03a15909138","f220632ebcf24e6b91bdc7c1ef23a640","ed9a72d5c23f4be3b04201a182fbcecb","ae0811838e5141ffa5e819950accba38","699ac20bb8304b29839d264a692d87a8","7ae1b5f1e89c42629dbb67c2835c836f","f475bdfca6cc48d0a10fe131910fdcaa","b1ec9782aa674c45b0ba28826144a96e","a11ec62bbaa74dfb9119224a6c10147f","3a9e521bb2f8445fb3cd4324f815477f","b87c9e0f9f4c412aa724ae2b8ec5ab2e","fdd68e4672f64bbd8ce96f336d875999","61ad4ddc268e47a6995f1ac499afd540","a368b5e69e4a48528dc5320a025e054f","6c188409e3d64aa69af3a6c85c5a7821","eb765d93825a4937a737d1a147429a08","b847d15a3c384fe7afcddcfb48473567","d93ef8958dcb42a6bf0b1a66698c4385","c32c2f2cd2964d3796695ad06a6faf2a","f7b1fadba3d14b67aea50d136fe29c11","4e47cdfa7b2c468589dac8bf74529299","0e463a593c45460291d7d617d2cc75c8","b392220174284bbea83a9280b64ccf53","800ebd5c96204eb89e052bbf539fe192","15cf31d2ea2944b5a2bc8cedec6c7c01","5a158ac1896f4235ae80e8560a6c11fc","20d4eab747b348fc82d77a4e5ff6df9a","8341e683d97f479892cdfe0d9ef07d3e","1d55523727244214827e614d05372d61","9a8245bee9a34d4589b10158a5822f34","9d7df81985624f84bd3ee0ddc310a14e","42ccd4b32e1c47c18891ee6f7a362e4a","b67c26ef40004ee28d8d0f4670471e09","9941d460da0e4198bcd66bd3ce3c922e","23739c1f0ed24d02ab6c61816daf329c","d47403009fce46fa9a6b0bf13d99dd69","f7cdadd427714d9cb43baea79ccbdecf","22984c663f72477188021baf41fa6faf","c40934ca61a841e2a7403b0b5c7ea2b5","e9743868dd6a44dab389af01d9affec8","63082f12c57740b88a31360b62a64a60","a3466c16e3a94902b24b394b699f19bf","b74621f29a134c3386447e12eb1572a0","6b01db126b7940ad8cc04bcd4046cbb0","b091332a19784130b814afd56f079e71","e70b8ed04a474b488da6244f8db3a207","3c59d26cf22745ea92ab8295db8c3c0f","0dd7d455304443f4a508f6f41ae908a4","ed131185d8874baca47effa5b419e4df","06b015fe4d764ad3ac9e97e14b2e2887","6330099e5c484de9b1721ff1cdcc240d","45bc07149f664c1fb6992c4c8ba84b86","07ea74f893e448ea9aa76cf72b0d7b11","0f25751057274931a1908f9a7fd6c61b","946e069dd8a84ede840191e7561923e3","1358ebff0ea5430e8b7e0576de0fcc7b","1f8cac9dde394a958d64a8c7088bcc61","b4c79398498c42dd87d29469f523921d","311b174ba8b54a43a82dfb642b374095","c0288b895aed4e518458095dd428db66","3171836721704b05b2bbbfe40a136792","8dd33b0fc0c04a57a7acea610b0aeefc","0f3820682ee147c6a611332213c98eca","c04ca842457b44299892f311d9399d83","512c554b4d50412a9dbe5fca82b3671c","ed1a2a64ca814acb912b588237dd0036","3043180f4c704e5384b84bc1e9dde932","061209b68a574c4896c782a5c93fe2ea","c235e0fe1d1a46d1a5cce5fee23238f2","c9bd12c6f9f64012a1b786d52a76bca7","e448c694a40f4689aa1cf17a15ac0c4c","a4dafc97828e47458a9e5efdc33b2abe","0f920e1d959546e981d3946fa82b4f08","56cdb30f116d4c6e8bc9fabec82898c0","f1401ec61fc04dd59844089a1acc3c1c","f439f694a2bd4966966439d4bda7018a","296f2bb1aa3f4be99d2aa5535533cfc5","e25aade715594a1f9e0047daf0a94b47","cf82fb6e817c499c988270de57cdc0ce","4f42d6a5ffc94da09f72529c3ab9c9b2","b031835634604e8c8fed808cbb90581c","e4c14f6ab6f740378ff75b35da123852","af614563530f4f3fb2450f91188c5676","6a7b7daa999047db9e53bcb053b7741a","98799747fda449799cce39d382fce41c","5dd57572002e4a1cba1e606723279234","8bbef9cd0fcf4c928a41f727a96e812a","10d0f2e17b6544aeaf074c6c6c6b0215","23f6a23187354441a8cccb9156c086c4","1197d705444f4fd5bf8b196116185ffb","fc0c3014174b46809c0973f3f34c7842","54a8dfda89fe4e71954403b3f607d63d","6edaf266b4714f06bd8aa8f5f2a5240a","55167a0a70e747eab05596fb7847b774","b4d3189a4723496e9011e67b7190a887","91c4a4c8a0234d88947760e6fe243401","1a345bee9cfa4e3fa9dfed616f38ac4b","034c18e694574eaabab5156806cbe0c1","b26b6b88dfcf48a6b3fa62f3f8cfa987","0fe24fa97d8f43c9a6dbdd3ad19b6cca","5d690085acfe40bf88faaa85e3032133","a4f6f24a30404b31ab5d10f17f5cda67","6547cdacd9a642f68480352c0f76c88a","28c71b2babcf4b3e901306dc2e5357fe","2fefafd5f7a04abc85d06dfc3f48e042","93ae72324d4f4f91bf689a437cbf6907","bc62375db8eb43f1a1fb323fcb5f7330","c440bd4cf3ff428bb0c293f318f2903c","d47f7e1cb03d46b289b9f88d2ebf0228","2f06d4e08c4149d3bfb558fc72c4b064","52b645d695954387ad87a53179ed4893","6b353b0dcc0c4fd0aa2f0a8d666d9232","bd8a857ecf744f39980be183217b1fd3","ba6e615cc5e84eff9b7ec3d1e994395a","c7deb94bae714336bb3cea0462b6f079","267265b94ad9441ebc2e8bec540d3911","6e53e7cc259a467e84323dc820095586","00e8b87ef93244358a94ad42dd492e82","21bbb9b5c6c746968656e0b379ff30ee","b3fa44ec34644b7b9b573e4d7daaa0eb","62e5a85c369e4b6dad3a1ddb3fcc45bf","5e38ff36e6c04500bd8212d2cb651019","93baace8d1ff4ad9b9eab9d31c53cb79","a9e2f0c438114381b805896b309b7eeb","592b3121ad6f42cfad4a920f11c0f568","100ca9d74ec14d8490de90239030c895","e4b04ef1363a4276a133b37a8abe4397","68b2f795f541479f97603b60f98822c4","d651da27970e46a0a0e706c99dcbc67e","e5aba4cb979e455cb1b119a764f19c99","82f9cc2d42b346798888d5a585e10347","fd1572d1d7ee4a4e9aef6c4c37a10833","7f909fa52a1547ce9024747501d3d9ea","3299094242a34367beaa09ff8552c475","15aef3a058004b5daec8f21ea560b31a","77b52c7345a6472791e5fc4f97d5a497","80d084ab212d4780a05edd44bf2af185","cfdcd5db761b440bbe28815d638d420e","5f386e960536494a828710fab715108b","57653ba9ae414fc3af97e1f3b3a85a87","02836952006a4c15b48bd35a8af4997d","fee12c2b401f474e9862666e6b155a5b","5970db2e031147b99cdccc893ea27699","21dc185fdd92494f86c75fd852536445","798c7f7a12ee4e3b9cb5c56d733365e1","c2730de4630741f58faead4e89a9ea1d","e90cc69a894b4e0993f9155b87ad4d7a","c8578d083b5542bb86460e77d48cb79c","a388251c4e9a4ae7acc69b3d3d7c1fa3","8787e3b5d901413699fb66d262f8e96f","1b04fe801cc84bd688022c441ed3dcaa","afc33062e9d44d73ae18a6f58b398e66","b09b7178a8b04f44b72a2fee453997f6","c805d48500c8403d87281fb87f3413b9","045e2b6a95084198a65c1669e8d45d18","835fa091307a4cf08749cf4ed34a1a62","a7bafa097e634332990157d989503baa","222b551df51b4b2c827e879108bc0ab9","cb7580717c8542bfa4b7e5e06fc3ac32","bcca4d0978044e0abed8d270391931d8","b93a07da97a44db9a1016546fbb541ac","2517101b631b47afb2e1df70f016b7b9","c285c812690d4c2582935bee7d651444","ca692f3479e840b0ae86c22b2cb7bb7a","101d4142cfd740b3a5933a16c13be655","2c985869dd914140853f78505ab5a20f","80358023abe343c096a4e39f830ad2b4","43def3fa66944a6c8a538cc89ab004b5","81218f13bc7f4678b19e16a1bdaf6334","5006242095f64fd89435aa27e6e77a6c","f4bfb24c9b544f76b4fc8c5c258837fa","9fb2e4cbad1f4808aa481e407112485d","7d4236bf238d48faba8d368d178a358f","5152ea6942a4453d993652a35d7cac91","4f02eae61d4748e3a7466c439f5b9fc8","5c40851a02f246b8beba5990cc72e6a5","150876705bc441d1b220fe29681362b6","dac5e379ca3a41b5a12d01ea3670a5df","033dba6d20174c7caa911642c3cfa36e","39b9a2be871b47df964116d4856b3825","c2f2558d66034f2291ae953db03dab07","8710835b294f43498f2e0d3cd31a46e1","4148616effa24059b23829a1f1a4ebc8","b0cc6309378b4cf78393cb660650a79d","c9a45d83e881472e9d12af4af3798f4d","af5e601e0b0442f8a9b25a36fb42e5d1","5356dd570b4844d6a0e159d13b773a0b","eae2fd44da854c7ea69fc80a4511ccc0","71b4af5355cd417db93e27cfdd44fc5b","2163afe8f43c406081339d05539eff6f","d087aea4cc824b13ae47c9f5eb873b96","a8a13c087116458a95372fd44d2acc02","bdcb6dc1ec0e4a37aed3999f7ed6ed13","bc6e5b859b504266964105883040a2e6","866e560c4fea4cd184c90c0aec311702","f8e4728c015447e9948c981d5d70f52a","fad0af71102c4fcea8861158e9fad982","3726f8365e154e7e8bb0419512f6c565","0032cd25bcc4441c94d8600ccbe4ec95","009f505db953424dab64e45e2fd11b87","f8b38ff1f00949e7bcf27ae41690d100","e2ba1e2f74b04244b51565b6242d8362","4d5fe74b7fa2461fb248e9f887cdfd2b","e0e2e0d152ea443c892731dd278f5f8e","d50989b4a78b47b58675c4c8738bc42e","d72c242d02104898a228f7b618b4f535","4693ca49b43e416086a64618b778582e","b6db94a0170d4edbb1204d57f307b156","3118288c9c3c405d909c6fe0f0f1b537","17f4a753295840a4889ab3aacc40abf6","ad24fe588813466d81fe28437e3c7b46","80a572ba365244d6957a16166d654039","4464f20c46cc4edbbe1ba0e8523d2e9d","55ee73838e8742c7acacab510f95522f","92922cf5627d430eb126e1a474898461","1dd2561f28c64ee2a4a3334499239b0a","b95eb01ea5fd4f5580864fff6d15c1d0","78fadae4bbf64f8c9a1e85cd2ff78dac","2ba996c48c9a489eaa92d1af3685696d","941c1d7df42c4b4ea4246ea996d3783a","b1ff4eca77314392aa1781adde6409da","c6f195f98497411f814cd560714578cf","57bc374282764a9da6527aa827ad0a93","30e7cbbc90eb444b863df446188a2263","e45d25b0bf474ebd94177fa40731e4b9","4db9913baa6049228e7d85ec1f6edb14","e47d479522df4ce3824e01cb6a7e3e3d","135665b916b342cdb25f888201a2c121","b10768aead744688958ea83226a25f35","82fffc9cdae34518a1fb0ae8ce49afd6","536fb1dafb9f41158991fa14fca126b0","f7a47c9828c44bddb796fa95b14a47eb","0c280d48f25f441391ff204b7d854b25","6da2812f2cc74a3a8b226acdcaec3c8f","4cea5ecc69fd43de93f2a55be02d4a13","a359c66b69e34232a094f24b600db54e","c0cefdcb28014d469c05efd5641a7eb9","13f7aa49b7144a2a8dda6174830cf69a","98b3e7ccaa2446e5918d5c4f3adcd609","f035dc27dddd45a9ab3885305ea6ce72","0aa46e9aa0a3403397939f05005c1145","0454e22cd2e14545ad1c2ceee7c36a1e","cd4a4d7564b34db9acbc80ea7e0f903f","6a46ae5d2888484eb79edaafa9140262","ac8a9ccbf9eb4d3dba5c3b80bfd4b2a0","21e656fb34a54fbda00a94dd57ffee30","6c85b9ff2cc94557a48286239ba2fa88","5fbc9003474b4e07a169361a97302e09","e465c35e83944cdc88a8721d7f21f78e","9f4c8c0dae6e49a09b9ff210047e3409","c9cac4aebc0341648fb4e37ae58264f2","213a02bee60444a69379a165af86f581","f497eaa73e2d4cdc93994f2a7a5a2c46","3457631848ef4329a7c8e742f2f7374b","abc0e4e7f71b42d8896b3b8f167b7fd1","ff7c1aa9f3c8460782c4189b40f89d2f","91e2376754a4462096d033572ae01bbb","cdbc9a2a7b104c25b04242752439e30f","54650eed46f44060909f946f7c62b3fe","14b4a9f758074bfdb1ecc92444c3725c","2af69974a0bc4c9ebc6dd6cc2e26b346","da5a39ec23b743a7a60e76a1dfc1a061","a9f872aaee4443cab7caa3df396e5913","ff8e8144486a47268025702b16c1684a","5f8abe8583934f3bac5e09dcaa122048","2103e1fee0614250a9e95cab98145191","68d2ffaf6a6749ad9163b5f030d59cf5","b78ecbfbfb104f73a873d0a532749e9d","86a20342ec764285acbf9d1e8bf1dc97","7f56a418f4bc466aabc90e40acd5504c","998ecec7fb264af88327062bc5d8dec5","e2128ef258b047b4b1c0b0c9d4175c56","5bb7a34e848a41ff8cab5d461b343ec4","831612d6c26b4e619da5710b15d4446a","59d7e95864d74298bfe0b6d839d97293","416c0bd420704adf9c0c9e5b6588f045","aa9f107bd7f0476da8a183d48ec50955","9309edcd1dd749d9b52eed784a4c1a92","6f45a1b26c054035bb5c380816128569","a759e94f880042df9da18c200ae6fa24","f87b34870e394258820ccbe5ce0f6c94","fb4ffda524c742e3a9c2a5ca7d747774","855a506b875a4b42b77b11dd5f735d05","e3c01968e08e4f25b452cb68beec6a63","d732738847484c9ab021fe125d3c0412","4d19099c7bd14c568338aaf9336bbbe4","ddc778c594a14ca197291c7e21473254","10a5354729e649478cba7509b491ac3e","dc176b91d3fd4994bbe121bf4ad1b7d1","11b2cc77995647e299e5743e499cd928","f830102cec514dd2b4e14b5226ba78ab","8d7f43341d0241cfbb3574700a401fe0","a397d1b7b0794f5ca42118f820f87f62","b00cc570e3324bb78de8c667b17e4d99","4e60d9e4e1e040d681df473f93de7160","35adcdac7e39424eb2ff134786b17c55","358a08b80b8c4a839e55ece444853148","d61df26ac6ac48d2ad8c9acb15a2d144","07119d766530498a89d0303e30e5c41d","eeb283d4e1bc49a89b82dfb2d3167d7b","69538225963c434aadb63d9fdf378e7a","195fccfd14d543818676174ca912fac4","2e45df918ebd4728b152a7d8ea5ee425","cf1590cdb997403c8e379653a80847b3","580ca19e72e04758bdf8dec6341c8673","7e5575ce3a564be4bb606f17f4bdfd3e","96b30ddccdb24c79afdc19bb80869efd","92f2af15f0174c21b2f4b1bae5bb7870","f5be3d984f424192ba385ea172f640bf","2e7cd9aca96f46cb9d2c3e508bbd8a48","9db33a180bb14a8eac486e28e428a2b7","fc5a34c076dc41cca2b819774395e807","ee043893a91841d8922c304d106f178b","31fde0bd3cb44a2ea55e8558fca6ea5d","9ed53489734444c690def02151f6d0bc","08b636f96030495a92e0c18e5dbb4906","33391d9949964b7092c72f9fb88eacd9","e3f735721f4b4f6e9ccd82c3292b2ae2","b9f01ba2986749d5b3b1619f736d8b03","25c0d7f999db4ce88947f3eab89fa0ab","87f99b2e890d4053b47b064ae110050c","48721e3c6c82426f935cfa5366afb423","50287a5e50c04143bd8ab8757856bd09","9c5666eeaa1245d998147c8159d729b6","dc60d653f8e74cc2ae5a5a66e82e9f06","1da779c9f40a4fa19265fbe010a17445","7e04c57039fb4423957d82b45289c869","7f60832b762c46eaab2b39f71e65709a","ae2a902273c84b15ba4cc2feee625ee6","52197e33555348c1b31d0d7f98c53b33","0a064eb6c5524fa6b49a33d9a4f3b274","c5c8f54c7f214dd3bf1f9472bd27f5f5","5e46e4e97cf044a39ea9a7f4813020ad","f3ccf0f0fc2f43e997315bb983d41e6a","381db2e3eb6d4e50bf0226d8c322edda","de2f775e2a904f9491f41746741d470e","59bd73f74a924651a58affcd49b4713d","9c0df71c6fa84ac79f369252c5513633","75cfe95385cc47acaabc001048e21977","9530b22a45074b6cadf20c3cda69b338","6b6855546ca4418992af41b3c244250d","7348ce0cea9c4044b362e32c5f21e08b","3c2867e50f8e491dac7c7cc6745faaff","facb983e185f4d8a9414c10e5d10d065","0aeabd212650407abd2de32baf4fbb39","586d57997ed04e05b1eef13a4ff088cd","93eaf8650c6147d0817cad94746213e0","4e54e63b449446b18db518c1652151c4","1494017b65f64c05aa7eb64c1652e2ba","cfdee12bd79840c9ad7df8b345ae2963","d5ce996bd30d40ac92fdbd8d32b16cce","38f3532d36bc4f4b8a54264adbb7292e","25a462020a634c25a7d391f995aaa611","072d9c87d6014117a634e3d6b1977d15","9212e86583a246ab8f2ba78aa929a7db","e17b444049ae44a7820bf3944985cf71","d1eab643a3654cb69e5ead2017d43496","314db16cae9440e2b14ee430179daef4","aabdc8656b5a4b4f955c50251439e59c","5f186e623a78432cb5fa1932c3896700","4cd6ad36a3b4408fa3d027b484ee06e7","d64fe3e507ec4ea8be5f22b07aa2b08d","8ad04b8f8cfa49ce93dbbdfd31ff569e","c7d40adafb124f6f88fd6d2cb248b87b","cbb22190e2b84094aeb2caabd281844a","e36c0240f7b84833abe206ec861f8c9f","296e0800d26f4252a94567fe7396b0c0","46aafa0be1044e23b5218b6c201854a9","3fc359d79c7048df837ac874329bed44","b518a2837f084f42b47ab6cade347e98","36458764667d4454b4fe5430b859fff7","563f54a9020e4addab65289bde8dd8e7","1a68b53fe08947ed8a76724951aabeee","1bc7993b70e94e718718db8151e353e2","21cbeb569f3243c0a3b0624be4a3768e","ba6d8377174d44089ae1a7fc49426904","f5977ee5ed934d81a0210322373f4dfd","6b8e6d8e70694db297d7fb336f249140","8e53d0f3c2824459b6de716fe3df1f07","e24d44e037934c829c0f3d56bb1a9c46","cac84cc9ba1845ab95f499997b446522","0122b207005d42a18e8b1fef2194b905","f40d9443163f49e789a0004991de1662","9237c97f66b3402bb1f9cc8a7554768a","136aebad3ec74eb79787650a25225758","06fa7bada83043f08c3af520e4ec6835","23698d8f980d4bf0a9b63460e90537f2","18d942b5acf04b2e9d2cebbe49561b9e","8eba4c057865466eb61ef67a21610a90","6a70743e69d64bf887e758f89ff03522","60b2ce894c904dda932980b884b29485","d073c051adff42bba00c63979e48e610","f86e6dd437d04e0bbfa8224619d582ff","1143a652a95d40089e86d18a5e797557","3b3c66493e594634bbc988feee1aa34e","82111cfc670241de8f0fb43d276c5c86","8130136eba684ddc93cd9c923df72d4b","e10ef4274f194b03a380facd44efe57a","f60af430525f424b91cd5983696798b0","a42f225e928a4e179a599366fe065718","5110c26b2fbc46c7a987f01d87155dc8","faa476f3d5d84194afa19533d073d201","f27835b54e1445df8eaaa971e3fcd0a1","8640fe9c1e6b441b8e33ce7b0c54371f","41b2be32d9464640befc183de504a135","ee5f07b30c8f48dda7a5ff27df6cc939","d3b39d25964147389ff0318de58d1d5e","c5deed3a4eeb49c79b9bc903ac5cc3b1","b73fa00ab1904cc787d097c5ad1dc876","cbe939eca3ee4433bb0d02ecadbfc38d","6e81af863021473ba78e0598f0a5f0ba","9ed7ba21263c4c58b974770427c7c0fd","2c771c99a477461bb8b1001dac6988b5","6da3c7f3150a4290bf261394540dcf47","a4ed494da6c844fdbd8d5e00387c85ef","8fc6e7fc760642eb8ba8989c734a4ff5","83644d36a1e949ebbe8c80dba5aa9311","b44023a1c31047a1b4fab8961d55e0e1","ccb98c9ed70d446c8148ff574789d9a0","ecaacec3ef9143e28ce74b3c26f1a6a5","de3df124721b49e7ad603308de2f95e0","dd8b41d4db13456d827e51aff522bcc9","13b80338daf845d6a3d42b0ebb17a332","297bafca5f344c2da179ef53caae53d3","25f9f6ad4b7647d693612fff3cb1221e","d0e68b794d69439caae92e425ef09a0f","8cf04158a7884a5884fe360c7ea58528","b60c085fc7c347cd8b8406f34fa6603c","4847e0e7c1924f5bbd946c90b3b9b2fa","369f2091a11645d0847343faba362ed3","f0cd8669fd7042a6bf86bd77ab4b4511","66d6d8b8695e4db6b847043acdcb26a1","5b83cf999e4f44cf9d3582610cad5dc2","b0f9fb069a3b4a9cb5c18b27feb42973","4e621f77485a468f99ee9ae18b95e1e0","f02f8725ad954db0a1a1d4a98246e3cf","2c150d2eb84e4bd8928f47cd853027a5","c262daceb5834d6ab400b6084299858c","99235966179e42e291909f1a6441bfac","909b390a13e84d2199f6c20462d7184b","dcc703ddcbb64121a959856b4e223f08","ff20b55ec7cf444fb14099376ed5bf1e","7956c60efcdc4fb58b9a749e03e5e7ed","82014b3323ef4b43b265fb3eadf6f32e","9e85fb466ba041569a36a54c36c153fc","bee96107a97e4053b92dc0ac9dab30b4","17f00e84b7fd46dd963e5528d9f829e7","ff492de90ee14d6b942fe1026dd5725a","f293eb32f5774ff693950e7304458491","4e0a9ef0e17948489d001a4645baa101","e6cb73530c0d46fd82d1176fcc2ac83f","675eeef8efdf4331842ee9c2d651b8ab","9aafd31426a34af59431e46355cbbe0b","4dc1a78fadb94703a5537c8f1ea5f5df","253eb4eee4e04606bf25ff00a6a2025d","bc45473b4a7b4a3495a3b9f8455ae314","90faa1a65dfa4d9d80bf4c70da4c031c","f407a4499f3140f0b27ba3647f2122cb","38f2aefd4ed842639fc08b00ce15a978","fd0dfe7f66884867b2682e49a212c504","8ae4f885df9b47dcb7f9963a2cc97402","7b8e77e7c5c4419db1d1e152caecfdf3","190d5e549ed74ce9ab5cbafa8a040d05","91e983bad51a4041be94b65badf26c6a","a0d01af739e94d55a66a8500956d2520","f478af4c41a84f2a93865dd6c9e0d709","9faaf981dd13431a8f2daa327555b08b","f13875b4162a40819ba83b571efc5f64","b337cf21dcfc45e29cfd7deea1490ec6","74aef966e9464c77bc5a0dd6733da99e","99397fe2e0e24079ab64af8c35949a37","23a8a7180c724fd19b04534406955536","de2e1715723a4fd98502560cd385b1c9","53bddf7d2ad1416eaf37686f8bb15da5","75b91e301b9d47258d8d7354f0cdd6ea","96a9c1c9c0364607a21c47daea20d583","ec9ac5be655743ecba40eea3d7422987","ab7d527956704cc1a136c41f736c4f03","78c32ae20969485ba8df93cc38816a4c","666ec0db5a57437a87d76142f0721115","4349b540e3e44821bd964b625f22e7c6","e4f6874348eb424696d3ed889fa49e83","f6777df9d8b846719a3c5d0cd880ee32","f74bbaeba8534f6bbdd6aa5fa31fbb50","aec6c8c48b534c73851c56a4ae1b5466","aa87b632861e435a97d38fadfc010193","eaf5b80144c64c4abcf376ba56815a0d","51937659928147a0945709c7d4d691d5","6533ee6a3b1a4e03b51e7d55b9ac72c3","67bbe6c81665405e97de9728a76f6676","d51b8d504d8f4572af5b595628fd423e","3dfd6af94e5441ea998b4f0ef122653b","c5273fa5a5c7489b91f1dcde1d4ecae0","3c1343130f964dd0b2e6f21a6a2ab37b","94098070e2724fd882ef9493df6dfe82","2dd30133d1114d80b6d4def9dbfd992d","959dd00925394a58b12260880aedd1b1","3a8fd820f3f94a09ae269d00ce8b2b5f","6d8ae762c9ee4989afb65a2ed506372e","bbab89595b1f4cba8a5ea1319a3ea0a9","73ceb15dc1234a3bbfad5d519c5255eb","4448e9c64aef4096afb921185bd1044c","04695caecf8b4590bb9f5e296524ddc9","a01531e024f24bd78e85614266ba3ba1","92137f93800b4ed99e9d729bccdf9023","1e7b3a2fd1e1473fa03cd431d96e2add","27832513f241405886d402fc0667c6c7","56fc7f11e4b94f479808ae825f9b6338","1d2bc9665877484a9aabc2f6f7ae925d","1415494b1fcc482a9c33bd9ab86e6d22","fb753fd000af42dfbec21c3b62d188f7","74b01f230af44d8eb0d945d8ac7a376d","cb81c664d2d04cc58f76d52b692ac022","9f62235019fc454d98b3d21676408c61","364b650589534e659c5396b7a17c327f","fa5e20582ae9445385646570ba5ae045","de0d200af4a64b42a8d87853bc3df795","bc9d133deff34f708a760e92e8b666a9","84f3970823a54a06b33df01ffbb9dfec","d5b6ebf02be14ab5a8a387aa13df3c7b","028b7f36c89347e180d97b76320ef43a","9ba657966c81483f9916193fe447cc3e","a6621b45cce44ffdbdd694fe1be53398","f9622981c64b4f4db1d535110187456b","1500a80501bb40c8a29908cf092b013b","db59cd3aacf648a6adf56c0f8d071a06","ffd7494d127b4eb099de4574259d5e2e","fbc66d6a38c04a519096a7e3384e2810","b801dc85d29a4bc9a232e86b6f545ffc","f5d7910796f346d09013d0c8c211a6c4","2ec0cc6bbbaa4d82b6bdd36913d043c2","e22cea7ea4d54357b185998775568de4","bc6dcd91d15c4d50baa11196ea0c3c34","f5baa4bddfdb40ac9e58e9496b4e1a02","1034b6051a8a4ad59cff5446fc1e6b64","db2d59ffae5e45af856a6c9d86f58106","f8e859b2664a47979317f30651c978b4","dfa61a1873d24c1aa7089a16b30bb48c","0eb4efaa5bb043d98b5938823ce6e561","b723fadcc50743e19f7e67f09705b89b","dfae425162094983b684ec084fa040fd","dd4fae91f5394fb19e7b57a171d4220a","d7f4fc124a884ae39911c4630c6e4a3f","bb3aba9914584b2bb9ba6d33093fd130","5f730f91d05d4e479f7fdc73904d8b49","5650d8b47f974ed1a0f21ea8c99f7856","b8bed01f4acd4e26a63263c62a36bc07","bccf1ebdf9c04ac1821acae0738a2657","b637535797a24c359eb2b5daa8b8669a","d9cb3169b49e4af3be856c0e18c3df41","012695287f344912b35bf73f3a362a04","257a0a5db21242599cf87c3e04ce9e0d","fe64aac2c4264b93a7f9f64ec10a02b7","8ae724ad00e24addb4576eb81d5676f5","f6961fd343ac40c0b9a3966bcdd3c5a7","1658fec61b744ee985bc2eacec8c6225","69d322ff34064b919ee977e07a9c03a2","776cb9b21b3c493490e1e79efc86dbed","63dbb284e0cd4e47aad78b32ca0c32f7","458ccb4664f441fb8862af48ce2a6d07","cf2a9f431bd74f7fb5e8614c1496ec05","cc9b8c99b84c472ab30c6dc1e709957b","4c18f9d086af47188078f3ec7e2fcb5c","991bb8df6a554774ab2615eb13b6c4c3","c00e3006aaa044baba2d5ffe81ce7556","3cdebc6ac70b487187da76d8c17b56f2","1cebf578ac8e459185b2f836a1819b51","0524b78bc3ee4316bfcfd4ab1b60e015","56395cfe0a1e415e9e9be34752d80ac4","6e66248891184ca180f1529b85f8b480","c55da4ca4f114023ab19621601045e94","13bbcb32c8b945e0b5e9eb7aa97d8696","cce1a9b6e3174c88b03272d40875d802","401403228b7e44f6b94f5bb2f313a791","9a0a576050ad4c7caabb66698f019ffa","36ef27cf276c4d068ee181e09cd186d3","f63955c0fa044973b526fefcf0fed4db","5bd55e3917e442c6be9bb0e0067578a0","a89fe53070a042808a500171c9b5fa30","1340905265814d7d9cc764d5f8a95211","a08ffd11232140e18ed7f6fe6cedd62e","ae9560a316fc4407a71de627490c63d3","54c9e9d6a16845a387a5203c05c02dba","6999335bc32a469d92d7ec8b7fc4b694","028f4ffd115e493498b34e4c63c55506","7d852835b8bf4293b6975bdad190e281","669a4f83cff44eb6a1098fb78fab81ac","63d1056ef5ea47bba80b45af16cf22e1","229b1ba226f74102871157965834b407","a5fef24112a544f2828dbc024a645553","b643a642f1624404a86714ab90071069","090c494ca1f94e0698d6d08e985a6bf3","cca28d432a8b494d8b285f12ea3ccb20","58e8550bc1714fb984344ca35cfa459a","3fd0d8b29c454ce6b467253793534728","b5383b8c4b48442899ad1fa681d21aca","e066e2e2823a472fb398f9055a2fe2f1","f80398ea607a48cd9011cdf3901a9e92","91540f92b6da49bba1d3868b35bf2b3c","9996ea2beb9248c6bcdebcc44f10d5f2","dc0fe4ee08e345eaab68205e7a145529","ca4e710eb1054a0981d4755b271f408e","80cf46da811a4fa3b56f94f34082cf26","250e5146a9be4f68962ceb1fce539229","c09dc3208f0346d8afb883552101b3da","ecfed519751648c192fb1584eba9c610","3ac0159d06ef4c879edccfff28e586c3","028c019d76764cffa5e1d29600915730","fe3dfd2ae8ed4f759ec79af37b3ea215","310e3c74639b4597ac558c937117682f","7798501f51a445a5a2fc67a7bec913b3","720c713762504ad4aea35ddbd6b65965","f3c04a98e57b4aabb50d4c86c9dc35df","6e14416ddb4f4eb999adf5aeee0b522c","117804ca1ab349be8131aaa10ae4fc3c","f61ce0d0e5994b7fbf8238086a71e097","cdf3d2bb6d4c4ff187b488eb6434876f","3c82ff2ff8a14790a45fa9bd14f023a5","3f7b7f9dfa5846babf2aed2dbeb49e73","08f80a25b8d04692976b84dc0538b52e","f7b14d9b605e4e9c9b3958287daf3ace","6251bdd958df4778be700a65b6a3ee87","391da880ac8946ceaafa3341386ae8f3","3c08b31beae743558c91600cd3995e37","fc38b0ece5514877ac81650a6dbf26c2","3972f7b079904d218350ac9b3363a6e0","c9589583baac407fb032a526f28375d6","c9cb8c94f9c246a78e9fe36bf1db591b","3b4f671e9e0b45918242d45086bbd608","d981d7d0150d4fa89b8e9cfaa631eaaa","697c6419ea0843cb93b28432ab825406","0a8f7c6176764ab08ace8f3dc1d11183","4bcd126bfa9941ef93df451ed7bf235f","e36a6305d398425aaaf0dcc4d0277cb3","8c26e3ddf52f4862a345c1afb1b2f903","05700be32679479e8b109e265b297426","bbf34cdf007d46a1923c06d6192b38a9","a7199140a6084038ba9a4468176e6106","db29f5dd40f94ee5be89b21d3c742854","59df51070e514b2f98c5314943240807","1fbe7efa01234f13b100467b172b573b","162e3e0f5d9f4a109012241aa38b429b","5d46e384b67c449f8775c1150d8074e4","94e1655664a54ad4a97c800fb3556b2b","4d929b7c83084ecaa062ff309a6a9505","3bdf808e77104e3bb54d5088642cac8e","2385c08b047c47ccb51b3dad007f21c4","effed6ad1d8440718aafab41f1c67509","5f2082e7f704412ea280ccffbfda87b9","67e9cf5b24a84f22b3281dc5c2dcdc54","b9cc6c8b00244d6e8faf518049aea16e","fb0a5d24d7364df8b609a7de47d6de1f","dd091ed8059a46a58e09389a43763ec7","d4ea71fa9b224b72a231a6d5ffac1788","f281cd80ed3a4f2a8eb9166508f8339e","037d738ded7f42d081c3e7cb430fd064","bae69315e9104a4f858939492ee7f6c2","5fd4e433ef7d433f8e44348a35b895f8","74c7859c8f8e4dd58d13171139d85f8f","9ffb6dca25794cbc99de10c5ed399a55","8b98433a62614a5795f3b221a31944cf","d12b2f4b031b4402b22b60a022e2dc41","9fc0e3ff447a4edbba6a43a546253f0b","ebec484288764afbb99b58fe1113653d","ecfe0861a13e4ea8abd05f24231b8d44","5ce09e7219b84b0cba539b9bfc52fa71","35a75e67950747a4a561a04c685f08c2","03145538866e4d3d829637053426e32d","f26d6262cf744082ad4c03ade9859b8b","9840ce4263f94411b44ae8c5687dd476","a5309f11bbc1407a860e29caf0265adc","bcbc616b31b943e79ffe882754044da7","f476e48433d74726acd1f79c93ef7d8c","f2fdb5661b6648579de5e3847a89ba72","f95fe9144f8a42e4a1f0e9d49b06f8df","d53c12a30a0741f9985678bb743ad28c","571276a6352d4f58a6f35ce7cbe47ff5","f29a790e36664f36adca36a1a837b0cc","fbcfcc4200af40de8843f52f463733df","a359e578a99f415095658e2841372bc4","b7ce6c9279e94656b0075e5347fbce6c","ae9a7da999d94cffad55634e37d6433c","ff38963aa93a4ecb9054e49a4c5c7582","388fdf2aa05f458dbb38256502296111","2e18d29497184c6698c146963cafb2fc","eda84f7ec2e64027a28e8bb335a58f00","5630ef14214947f6b6375592887a9814","76c00ccb2e2f40b6b7e126beb81aa175","f3db0894f5dd4eeeb8c9cf923df50a4c","2e404fd3e7e94708816afe3e3ae96fd7","4c270c97c38d4a278763b775e4196dc6","c6d0917346064059923a45f1fb95186a","349a6b212cc846c797ca11dcf1e13700","95446967941546e98e405b91663c708e","89b2a7e959ef44a897165dc9bf98e043","cdc7436ed8b74a1e9d9abfbed12117f9","81fd5ec160da4ca9847a2c61a5ac1d47","1e943fbaae2149058e3d430299211706","b1082653ce9243408b35c0b614d4c719","ec56f27ed7b14767974cb1cab5ad9f93","31067398f0564b32b111a2568545188f","3b1c542d711a4bb79c1908e11523d0f7","1c2400e6ad50470c883dc3647c306f87","9d45a9dc289c4caea17b4b2571eb0eff","2a6970c9aba641348390f726172c37e0","72d785321af34bbfb8d62adc125b3d87","c85d884efb264965ac490a68100694f8","9f4db2ed87684ae8bf411eb6bff4b99d","316adf58d19f45569143df31fb3b50f1","ed70cd4d511940c4bafd3a8ad0759b20","e7acc69c9a494cc593e1aac5e47337a8","d4d63c399a274f078e7367e4e5bc4f76","26779c763f364353b0462b1d5e23ecd1","e219e73cb53b4263b895fd4a3176c8d6","34ef1fb549d949dc86baad2bf1261ff3","55f75050f94841dda061bf492f8dcf7a","817808dd31134ae38209c6273c58e746","ee0c602f83e74dbd87b2cdba5149202c","5569dc9f7fa84dbcb36d6e6cd3bdc71a","022cf591a51d4287bb05161489d6aa36","b951e70b93444f3496bd3710c1aceea3","fe7fae7fe6df4ea293023254449ac79f","9e8b7a6acf684e069a65de1a44b18c56","32502230f5fe4e8ca8e71257a49e38e7","f706d080bfea4add875802d2d3d90c97","370a414b6d9349b4a5f52fc68148ddf6","44addfabf755467e9cc08ffefae310d3","57b69293d7a242f5873c8bf2f84a9c07","e3e846aeacec44faa35d2143161e0fe7","cf2a2fb4642f465eae78e3733f022590","1ece4dc3a039459cb1581f1629340e08","285791d9d32847879394aa457c3acf5a","3ff14f5cd4ae4e42926e3cef073ad64f","68f7d7051b214e219646b3ceee4483a9","fc68d695c8874cb99ccb6303ac0d28c9","44f11828888a4008be7c54b9bd63a5eb","c5f918262fbc4b9d83bf6541a1f266ba","03d64b143040400c99fdc145d4ccbe67","0a28fe8fae96492fb3eefdad23c354d7","169366fda41e49599ad78431332ab8eb","2e47ecc865dc465292ed090376b8040f","941663eded2845f39af788a69a496073","0166755b4b7f4bbba8525bf50b66d09d","66d4cf4b3723407db7aaf2bf81be6ffd","f9a03c1d15a9486b8bc7fc643dae8865","094827a9aad94eada2f991cada9a2574","d70b1ded29534602aee04c4d3f947001","76633b1b689a45fda0dce7546f0b5d35","73763c3edcf448caa5fc2b7a78104571","7f6c99954aba436b946e8032e1baa6ea","d9876890f3c64c2dbe667909b8899f9e","856878c30c064523af1b1e1d2d453a36","c13328c79f7e42dda63aa08a867d4451","7faefb7637a04a8ebb0625f87631e4ec","2bfa692ea15844b98c0520ca0653b3c0","c0f4b975cecb4a1e9769766b26f98261","8e5811b56fa747f9982ff1fe90781bbb","5617ea3cb4014757b611757d4852e258","cb8b84024b27443a976d6378d799f0ba","e6f0c559b603408386ad5bd2891b8cf0","9ea149fbdc004aa286bc392404667a84","efd7ff5250e04ad3a6a2cc6b88b4add5","5c6362f67a154b3e8bf56dc2cf219b22","e25e62cafe8f477e9692c1f7bcc50a39","c55b85fec4dd47faae3b4dd95e5c40ca","bb9fd2cb05194245b2597ab1fb50e463","030873c0e5bb451989a261cfb76f343f","e53f2026df2d4736bc9b45ee33436fc0","acbf4845ae10419e90c477501e93a8a7","ff2fe2912452428dba06cbbae43fa1d8","4bbdfb0d81fd4b258fa2b5b7de207c23","cceeead0148244a28edbd9a7c4497df7","64c47e7a59d5454c844e8454dd865d6f","765552dd8a924931aaa5012f2827a50d","7a80c9da3a404dd981fa15a5c6369b0d","767632fc7ae348c6bdb95e4f3c18f7e6","2d6020218bf543168bf8f8480822fa93","e89405ace2c44c8b8c51b131f5f17908","cc27813e2dff498b9d26c331d9c074fb","181cdd5e6eaa4f90b2e15bd21112cb92","e49c33cc6567471a8461edc2b78e1588","3f5ceb724c4449f488aeba356ee72715","06abb65de6cb4b5daf324d8edb260ef6","f589fa71b21145149d7c82151e04ce38","dfb50adf812140709394faee0b438589","771c2c3c62f2439e851542e0d1b505a9","f815f1c9eabd4671b69cefbce297c99b","7654b26fc6a249eebd0b8b3ebadebc52","0191d9b5211444fa8cad721270b0b54d","2fdb4f5368ee4d088da77527cbe5b06f","872570368ce74214bdb57557b13fc915","66585f1e98eb4d71a3914ad3e175fd06","e7c528251a194bb69b61a73a5b4eeba5","bf672e1099404a38af7b1eb66ca3c0d7","0be58dd37e9d46f485964659de0e6b48","590d009de52a48cc9673a6a2e00aced8","df4483c5d2924518b228186e7bf844a6","7dc91e6213a04436974ac8102e4a6263","e7186ec776174613ab73fada27d4d076","59f4fddd66f948ac98d4c6530f830864","058633dd60ea4f76948317b7c2fcd32e","371880989f5742d4a2faffcfc36fe83b","5d3085dcdafe47c9aee23df53a6c2b1a","efaeadf50a824012a697f74f0b1d8b88","4764edd9ef644210948fcf1a2f24acbe","d1d56f3273eb4f60a114a53b4578200a","9ccdbccc0c9841ffb1ef0a099433b66c","ee3f23e2cb1343468bd87aca48d8f901","dd9ada9335ee4c2894c2e377f7b363ae","8a977d61470a448a8b1c8de6da64aad6","3e7338e2253347a4bdbf917d11203f6d","ac2883457dc34398974398cd8aa7ae28","b79f3ca27ef84de3a2d54831b9f9946f","4c196a9a279e4765ad3281f3b21fa693","c0ff88f8518f466198a67f4d63f5aede","9d8c98d05a58404db8cfe46dfec32d70","d7aaedc5aded45b88f949c5ff995ccf9","70f84d799b514bbfb3aa64d6853aed13","853333ea86414bb99912556e86857596","4e355540780a409a9c6c5bda8e235893","03edb7f1c34e4d898e3503aeedf74a24","0c53416c4e2a423d98e52cfd76b88cd1","93517525ce2d4e1db27d2513a0addcb9","20615db287b94c3e8c2e6a9c0c23a554","359a25a838744533940a36f520098ba3","28380dcf513549d486886d607257fe35","710e63926fb74266ade104c63ef58e94","c5865ffee5d544b6b5a349b51e6cb3c0","c4305ec5a3a3473d84d24addae866c84","c46aee66ae5741789a3ed634f9e1dc2f","e06a23bddf014a1b989afce5127f69ad","89997fa88c7a40a8bfca1f8b9afffcfc","68cf079c02ee4a869a01b1bb210f5de6","931d34fccb224a5998c1ed41cefa4cf6","590495d12907460faed6c26bff0b80c7","e4f01c14983e477b9f4b8dcef6e69030","5c869bdd8f5340b2bd19639b1100de2c","1726260336c545c0a69236409817f058","b7312e6135d04bea8bc50c451f01363d","6420643e44234105a449182370c6b79d","ade157da0a33484d966a3fd576d831f1","389118ac1d884c778d9107658d1bf281","65d54ffa85ed41378ad8a7960cafda03","5ebc21c096b342cfbbfda7b1a9c94bda","7200925e79964b119c8fc6b8610f3362","97d2050c88b04640802a964661f7c324","26dad6a699b14e00a0f2726fe93158f8","9271372a449e40afa800760d47626991","557ca72213104c98b8f99d6a4be94b19","3a62841f7af94709a60414647a2ca9d5","03f49210e70044c7a1b1345571e8e13d"};
        Map<String,String> err_inp_reqIDMap = new HashMap<>(err_inp_reqIDs.length);
        for (String tmp1 :err_inp_reqIDs){
            err_inp_reqIDMap.put(tmp1,"err_inp");
        }
        System.out.println("err_inp_reqIDMap大小:"+err_inp_reqIDMap.size());

        //A1
        String[] err_log_reqIDs = {"986af677071e4f0aa8763688e02e6e81","c305c77631d34ad78db6a2fdae01520e"};
        //D2
        //String[] err_log_reqIDs = {"57844b269b6649fe9a5e158cd5c97c10","40d9f1a6f26743cda30c2c87ce355481","43c54d432e744619bc96ec590686109d","3515fdadf6ff4d6b807e37d662fe3c87","56985b6b687749b3ba10285d432212a7","ab79eff039974529b2ceb13f2987866b","8aa294edf7cd478591f4b18e6ba8efec","4fb182a5b6e649daa7641b2b233ae5f3","60f333676c4e447996967cc2b1e3a616","f1c1b185a8a0411aa037392aeba6d923","eafc3e242ee340ce824c1fc545241a9b","2398fe0bee7a41d1b10d9fd785321ff6","3a02163e803943309fd96bddc8731563","b3ea444f9c544259b6d90da0ac267986","2786e5abf6574aa48ce0224a3f7bb824","79e28b553abf46f6bf775de17010ef75","f0ef0862f741420fa6b5c8d89742279a","94e8d2a385ef43f38873c0a1e48cb214","7b1e9cd00ec14d588bbb31b181f14ab2","c0e5447f89ed4c1e926e6e4fae14951a","f5ab717d367049ac84e45446d1014f45","4d29bc60a9184d0f8712d0916ce748f9","743e704157b94deca6be0e015917a3a8","36d405b5be7c45329d6f59480de6ec4e","3c74bef561d34d4ca5927fefa165780d","e6ea83a66b7146dda9d24ef081c85a96","abd01441db1c4ffbae8ee9707b387f91","1393c0bbfb2b4a26ac04ccdf55cefc22","ca3817b2c9e645bea7d37834fc2aafed","414c0289bb2e41e0970b734f941640b4","cc4834ccd5e746008610f4468c0ffd08","857e13f3ecdb47ca8b913f550c7a2321","9058bc0fb8994e5bbdb5f927babfcf12","bbb27fe1440046179e77823791947eae","fc99cb58b0dc4d4d815b6e13e312412e","5b4e52f6686049f7b90d9074a9fd405c","8466d6558cbf4c3d8d62f0cc4de708f1","a4da148e6cb24ba28728c8fb0d0d0189","7c1d74da6b9e4d0d859d988683b455b0","2ac66e9f833a488b99203d988047c166","5785e78a79b143ee9d3c84e6f3f974a6","9b895385499747d0aa5302afdd04668d","04352b76815748febd5c1a2828f70ad6","2052f2ff465646d2bc84c91eaf104163","e769c9ecd53840aeab6b1c443ffc4375","61e5de3ba4b4449d98f717bc986e6058","9332995c4dfe4c62bb9dc4a8fe8c3cba","aee37ffa58a4460ca9262e7806c27cd0","0d12336183214614b912458a6d682a57","fe228f2899684da1a5b6c5ac3e3b4833","31f40f0f16ac4739baab13435c4991fc","4c0563a7d515485aa8ab8f0109c54384","d39f976494d744cd8450632972670507","3dbdd147e36140a6856c663c1a46f2dd","5ee5d7b3fb244b8bb3a1c16974673915","aef36f5964cf413595e53e2474301b6f","98bd1e20ec904460810a4cf62cea7c48","2b7514f450bc48f39969d0940b1cde4a","99c77303a2894f0b94710e72b12c568e","44d4d70cb3134b1e96df96dd5f64816f","96e3dff5ab764291988f962ca29b5deb","16693f15ca6b401dbc2607837ff9dd20","6b026e988b704e89a9d2144a7f43bd34","167fe6b806dd438389e4142f83bf4df7","7d0528a3b3b14a98b300b94bff121248","c49fd988b60b4548b1b2cf65c912eeb2","80bdbdc03cb14aecbe3f26a02ee479ce","c9a7d146fc0444299ff617b97fc32b93","2ee035da88904a7caf5e5236ac741add","348390596c2c415b91766bcaa98266d3","ae963fbad8e54bf0b20e59be24e91665","492ccc1de1114529bf67c63dd766ed3c"};
        Map<String,String> err_log_reqIDMap = new HashMap<>(err_log_reqIDs.length);
        for (String tmp2 : err_log_reqIDs){
            err_log_reqIDMap.put(tmp2,"err_log");
        }
        System.out.println("err_log_reqIDMap大小:"+err_log_reqIDMap.size());
        //---------------------------------------------------------------


        List<String> lineList = ReadOrWriteTxt.readTxtList("D:\\用户目录\\Downloads\\生产数据\\lhp_A1_20170209_20191025_01.txt");
        System.out.println("lineList:"+lineList.size());
        String fileName = "D:\\用户目录\\Downloads\\生产数据\\new_lhp_A1_20170209_20191025_01.txt";


        for(int i=0;i<lineList.size();i++){
            int flag = 0;
            String str = lineList.get(i);
            if(str.length() < 30 ){//#applyInfo   #singleLoanAccountInfo
                continue;
            }
            JSONObject jsonObj= JSONObject.parseObject(str);
            String id = jsonObj.getString("reqID");

            if(err_inp_reqIDMap.containsKey(id)){
                jsonObj.put("emailAddress",null);
                writeLog(id+" Set emailAddress null.");
                flag++;
            }

            if(err_log_reqIDMap.containsKey(id)){
                err_log_reqIDMap.remove(id);
                writeLog(id+" Set remove.");
                flag++;

                if(flag>=2){
                    writeLog("发现两个错误类别都存在:"+id);
                }

                continue;
            }

            try {

                FileUtils.write(new File(fileName), jsonObj.toJSONString()+"\r\n", "UTF-8", true);
            } catch (IOException e) {
                System.err.println("build data,"+e);
            }

        }
        System.err.println("build data finTechAgencyBusiness end.");
    }

    public static void buildD2_inputerror() {
        List<String> ok_data_json = ReadOrWriteTxt.readTxtList("D:\\用户目录\\Downloads\\A1D2_M\\build_D2_01_M.txt");
        Map<String,String> ok_data_Map = new HashMap<>(ok_data_json.size());
        for(int i=0; i<ok_data_json.size(); i++){
            JSONObject jsonObj= JSONObject.parseObject(ok_data_json.get(i));
            JSONObject business = jsonObj.getJSONObject("finTechAgencyBusiness");
            ok_data_Map.put(business.getString("orderID"),jsonObj.toJSONString());
        }


        //D2
        String[] err_inp_reqIDs = {"823d231cf7d242a297c4d05ec7d5fa11","a308639c82a44858afa8ddd753e88b91","232e02f5dcef494fb2f7986efbab5c3d","b15388dbff404fb48a4ead830d4997a6","f1e0f47eb14b489695b7e3fd9a288e6a","7f1d9bfd3c9547a49ea765b66fffe4f7","c1451e022aea4b2297cd83964688bc45","94426a510d3f4ff2b6fece4bf59fb21f","d07c11193c08420c8e48de12d4da8270","a48d657b4bb04cc48fd3fb0f99126c2b","ceeb059d7567485cb33f1f1b4a8bd6fc","a6ff8b0099a4408f8d93587f3f60461f","967984dda45b4b249fc33970ecac4653","204ab92e32054fa98068d2f9802b1676","1fb29fa7aaf44231abb33ee6dc9a9ae5","cd57561995994aad802f2b9c3ee84af3","3ac9889a2b4f4e569ec44ae9daba1a7b","9c39d735067344ec976ec5c8a3f166cc","c0d92f11f62b4a24adac9707f23c6ea6","5924c24964c5423591d32f1dc782718f","8c96f3a583804dbda5fcea6dc7335bee","552c9cc2b3fb4074a745a173b36f6db0","f8f3503cbb54483aad4abe83bb4fcd1f","4b36e7b5826143e8b022f2f25fdc3f7a","95d4792ffa444d41ba874332f1920959","9f880da744e94a7ebef9b8bb18dabe4e","736805aedd954709b8bab9ca63313158","e2456249c414460faae5aee194a5c09c","9e06f618b4544bbea9087bbc9e4cf6e3","2668b865eedb43f29cc715256577f5de","cedebc77c12b4d9f9b0c797d899ca8c8","3dee8ef8956341429a78c0b6b9a42314","63c8b611768e40848845a77ec1928148","2c8f6f662ea84907a100fcf02a7134fb","53044da4f5844f4eb5098fb44d3e95ce","e32417463a554b09907cbf20bfcc49c4","3019ec25a1a043fa85d5c15af1cc3de1","df70f35c800d499595d0c5eeb7455bbc","374c19d34bf3428284489ac4cc49b431","66cee92aed5a4dc19fce3e412ca86b0e","3c79ea60ef1e44c4b0f96a2a27c51c0a","ac5cf31254404c62b14ce221cf780d23","519fbf7b913e41bba0beca60da50e4c4","ca5bf98854ff484a9617c064133c1fd1","2cda465d3d5345908985702d8ae5621c","d4a742f80d5a40eab886662facfd5397","169683e586ac459e91598addd44979e1","fdc55a2cb00649bb9af253c4600c31dd","acebccb261fc4685be390c12017be94a","5fb372042007494bb5c4b1e2efb25728","e166eb1dcd85489b9e34efd46c8c4955","69e90cd6f53441ef87aa364c1f4ff968","dd5040ddf5434cb4925050542695a09e","102866da6df64a96b72dc9e98e3abe94","6e296e844bc94ce59732c801a7706492","c1a8006d71f54a13bbb125efba74bcf6","26ad3c884db8438e8dede0b291660302","fdfd237c21574b6ebc7f8faf82ae1cfc","b731a90533404a73a9d8a17f34d3d9fb","c01423e691cb4e539206f7cfe37e8854","00bebd01b57841fea99af05ebf673c06","5f4da64d01104a77859ba1d5de59a35d","da4286b914a440498ab2638b5cc68b60","570390f3e19c4f25b67f2a71bf3fa58a","086020e11b5f48afb844ad43d04cdbec","00d9971903484465a09573d869c2bd11","d9181daaf980403190ba0ab09b0691ed","5ae41dd2d7ee49f7ae249b4913c4c557","fe9f3a43cb0e470cb2e0e7261b85103c","4db71adf43dc491da9f30118d61c1eb6","51b7c6a01cf74b5184d25f1e71f68128","870a12865f2840cda69a4d9a7e99416e","6adf7301349d49cf9354c5eb5cbdd790","b806ca08c9b84b5a8afa4941bf045649","d0257cf08a644eea8aa09a9f9348c170","4599e91cf10b4b60b1e0f56970ee02a2","46971ae0663a4f4096f57c3836d8c543","27bece6f625f40ce9cb240cda1551368","e41e8dc867cc49e38975c379a06e989c","0b11e72245c94a3bbd28ba0abeb0d311","d5fa8be2c1de42489d9bfe33c2ecc164","99dd9444c1634b6793b97cc7ae4ca26e","53342012026445c1abfe48f3545978e5","51acbf396e424fa0bed8281449362343","7f81c943ebce47c6bcda60aa403889ac","f2fe8925ff0c4938820ec93cf15bb58b","e15bd148c2f047f4a0905f439bd6c259","b13536748b5947b49c8ae4b2b5930f9b","e67c473bf358404e841474e327615ea0","44dcb060592142458e222dde30c41318","5b64cfd77cdf40f7a78ae85efaf28a8a","419e20e0f17748c8837ff608be2c6b92","1b176f0c16d04400a7ca506f6e6b3580","a26cb9cdccee4af3938a5348a0b67052","1a6283158a364d1ca9139b84bdb3ec7e","8c62d81d74144c43a315f40b3ec892dd","0aa67805757f46a0ba60f88d4474fa57","df74d07d058e4978939f74183b5b73a4","946c895795de433ba739e9bf667e2349","496fc1605411482ca5e2eaff9e285573","34185fa83b6043239ed5e591ebeee353","5e7a64128ecd410f911ef0d87982a8aa","2b68b8900fef4a0797e84d961e206083","2b6b6d2086ec437faaf061882221ef2c","3f0216d42a4f49a99cf2fa1423293fdc","ea3e2d8ffc5448b48d31c6e3b10c86de","81198279254a4aef93b5ddf7edbbecf7","17679ccbf475463e998b185f8933676b","65c6292b840e4441a9ced2c9daa837b0","69b46e581e43477aab72036d331d2660","ddf7672012d146bcb638387405f5564a","8e557b3228884235b24a27822dc0f408","aa540b6ff3f248dc93f85604fac3c9d0","f4aade50c2be45b883054a59c32a997d","2666401170bd4690b4c7ec56c0b0ad27","748da698f416499a97ef6648e21c0d18","38f3cbabf3a646c380863ea8e2392866","d115d91d44d840e68ffa5f1a70779d7d","6604bc07d5e64d37ba07ee0e9bf6b2f4","73e2b288dfca4e469beb74efc7b092a8","4bd1836d2b3c4b1f85640d06f271e307","bc761a95a7ab4d49ac07d3b8550b941a","58d76cf54cba42f88fb564606d25efa6","8e916eb02a5846c1b82d780ffe82f7ae","5e44b602745a421faf8ab38db13f8318","1b699bfd40564d00a837cf042958d7d7","f0b069411e3b47629e322134aac09288","ab95e3e942b144f296402d8ecfd8c57d","eecdee362dab486abde92c803b7a5ff2","6118e96536314844b3b87cb946c26d0a","583e8d6421ec47d087792ed663e262f5","726977d22c84487483ad78dbfaf3f631","dc773b132b014db38644e22f18f53653","b9cac5ebcc4e490aa866cc690eada30c","e8a06a66f41a4392a8a92bc1c7935b93","d842df8611cd4b20b083a1bd48b8c355","597d6e754e294f96b673f8f7a084f6c7","ae1dc96f36304ed4b452d11f1aa2b4ad","8d105dbf4c3c4f8c9e6635e3047b5aef","68eb5323af1041a689340ee014184cfa","46311bdf495842e284213b3698469d8a","8f3c933d47bd430985a620b7e6038862","f10fe686ca2c43508e630aa8bbd711c3","cf46e81c9f38470f9402081aad9c5c49","c38f131789f24bef939378e78a4e99e3","7d2c3776df34487b9362ed104b364aa4","b2bcec3a823c43d795d39b2469f585b8","11582c7b3ab3433bb61248945f9297c5","7720adfd2e044c1c9507b8a7b77f6999","2c2e649268fa4b71b0022541b1657350","9fc0956470844c0e87fc44a837784648","5235ac28585a43759e278f63ecc2c4a0","22dedfb6861f4697bb51817641b6a43a","a35890989dbc42f0b7c0d98997ab7539","5b20efb98475420c8e60d062bbf8e927","dd4a61f909db4656a656eb9688c0925f","93817b3541cb46f0ac775feacae09b23","4cd6233f2c4c4218b51b49a712dc667f","9aee48f031384f8aa62a747d8f4e6149","a798a46f1f9a4b269fbc7b50b9aff8cb","e4efd190fd6b4545a08e627a160a0e18","a66a7d15c10f49cc96ac642a6e145c1a","040a934779e64d648097ad123cb18171","cab3064b5f3844328581adbf56409dcc","afbfffa69af648649ad78e99b2df4948","17d4814a5fd945b18e8229bb4b887ef9","47e4ef46dc3b4a61b63e4223f16612b7","984835595da64cd0ab37e25748aed3f2","6381dfec2d9140aca8f6ee2864685fa8","9791c5388f6f41d6ad094030bc4a5369","9436bd60df6844c3a38a9c1907772e81","3faa7c41c42c4bc89098fefc726022d8","8db2fadbd96b4b9f85ea48aed0713201","82aafc857ada43d88cfa4837f9cdf988","a55f3446d90a487587871f48dd59a250","f4e1d0b5294c4807bd473d42e4f8c7c8","0f4c956acaa74552af7f3d3a075ca74b","fc74de3ed96a4d00a8d1082841c56e6a","e7012969879341bdadda88d7be33e434","c9b441502f4d477d8f6a00559fc843ef","2bde698746cc493485cd0db52db11130","8577e4a280df48ac889af63e1b90e226","d0b3e66c909c4b4396f1c9252dbbe13a","41c31d9581d54013b56e74bbaf908cf7","23908df8096a4856a34fe42bafe7073b","bb8b8687519f41d2b7b2661613e26862","5629916b3be84113821a1d5957fd14ca","9247b38663a045998444b6f807617cd6","9f59495d49f3414fa21a532ed018318b","624fc472609a4eaaa5e5145441ecf8bb","e839f36af3e149c48417cdcca27097d0","438997f5ebf24ad08a44b96dcf2ff83b","fec98448efd244c3b0754cd183efe93a","090803445e5848c182744b9148df84b4","1ec3b73cd98a41fbb3766ab428d4c7ad","98394155a58a42e8a1dc4f5f53729738","062630e92c9b44a49fcb5c5a9c5c85a2","fa48c8457fe14d3d944db2c51243f619","2959b15c72ec4e11959ff1fbf49d89be","2c68fe95523c4036b988dede6959fa51","8f9c9f058ebb40ffa169d569933edb00","66d8e4f18cee4b36b2137e9a94ba7f98","59388cf44c1c4cb1a13f9b19bbfffd16","6afb8ce17c9540219ce10124e7960470","e7c80a468b85483e9b3b49d64f218be7","2cdfd7bca22e485e80eb464e85215db6","8ae1b3a1da6740cabfd3856dd78575dc","252d50defc3f4bf196fc07b458f4af95","7702b18ed0434cf1900e5e229cb4066f","baf924c30cae4888a2e56b9f4acf0602","7635760c420f46ac9953c9c9d0e7e631","f09bf67635ca4f82950b93286b46df6a","24a00957a4974499b7ae74b4a724f4b2","1f364b9dd50744468bfaf2363857d279","9977defc7a024d54992ce2e72232fc72","dd926ad0d7f6451ea8caa87b38025350","5e0114dc096949e19a4b8914ffec89c2","ae600e22fd254072ad6e84871132a399","0dc8fdc751e04939b492cc549511090c","e71f0b33d15548dda8de99163babe63c","214dc36783a14288b02620df4389ea6a","36fd87a434e744dea71a0cdb840dd69f","1300cb2a9e4542f88c57189804d19765","3c812a2635e842359c0e7a91c529fce1","e4eb1484d9bc48168673aac4ab3eb69c","e37aaea6b5364b90862c837ae1d2a3b1","bf6232b49eb2419f881628db5fe9a9a0","f8b390a09f9c45f0a634cb0953131af1","067b74954997414a97b6bcb340264cf9","8717283834b1452ca0b8bce8b33d1b4f","36666136c22541d694227ce02c1fa102","f54392fe7137414bb494385e7d0ea617","01cad016a1b3463a9c4c9f86fc6070a9","3bcf5ce2fb064a20869704d712a9cad0","a7385523baf5463cbde06b95c10dc5b8","ae82de808abc4451af0b59b0412e6c53","7e0b249c0c7d41eb9556ad228f44e647","0ef7dcbf1cc44d408bf248e068f07d5e","be36bdc602c64c48b0d0452a01a8129d","fce97030b7f64e7a949ce2ad2c6f6882","42d85fad6e3840fb904e28051e8a2b78","75f65e0a366e48c0a7481f8da147d662","604daf098fa64de792b9823c5f24651d","0a0b082addc249a3818d0fc40ff6e39d","21106d46ee3846c3975dcafeae0a4413","7667f1a1bf934d938cfbb4c41294c117","620a19efda0e4f888e0cd55e14992e59","636a042a8afd4c7aa6a65a48402e66b8","94740cb083fb4e5397520e330b990c85","235652e2d3b34271b2dc3164aeed67dd","b26f199232244aaf914814868fb0b555","b602db4850694a8f83d3f4be7eaf8b05","7ceda123a94d4a71bdcb072691d66c58","6c60c9f8e6df43d2a847536ac5be2956","ffffb2ebe6bb411cbffbad9eed601799","1096d4b79aa44b11b1dc94673577daab","e371bdd55ac740d59c83b03ff8249c92","ff0ea144e600405490d0eccd540f8cd0","336b205ab6ad48419a2f7cf1d5f40974","0bfaa34a1c204168ae0fef43ea60a530","7a8963312ad945609b91098b51a19661","054bdd65f0404a30863c9127440735db","6ce4704428574343818751fe42365b1a","1b6bf53aff1547d1b11c9976356dac94","7022297546764f6387e46563e2336ab3","a42181d146914723bc9750ca3af37ce5","5548aca247e34cc8965c61a227fbef87","5bd2068d87204e6b923eea221d0aaed9","e2f90e0946bd42149eb380ab07676074","30cf7c2dffdb498f84ac4092644ec347","a8d019879ea74dd0becf984bd9d68c43","60d5b23e36c94efd8e129d497b1d3252","97235fbfb8e545aba22ac6108e215ceb","c62a0fe903be4cc09527590ff86127d2","978358d03fec4e418127822a2fc0a554","06059d4f51c64ea7a03e5020e195b0a5","21235aa314e8459d9c28a46debdd8902","34a99c4bd57f48929cc18b92011259f4","99688c964e404c93b24cdf066b94fa60","f648bd06a3d546518c1bfedc27e8f136","4f74fa3839e54e61995d658989a287ad","d7e2c821eca9457faacda76ae3d44678","7e74b82f82434b19ad779dc716a3c679","7f3268b6efa44566ad6ef21fc8a705d8","bc62e634630841d88cd775dfe1a2cc04","6640354df12442f989c0739eaf831eac","3e5064cc2687458f88237d7dda6aaec4","b3356fb3862e4c98ad546cc052e6dded","50e7c0efe53c4a329b680061c4a7a6d1","c4f411d41fe44c15ab7b1ad2187edc36","a8eeecfd68dd4cf1b997045953ea0934","b42a141313754b9d895dc58a2d5d5e8c","998b2173fe8a4aae836c6c8efeacb269","8112817317144431808b7c493cda2a8d","bfb90e5cec394a65a87cad2b107102f2","0a5662855733414c96474ba4b1067213","a000be5c91bf4a8a967943cb3bd54562","8d53d30ee39a4a4892074762b6f05a95","442c6448fe9a4c67b7bfda8df70d7bfe","975b409f055449e783383c2a9143d8fd","05d4b383dd6d4fe1877482bf3bf7800c","f089021c22a54bca826b727c68804583","905f0d98fe404d498ea11d74a5221924","311fc46996c24d24aa07d5ad9ad54fb2","1969ab4634154edd850f658c6af73870","2797eb7f135f470894f9b45c26a231b0","068f1cf349c7443088d83c68bbe8fb25","2be56e2e58904c5eafa5442d1ee22e96","e10a803ae41f46cdbf568f28522438bf","908654ecd92b479d85013db65591f74b","5f7f500e22374622aab2d05e8b61cf55","693e7eea3c804ec89f34ce5d50249309","aab2983a25d94a688fc4ff54e5d75d6d","cfa3866c2b084c77a3149cac51376482","9cde97c6c8cc46b0af82d505a8f41703","31ac276718ed47cebbd58295eb1266db","b4958933b99e41fcbbb6b596d0629029","951c91bb601e4762b88cc681d188a375","ef1c97ca9ba54ede9be3bdfed7065e73","e1c388134b624b11bf9da8533cd10a08","5baa980e32064cce8eb36311b7021dae","f7de99b8f2c74e60ae2cbe93ec48dfdf","b3a5502eeb914a1c87706204419345ff","4853c53dd8634533b61e0a00d17cf720","6c7396f826a642238a4f53785ae8c018","ca747c2911c342a4b6822938e2ace32f","d86ec41d185147729a655a1723f6a07f","eba0fcfd8995490ba01a9232528c8b10","0dd084c38e9d4e59bf0dec86d24e67e2","496d13567c9548ec88db130214e9c1ec","afd5d8c6a8d140dda18fa8a50aeadc94","1674d6c188cd436fa149130a8a7424cd","d40a23e9eb244cb594045e747ff62772","77559185a9c440f2bff080f401cbb374","9ed035b15a884eed8375799b55368c17","0db31c779a9f4b649c44722c112dfe67","829f6809a4554c19bf6e661a4f95121c","8a17d8c4b4564eb7a06bef7d6ce2e8e9","bb336cd5fcae49d98b89207afdddf67f","4aaabf791e2c49319c6be8b85ff7b67e","178c4c94303746c1bd256a1dab522db2","4aa52a173f354c078ad1d118c00cdab8","26d126c7b24b414fa8df2959cca4b7ab","478061ff78ec477bad1319b5b3749cc2","d302b68de77b445d87840ead7bbd9b2c","5f7085782e3a40aaaae8f15aea55b7aa","65c64b6d5c314a0f92797791e2422593","95e939da1edc4ff08b6908afeabe32df","33891710358e470e82551206533a98d3","7149c53b312844f7ba1cad999007a087","b548da8a665e43cbb77af375c784f859","9b0b94c461b845bea2daf856bad41749","233ff30b1fa542679be14eb50df8bb3a","e23279b7f4a8417cbbeefc7cb7b11f02","104e8306c6ab4786b8e5814d4d03498f","cfa8675cb40f48c3a44b0c9c032190e8","3376fdeb53a64839baad01662e14b57c","ff74e277ae66471ca8a44cd8225e20f2","1953bd441f524fde988a697e49875541","010f91b3f8244a34bec02e1c6538c4f8","b4a76238f5da40aea2ee294e8cf8630f","583efc03543c447f9c414b53b2b4a4ab","eba17b3b54f848c8ab615641f01d87fd","068419623ca7480da978a6a1cdd027b6","94d1b1134d3649a98d2ebbd8cd33c40c","c795d571d97c4a888d87d342e5ac557a","12482b8bd72f4034a2a42ebeddd32b93","6930ae7515b8444d816718f1ec02a603","6c685f59c25b459684204bbf448f7d2c","d1ace5cb3cdd4a2ba41e1adf4d3e5b44","7b292d7200cb4c8ea0a5236154136b2e","fd070c7e4ea74832a6fb0aa29ba6f1bd","62e148ae0107439ab1a64a36d0d20ca6","fd5aa206c04447418f77b8ffb7732c66","ec58abd9290d4e0b9b8ca97cbcd1af1f","408e44970bd54d2d8d996859558c85f0","752b430cd19a4c528a517367c917021a","56d09ef3e10342b68ff50cb3311f933f","5b7b2437c7c8459e8bbf238d612c5fd4","f8c72a9d085b45dab5f8db279d1e6340","d004d6e9913b4602b3b46b4da9cc06bd","2dca4a68a655495aafff51d53527f89a","3e57eca95a7e487ea7086809c8294775","5caeda0b08af41a0afde64d6be0d1e1a","d938c98dd0b8431fae0fd32aecaea4db","d689b8aa7156495f990b7b27509db714","742386e75ada480fa4638bd88649bfa9","21a685c9e72245af8b1516f37661cb5d","0f8938ccd402484a82873fde2e52b208","a9201c6911d844419e623ec7defae5f8","ec8b48933fd649d4af48c9762454c0a6","cfdf47d800be41b1982bfcfd1e7a99c7","586e6f46d1b043b784b2dbf2c85d0a05","b381408e512a4c2db07b3488cf4d2063","39e8cdf14411439bae6cbbb1bbc14942","4850534111464e5b84232a49b97cfb87","c3c35eba795f4609b431626731a112a5","96d1a616e929446dbfc2e535d3233d03","edfbee84144941cc864f0abb9b0eb83c","cd40d465fda64843a76aa0284c725ec4","472d1529a1414b7098d7ccbaac542516","d2a03440f2db427b9555a10f007ca8c9","0cfa394a17cc4825a81f7266e15013c3","732e437df7d248c3afbe60a1462b2be4","834b0fa82c304c278b6b7473fd64b7f9","74741608680249a9aafce3ddaf5ac3d5","027e3e1210254bb89fbe01ba1826682f","21f6f879b7b7462facf432d2ac5fbfa6","68fd0a531fca4f4aab7d9bd2f4c2face","718f479a4b15441392ee97f5a4468749","d509cb2c6e0546e5a7b4031481165a0b","a18c3b05eea942159e41bcca1b6c8a29","8a60f28cf94b44628884bd836d8aa6b2","4d5c63bab10d4c1d98dff4891d50200d","8b20bead59a04a5fa668e742235fa7a4","3dedf93416dc4cb3a40b8ebf5223f96b","3ba254c1d5f24ac59c4127830c66e043","f610c6c66d184679ab99659fec486f11","e050112005f543ab90213b62221bd78c","a25d01226f1e4f159960c1495d5c3155","1e9512ccbce34d34bd22ad20277cc805","8608d442cbdb4f56921bda9730b9d402","bdef7135927a4da7b074d9117d08c34d","6885163278ed411a8ec9bf1bf6e1276d","a60c54b055b24f0e96748b25a69ff0d0","24be29986b0440bcb30de8bface5efcd","2028d33f91674733bd57435ac6626b98","b1bf6d81ee824a3baf0590805fc63915","f921bbf7e8574b65a9472de8a05605f4","aaa09a06ce7543a1a26a123837df2bc4","7402ab92d6e64297898a276fdda566c6","4c0976a6152b42d6ba16e616e323980e","8de0c96c101549f2864a1de479e3615d","112dd62d8c40484abd6ac1aa0423450e","9085a644ca4e4266aa8c03df199f7f42","e022f738078b4171bf55b289e5b6ecf2","83cddb0457564efba5caeed97016b26d","9449186871dc454abe7ddefc8a88b92c","4ee098fb3c5949acb83a71f4bcb58bc8","245e9de77bbc49c5ad559c928bd3f04d","1002c331449e4b7e8d5a720ae1d0b122","9a4c5cd28385469e9ea9cffeeb6be948","d059c074d1ab4975aa0f0963b3a79871","e46257a77cfb42a8a625594894c4789b","42ea227db9c84f109fbc080fc83de1eb","efe7b430abf24eb5bb44a6a78943d0af","e6ccfae48d4348d48847a50e13ba9db3","601321133082464a8c269cd53a845717","bb19714fcd504094ab3c7d1d92241001","02c2729852624507a18c0fd2b0031d08","bcb5f62d8f09449680bbde66251ecdf4","1b6b5fd4c27b4086b19bed18099401b7","77512075ab8a4869af3944cc6d64b127","95bcda5446f34c01b881f0938e7e1c1c","401e803091a5464988afc41d82a5cc17","f177e9bb7c38454db93ea8c6e661ba37","a006593d2c734a03bc216b530c0531b4","d14530d734ec4f2c93a1c2979e7c2fad","f1c51b686f8a4e88add393642a944135","741118e5593d4017a83a3151ef772fdf","fbdca2fd2ca543aabb5ce994770dfa0d","a0ac7f8373ba4931be991a6f6f8ae040","c5bb98dab438456793acf220e07fd522","21520f8828f34e5f955d10e30ae98680","8fb18e0e690445dda7cc43bbc79ab258","25df0693dd4d4c179d8863b097a981e4","2f86a40657c9401ba65b4d7ab3d6a766","42a736aadf4f4b62b6a17c3c11441d47","578bf98e9fa548ae84dc679a45609ba3","3d380ccb01e5494ea3da0ae9c8f9246c","89ff2a810671434a8f4749124cc67b79","3445c8e6567a434fbd62829ede5b3bb9","e125ee334420484583626a87c45b06fb","a30d4c6283724ab1be0de021c9527898","ecd62529cd6d4a488f8927e85367c55b","c8c544d4d9a245a189e2fa62909e2dcb","e7bc192b5c6a4b2986b85b98b9b30e9e","8a3938f3d9984985a19e9a21ac39743d","5639edeef4be4141ae5da218d651ea3a","2e0ce38073334479aae8d521769ae9aa","e3118676e911431092ad558d690c2c2a","baa520fb5b3645e6b68275ae3eac520e","390d9b0b356e45e29f959c36ed7c7d46","0386b4d7542a4619bc6bdbbbd487a8bc","b4db7173e43d494ca833e926718f64b0","c1113d346a19449fb2abff9f50854961","29671e6f77f44bb298b4175dd64ed93f","630430e1eebd42ad95699f533703417e","daa16c4c1b0d474f94e325afece49f16","e5f901480f774bb382ee1757de3fbfb3","3ab2cd0dd11e4e1a94b5db7c075f243d","0dc92612cd6c4e4899f7aa415136a26b","13fd6b96a3ad4873a0972a095a015653","a821954c5b754a49a854a8d7cf665f63","e9ee964b54954c6b82f76199dc822877","7cf36eebea93469c9a5da4ff1c01af8b","86d42b988fdc453293dbc70408ea974f","54ce64f25b6c4c079b3b4e3ffbe24a54","58f17e012be24358a0770685e5742708","3d43b743180e4981a5197eae04f2bccb","e977645b798d49e5b012a90d3d17fde2","f3b60198a28448cd82633bed380ccad8","d14ef05664604bd780646ef44a88d23b","a2c8d896ba484ce2bd7f6340728780d2","e8e5441e1056435498e7fbb4851bf56f","b1fcfc3e5e8142daa887755bdf0215df","269daceb9b2944119b641583f8967d4d","d26db66da87b4ae1aa4700cea862ac5b","29cda193d1a64549ab5fec70c694401f","f86eb9a37e5549008e3b770998328cc7","91d4ef1fecb844b682dd92dedebb1d25","36c2255881e540aba03b25d606b46547","8465aea335f842a389be0bd58e0cd8de","2c511352a87041dca6e0a48489deeb2f","40a09a4d61ff498d812da255e1b2c08b","bba57bae6fb8404d82205f14b8a643ed","24a97e11752e4da394289bbe43b91ef7","16a7b838ad6a47269b9e18830968d2bf","563470e796c5496483de96d40837c5cc","206d9f76e1314dc896ef753a913a3633","5f95807f439147969aa6b11d68cf3808","49d039568322475cbb3ae69e72e7746b","605f1644789c477c85ec2c64ec820b15","acab1b976d624405ac22e2544c10dbb6","a104368ddca24eb581c2fc236ba2e8e2","65192ebb70624db5ab53c33d756a1f2b","f0f6fd8f5bd7403987fa8314dd53bbb4","34caddae62ca476e84449e726c9c0a23","5d528f28b8d34843a486bdf95c02ace7","13edde71305f4a06bb6a67135b57c29d","877d09bc0156473ebc0a4cfaf39ef6ee","7c2d51b13bd24480a4c9e696954b6978","265ea697dfd04945b88c2fbcd03e4d28","c0bf78696cff48dfa5ddd0bcd89073cf","7cff3a66fcc64bacbd712fa1350b5fd9","ff6c62df65ba4bc89d41e82990ff94cd","a89de189104f48deaa51d4fbc04d2348","809562d0e4834ca29348a9a9c62427b0","868d8042ce2a4cf8b8288e112d4a1c54","d240f85d746c430fa25e8aaf60d08119","3ba84d2a657c43e48c0ff66b6ae1f07a","8cdf6a9a17c144bc99c2fd2af7060a04","d2a2f270898e48868c947e1d87a55af6","bae0d9f47ba6497292d8f24be1ba4016","50362280596f4beb88c820318fbdac19","6f08a33c01c849baa8d0e4f4c94e4a2f","5f2ad8c2bce146bcaccb680450f2c630","1bd3f1647e4c4d1a9bd7cd31a7dd79e9","fe35d8013175490b9e547c7d0b4ec4f1","88b2c8e2cbe34ffb81f60723bde83c45","854ee9ee20464b65b0cc4c8c0ab6e642","9499be2d9f4b4dcfafc20dd7e6c7855a","93808964cf6e4050b5307ed4e20b8998","ac6eb82eef2f472cbf7343fd08a175e2","f7c21749107941e3b683f287dd42f1e2","d8535e5123d244b581104d22cd65c8fa","61ffa487ea7c4e64a4a1b04afbde65e7","a5ea97e0b6ef4fef9f923af0757c8d57","acc7672d7f5945deb6a37336dd850b3c","cf5db1e4769d4de887ae1443ac8f0b18","fea931a461e14aea9a1aeed356853def","bab18a1c8170430682c16138c25e129f","d7c9869aaabf4eb4b474273a89456c74","db5790de57494335b224be1bb76509ad","b02d8b6dee0948528e89a79449e414f3","61f4ef133ce3497a8d56c71585578b0e","7872a3e36551451280cf2fc8d81ecc7d","83c91f4cb3b14d9db99f8a08479a4e53","8d48114809324915962807b7836766ac","097af87877d749bcb3196c2d7e83bb50","4f7d6ad99b2940288a5eb59f6236be88","4ae54760409f44af801cdf96cb8d6777","fff5e6c47d7a478eac898d69b9dd4d03","fffc64bd9ee2435fbdd1bca5f4a2d814","e5fc538e5841438ca584ecac6bba50f5","a19f1dab5ef441bcac66635896c8ed11","800a68302c5e4800b13d7ab4b8184417","1fcd38884fc946a09815d00c82bde0ae","6c4506fb8bb3479888b8216a0983591d","28277a34bd68403fb8adeb4d394e83a5","934df9314def4732b201923db2b05764","b234f45c9c1842dea428dc430b491dac","60833ebbd5e14071b222adaec365def5","b64fde57732a4bcd8f04879135781080","4cead31aa6204cf197b112295206c2bf","676c7657ae9f4996b38709846a44a70b","7e035ba67e76431a8bd3be40cffde814","358c6b2d6d1e4014925b58a723366a5b","e82d1619f1e448eaae936b1c93cdf3cd","e4f6896374864050b2c3b4f0f15b0325","d1991e42e7fb4863a99009b7f6c373ef","d4faa0eed1ff45bcb7dfd9a9274f355c","df04a51b4b2646f584edad9bcd9f9800","6557604d8885432f8feb2d4b318f49de","7f42b44e62b94bc498de87facd8baba4","2af06b8e5d394f0d9a788e53fc9f2918","499c08b7076f47d193f91b95c9f78922","b7781a122cd942ffab75b2da2ea0ad6d","128b5d6f5c074ca3a7e1da6f5c691199","c076f982afa74e97baab89cb557083b0","4a8d8ac0e0e64bb79051ecb1654b6a80","3f055d36846e4178a8791dd04b13590a","7ffebcc6c5e74e2abbffbd7b34bb9b25","ef8d7708c3c2423ba2bbce8697c88941","55452f9377774eb18f909ae200c41266","0069a30be9694b5c86253b6ed373050b","d6aab597aa934e16a722a470380ef310","59e2140db3e140e0ae3fa4d1b2d6d78b","aa24e8e547b94d609b8be9e1eeeb3eca","7e01cdccde284938acb788d0f4249338","e70409dff278429086df2b4ed24c9bbd","9e23532fa3d443eea190ee74cd0e03a2","bfdf89c4ca9445e380f45021fb2a38ea","9f17f70838a64b06b51876bb91747076","cf3b7afb34754d94a51acac50c7be63f","e49e0ad2be9646dc971883e39eb7b9ce","964423753e9542328159af9865aa6b97","f809ca559d0d4e778c5668e9c69e0c37","3145af091e944c768b13f5bf14d85f9e","26c2e4bc29b046e39f197fef24169875","e13ca473f2a64f2c9d0026669a033a27","5db00c4f11ea470c872a0597c99c637c","c0895001c09942eca71eeb8b8385ce79","a3330cabd1a042919b37c3bf9543ca8c","e590b65cd65442c684310b1d6b98c5ec","58c5b47cd7ef49b68c0db56d47312bc1","5c395ac2143946e7b5d917dc92cb4da3","41083358321e449e8479ecc1f4a2b85f","ff049e60ff7a4eedadb43aa811051e39","f1194861f20349d789a84b6ddd8b28c2","548d432eb79c44099295c1ff121f7db6","f0896d62653e41a5bd1b93c073abeaf9","543bc61986b94720bf822124345c0829","4a56cc8e015a4b369e72c385786c2b74","cf7d901bc79e4db883e5353cd84374c3","c52c4e757fac466a94422b8ef4f14247","02bac49ec54e418583122957b3861d3a","44a639fb2faa43aebe15df9c47182550","b22331ce7b5c40bd97441b556e3fb7e8","7bede79a1cc4449f99af339ff84e6a5d","9b59fcf7306240eda73c55d0a3730dae","7269f94e209841d5b7f4a2a3aa8400e7","4cf80b7cf5044144b37299fa2be6aca5","e5e58af1a8154c5ba4cc9da30889495d","ec4ae3238aa147328d352ad6039307e3","b5786dc852ae41f68f4b3e444ed8c877","ab60a48c2e43414380a123ae34e456b7","0390a14395ea45f697d2dbe27574b137","aedeb45a48e14157802df44433bd5b2c","22ea9ec76db449c8b676eee5d4d34888","17866dc904094d85821ce42a95ad4d46","d21b0ac7471c4660b9bbba249d83bedf","cf944e639602465ea6eae155dd4b524a","ad9742cb214f4b3bba967997b07472e9","59dbdcc974d54a6cb9987dfb2c9fa754","47792ffb22c14aadaf02605e2357f684","aa82622a886a4ae893149c8c37712540","1abbda88e7a64ef0881b93cc746ac99b","96334fa84b15484581ee964466d14414","7188dabac936451182fe8c678ba39bd5","d5a88c2aa0a64441bfc9afdf9a91832b","3fd62ce42b55469ba1c54591f454d8f8","b24cf51f2dff4ee2bb79f648e2efac84","d495788df144462a9fd6e6e622a6d1cc","0bf28b570b684090b0c411ea8cc6c38e","c9071c27d8fa426497a39ecb577fa515","11e6077d4a65401dbad34e2e508bbcea","bad5095cea7d44da89461e23c08b3067","04d67060ebe24d4f98fa1d99300d57b9","9e4b093eaa5a4d2ebee29a8c9b69e86b","982198230c9c49cb9dc3a356b9d20d39","57e32804e69a4121a9cd2db41e50adfd","54558b05c74c46588f113d19f54acb3c","cee19a7a00564e3ea68089494c85e378","841664659951409c826fd2416d3c2f12","9994ac85c3094830b4190345c6e3c15c","4fcb56f556c44e3ea201db02fa7d0dde","5d7eb8b2f4064f8dbb51030411a301ac","a637876f102846089d32ea3bc0d1853e","74275aca35db4d5899f9e43973cc80a6","473896cd1262460a9de1fd861ed7f34c","586a22e8a05746d8b010f4b801630a18","9d1f90df10cd45c5a2fa026cd78a0d78","903575bf009f45b8bca7ab969c027091","540c14619cb44a779ce5b4d6a29e280e","50a04f01bcb145e1b9ef00637fe495c4","9294068de194482da3b18328317a416b","eaef27ca83fc46bb9c3b5bc0f72e04d1","f5af4cf177c849fabae3a75a5b81cf3d","73ce01bfaca447319053a3ea035b86b8","3a09b556bc2c4167954608eea10d37aa","63a5530862c448b3b19601c6aae68b8e","217f37c3411a4319a82edb515f0e3cbb","115fd8c5356a440185e96eb6ccfd8db2","25153fbd002b4e22b1850fdbfde3887f","ceb5cf24f1034af48fc3276e73ef2678","b0c9c9d8ed924b3bbb5926a9b0d42269","816f44363ad647f192cfa09d03e5bd05","fedbcb28b33345e3b2641bfb40f6ad20","56fb3e554aa945f4a5cc371e72fcf204","4805f64790be4fb18c2f4489a3ad91f6","7aa68c8c1e1b4ce08125f29c1e53f265","99b0eeb5fb164712ac87743f139b24e3","d2fea5847475431eb1206d24f7aa36bf","62398d2367e54139b60cfe6f70c05ed2","56f41eee9b784a9085e0caf9a56e44c3","111d5c2aec2e42ae922a5e25f1e2482e","8ad59d77882f4261876048a594d43b19","a73c6a7cc612416e82fe9ac62faee699","9901955883ca4b3389fb39f558947cce","3da1387058b7429ab62fa469249cabe8","9d20df1da29d4cb2ba899e256ca5f9ae","2320734781a54d36ad0f7c57fbfa3c03","4f27a313383743eebe09877716df7cf8","40dbe2c63a564f12a99bc607434ebc28","43ce48a80aea4e7c8f4f44c6894ab65c","d0d85ae17bbd4e189ee1829ebc7db990","aca0f6defe274ba8860db1a163fff32f","ee9c323b8a964788b5f1ac058347dae1","9e3e403a4d474a6b920eb1af91ca6c08","52397774633c4ec48a2e9b43814d7c67","be701a4af31c412ca5fb72d4935b84ad","79f16fbd0fe740ca86ffd86b30b8ca9e","8cce6ca9519047d78a8f5e57a35d0560","f5f373ab03c24364b475797e9459e16d","7eccd257b0834cb8938b97a40116b5a9","74b41049960b4c1e85b18dfc83270232","00572623851f4a27a8678857c4abcb2a","d2e37e52961a438186fdc98f0375b1ce","7653b10aa48e499cb920065a3de61673","6847487239d84971a57dc2de317ac118","7639064cf02542a4b0fc31c25d19bebf","093d30a6cc7b460eb939bf7f44f1f7fc","572b3da8d7604ab294beeef4d5ad7515","1b785e084ee04e33b21cc499627199e8","80b6c5cd600f462992d6d143b58f8158","2747fc75cf2447cfa3cb7dc517d33fa4","83e0321f91c74a6d93bd0eb4182ea836","5f27eb1083154af796f1afd98764030b","a4acc6c67c0447b28335ad3cb66c3bd8","6fab8cb5ba864ee1b96f3ed84eb34aee","54a9e7b9ec574d36b887a25957333b74","54440b82f93c463dbbfe3ee56fef879c","56bb094af16a4cdd8b6d6a3359528440","b68146da410b4fe5ba04e923f4a70595","90cb7a9573794d84a824103e817cc35a","4f338050e5a040eea2bce1d8a909416e","b6ea4a4f2bb649dd96c808759948cfb5","f8b9c2034b3c445881a17f3162e030f1","c86871f8584e4c9599f9f5d0a7d503e6","3b5ada1785c3441ea592f95878fc3130","771f5a63a71e486daa0ff2aedf205803","825b1f6920224652991b519e00a0c1b5","98bff7338c154371bf6cd8d05781c358","3768812f75bf40e6b9223b7b0d4fab63","c23b045519f8413ea02e2d63099649df","bbab9dba922b4f4cae3ab49e6fa242c2","7e4c8451a5ed4e01ba80c5020879558e","f58868cfa84c44dcb7b011260b13295a","26549ca6f48f4a94b4a6cc082b34f32a","ff51690df9a84e9cb226e139c9177546","639d6a418a8245bb81dea2e2dd081dce","52aa5243aaaf4feab8a81789cf6818a0","ea6590a960f74b35842c67816573d876","ddcc36bdd49841c48d561ac615d23918","3d630b67b8f24f6787743b4afc616289","512ce6e3c1574822910245c72e588ce9","b8dba35c19714abfa8d1199646ad3937","5363c075381343759e5723733cc91323","a39dc1e3ee5441f7b363bf4d274b48ff","d165939e69114f72b084c4fbaaeecf70","320bd5964f30459db27dd65123218a3e","e3944916a8ca44449b160c55ca9ed198","7beedaaa893848a092bf0ffeb953fa3c","2ce0f0ef681549f3b4cb47ff25057cc5","d80bc0dbff5d4fa895ea5a1dd79035cf","861a736f8b254810858d3d84fe346c0a","cae5e01948174be29ca8fd34bb12cd66","1150d83b08644784989a00470d5cbacd","db7f6e43b11a48358fc24387436bb592","2be3e04477de4c8eae77644cfefb05fa","7cbe1cc64a2a454aa51ea0815ced44e1","f15b71756c394bfe97fe7b32f09f1817","71c56f0e5097400db9f76bad7534a1c5","1da029e5d8ea42c09a4b3c3b059cf6c8","5d62d5c08d1c422e92b4a05274c1de38","c9f6e82c64b34093a7a8edf90ea30426","fe84c0366be945cfa734f4b4f20b8959","2348088e5b634b898498efb94ca2c510","e244589b3d394e39a4e1c091f2f87d76","442cfd07842b48e4a787b57f367e2e76","aa7a8c6c421d4f9f847822b2adcf336c","20bfaa00955f4e0298abae2f4e81afe7","42b65b06bf83443ab097ce6076932bd9","5e00fd58df624f31a4d40da88daab9d4","c1e0f6a8cdab43adb6a3316065214428","20e118b88cb344688041fbb8bbdafd97","986aeaca4e7048989351e463e44de10c","e5a737fbffee4da4a2c3324cb5bc4bf5","aa8f0c4452ad43f98a8677f2f3492445","2d18bf67088847deb4ef75a8c9acc4dc","3634ab3aa1594b2aa841c3f9e040c750","229a84299f344193acc358f7a80aa87a","2f90f18ebef34d93b7bdadc164a22c1c","07c5c936d4f041119bb48269c891e966","0f698aec44b34eadbe05cc9251639a0d","2116e22f335841e5a485087299928efe","db48f3e7f6444f7f910e7ce7f43a14d7","186fddb8527a45a6bf7fd87a5e13966c","337c7d3cfaa14e3fb75f302e761fd090","c727b01e55c248d88e8d8f9a12aa797c","32d8874c02a44eb4bacc284869053205","c6641e7d226d4b48b65aa4feedcdaa0b","450b0b9d6208447d93d14bca1bcb60bc","e1658ab42d284d39b593a684a66e51f3","d9ef9a25d14b42f8aa890b243bb59025","4edcae564ee1431d8f182f1fd08a5e4b","64d1104fd18a4c6ebfd144fc7e75587c","ab2461020f7c4479be62ff609a8f9903","f49e1a035348488c8d1b61530868e03d","680c3596c93b4ea6a3bcaf311a5d7fae","c7a998c47d674316980151dac913e0a7","cf09cec0a3574d79ab46a49eb308d8e9","af3cf35f297d493382043642c25e5784","1a451531ca1e4633a8693f89bf4c007f","8dac7009e2094728b4c492282e6225b7","64c3b6b324ca4be8b078e221ebd74d27","bd3738e9aa06489c8bde9a967b36e62a","b646b6ef36b54e1d859ba2f64e997aee","db54bfe5c9e246c2b36d106d13847623","2b8999f0bcbf44ba8b16d57a778fec17","325b48f6b4f8428780d96c69741a61b8","452302dbb09c4bafb62a503eb6b2931a","2436aa7783184a8d98c926534bb298d5","25ab2200598f4cb385196ca5819deb6d","23cefe8b43f646319f95b1d6fe3e320b","5b86c4079bf749b3acca261b874f7e4d","fb0698d1e3f549d5854a46e3f666f670","006729d8c58f47b9a08ecad3f00b9ecd","a1a999263d394ae08bf13fc1eec17512","0b08b832d9e146648c89609f4acd6408","2e84d08130884a2c9b6d08061a85d6b4","164d75fac37d45e99cf4f5bce046aaf1","50a41f0b0d33459aa978ff0db9d245ac","2a5f7aa05fa64e489e6fbc41d7e252b2","02214818d27e4e379f80a6bcb0197df0","bf1f1d0054c04280b84aa05ec9caa2b4","a17061aa5e3a44538e86e2cde4dd2d42","4c4daebb4ec44d95924db4779d886fe5","1b1cbe35a0534ebd98d6af37ffc580fb","61c6263c80fb4e688bd6bf5da5e343d5","e78b68fec3664eb29f9b468669048969","c01b0bbe12a14144873c71161b2d0a31","4cb42b9dedde43e0b5f045212554d991","101141a552d14f7295f1ab728a4de1c3","43d3ebbc67ee463abbe45927f4705d68","0b3ca2d656a7450bb373d6f2390b580d","21d89818200d44e6a3ac37077e3a81a7","1819410d17b840e4baf3a3d87bb9bde7","f97adf2f66f44e8a91cf1105fd7eaabe","8f68c859c6fa42f2bfe29d4b40b4e614","d74b5c3758f049e0ba1e4bfa99c7f8fe","016f893d676047b78379e03cb2cb696b","97717af8bb0448af9d7f89a4ed465027","9e46b68f819e44669be647d01770ebbf","abef67eef5b74972abb321cd4bd6fc78","1845b9cf6c4b414fb63d7e79c44ae080","2576198045844ec3bae475dfcdf97182","ee76f58ff8b342368e97471f6130c183","9cd85b4c0256456d8906a5ff721157e3","728172530d8b44ceb146f8399d497b35","64da6af3f762467c8e0c6e46e0537f0b","fa2da455fbce4fa583fbe3e1936c91c8","652105a2446f4984aab10fbaa79dd4d3","571191c8378a4a69ae8c6542f036e266","d4a09a8536634d40a675af7cfce3c68b","41bc89b60cb94ca5b8c428029649325f","ef1b2c6218d14a02bdd77b1523ee206f","f6442ec14f494e94b7d61a4566a15734","426fa5468d374cadb1fc4b2b3bafacd1","1424c417e9034777a44e3535e55df5f6","ad21d1f95ad84235ae95110ad3d9d9af","44ade40b83d7450f8fc8b6dc34b901f6","c9a36a951e4049f88f210b6df24dcfb0","92194a42246f4eeebe65ea7743cdb167","7c9aca95a6844daf9a936b69a485755c","ed7d7f7d8c224d25b5ea16b3d2c2c0c8","89872d9327a64690a318201cab63d6a9","8f94d4af005342938b1b4912ac327c01","b2f9d0e6e4a64821b1e81d1dfc00534a","4eb3e61030f24f9aaa125a3635695de3","298bdcab4adc4fbb93d00beb6da41563","df7f36aa540a4d95b80c40cc49628903","0df6468b4c44458998914aa9242e699e","1d93e2bb0b33487e86a2fcf7355f854e","57b8145d6b17477f9956bb65cbb1d22d","b124e6cf8d9541109889d5c620d0dc2d","85ae81fc274948a6957626324a71138d","9dfdfa02b93241799821df8513e5a5dc","9f9e80ef5e904d3983f46d0ba43ea359","43094b59cb7d4e978a50e4c67c18d0cf","c39f36e4565a4b46bad531df1e5055ee","a3aa93dc3965443ba48b2bbc52d2e8a8","fcdcf2d83c704a3abbfba9309e09f615","17d0d7f5d8314e3ca323fe428354752c","02bf8cbff5c2461eaa4d380a9cff4a37","43fbda1f6f2d4b4da3dd031c20267077","13a3bcfda69f406ea1cbf2224790b189","3af55ed6aa174718a26839084a134eb0","073033e98c6c4c868c968fd8b7a8f618","dc4808a499ab41d48157b3447f561ad0","4d6a9d77ce6c42f19919ed760cf4345d","5340d8b603ef431abbce531892fb0d22","3ecdf442874248fc9a6885d2bab579db","f80ce27026244e24a8e2830bb91d0baa","e73cc86a63eb4efaabb588b5e16230d2","bf98efc9e8c5496daf89ea0aee19745f","09f96fdfe779425499048b9a80e9a423","da1db9dc7f5545aeb842b16997677c93","43bb136122104527969535724a53f27c","ff68a1d8b10a434898b2834e59168afe","4f1bff2a9b9147dbbde4e841784a9efe","4bbdfbf7610440169be0b465e1525170","a216327010fd4594908694b785d12343","a8760b2541c346fbabb419c1c3e6845a","269f24a7eef3486a98bbd9be3e9fd1ae","6acb96f449e64efbaa761d5f9aded9bf","06c9376142194f74ad365e8d58168b60","3fbddb34334146eebd4f9b58496c41f6","d7a97e54a9834d8fb6d3c1223588996e","631ee3b5570d46a191a27a7b39fb58e9","ab94b22b698e4bb3b08716e10406002a","d01e59b3dd1d4ca7b4395225e8e25a8d","0ad8f0866c004dac86a81a5d4efc2d1f","5077c72717ad48cb97158967a311cfd4","b15c3ad772b54a1b9bc13a84db022c2e","cc609ca975664ba89eb5be4137d120e2","9a423f320ba04a0aa4d7b2027cee06cb","8ff98d890962465eac9d0a9f1769fe8e","91f3423b72b7462f827ddd7933778e27","d41855b1e7e14a579fe4626822f3db75","82304f3b00f348f6aa5af1a4c51760b0","067b6230c6964d2995cecdb5fdaa2213","615fed68a4e64a5cbddd1ce66b3d806f","b5e488513feb47bfa297868a0d6043ef","b809904222704979a77561cb503e46e5","8969e825c6614e42a29820fb8b6bdbc0","4bc6914141314b83a1fe9cd3c67b7d85","d604c19a6f244697b9c89e44ddb08e55","a82e8ae3c0b9401897fce03a15909138","f220632ebcf24e6b91bdc7c1ef23a640","ed9a72d5c23f4be3b04201a182fbcecb","ae0811838e5141ffa5e819950accba38","699ac20bb8304b29839d264a692d87a8","7ae1b5f1e89c42629dbb67c2835c836f","f475bdfca6cc48d0a10fe131910fdcaa","b1ec9782aa674c45b0ba28826144a96e","a11ec62bbaa74dfb9119224a6c10147f","3a9e521bb2f8445fb3cd4324f815477f","b87c9e0f9f4c412aa724ae2b8ec5ab2e","fdd68e4672f64bbd8ce96f336d875999","61ad4ddc268e47a6995f1ac499afd540","a368b5e69e4a48528dc5320a025e054f","6c188409e3d64aa69af3a6c85c5a7821","eb765d93825a4937a737d1a147429a08","b847d15a3c384fe7afcddcfb48473567","d93ef8958dcb42a6bf0b1a66698c4385","c32c2f2cd2964d3796695ad06a6faf2a","f7b1fadba3d14b67aea50d136fe29c11","4e47cdfa7b2c468589dac8bf74529299","0e463a593c45460291d7d617d2cc75c8","b392220174284bbea83a9280b64ccf53","800ebd5c96204eb89e052bbf539fe192","15cf31d2ea2944b5a2bc8cedec6c7c01","5a158ac1896f4235ae80e8560a6c11fc","20d4eab747b348fc82d77a4e5ff6df9a","8341e683d97f479892cdfe0d9ef07d3e","1d55523727244214827e614d05372d61","9a8245bee9a34d4589b10158a5822f34","9d7df81985624f84bd3ee0ddc310a14e","42ccd4b32e1c47c18891ee6f7a362e4a","b67c26ef40004ee28d8d0f4670471e09","9941d460da0e4198bcd66bd3ce3c922e","23739c1f0ed24d02ab6c61816daf329c","d47403009fce46fa9a6b0bf13d99dd69","f7cdadd427714d9cb43baea79ccbdecf","22984c663f72477188021baf41fa6faf","c40934ca61a841e2a7403b0b5c7ea2b5","e9743868dd6a44dab389af01d9affec8","63082f12c57740b88a31360b62a64a60","a3466c16e3a94902b24b394b699f19bf","b74621f29a134c3386447e12eb1572a0","6b01db126b7940ad8cc04bcd4046cbb0","b091332a19784130b814afd56f079e71","e70b8ed04a474b488da6244f8db3a207","3c59d26cf22745ea92ab8295db8c3c0f","0dd7d455304443f4a508f6f41ae908a4","ed131185d8874baca47effa5b419e4df","06b015fe4d764ad3ac9e97e14b2e2887","6330099e5c484de9b1721ff1cdcc240d","45bc07149f664c1fb6992c4c8ba84b86","07ea74f893e448ea9aa76cf72b0d7b11","0f25751057274931a1908f9a7fd6c61b","946e069dd8a84ede840191e7561923e3","1358ebff0ea5430e8b7e0576de0fcc7b","1f8cac9dde394a958d64a8c7088bcc61","b4c79398498c42dd87d29469f523921d","311b174ba8b54a43a82dfb642b374095","c0288b895aed4e518458095dd428db66","3171836721704b05b2bbbfe40a136792","8dd33b0fc0c04a57a7acea610b0aeefc","0f3820682ee147c6a611332213c98eca","c04ca842457b44299892f311d9399d83","512c554b4d50412a9dbe5fca82b3671c","ed1a2a64ca814acb912b588237dd0036","3043180f4c704e5384b84bc1e9dde932","061209b68a574c4896c782a5c93fe2ea","c235e0fe1d1a46d1a5cce5fee23238f2","c9bd12c6f9f64012a1b786d52a76bca7","e448c694a40f4689aa1cf17a15ac0c4c","a4dafc97828e47458a9e5efdc33b2abe","0f920e1d959546e981d3946fa82b4f08","56cdb30f116d4c6e8bc9fabec82898c0","f1401ec61fc04dd59844089a1acc3c1c","f439f694a2bd4966966439d4bda7018a","296f2bb1aa3f4be99d2aa5535533cfc5","e25aade715594a1f9e0047daf0a94b47","cf82fb6e817c499c988270de57cdc0ce","4f42d6a5ffc94da09f72529c3ab9c9b2","b031835634604e8c8fed808cbb90581c","e4c14f6ab6f740378ff75b35da123852","af614563530f4f3fb2450f91188c5676","6a7b7daa999047db9e53bcb053b7741a","98799747fda449799cce39d382fce41c","5dd57572002e4a1cba1e606723279234","8bbef9cd0fcf4c928a41f727a96e812a","10d0f2e17b6544aeaf074c6c6c6b0215","23f6a23187354441a8cccb9156c086c4","1197d705444f4fd5bf8b196116185ffb","fc0c3014174b46809c0973f3f34c7842","54a8dfda89fe4e71954403b3f607d63d","6edaf266b4714f06bd8aa8f5f2a5240a","55167a0a70e747eab05596fb7847b774","b4d3189a4723496e9011e67b7190a887","91c4a4c8a0234d88947760e6fe243401","1a345bee9cfa4e3fa9dfed616f38ac4b","034c18e694574eaabab5156806cbe0c1","b26b6b88dfcf48a6b3fa62f3f8cfa987","0fe24fa97d8f43c9a6dbdd3ad19b6cca","5d690085acfe40bf88faaa85e3032133","a4f6f24a30404b31ab5d10f17f5cda67","6547cdacd9a642f68480352c0f76c88a","28c71b2babcf4b3e901306dc2e5357fe","2fefafd5f7a04abc85d06dfc3f48e042","93ae72324d4f4f91bf689a437cbf6907","bc62375db8eb43f1a1fb323fcb5f7330","c440bd4cf3ff428bb0c293f318f2903c","d47f7e1cb03d46b289b9f88d2ebf0228","2f06d4e08c4149d3bfb558fc72c4b064","52b645d695954387ad87a53179ed4893","6b353b0dcc0c4fd0aa2f0a8d666d9232","bd8a857ecf744f39980be183217b1fd3","ba6e615cc5e84eff9b7ec3d1e994395a","c7deb94bae714336bb3cea0462b6f079","267265b94ad9441ebc2e8bec540d3911","6e53e7cc259a467e84323dc820095586","00e8b87ef93244358a94ad42dd492e82","21bbb9b5c6c746968656e0b379ff30ee","b3fa44ec34644b7b9b573e4d7daaa0eb","62e5a85c369e4b6dad3a1ddb3fcc45bf","5e38ff36e6c04500bd8212d2cb651019","93baace8d1ff4ad9b9eab9d31c53cb79","a9e2f0c438114381b805896b309b7eeb","592b3121ad6f42cfad4a920f11c0f568","100ca9d74ec14d8490de90239030c895","e4b04ef1363a4276a133b37a8abe4397","68b2f795f541479f97603b60f98822c4","d651da27970e46a0a0e706c99dcbc67e","e5aba4cb979e455cb1b119a764f19c99","82f9cc2d42b346798888d5a585e10347","fd1572d1d7ee4a4e9aef6c4c37a10833","7f909fa52a1547ce9024747501d3d9ea","3299094242a34367beaa09ff8552c475","15aef3a058004b5daec8f21ea560b31a","77b52c7345a6472791e5fc4f97d5a497","80d084ab212d4780a05edd44bf2af185","cfdcd5db761b440bbe28815d638d420e","5f386e960536494a828710fab715108b","57653ba9ae414fc3af97e1f3b3a85a87","02836952006a4c15b48bd35a8af4997d","fee12c2b401f474e9862666e6b155a5b","5970db2e031147b99cdccc893ea27699","21dc185fdd92494f86c75fd852536445","798c7f7a12ee4e3b9cb5c56d733365e1","c2730de4630741f58faead4e89a9ea1d","e90cc69a894b4e0993f9155b87ad4d7a","c8578d083b5542bb86460e77d48cb79c","a388251c4e9a4ae7acc69b3d3d7c1fa3","8787e3b5d901413699fb66d262f8e96f","1b04fe801cc84bd688022c441ed3dcaa","afc33062e9d44d73ae18a6f58b398e66","b09b7178a8b04f44b72a2fee453997f6","c805d48500c8403d87281fb87f3413b9","045e2b6a95084198a65c1669e8d45d18","835fa091307a4cf08749cf4ed34a1a62","a7bafa097e634332990157d989503baa","222b551df51b4b2c827e879108bc0ab9","cb7580717c8542bfa4b7e5e06fc3ac32","bcca4d0978044e0abed8d270391931d8","b93a07da97a44db9a1016546fbb541ac","2517101b631b47afb2e1df70f016b7b9","c285c812690d4c2582935bee7d651444","ca692f3479e840b0ae86c22b2cb7bb7a","101d4142cfd740b3a5933a16c13be655","2c985869dd914140853f78505ab5a20f","80358023abe343c096a4e39f830ad2b4","43def3fa66944a6c8a538cc89ab004b5","81218f13bc7f4678b19e16a1bdaf6334","5006242095f64fd89435aa27e6e77a6c","f4bfb24c9b544f76b4fc8c5c258837fa","9fb2e4cbad1f4808aa481e407112485d","7d4236bf238d48faba8d368d178a358f","5152ea6942a4453d993652a35d7cac91","4f02eae61d4748e3a7466c439f5b9fc8","5c40851a02f246b8beba5990cc72e6a5","150876705bc441d1b220fe29681362b6","dac5e379ca3a41b5a12d01ea3670a5df","033dba6d20174c7caa911642c3cfa36e","39b9a2be871b47df964116d4856b3825","c2f2558d66034f2291ae953db03dab07","8710835b294f43498f2e0d3cd31a46e1","4148616effa24059b23829a1f1a4ebc8","b0cc6309378b4cf78393cb660650a79d","c9a45d83e881472e9d12af4af3798f4d","af5e601e0b0442f8a9b25a36fb42e5d1","5356dd570b4844d6a0e159d13b773a0b","eae2fd44da854c7ea69fc80a4511ccc0","71b4af5355cd417db93e27cfdd44fc5b","2163afe8f43c406081339d05539eff6f","d087aea4cc824b13ae47c9f5eb873b96","a8a13c087116458a95372fd44d2acc02","bdcb6dc1ec0e4a37aed3999f7ed6ed13","bc6e5b859b504266964105883040a2e6","866e560c4fea4cd184c90c0aec311702","f8e4728c015447e9948c981d5d70f52a","fad0af71102c4fcea8861158e9fad982","3726f8365e154e7e8bb0419512f6c565","0032cd25bcc4441c94d8600ccbe4ec95","009f505db953424dab64e45e2fd11b87","f8b38ff1f00949e7bcf27ae41690d100","e2ba1e2f74b04244b51565b6242d8362","4d5fe74b7fa2461fb248e9f887cdfd2b","e0e2e0d152ea443c892731dd278f5f8e","d50989b4a78b47b58675c4c8738bc42e","d72c242d02104898a228f7b618b4f535","4693ca49b43e416086a64618b778582e","b6db94a0170d4edbb1204d57f307b156","3118288c9c3c405d909c6fe0f0f1b537","17f4a753295840a4889ab3aacc40abf6","ad24fe588813466d81fe28437e3c7b46","80a572ba365244d6957a16166d654039","4464f20c46cc4edbbe1ba0e8523d2e9d","55ee73838e8742c7acacab510f95522f","92922cf5627d430eb126e1a474898461","1dd2561f28c64ee2a4a3334499239b0a","b95eb01ea5fd4f5580864fff6d15c1d0","78fadae4bbf64f8c9a1e85cd2ff78dac","2ba996c48c9a489eaa92d1af3685696d","941c1d7df42c4b4ea4246ea996d3783a","b1ff4eca77314392aa1781adde6409da","c6f195f98497411f814cd560714578cf","57bc374282764a9da6527aa827ad0a93","30e7cbbc90eb444b863df446188a2263","e45d25b0bf474ebd94177fa40731e4b9","4db9913baa6049228e7d85ec1f6edb14","e47d479522df4ce3824e01cb6a7e3e3d","135665b916b342cdb25f888201a2c121","b10768aead744688958ea83226a25f35","82fffc9cdae34518a1fb0ae8ce49afd6","536fb1dafb9f41158991fa14fca126b0","f7a47c9828c44bddb796fa95b14a47eb","0c280d48f25f441391ff204b7d854b25","6da2812f2cc74a3a8b226acdcaec3c8f","4cea5ecc69fd43de93f2a55be02d4a13","a359c66b69e34232a094f24b600db54e","c0cefdcb28014d469c05efd5641a7eb9","13f7aa49b7144a2a8dda6174830cf69a","98b3e7ccaa2446e5918d5c4f3adcd609","f035dc27dddd45a9ab3885305ea6ce72","0aa46e9aa0a3403397939f05005c1145","0454e22cd2e14545ad1c2ceee7c36a1e","cd4a4d7564b34db9acbc80ea7e0f903f","6a46ae5d2888484eb79edaafa9140262","ac8a9ccbf9eb4d3dba5c3b80bfd4b2a0","21e656fb34a54fbda00a94dd57ffee30","6c85b9ff2cc94557a48286239ba2fa88","5fbc9003474b4e07a169361a97302e09","e465c35e83944cdc88a8721d7f21f78e","9f4c8c0dae6e49a09b9ff210047e3409","c9cac4aebc0341648fb4e37ae58264f2","213a02bee60444a69379a165af86f581","f497eaa73e2d4cdc93994f2a7a5a2c46","3457631848ef4329a7c8e742f2f7374b","abc0e4e7f71b42d8896b3b8f167b7fd1","ff7c1aa9f3c8460782c4189b40f89d2f","91e2376754a4462096d033572ae01bbb","cdbc9a2a7b104c25b04242752439e30f","54650eed46f44060909f946f7c62b3fe","14b4a9f758074bfdb1ecc92444c3725c","2af69974a0bc4c9ebc6dd6cc2e26b346","da5a39ec23b743a7a60e76a1dfc1a061","a9f872aaee4443cab7caa3df396e5913","ff8e8144486a47268025702b16c1684a","5f8abe8583934f3bac5e09dcaa122048","2103e1fee0614250a9e95cab98145191","68d2ffaf6a6749ad9163b5f030d59cf5","b78ecbfbfb104f73a873d0a532749e9d","86a20342ec764285acbf9d1e8bf1dc97","7f56a418f4bc466aabc90e40acd5504c","998ecec7fb264af88327062bc5d8dec5","e2128ef258b047b4b1c0b0c9d4175c56","5bb7a34e848a41ff8cab5d461b343ec4","831612d6c26b4e619da5710b15d4446a","59d7e95864d74298bfe0b6d839d97293","416c0bd420704adf9c0c9e5b6588f045","aa9f107bd7f0476da8a183d48ec50955","9309edcd1dd749d9b52eed784a4c1a92","6f45a1b26c054035bb5c380816128569","a759e94f880042df9da18c200ae6fa24","f87b34870e394258820ccbe5ce0f6c94","fb4ffda524c742e3a9c2a5ca7d747774","855a506b875a4b42b77b11dd5f735d05","e3c01968e08e4f25b452cb68beec6a63","d732738847484c9ab021fe125d3c0412","4d19099c7bd14c568338aaf9336bbbe4","ddc778c594a14ca197291c7e21473254","10a5354729e649478cba7509b491ac3e","dc176b91d3fd4994bbe121bf4ad1b7d1","11b2cc77995647e299e5743e499cd928","f830102cec514dd2b4e14b5226ba78ab","8d7f43341d0241cfbb3574700a401fe0","a397d1b7b0794f5ca42118f820f87f62","b00cc570e3324bb78de8c667b17e4d99","4e60d9e4e1e040d681df473f93de7160","35adcdac7e39424eb2ff134786b17c55","358a08b80b8c4a839e55ece444853148","d61df26ac6ac48d2ad8c9acb15a2d144","07119d766530498a89d0303e30e5c41d","eeb283d4e1bc49a89b82dfb2d3167d7b","69538225963c434aadb63d9fdf378e7a","195fccfd14d543818676174ca912fac4","2e45df918ebd4728b152a7d8ea5ee425","cf1590cdb997403c8e379653a80847b3","580ca19e72e04758bdf8dec6341c8673","7e5575ce3a564be4bb606f17f4bdfd3e","96b30ddccdb24c79afdc19bb80869efd","92f2af15f0174c21b2f4b1bae5bb7870","f5be3d984f424192ba385ea172f640bf","2e7cd9aca96f46cb9d2c3e508bbd8a48","9db33a180bb14a8eac486e28e428a2b7","fc5a34c076dc41cca2b819774395e807","ee043893a91841d8922c304d106f178b","31fde0bd3cb44a2ea55e8558fca6ea5d","9ed53489734444c690def02151f6d0bc","08b636f96030495a92e0c18e5dbb4906","33391d9949964b7092c72f9fb88eacd9","e3f735721f4b4f6e9ccd82c3292b2ae2","b9f01ba2986749d5b3b1619f736d8b03","25c0d7f999db4ce88947f3eab89fa0ab","87f99b2e890d4053b47b064ae110050c","48721e3c6c82426f935cfa5366afb423","50287a5e50c04143bd8ab8757856bd09","9c5666eeaa1245d998147c8159d729b6","dc60d653f8e74cc2ae5a5a66e82e9f06","1da779c9f40a4fa19265fbe010a17445","7e04c57039fb4423957d82b45289c869","7f60832b762c46eaab2b39f71e65709a","ae2a902273c84b15ba4cc2feee625ee6","52197e33555348c1b31d0d7f98c53b33","0a064eb6c5524fa6b49a33d9a4f3b274","c5c8f54c7f214dd3bf1f9472bd27f5f5","5e46e4e97cf044a39ea9a7f4813020ad","f3ccf0f0fc2f43e997315bb983d41e6a","381db2e3eb6d4e50bf0226d8c322edda","de2f775e2a904f9491f41746741d470e","59bd73f74a924651a58affcd49b4713d","9c0df71c6fa84ac79f369252c5513633","75cfe95385cc47acaabc001048e21977","9530b22a45074b6cadf20c3cda69b338","6b6855546ca4418992af41b3c244250d","7348ce0cea9c4044b362e32c5f21e08b","3c2867e50f8e491dac7c7cc6745faaff","facb983e185f4d8a9414c10e5d10d065","0aeabd212650407abd2de32baf4fbb39","586d57997ed04e05b1eef13a4ff088cd","93eaf8650c6147d0817cad94746213e0","4e54e63b449446b18db518c1652151c4","1494017b65f64c05aa7eb64c1652e2ba","cfdee12bd79840c9ad7df8b345ae2963","d5ce996bd30d40ac92fdbd8d32b16cce","38f3532d36bc4f4b8a54264adbb7292e","25a462020a634c25a7d391f995aaa611","072d9c87d6014117a634e3d6b1977d15","9212e86583a246ab8f2ba78aa929a7db","e17b444049ae44a7820bf3944985cf71","d1eab643a3654cb69e5ead2017d43496","314db16cae9440e2b14ee430179daef4","aabdc8656b5a4b4f955c50251439e59c","5f186e623a78432cb5fa1932c3896700","4cd6ad36a3b4408fa3d027b484ee06e7","d64fe3e507ec4ea8be5f22b07aa2b08d","8ad04b8f8cfa49ce93dbbdfd31ff569e","c7d40adafb124f6f88fd6d2cb248b87b","cbb22190e2b84094aeb2caabd281844a","e36c0240f7b84833abe206ec861f8c9f","296e0800d26f4252a94567fe7396b0c0","46aafa0be1044e23b5218b6c201854a9","3fc359d79c7048df837ac874329bed44","b518a2837f084f42b47ab6cade347e98","36458764667d4454b4fe5430b859fff7","563f54a9020e4addab65289bde8dd8e7","1a68b53fe08947ed8a76724951aabeee","1bc7993b70e94e718718db8151e353e2","21cbeb569f3243c0a3b0624be4a3768e","ba6d8377174d44089ae1a7fc49426904","f5977ee5ed934d81a0210322373f4dfd","6b8e6d8e70694db297d7fb336f249140","8e53d0f3c2824459b6de716fe3df1f07","e24d44e037934c829c0f3d56bb1a9c46","cac84cc9ba1845ab95f499997b446522","0122b207005d42a18e8b1fef2194b905","f40d9443163f49e789a0004991de1662","9237c97f66b3402bb1f9cc8a7554768a","136aebad3ec74eb79787650a25225758","06fa7bada83043f08c3af520e4ec6835","23698d8f980d4bf0a9b63460e90537f2","18d942b5acf04b2e9d2cebbe49561b9e","8eba4c057865466eb61ef67a21610a90","6a70743e69d64bf887e758f89ff03522","60b2ce894c904dda932980b884b29485","d073c051adff42bba00c63979e48e610","f86e6dd437d04e0bbfa8224619d582ff","1143a652a95d40089e86d18a5e797557","3b3c66493e594634bbc988feee1aa34e","82111cfc670241de8f0fb43d276c5c86","8130136eba684ddc93cd9c923df72d4b","e10ef4274f194b03a380facd44efe57a","f60af430525f424b91cd5983696798b0","a42f225e928a4e179a599366fe065718","5110c26b2fbc46c7a987f01d87155dc8","faa476f3d5d84194afa19533d073d201","f27835b54e1445df8eaaa971e3fcd0a1","8640fe9c1e6b441b8e33ce7b0c54371f","41b2be32d9464640befc183de504a135","ee5f07b30c8f48dda7a5ff27df6cc939","d3b39d25964147389ff0318de58d1d5e","c5deed3a4eeb49c79b9bc903ac5cc3b1","b73fa00ab1904cc787d097c5ad1dc876","cbe939eca3ee4433bb0d02ecadbfc38d","6e81af863021473ba78e0598f0a5f0ba","9ed7ba21263c4c58b974770427c7c0fd","2c771c99a477461bb8b1001dac6988b5","6da3c7f3150a4290bf261394540dcf47","a4ed494da6c844fdbd8d5e00387c85ef","8fc6e7fc760642eb8ba8989c734a4ff5","83644d36a1e949ebbe8c80dba5aa9311","b44023a1c31047a1b4fab8961d55e0e1","ccb98c9ed70d446c8148ff574789d9a0","ecaacec3ef9143e28ce74b3c26f1a6a5","de3df124721b49e7ad603308de2f95e0","dd8b41d4db13456d827e51aff522bcc9","13b80338daf845d6a3d42b0ebb17a332","297bafca5f344c2da179ef53caae53d3","25f9f6ad4b7647d693612fff3cb1221e","d0e68b794d69439caae92e425ef09a0f","8cf04158a7884a5884fe360c7ea58528","b60c085fc7c347cd8b8406f34fa6603c","4847e0e7c1924f5bbd946c90b3b9b2fa","369f2091a11645d0847343faba362ed3","f0cd8669fd7042a6bf86bd77ab4b4511","66d6d8b8695e4db6b847043acdcb26a1","5b83cf999e4f44cf9d3582610cad5dc2","b0f9fb069a3b4a9cb5c18b27feb42973","4e621f77485a468f99ee9ae18b95e1e0","f02f8725ad954db0a1a1d4a98246e3cf","2c150d2eb84e4bd8928f47cd853027a5","c262daceb5834d6ab400b6084299858c","99235966179e42e291909f1a6441bfac","909b390a13e84d2199f6c20462d7184b","dcc703ddcbb64121a959856b4e223f08","ff20b55ec7cf444fb14099376ed5bf1e","7956c60efcdc4fb58b9a749e03e5e7ed","82014b3323ef4b43b265fb3eadf6f32e","9e85fb466ba041569a36a54c36c153fc","bee96107a97e4053b92dc0ac9dab30b4","17f00e84b7fd46dd963e5528d9f829e7","ff492de90ee14d6b942fe1026dd5725a","f293eb32f5774ff693950e7304458491","4e0a9ef0e17948489d001a4645baa101","e6cb73530c0d46fd82d1176fcc2ac83f","675eeef8efdf4331842ee9c2d651b8ab","9aafd31426a34af59431e46355cbbe0b","4dc1a78fadb94703a5537c8f1ea5f5df","253eb4eee4e04606bf25ff00a6a2025d","bc45473b4a7b4a3495a3b9f8455ae314","90faa1a65dfa4d9d80bf4c70da4c031c","f407a4499f3140f0b27ba3647f2122cb","38f2aefd4ed842639fc08b00ce15a978","fd0dfe7f66884867b2682e49a212c504","8ae4f885df9b47dcb7f9963a2cc97402","7b8e77e7c5c4419db1d1e152caecfdf3","190d5e549ed74ce9ab5cbafa8a040d05","91e983bad51a4041be94b65badf26c6a","a0d01af739e94d55a66a8500956d2520","f478af4c41a84f2a93865dd6c9e0d709","9faaf981dd13431a8f2daa327555b08b","f13875b4162a40819ba83b571efc5f64","b337cf21dcfc45e29cfd7deea1490ec6","74aef966e9464c77bc5a0dd6733da99e","99397fe2e0e24079ab64af8c35949a37","23a8a7180c724fd19b04534406955536","de2e1715723a4fd98502560cd385b1c9","53bddf7d2ad1416eaf37686f8bb15da5","75b91e301b9d47258d8d7354f0cdd6ea","96a9c1c9c0364607a21c47daea20d583","ec9ac5be655743ecba40eea3d7422987","ab7d527956704cc1a136c41f736c4f03","78c32ae20969485ba8df93cc38816a4c","666ec0db5a57437a87d76142f0721115","4349b540e3e44821bd964b625f22e7c6","e4f6874348eb424696d3ed889fa49e83","f6777df9d8b846719a3c5d0cd880ee32","f74bbaeba8534f6bbdd6aa5fa31fbb50","aec6c8c48b534c73851c56a4ae1b5466","aa87b632861e435a97d38fadfc010193","eaf5b80144c64c4abcf376ba56815a0d","51937659928147a0945709c7d4d691d5","6533ee6a3b1a4e03b51e7d55b9ac72c3","67bbe6c81665405e97de9728a76f6676","d51b8d504d8f4572af5b595628fd423e","3dfd6af94e5441ea998b4f0ef122653b","c5273fa5a5c7489b91f1dcde1d4ecae0","3c1343130f964dd0b2e6f21a6a2ab37b","94098070e2724fd882ef9493df6dfe82","2dd30133d1114d80b6d4def9dbfd992d","959dd00925394a58b12260880aedd1b1","3a8fd820f3f94a09ae269d00ce8b2b5f","6d8ae762c9ee4989afb65a2ed506372e","bbab89595b1f4cba8a5ea1319a3ea0a9","73ceb15dc1234a3bbfad5d519c5255eb","4448e9c64aef4096afb921185bd1044c","04695caecf8b4590bb9f5e296524ddc9","a01531e024f24bd78e85614266ba3ba1","92137f93800b4ed99e9d729bccdf9023","1e7b3a2fd1e1473fa03cd431d96e2add","27832513f241405886d402fc0667c6c7","56fc7f11e4b94f479808ae825f9b6338","1d2bc9665877484a9aabc2f6f7ae925d","1415494b1fcc482a9c33bd9ab86e6d22","fb753fd000af42dfbec21c3b62d188f7","74b01f230af44d8eb0d945d8ac7a376d","cb81c664d2d04cc58f76d52b692ac022","9f62235019fc454d98b3d21676408c61","364b650589534e659c5396b7a17c327f","fa5e20582ae9445385646570ba5ae045","de0d200af4a64b42a8d87853bc3df795","bc9d133deff34f708a760e92e8b666a9","84f3970823a54a06b33df01ffbb9dfec","d5b6ebf02be14ab5a8a387aa13df3c7b","028b7f36c89347e180d97b76320ef43a","9ba657966c81483f9916193fe447cc3e","a6621b45cce44ffdbdd694fe1be53398","f9622981c64b4f4db1d535110187456b","1500a80501bb40c8a29908cf092b013b","db59cd3aacf648a6adf56c0f8d071a06","ffd7494d127b4eb099de4574259d5e2e","fbc66d6a38c04a519096a7e3384e2810","b801dc85d29a4bc9a232e86b6f545ffc","f5d7910796f346d09013d0c8c211a6c4","2ec0cc6bbbaa4d82b6bdd36913d043c2","e22cea7ea4d54357b185998775568de4","bc6dcd91d15c4d50baa11196ea0c3c34","f5baa4bddfdb40ac9e58e9496b4e1a02","1034b6051a8a4ad59cff5446fc1e6b64","db2d59ffae5e45af856a6c9d86f58106","f8e859b2664a47979317f30651c978b4","dfa61a1873d24c1aa7089a16b30bb48c","0eb4efaa5bb043d98b5938823ce6e561","b723fadcc50743e19f7e67f09705b89b","dfae425162094983b684ec084fa040fd","dd4fae91f5394fb19e7b57a171d4220a","d7f4fc124a884ae39911c4630c6e4a3f","bb3aba9914584b2bb9ba6d33093fd130","5f730f91d05d4e479f7fdc73904d8b49","5650d8b47f974ed1a0f21ea8c99f7856","b8bed01f4acd4e26a63263c62a36bc07","bccf1ebdf9c04ac1821acae0738a2657","b637535797a24c359eb2b5daa8b8669a","d9cb3169b49e4af3be856c0e18c3df41","012695287f344912b35bf73f3a362a04","257a0a5db21242599cf87c3e04ce9e0d","fe64aac2c4264b93a7f9f64ec10a02b7","8ae724ad00e24addb4576eb81d5676f5","f6961fd343ac40c0b9a3966bcdd3c5a7","1658fec61b744ee985bc2eacec8c6225","69d322ff34064b919ee977e07a9c03a2","776cb9b21b3c493490e1e79efc86dbed","63dbb284e0cd4e47aad78b32ca0c32f7","458ccb4664f441fb8862af48ce2a6d07","cf2a9f431bd74f7fb5e8614c1496ec05","cc9b8c99b84c472ab30c6dc1e709957b","4c18f9d086af47188078f3ec7e2fcb5c","991bb8df6a554774ab2615eb13b6c4c3","c00e3006aaa044baba2d5ffe81ce7556","3cdebc6ac70b487187da76d8c17b56f2","1cebf578ac8e459185b2f836a1819b51","0524b78bc3ee4316bfcfd4ab1b60e015","56395cfe0a1e415e9e9be34752d80ac4","6e66248891184ca180f1529b85f8b480","c55da4ca4f114023ab19621601045e94","13bbcb32c8b945e0b5e9eb7aa97d8696","cce1a9b6e3174c88b03272d40875d802","401403228b7e44f6b94f5bb2f313a791","9a0a576050ad4c7caabb66698f019ffa","36ef27cf276c4d068ee181e09cd186d3","f63955c0fa044973b526fefcf0fed4db","5bd55e3917e442c6be9bb0e0067578a0","a89fe53070a042808a500171c9b5fa30","1340905265814d7d9cc764d5f8a95211","a08ffd11232140e18ed7f6fe6cedd62e","ae9560a316fc4407a71de627490c63d3","54c9e9d6a16845a387a5203c05c02dba","6999335bc32a469d92d7ec8b7fc4b694","028f4ffd115e493498b34e4c63c55506","7d852835b8bf4293b6975bdad190e281","669a4f83cff44eb6a1098fb78fab81ac","63d1056ef5ea47bba80b45af16cf22e1","229b1ba226f74102871157965834b407","a5fef24112a544f2828dbc024a645553","b643a642f1624404a86714ab90071069","090c494ca1f94e0698d6d08e985a6bf3","cca28d432a8b494d8b285f12ea3ccb20","58e8550bc1714fb984344ca35cfa459a","3fd0d8b29c454ce6b467253793534728","b5383b8c4b48442899ad1fa681d21aca","e066e2e2823a472fb398f9055a2fe2f1","f80398ea607a48cd9011cdf3901a9e92","91540f92b6da49bba1d3868b35bf2b3c","9996ea2beb9248c6bcdebcc44f10d5f2","dc0fe4ee08e345eaab68205e7a145529","ca4e710eb1054a0981d4755b271f408e","80cf46da811a4fa3b56f94f34082cf26","250e5146a9be4f68962ceb1fce539229","c09dc3208f0346d8afb883552101b3da","ecfed519751648c192fb1584eba9c610","3ac0159d06ef4c879edccfff28e586c3","028c019d76764cffa5e1d29600915730","fe3dfd2ae8ed4f759ec79af37b3ea215","310e3c74639b4597ac558c937117682f","7798501f51a445a5a2fc67a7bec913b3","720c713762504ad4aea35ddbd6b65965","f3c04a98e57b4aabb50d4c86c9dc35df","6e14416ddb4f4eb999adf5aeee0b522c","117804ca1ab349be8131aaa10ae4fc3c","f61ce0d0e5994b7fbf8238086a71e097","cdf3d2bb6d4c4ff187b488eb6434876f","3c82ff2ff8a14790a45fa9bd14f023a5","3f7b7f9dfa5846babf2aed2dbeb49e73","08f80a25b8d04692976b84dc0538b52e","f7b14d9b605e4e9c9b3958287daf3ace","6251bdd958df4778be700a65b6a3ee87","391da880ac8946ceaafa3341386ae8f3","3c08b31beae743558c91600cd3995e37","fc38b0ece5514877ac81650a6dbf26c2","3972f7b079904d218350ac9b3363a6e0","c9589583baac407fb032a526f28375d6","c9cb8c94f9c246a78e9fe36bf1db591b","3b4f671e9e0b45918242d45086bbd608","d981d7d0150d4fa89b8e9cfaa631eaaa","697c6419ea0843cb93b28432ab825406","0a8f7c6176764ab08ace8f3dc1d11183","4bcd126bfa9941ef93df451ed7bf235f","e36a6305d398425aaaf0dcc4d0277cb3","8c26e3ddf52f4862a345c1afb1b2f903","05700be32679479e8b109e265b297426","bbf34cdf007d46a1923c06d6192b38a9","a7199140a6084038ba9a4468176e6106","db29f5dd40f94ee5be89b21d3c742854","59df51070e514b2f98c5314943240807","1fbe7efa01234f13b100467b172b573b","162e3e0f5d9f4a109012241aa38b429b","5d46e384b67c449f8775c1150d8074e4","94e1655664a54ad4a97c800fb3556b2b","4d929b7c83084ecaa062ff309a6a9505","3bdf808e77104e3bb54d5088642cac8e","2385c08b047c47ccb51b3dad007f21c4","effed6ad1d8440718aafab41f1c67509","5f2082e7f704412ea280ccffbfda87b9","67e9cf5b24a84f22b3281dc5c2dcdc54","b9cc6c8b00244d6e8faf518049aea16e","fb0a5d24d7364df8b609a7de47d6de1f","dd091ed8059a46a58e09389a43763ec7","d4ea71fa9b224b72a231a6d5ffac1788","f281cd80ed3a4f2a8eb9166508f8339e","037d738ded7f42d081c3e7cb430fd064","bae69315e9104a4f858939492ee7f6c2","5fd4e433ef7d433f8e44348a35b895f8","74c7859c8f8e4dd58d13171139d85f8f","9ffb6dca25794cbc99de10c5ed399a55","8b98433a62614a5795f3b221a31944cf","d12b2f4b031b4402b22b60a022e2dc41","9fc0e3ff447a4edbba6a43a546253f0b","ebec484288764afbb99b58fe1113653d","ecfe0861a13e4ea8abd05f24231b8d44","5ce09e7219b84b0cba539b9bfc52fa71","35a75e67950747a4a561a04c685f08c2","03145538866e4d3d829637053426e32d","f26d6262cf744082ad4c03ade9859b8b","9840ce4263f94411b44ae8c5687dd476","a5309f11bbc1407a860e29caf0265adc","bcbc616b31b943e79ffe882754044da7","f476e48433d74726acd1f79c93ef7d8c","f2fdb5661b6648579de5e3847a89ba72","f95fe9144f8a42e4a1f0e9d49b06f8df","d53c12a30a0741f9985678bb743ad28c","571276a6352d4f58a6f35ce7cbe47ff5","f29a790e36664f36adca36a1a837b0cc","fbcfcc4200af40de8843f52f463733df","a359e578a99f415095658e2841372bc4","b7ce6c9279e94656b0075e5347fbce6c","ae9a7da999d94cffad55634e37d6433c","ff38963aa93a4ecb9054e49a4c5c7582","388fdf2aa05f458dbb38256502296111","2e18d29497184c6698c146963cafb2fc","eda84f7ec2e64027a28e8bb335a58f00","5630ef14214947f6b6375592887a9814","76c00ccb2e2f40b6b7e126beb81aa175","f3db0894f5dd4eeeb8c9cf923df50a4c","2e404fd3e7e94708816afe3e3ae96fd7","4c270c97c38d4a278763b775e4196dc6","c6d0917346064059923a45f1fb95186a","349a6b212cc846c797ca11dcf1e13700","95446967941546e98e405b91663c708e","89b2a7e959ef44a897165dc9bf98e043","cdc7436ed8b74a1e9d9abfbed12117f9","81fd5ec160da4ca9847a2c61a5ac1d47","1e943fbaae2149058e3d430299211706","b1082653ce9243408b35c0b614d4c719","ec56f27ed7b14767974cb1cab5ad9f93","31067398f0564b32b111a2568545188f","3b1c542d711a4bb79c1908e11523d0f7","1c2400e6ad50470c883dc3647c306f87","9d45a9dc289c4caea17b4b2571eb0eff","2a6970c9aba641348390f726172c37e0","72d785321af34bbfb8d62adc125b3d87","c85d884efb264965ac490a68100694f8","9f4db2ed87684ae8bf411eb6bff4b99d","316adf58d19f45569143df31fb3b50f1","ed70cd4d511940c4bafd3a8ad0759b20","e7acc69c9a494cc593e1aac5e47337a8","d4d63c399a274f078e7367e4e5bc4f76","26779c763f364353b0462b1d5e23ecd1","e219e73cb53b4263b895fd4a3176c8d6","34ef1fb549d949dc86baad2bf1261ff3","55f75050f94841dda061bf492f8dcf7a","817808dd31134ae38209c6273c58e746","ee0c602f83e74dbd87b2cdba5149202c","5569dc9f7fa84dbcb36d6e6cd3bdc71a","022cf591a51d4287bb05161489d6aa36","b951e70b93444f3496bd3710c1aceea3","fe7fae7fe6df4ea293023254449ac79f","9e8b7a6acf684e069a65de1a44b18c56","32502230f5fe4e8ca8e71257a49e38e7","f706d080bfea4add875802d2d3d90c97","370a414b6d9349b4a5f52fc68148ddf6","44addfabf755467e9cc08ffefae310d3","57b69293d7a242f5873c8bf2f84a9c07","e3e846aeacec44faa35d2143161e0fe7","cf2a2fb4642f465eae78e3733f022590","1ece4dc3a039459cb1581f1629340e08","285791d9d32847879394aa457c3acf5a","3ff14f5cd4ae4e42926e3cef073ad64f","68f7d7051b214e219646b3ceee4483a9","fc68d695c8874cb99ccb6303ac0d28c9","44f11828888a4008be7c54b9bd63a5eb","c5f918262fbc4b9d83bf6541a1f266ba","03d64b143040400c99fdc145d4ccbe67","0a28fe8fae96492fb3eefdad23c354d7","169366fda41e49599ad78431332ab8eb","2e47ecc865dc465292ed090376b8040f","941663eded2845f39af788a69a496073","0166755b4b7f4bbba8525bf50b66d09d","66d4cf4b3723407db7aaf2bf81be6ffd","f9a03c1d15a9486b8bc7fc643dae8865","094827a9aad94eada2f991cada9a2574","d70b1ded29534602aee04c4d3f947001","76633b1b689a45fda0dce7546f0b5d35","73763c3edcf448caa5fc2b7a78104571","7f6c99954aba436b946e8032e1baa6ea","d9876890f3c64c2dbe667909b8899f9e","856878c30c064523af1b1e1d2d453a36","c13328c79f7e42dda63aa08a867d4451","7faefb7637a04a8ebb0625f87631e4ec","2bfa692ea15844b98c0520ca0653b3c0","c0f4b975cecb4a1e9769766b26f98261","8e5811b56fa747f9982ff1fe90781bbb","5617ea3cb4014757b611757d4852e258","cb8b84024b27443a976d6378d799f0ba","e6f0c559b603408386ad5bd2891b8cf0","9ea149fbdc004aa286bc392404667a84","efd7ff5250e04ad3a6a2cc6b88b4add5","5c6362f67a154b3e8bf56dc2cf219b22","e25e62cafe8f477e9692c1f7bcc50a39","c55b85fec4dd47faae3b4dd95e5c40ca","bb9fd2cb05194245b2597ab1fb50e463","030873c0e5bb451989a261cfb76f343f","e53f2026df2d4736bc9b45ee33436fc0","acbf4845ae10419e90c477501e93a8a7","ff2fe2912452428dba06cbbae43fa1d8","4bbdfb0d81fd4b258fa2b5b7de207c23","cceeead0148244a28edbd9a7c4497df7","64c47e7a59d5454c844e8454dd865d6f","765552dd8a924931aaa5012f2827a50d","7a80c9da3a404dd981fa15a5c6369b0d","767632fc7ae348c6bdb95e4f3c18f7e6","2d6020218bf543168bf8f8480822fa93","e89405ace2c44c8b8c51b131f5f17908","cc27813e2dff498b9d26c331d9c074fb","181cdd5e6eaa4f90b2e15bd21112cb92","e49c33cc6567471a8461edc2b78e1588","3f5ceb724c4449f488aeba356ee72715","06abb65de6cb4b5daf324d8edb260ef6","f589fa71b21145149d7c82151e04ce38","dfb50adf812140709394faee0b438589","771c2c3c62f2439e851542e0d1b505a9","f815f1c9eabd4671b69cefbce297c99b","7654b26fc6a249eebd0b8b3ebadebc52","0191d9b5211444fa8cad721270b0b54d","2fdb4f5368ee4d088da77527cbe5b06f","872570368ce74214bdb57557b13fc915","66585f1e98eb4d71a3914ad3e175fd06","e7c528251a194bb69b61a73a5b4eeba5","bf672e1099404a38af7b1eb66ca3c0d7","0be58dd37e9d46f485964659de0e6b48","590d009de52a48cc9673a6a2e00aced8","df4483c5d2924518b228186e7bf844a6","7dc91e6213a04436974ac8102e4a6263","e7186ec776174613ab73fada27d4d076","59f4fddd66f948ac98d4c6530f830864","058633dd60ea4f76948317b7c2fcd32e","371880989f5742d4a2faffcfc36fe83b","5d3085dcdafe47c9aee23df53a6c2b1a","efaeadf50a824012a697f74f0b1d8b88","4764edd9ef644210948fcf1a2f24acbe","d1d56f3273eb4f60a114a53b4578200a","9ccdbccc0c9841ffb1ef0a099433b66c","ee3f23e2cb1343468bd87aca48d8f901","dd9ada9335ee4c2894c2e377f7b363ae","8a977d61470a448a8b1c8de6da64aad6","3e7338e2253347a4bdbf917d11203f6d","ac2883457dc34398974398cd8aa7ae28","b79f3ca27ef84de3a2d54831b9f9946f","4c196a9a279e4765ad3281f3b21fa693","c0ff88f8518f466198a67f4d63f5aede","9d8c98d05a58404db8cfe46dfec32d70","d7aaedc5aded45b88f949c5ff995ccf9","70f84d799b514bbfb3aa64d6853aed13","853333ea86414bb99912556e86857596","4e355540780a409a9c6c5bda8e235893","03edb7f1c34e4d898e3503aeedf74a24","0c53416c4e2a423d98e52cfd76b88cd1","93517525ce2d4e1db27d2513a0addcb9","20615db287b94c3e8c2e6a9c0c23a554","359a25a838744533940a36f520098ba3","28380dcf513549d486886d607257fe35","710e63926fb74266ade104c63ef58e94","c5865ffee5d544b6b5a349b51e6cb3c0","c4305ec5a3a3473d84d24addae866c84","c46aee66ae5741789a3ed634f9e1dc2f","e06a23bddf014a1b989afce5127f69ad","89997fa88c7a40a8bfca1f8b9afffcfc","68cf079c02ee4a869a01b1bb210f5de6","931d34fccb224a5998c1ed41cefa4cf6","590495d12907460faed6c26bff0b80c7","e4f01c14983e477b9f4b8dcef6e69030","5c869bdd8f5340b2bd19639b1100de2c","1726260336c545c0a69236409817f058","b7312e6135d04bea8bc50c451f01363d","6420643e44234105a449182370c6b79d","ade157da0a33484d966a3fd576d831f1","389118ac1d884c778d9107658d1bf281","65d54ffa85ed41378ad8a7960cafda03","5ebc21c096b342cfbbfda7b1a9c94bda","7200925e79964b119c8fc6b8610f3362","97d2050c88b04640802a964661f7c324","26dad6a699b14e00a0f2726fe93158f8","9271372a449e40afa800760d47626991","557ca72213104c98b8f99d6a4be94b19","3a62841f7af94709a60414647a2ca9d5","03f49210e70044c7a1b1345571e8e13d"};
        Map<String,String> err_inp_reqIDMap = new HashMap<>(err_inp_reqIDs.length);
        for (String tmp1 :err_inp_reqIDs){
            err_inp_reqIDMap.put(tmp1,"err_inp");
        }
        System.out.println("err_inp_reqIDMap大小:"+err_inp_reqIDMap.size());


        List<String> lineList = ReadOrWriteTxt.readTxtList("D:\\用户目录\\Downloads\\生产数据\\lhp_D2_20170209_20191025_01.txt");
        System.out.println("lineList:"+lineList.size());
        String fileName = "D:\\用户目录\\Downloads\\生产数据\\new_lhp_D2_20170209_20191025_01.txt";

        for(int i=0;i<lineList.size();i++){
            String w_str = "";

            String str = lineList.get(i);
            if(str.length() < 30 ){//#applyInfo   #singleLoanAccountInfo
                continue;
            }
            JSONObject jsonObj= JSONObject.parseObject(str);
            String reqId = jsonObj.getString("reqID");
            JSONObject business = jsonObj.getJSONObject("finTechAgencyBusiness");



            if(err_inp_reqIDMap.containsKey(reqId)){

                String orderID = business.getString("orderID");
                w_str = ok_data_Map.get(orderID);
                writeLog("reqId="+reqId+" Find, orderID find "+(StringUtils.isNotBlank(w_str))+":"+w_str);
            }else{
                business.remove("institutionalFundingPartnerLoanID");//资金合作方贷款/授信账户编号
                business.remove("preCreditLimit");//预授信额度
                jsonObj.put("finTechAgencyBusiness",business);
                w_str = jsonObj.toJSONString();
            }

            try {
                FileUtils.write(new File(fileName), w_str+"\r\n", "UTF-8", true);
            } catch (IOException e) {
                System.err.println("build data,"+e);
            }

        }
        System.err.println("build data finTechAgencyBusiness end.");
    }


    public static void buildD2_logicerror() {
        //D2
        String[] err_log_reqIDs = {"57844b269b6649fe9a5e158cd5c97c10","40d9f1a6f26743cda30c2c87ce355481","43c54d432e744619bc96ec590686109d","3515fdadf6ff4d6b807e37d662fe3c87","56985b6b687749b3ba10285d432212a7","ab79eff039974529b2ceb13f2987866b","8aa294edf7cd478591f4b18e6ba8efec","4fb182a5b6e649daa7641b2b233ae5f3","60f333676c4e447996967cc2b1e3a616","f1c1b185a8a0411aa037392aeba6d923","eafc3e242ee340ce824c1fc545241a9b","2398fe0bee7a41d1b10d9fd785321ff6","3a02163e803943309fd96bddc8731563","b3ea444f9c544259b6d90da0ac267986","2786e5abf6574aa48ce0224a3f7bb824","79e28b553abf46f6bf775de17010ef75","f0ef0862f741420fa6b5c8d89742279a","94e8d2a385ef43f38873c0a1e48cb214","7b1e9cd00ec14d588bbb31b181f14ab2","c0e5447f89ed4c1e926e6e4fae14951a","f5ab717d367049ac84e45446d1014f45","4d29bc60a9184d0f8712d0916ce748f9","743e704157b94deca6be0e015917a3a8","36d405b5be7c45329d6f59480de6ec4e","3c74bef561d34d4ca5927fefa165780d","e6ea83a66b7146dda9d24ef081c85a96","abd01441db1c4ffbae8ee9707b387f91","1393c0bbfb2b4a26ac04ccdf55cefc22","ca3817b2c9e645bea7d37834fc2aafed","414c0289bb2e41e0970b734f941640b4","cc4834ccd5e746008610f4468c0ffd08","857e13f3ecdb47ca8b913f550c7a2321","9058bc0fb8994e5bbdb5f927babfcf12","bbb27fe1440046179e77823791947eae","fc99cb58b0dc4d4d815b6e13e312412e","5b4e52f6686049f7b90d9074a9fd405c","8466d6558cbf4c3d8d62f0cc4de708f1","a4da148e6cb24ba28728c8fb0d0d0189","7c1d74da6b9e4d0d859d988683b455b0","2ac66e9f833a488b99203d988047c166","5785e78a79b143ee9d3c84e6f3f974a6","9b895385499747d0aa5302afdd04668d","04352b76815748febd5c1a2828f70ad6","2052f2ff465646d2bc84c91eaf104163","e769c9ecd53840aeab6b1c443ffc4375","61e5de3ba4b4449d98f717bc986e6058","9332995c4dfe4c62bb9dc4a8fe8c3cba","aee37ffa58a4460ca9262e7806c27cd0","0d12336183214614b912458a6d682a57","fe228f2899684da1a5b6c5ac3e3b4833","31f40f0f16ac4739baab13435c4991fc","4c0563a7d515485aa8ab8f0109c54384","d39f976494d744cd8450632972670507","3dbdd147e36140a6856c663c1a46f2dd","5ee5d7b3fb244b8bb3a1c16974673915","aef36f5964cf413595e53e2474301b6f","98bd1e20ec904460810a4cf62cea7c48","2b7514f450bc48f39969d0940b1cde4a","99c77303a2894f0b94710e72b12c568e","44d4d70cb3134b1e96df96dd5f64816f","96e3dff5ab764291988f962ca29b5deb","16693f15ca6b401dbc2607837ff9dd20","6b026e988b704e89a9d2144a7f43bd34","167fe6b806dd438389e4142f83bf4df7","7d0528a3b3b14a98b300b94bff121248","c49fd988b60b4548b1b2cf65c912eeb2","80bdbdc03cb14aecbe3f26a02ee479ce","c9a7d146fc0444299ff617b97fc32b93","2ee035da88904a7caf5e5236ac741add","348390596c2c415b91766bcaa98266d3","ae963fbad8e54bf0b20e59be24e91665","492ccc1de1114529bf67c63dd766ed3c"};
        Map<String,String> err_log_reqIDMap = new HashMap<>(err_log_reqIDs.length);
        for (String tmp1 : err_log_reqIDs){
            err_log_reqIDMap.put(tmp1,"err_log_reqIDs");
        }
        System.out.println("err_log_reqIDMap大小:"+err_log_reqIDMap.size());

        List<String> lineList = ReadOrWriteTxt.readTxtList("D:\\用户目录\\Downloads\\lhp_D2_20170209_20191025_TEST_01.txt");
        System.out.println("lineList:"+lineList.size());

        String fileName = "D:\\用户目录\\Downloads\\D2_TEST_logicerror_data.txt";

        for(int i=0;i<lineList.size();i++){
            String str = lineList.get(i);
            if(str.length() < 30 ){//#applyInfo   #singleLoanAccountInfo
                continue;
            }
            JSONObject jsonObj= JSONObject.parseObject(str);
            String reqId = jsonObj.getString("reqID");

            if(err_log_reqIDMap.containsKey(reqId)){
                try {
                    FileUtils.write(new File(fileName), jsonObj.toJSONString()+"\r\n", "UTF-8", true);
                } catch (IOException e) {
                    System.err.println("build data,"+e);
                }
            }
        }
        System.err.println("build data finTechAgencyBusiness end.");
    }



    public static void buildD3_logicerror() {

        List<String> logicerrorList = ReadOrWriteTxt.readTxtList("D:\\JavaTeam\\D3_build\\d3_041_errData.txt");
        Map<String,String> err_log_loanIdMap = new HashMap<>(logicerrorList.size());
        for (String strs : logicerrorList){
            String[] tmpArr = strs.split("[|]");
            err_log_loanIdMap.put(tmpArr[1],strs);
        }
        System.out.println("err_log_loanIdMap 大小:"+err_log_loanIdMap.size());



        List<String> lineList = ReadOrWriteTxt.readTxtList("D:\\JavaTeam\\D3_build\\D3_04.txt");
        System.out.println("lineList:"+lineList.size());
        String fileName = "D:\\JavaTeam\\D3_build\\new_D3_04.txt";

        int totalCount = 0,removeCount=0;
        for(int i=0;i<lineList.size();i++){
            System.out.println("START:"+i);

            String str = lineList.get(i);
            if(str.length() < 30 ){//#applyInfo   #singleLoanAccountInfo
                continue;
            }

            RepaymentInfoZhuDai repaymentLoanInfo = new Gson().fromJson(str, new TypeToken<RepaymentInfoZhuDai>(){}.getType());
            String loanId = repaymentLoanInfo.getLoanId();



            if(err_log_loanIdMap.containsKey(loanId)){
                //2|100011189|9|2019-02-22T00:00:00|
                String[] errMsgArr = err_log_loanIdMap.get(loanId).split("[|]");
                if(repaymentLoanInfo.getTermNo()==Integer.parseInt(errMsgArr[2]) && repaymentLoanInfo.getStatusConfirmAt().equals(errMsgArr[3])){
                    if(repaymentLoanInfo.getRealRepayment()==null || repaymentLoanInfo.getRealRepayment().intValue()==0){
                        if(repaymentLoanInfo.getRealRepaymentDate()==null || repaymentLoanInfo.getRealRepaymentDate().equals("")){
                            writeLog(JSON.toJSONString(repaymentLoanInfo));
                            removeCount++;
                            continue;
                        }
                    }
                }

            }

            try {
                FileUtils.write(new File(fileName), JSON.toJSONString(repaymentLoanInfo)+"\r\n", "UTF-8", true);
            } catch (IOException e) {
                System.err.println("build D3 data,"+e);
            }
            totalCount++;
        }
        System.out.println("build D3 end, lineList="+lineList.size()+",totalCount="+totalCount+",removeCount="+removeCount+", 合="+(totalCount+removeCount));
    }




        public static void main(String[] args) {
//        List<String> lineList = ReadOrWriteTxt.readTxtList("D:\\用户目录\\Downloads\\D2_M_01.txt");
//        System.out.println("lineList:"+lineList.size());
//        StringBuffer buff = new StringBuffer();
//        for(int i=0;i<lineList.size();i++){
//            String str = lineList.get(i);
//            JSONObject jsonObj= JSONObject.parseObject(str);
//            JSONObject business = jsonObj.getJSONObject("finTechAgencyBusiness");
//            //orderID
//            //relationID
//            buff.append("'"+business.getString("relationID")+"',");
//        }
//        System.out.println(buff.toString());


            //buildD2_inputerror();

           // buildD2_logicerror();

            buildD3_logicerror();

        }
}
