package cn.quantgroup.report.utils;

import cn.quantgroup.report.domain.tidbrisk.CallRecord3;
import com.alibaba.fastjson.JSON;
import lombok.extern.slf4j.Slf4j;

import javax.sql.DataSource;
import java.sql.*;
import java.util.List;

/**
 * @Author fengjunkai
 */
@Slf4j
public class JdbcUtils {

/*
    public static void prepareBatchUpdateExecuteTransactionid(String sql, List<CallRecord1> callRecord1s){
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = HIK_DATA_SOURCE.dataSourceJdbc.getConnection();
            ps = conn.prepareStatement(sql);
            conn.setAutoCommit(false);
//            String sql = "INSERT INTO `call_record` (`request_url`, `transaction_id`, `uuid`, `url_type`, `code`, `created_at`, `updated_at`) VALUES (?,?,?,?,?,?,?)";
            for (int i = 0; i < callRecord1s.size(); i++) {
                CallRecord1 callRecord1 = callRecord1s.get(i);
                ps.setString(1, callRecord1.getTransactionId());
                ps.setString(2, callRecord1.getUuid());
                ps.setString(3, callRecord1.getUrlType());
                ps.setString(4, callRecord1.getCode());
                ps.setTimestamp(5, callRecord1.getCreated_at());
                ps.setTimestamp(6, callRecord1.getUpdated_at());
                ps.addBatch();
            }
            ps.executeBatch();
            conn.commit();
        }catch(Exception e){
            System.out.println("======执行sqlException异常======"+sql+"\r\n");
            System.out.println("");
            e.printStackTrace();
        }finally {
            close(conn, ps,null);
        }
    }
*/

    private static void close(Connection conn, Statement st, ResultSet rs){
        try {
            if(rs!=null)
                rs.close();
            if(st!=null)
                st.close();
            if(conn!=null)
                conn.close();
        } catch (SQLException e) {
            e.printStackTrace();
        }

    }

    public static void batchUpdateExecuteCallRecord(DataSource dataSourceJdbc, String sql, List<CallRecord3> callRecord3List){
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = dataSourceJdbc.getConnection();
            ps = conn.prepareStatement(sql);
            conn.setAutoCommit(false);
            //"INSERT INTO `call_record` (`request_url`, `channel_type`, `channel_id`, `transaction_id`, `uuid`, `url_type`, `code`, `created_at`, `updated_at`) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?);"
            for (int i = 0; i < callRecord3List.size(); i++) {
                CallRecord3 callRecord3 = callRecord3List.get(i);
                ps.setString(1, callRecord3.getRequestUrl());
                ps.setString(2, callRecord3.getChannelType());
                ps.setString(3, callRecord3.getChannelId());
                ps.setString(4, callRecord3.getTransactionId());
                ps.setString(5, callRecord3.getUuid());
                ps.setString(6, callRecord3.getUrlType());
                ps.setInt(7, callRecord3.getCode());
                ps.setTimestamp(8, callRecord3.getCreatedAt());
                ps.setTimestamp(9, callRecord3.getUpdatedAt());
                ps.addBatch();
            }
            ps.executeBatch();
            conn.commit();
        }catch(Exception e){
           log.error("======执行batchUpdateExecuteCallRecord异常======"+sql+"\r\n",e);
           log.error("方法batchUpdateExecuteCallRecord异常, DATA: {} \n", JSON.toJSON(callRecord3List));
           e.printStackTrace();
        }finally {
            close(conn, ps,null);
        }
    }


}
