package cn.quantgroup.report.job;

import cn.quantgroup.report.service.baihang.BaiHangZhuDaiService;
import cn.quantgroup.report.service.manualTool.ManualToolService;
import cn.quantgroup.report.utils.dingtalk.DingTalk;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Stopwatch;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.TimeUnit;


/**
 * -----------------------------------------------------------------------------<br>
 * 描述: 一些繁琐的日正常工作task<br>
 * 作者：yanhui.Hao <br>
 * 时间：2020.03.11 <br>
 * 授权: (C) Copyright (c) 2017 <br>
 * 公司: 北京众信利民信息技术有限公司 <br>
 * -----------------------------------------------------------------------------
 */
@Component
public class RoutineWorkTask {

    private static final Logger log = LoggerFactory.getLogger(RoutineWorkTask.class);

    @Autowired
    private RedisTemplate<String, String> redisTemplate;

    @Autowired
    private DingTalk dingTalk;

    @Autowired
    private ManualToolService manualToolService;

    @Autowired
    BaiHangZhuDaiService baiHangZhuDaiService;


    /**
     * 百行报送工程RoutineWorkTask锁key
     */
    public static final String ROUTINE_WORK_BH_LOCK_KEY_1 = "ROUTINE_WORK_BH_LOCK_KEY_1";
    public static final String ROUTINE_WORK_BH_LOCK_KEY_2 = "ROUTINE_WORK_BH_LOCK_KEY_2";


    public static final String ZXLM_A1_INTERFACE_SEND = "ZXLM_A1_INTERFACE_SEND";
    public static final String ZXLM_D2_INTERFACE_SEND = "ZXLM_D2_INTERFACE_SEND";
    public static final String ZXLM_D3_INTERFACE_SEND = "ZXLM_D3_INTERFACE_SEND";

    //百行反馈日志（今天反馈日志是昨天05:00报送的），但最近百行反馈日志一直延迟,-1代表向前推一天，既昨天
    @Value("${baihang.backLog.delay.day}")
    public String BACKLOG_DELAY_DAY;

    @Async
    @Scheduled(cron = "0 0 18 * * ?")
    public void downloadLog() {
        //if (increment(ROUTINE_WORK_BH_LOCK_KEY_1)) {
        //    redisTemplate.expire(ROUTINE_WORK_BH_LOCK_KEY_1, 10, TimeUnit.SECONDS);
        String ip = getServerIp();
        if (StringUtils.isNotEmpty(ip) && (StringUtils.equalsAnyIgnoreCase(ip, "172.21.10.8", "172.17.0.122"))) {

            Stopwatch stopwatch = Stopwatch.createStarted();
            //yyyyMMdd
            //2020.03.19 本来今天查看今天的反馈日志（今天反馈日志是昨天05:00报送的），但最近百行反馈日志一直延迟1天
            String newDatenyr = getNewDatenyr();

            log.info("下载（众信利民助贷）百行反馈日志开始>>>>>>>>, newTime: {} , newDatenyr: {} ", LocalDateTime.now(), newDatenyr);

            //指定只有172.21.10.8服务器
            //String downloadUrl = "http://172.21.10.8:9021/manualtool/send/baihang?key=b5140fb2-2c85-4b5a-abcf-3e97528014db";

            String p1 = "L0hNMklnTjNPenA1aDdqSHpreld1UT09";
            String p2 = "UTg1UFN4SjN3TThuVXFIVEFUUFR0QT09";
            String p3 = "Mm12NTBKU1JkVFE3MjlCK3RnZTNRdz09";
            String p4 = "MmJJMzNUQVRMSXQ4V3VDbUswZGNlUT09";
            String p5 = newDatenyr;
            String secretKey = "UY1I5dHb3iq/DtEAm1f3yu7emYzlSvpFNPkxpOMSegqYJ08M2drTtNiqLyaxjbERWR0yS5CHPKpHwGjTXWHP3DEEDfXX4LhRtmiN1LIpZPdl87YWpDJ1qg07EN671JcY406oPbh7KsHFO0I0B32Hee1iZanKL4tzqmgF4dvsUNs=";

            String isSend = "false";//不自动报送
            String sendIncludeType = "D2,D3";//不不自动报送，该参数没有用
            String isProduct = "true";
            String errorCode = "D3_035,";//以后发现其他错误code，可以追加

            try {

                Stopwatch stopwatch1 = Stopwatch.createStarted();
                Map<String, String> resultMap = manualToolService.sendBaiHangData(p1, p2, p3, p4, p5, secretKey, isSend, errorCode, isProduct, sendIncludeType);
                log.info("下载&处理众信利民助贷反馈日志结束, result: {} , 耗时: {} ", JSONObject.toJSONString(resultMap), stopwatch1.stop().elapsed(TimeUnit.MILLISECONDS));

                if (resultMap != null) {
                    String success = resultMap.get("success");
                    String alarm = resultMap.get("alarm");
                    String isEmpty = resultMap.get("isEmpty");

                    if (StringUtils.isNotEmpty(success)) {
                        if (StringUtils.isNotEmpty(isEmpty)) {
                            //dingTalk.talk("Info", "下载&处理" + newDatenyr + "（ZXLM助贷）百行反馈日志结束", success);

                            if(StringUtils.isNotEmpty(alarm)){
                                //Thread.sleep(500);
                                dingTalk.talk_ToUser("下载"+newDatenyr+"（ZXLM助贷）百行反馈主日志文件不存在", "下载反馈主日志文件不存在，请注意确认或和百行联系！");
                            }else{
                                dingTalk.talk("Info", "下载&处理" + newDatenyr + "（ZXLM助贷）百行反馈日志结束——[OK]", success);
                            }

                            log.info("下载（众信利民助贷）百行反馈日志结束<<<<<<<<, newDatenyr: {}, 耗时: {} ", newDatenyr, stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
                            return;
                        } else {
                            dingTalk.talk("Info", "下载&处理" + newDatenyr + "（ZXLM助贷）百行反馈日志结束", success + "——[10分钟后将会自动重新报送，若有问题请及时停止！]");

                            String json_sq_A1 = resultMap.get("json_sq_A1");
                            if (StringUtils.isNotEmpty(json_sq_A1) && "true".equals(json_sq_A1)) {
                                setRedisValStr(ZXLM_A1_INTERFACE_SEND);
                            }

                            String json_fk_D2 = resultMap.get("json_fk_D2");
                            if (StringUtils.isNotEmpty(json_fk_D2) && "true".equals(json_fk_D2)) {
                                setRedisValStr(ZXLM_D2_INTERFACE_SEND);
                            }

                            String json_hk_D3 = resultMap.get("json_hk_D3");
                            if (StringUtils.isNotEmpty(json_hk_D3) && "true".equals(json_hk_D3)) {
                                setRedisValStr(ZXLM_D3_INTERFACE_SEND);
                            }

                            log.info("下载（众信利民助贷）百行反馈日志结束<<<<<<<<, newDatenyr: {}, 耗时: {} ", newDatenyr, stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
                            return;
                        }
                    }
                }
            } catch (Exception e) {
                log.error("下载（众信利民助贷）百行反馈日志异常<<<<<<<<, newDatenyr: {} ", newDatenyr, e);
                //dingTalk.talk("Error", "下载&处理（ZXLM助贷）百行反馈日志系统异常", "(" + newDatenyr + ") 异常信息：" + e.toString());
                dingTalk.talk_ToUser("下载&处理（ZXLM助贷）百行反馈日志系统异常", "(" + newDatenyr + ") 日常处理ZXLM助贷反馈日志系统异常,请尽快手动处理！！！");
                return;
            }


            dingTalk.talk_ToUser("下载（众信利民助贷）百行反馈日志未知异常", "下载 (" + newDatenyr + ") 反馈日志失败，请尽快手动处理！");
            log.info("下载（众信利民助贷）百行反馈日志结束<<<<<<<<, newDatenyr: {}, 耗时: {} ", newDatenyr, stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));

        }
    }


    @Async
    @Scheduled(cron = "0 10 18 * * ?")
    public void sendBaoSong() {
        //if (increment(ROUTINE_WORK_BH_LOCK_KEY_2)) {
        //    redisTemplate.expire(ROUTINE_WORK_BH_LOCK_KEY_2, 10, TimeUnit.SECONDS);
        String ip = getServerIp();
        if (StringUtils.isNotEmpty(ip) && (StringUtils.equalsAnyIgnoreCase(ip, "172.21.10.8", "172.17.0.122"))) {

            Stopwatch stopwatch = Stopwatch.createStarted();
            //yyyyMMdd
            String newDatenyr = getNewDatenyr();

            //指定只有172.21.10.8服务器   172.21.10.8:9021
            //String send_A1_url = "http://172.21.10.8:9021/zhudai/re_send/manual/buquan/mainApplySend?key=b5140fb2-2c85-4b5a-abcf-3e97528014db";
            //String send_D2_url = "http://172.21.10.8:9021/zhudai/re_send/manual/buquan/mainLoanInfoSend?key=b5140fb2-2c85-4b5a-abcf-3e97528014db";
            //String send_D3_url = "http://172.21.10.8:9021/zhudai/re_send/manual/buquan/mainRepaymentLoanInfo?key=b5140fb2-2c85-4b5a-abcf-3e97528014db";

            log.info("众信利民助贷-百行重新报送开始>>>>>>>>, newTime: {} , newDatenyr: {} ", LocalDateTime.now(), newDatenyr);

            if (getRedisValStr(ZXLM_A1_INTERFACE_SEND)) {
                try {
                    redisTemplate.delete(ZXLM_A1_INTERFACE_SEND);

                    String result = baiHangZhuDaiService.sendHandApplyToBaiHang(true, null);
                    log.info("众信利民助贷-百行重新报送A1结束, newTime: {} , newDatenyr: {} , result: {} ", LocalDateTime.now(), newDatenyr, result);

                    dingTalk.talk("Info", "ZXLM助贷-重新报送 A1 结束", "(" + newDatenyr + ")" + result);

                    Thread.sleep(3 * 1000);//3秒

                } catch (Exception e) {
                    log.error("（众信利民助贷）重新报送A1异常, newTime: {} , newDatenyr: {} ", LocalDateTime.now(), newDatenyr, e);
                    dingTalk.talk_ToUser("ZXLM助贷-重新报送 A1 异常", "(" + newDatenyr + ") A1报送异常,请尽快查看处理!");
                }
            }

            if (getRedisValStr(ZXLM_D2_INTERFACE_SEND)) {
                try {
                    redisTemplate.delete(ZXLM_D2_INTERFACE_SEND);

                    String result = baiHangZhuDaiService.sendHandLoaInfoReportToBaiHang2(true, null, "true");

                    log.info("众信利民助贷-百行重新报送D2结束, newTime: {} , newDatenyr: {} , result: {} ", LocalDateTime.now(), newDatenyr, result);

                    dingTalk.talk("Info", "ZXLM助贷-重新报送 D2 结束", "(" + newDatenyr + ")" + result);

                    Thread.sleep(10 * 1000);//10秒

                } catch (Exception e) {
                    log.error("（众信利民助贷）重新报送D2异常, newTime: {} , newDatenyr: {} ", LocalDateTime.now(), newDatenyr, e);
                    dingTalk.talk_ToUser("ZXLM助贷-重新报送 D2 异常", "(" + newDatenyr + ") D2报送异常,请尽快查看处理!");
                }
            }

            if (getRedisValStr(ZXLM_D3_INTERFACE_SEND)) {
                try {
                    redisTemplate.delete(ZXLM_D3_INTERFACE_SEND);

                    String result = baiHangZhuDaiService.sendHandRepaymentReportToBaiHang1(true, null);
                    log.info("众信利民助贷-百行重新报送D3结束, newTime: {} , newDatenyr: {} , result: {} ", LocalDateTime.now(), newDatenyr, result);

                    dingTalk.talk("Info", "ZXLM助贷-重新报送 D3 结束", "(" + newDatenyr + ")" + result);


                } catch (Exception e) {
                    log.error("（众信利民助贷）重新报送D3异常, newTime: {} , newDatenyr: {} ", LocalDateTime.now(), newDatenyr, e);
                    dingTalk.talk_ToUser("ZXLM助贷-重新报送 D3 异常", "(" + newDatenyr + ") D3报送异常,请尽快查看处理!");
                }
            }

            log.info("众信利民助贷-百行重新报送结束<<<<<<<<, newDatenyr: {}, 耗时: {} ", newDatenyr, stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
        }
    }


    private Boolean increment(String key) {
        Long increment = redisTemplate.opsForValue().increment(key, 1);
        return increment <= 1;
    }

    private void setRedisValStr(String key) {
        try {
            redisTemplate.opsForValue().set(key, "true", 15, TimeUnit.MINUTES);
        } catch (Exception e) {
            log.error("Redis中set值异常, key: {} ", key, e);
        }
    }

    private boolean getRedisValStr(String key) {
        String value = null;
        try {
            value = redisTemplate.opsForValue().get(key);
        } catch (Exception e) {
            log.error("Redis中get值异常, key: {} ", key, e);
        }

        if (StringUtils.isNotEmpty(value) && "true".equals(value)) {
            return true;
        } else {
            return false;
        }
    }


    private static String getServerIp() {
        try {
            Enumeration<NetworkInterface> allNetInterfaces = NetworkInterface.getNetworkInterfaces();
            while (allNetInterfaces.hasMoreElements()) {
                NetworkInterface netInterface = (NetworkInterface) allNetInterfaces.nextElement();
                Enumeration<InetAddress> addresses = netInterface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress ip = (InetAddress) addresses.nextElement();
                    if (ip != null
                            && ip instanceof Inet4Address
                            && !ip.isLoopbackAddress() // loopback地址即本机地址，IPv4的loopback范围是127.0.0.0 ~ 127.255.255.255
                            && ip.getHostAddress().indexOf(":") == -1) {
                        log.info("本机的IP = " + ip.getHostAddress());
                        return ip.getHostAddress();
                    }
                }
            }
        } catch (Exception e) {
            log.error("获取本地ip异常", e);
        }
        return null;
    }

    private String getNewDatenyr() {
        int bakDay = 0;
        if (StringUtils.isNotBlank(BACKLOG_DELAY_DAY)) {
            try {
                bakDay = Integer.parseInt(BACKLOG_DELAY_DAY);
            } catch (Exception e) {
                log.error("数字转换异常, BACKLOG_DELAY_DAY: {} ", BACKLOG_DELAY_DAY, e);
            }
        }

        //yyyy-MM-dd
        String newDatenyr = null;
        if (bakDay != 0) {
            newDatenyr = LocalDateTime.now().plusDays(bakDay).format(DateTimeFormatter.ISO_DATE);
        } else {
            newDatenyr = LocalDateTime.now().format(DateTimeFormatter.ISO_DATE);
        }
        newDatenyr = newDatenyr.replace("-", "");
        return newDatenyr;
    }


}
