package cn.quantgroup.report.utils;

import org.apache.commons.lang3.StringUtils;

public class MaskedUtils {
  public static String buildMaskedAccountNumber(String accountNumber) {
    return StringUtils.substring(accountNumber, accountNumber.length() - 4);
  }

  public static String buildMaskedAccountNumber4BitExposed(String accountNumber) {
    final String overlay = StringUtils.repeat("*", accountNumber.length() - 4);
    return StringUtils.overlay(accountNumber, overlay, 0, accountNumber.length() - 4);
  }

  public static String buildMaskedCorporateAccountNumber(String accountNumber) {
    return StringUtils.substring(accountNumber, accountNumber.length() - 4);
  }

  public static String buildMaskedIdentityNumber(String identityNumber) {
    if (identityNumber != null) {
      final String overlay = StringUtils.repeat("*", identityNumber.length() - 4);
      return StringUtils.overlay(identityNumber, overlay, 3, identityNumber.length() - 1);
    }
    return null;
  }

  public static String buildMaskedMobileNumber(String mobileNumber) {
    final String overlay = StringUtils.repeat("*", 4);
    return StringUtils.overlay(mobileNumber, overlay, 3, 7);
  }

  public static String buildMaskedName(String name) {
    if (StringUtils.isBlank(name)) {
      return name;
    }
    final String overlay = StringUtils.repeat("*", name.length() - 1);
    return StringUtils.overlay(name, overlay, 0, name.length() - 1);
  }

  public static String buildMaskedNameFirstBitExposed(String name) {
    if (name == null || name.length() <= 1) {
      return name;
    }
    final String overlay = StringUtils.repeat("*", name.length() - 1);
    return StringUtils.overlay(name, overlay, 1, name.length());
  }

  public static String buildMaskedMobileNumber7Bit(String mobileNumber) {
    final String overlay = StringUtils.repeat("*", 7);
    return StringUtils.overlay(mobileNumber, overlay, 0, 7);
  }

  public static String buildMaskedIdentityNumber7BitExposed(String identityNumber) {
    if (identityNumber != null) {
      final String overlay = StringUtils.repeat("*", identityNumber.length() - 7);
      return StringUtils.overlay(identityNumber, overlay, 3, identityNumber.length() - 4);
    }
    return null;
  }

  public static String buildMaskedCommonString(String string) {
    if (StringUtils.isBlank(string)) {
      return string;
    }
    if (string.length() > 15) {
      final String overlay = StringUtils.repeat("*", string.length() - 7);
      return StringUtils.overlay(string, overlay, 3, string.length() - 4);
    }
    if (string.length() > 10) {
      final String overlay = StringUtils.repeat("*", string.length() - 8);
      return StringUtils.overlay(string, overlay, 5, string.length() - 3);
    }
    if (string.length() > 5) {
      final String overlay = StringUtils.repeat("*", string.length() - 5);
      return StringUtils.overlay(string, overlay, 3, string.length() - 2);
    }
    final String overlay = StringUtils.repeat("*", string.length() - 1);
    return StringUtils.overlay(string, overlay, 1, string.length());
  }

  public static String buildMantissaMobileNumber(String mobileNumber) {
    return StringUtils.substring(mobileNumber, mobileNumber.length() - 4);
  }

  public static String buildMaskedIdentityNumberMantissa(String identityNumber) {
    if (StringUtils.isNotBlank(identityNumber)) {
      final String overlay = StringUtils.repeat("*", identityNumber.length() - 14);
      return StringUtils.overlay(identityNumber, overlay, 14, identityNumber.length());
    }
    return null;
  }

  public static String maskedMobileNumber7BitExposed(String mobileNumber) {
    if (StringUtils.isNotBlank(mobileNumber) && mobileNumber.length() >= 7) {
      final String overlay = StringUtils.repeat("*", mobileNumber.length() - 7);
      return StringUtils.overlay(mobileNumber, overlay, 7, mobileNumber.length());
    }
    return mobileNumber;
  }

  public static String maskedBankAccountNumber6BitExposed(String bankAccountNumber) {
    if (StringUtils.isNotBlank(bankAccountNumber) && bankAccountNumber.length() >= 6) {
      final String overlay = StringUtils.repeat("*", bankAccountNumber.length() - 6);
      return StringUtils.overlay(bankAccountNumber, overlay, 6, bankAccountNumber.length());
    }
    return bankAccountNumber;
  }

}
