package cn.quantgroup.report.service.manualTool;

import com.jcraft.jsch.*;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;

import java.io.*;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

@Slf4j
public class ShellUtils {

    // 字符编码默认是utf-8
    public static final String DEFAULT_CHART = "UTF-8";
    public static final String CHANNEL_TYPE_EXEC = "exec";
    public static final String CHANNEL_TYPE_SHELL = "shell";
    public static final String CHANNEL_TYPE_SFTP = "sftp";

    private static final String DEFAULT_CHANNEL_TYPE = CHANNEL_TYPE_EXEC;

    private static final Integer DEFAULT_PORT = 22;// 默认连接端口

    private String ip;
    private int port;
    private String userName;
    private String userPwd;

    private static final JSch jsch = new JSch();// session构造器
    private Session session = null;
    private ChannelShell channelShell = null;
    private ChannelExec channelExec = null;
    private ChannelSftp channelSftp = null;

    private InputStream inputStream = null;
    private OutputStream outputStream = null;
    private BufferedReader in = null;

    public static Lock LOCK = new ReentrantLock(); // 注意这个地方

    public ShellUtils(String ip, String username, String password) throws Exception {
        this.ip = ip;
        this.userName = username;
        this.userPwd = password;
        this.port = DEFAULT_PORT;
    }

    public ShellUtils(String ip, int port, String username, String password) throws Exception {
        this.ip = ip;
        this.userName = username;
        this.userPwd = password;
        this.port = port;
    }

    public Boolean login() {
        boolean flg = false;
        try {
            session = jsch.getSession(this.userName, this.ip, this.port);
            log.info("shellUtils login init session ok!");
            session.setPassword(this.userPwd);
            session.setConfig("StrictHostKeyChecking", "no");// 去掉连接确认的
            session.connect(30000);
            flg = true;
            log.info("shellUtils login session.connect ok!");
        } catch (JSchException e) {
            e.printStackTrace();
            log.error("shellUtils login error JSchException!", e);
        }
        return flg;
    }

    public void initChannel(String channelName) throws JSchException {
        if (StringUtils.isBlank(channelName)) {
            throw new JSchException();
        }
        try {
            if (CHANNEL_TYPE_EXEC.equals(channelName)) {

                this.channelExec = (ChannelExec) session.openChannel(this.CHANNEL_TYPE_EXEC);
                this.channelExec.connect();
                log.info("shellUtils openChannel >" + channelName + " channel ok!");

                this.inputStream = channelExec.getInputStream();
                this.outputStream = channelExec.getOutputStream();
                log.info("shellUtils channel >" + channelName + " get inputStream & outputStream ok!");

            } else if (CHANNEL_TYPE_SHELL.equals(channelName)) {

                this.channelShell = (ChannelShell) session.openChannel(this.CHANNEL_TYPE_SHELL);
                this.channelShell.connect();
                log.info("shellUtils openChannel >" + channelName + " channel ok!");

                this.inputStream = channelShell.getInputStream();
                this.outputStream = channelShell.getOutputStream();
                log.info("shellUtils channel >" + channelName + " get inputStream & outputStream ok!");

            } else if (CHANNEL_TYPE_SFTP.equals(channelName)) {

                this.channelSftp = (ChannelSftp) session.openChannel(this.CHANNEL_TYPE_SFTP);
                this.channelSftp.connect();
                log.info("shellUtils openChannel >" + channelName + " channel ok!");

                this.inputStream = channelSftp.getInputStream();
                this.outputStream = channelSftp.getOutputStream();
                log.info("shellUtils channel >" + channelName + " get inputStream & outputStream ok!");

            } else {

                this.channelExec = (ChannelExec) session.openChannel(this.DEFAULT_CHANNEL_TYPE);
                this.channelExec.connect();
                log.info("shellUtils openChannel >" + channelName + " channel ok!");

                this.inputStream = channelExec.getInputStream();
                this.outputStream = channelExec.getOutputStream();
                log.info("shellUtils channel >" + channelName + " get inputStream & outputStream ok!");
            }
        } catch (JSchException e) {
            e.printStackTrace();
            log.error("initChannel方法出现JSchException异常！", e);
        } catch (IOException e) {
            e.printStackTrace();
            log.error("initChannel方法出现IOException异常！", e);
        }
    }

    /**
     * 释放IO
     */
    public void ioclose() {
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
            if (this.outputStream != null) {
                this.outputStream.close();
            }
        } catch (IOException e) {
            e.printStackTrace();
            log.error("shellUtils ioclose error!", e);
        }
    }

    /**
     * 关闭通道
     */
    public void closeChannelShell() {
        try {
            this.in.close();
            if (this.channelShell != null) {
                this.channelShell.disconnect();
            }
            if (this.session != null) {
                this.session.disconnect();
            }
        } catch (Exception e) {
            e.printStackTrace();
            log.error("shellUtils closeChannelShell error!", e);
        }
    }

    public void execute(List<String> cmdList, boolean appendLast) {
        // this.LOCK.lock();
        synchronized (this.outputStream) {
            ///System.out.println("execute start." + cmdList.toString().replace("\n\r", "|"));
            try {
                if (this.outputStream == null) {
                    this.outputStream = channelShell.getOutputStream();
                }

                for (String cmd : cmdList) {
                    this.outputStream.write(cmd.getBytes());
                }

                if (appendLast) {
                    this.outputStream.write("echo '++CMD LAST++' \n\r".getBytes());
                }
                this.outputStream.flush();

                Thread.sleep(4000);
            } catch (IOException e) {
                e.printStackTrace();
                log.error("shellUtils execute error IOException!", e);
            } catch (InterruptedException e) {
                e.printStackTrace();
                log.error("shellUtils execute error InterruptedException! ", e);
            } finally {
                // this.LOCK.unlock();
                log.info("shellUtils execute end.");
            }
        }
    }

    public String outCmdResult() {
        try {
            this.LOCK.lock();
            if (this.inputStream == null) {
                this.inputStream = this.channelShell.getInputStream();
            }

            if (this.in == null) {
                this.in = new BufferedReader(new InputStreamReader(this.inputStream, DEFAULT_CHART));
            }
        } catch (IOException e) {
            e.printStackTrace();
            log.error("shellUtils outCmdResult error IOException!", e);
        } finally {
            this.LOCK.unlock();
        }

        synchronized (this.in) {
            StringBuffer buff = new StringBuffer();
            try {
                log.info("shellUtils outCmdResult >>>>>>>inputStream start.");
                while (in.ready()) {
                    String line = in.readLine();
                    buff.append("\n");
                    buff.append(line);
                    if (line.startsWith("[") && line.contains("@") && line.contains("]# ")) {
                        //不打印
                    } else {
                        if (StringUtils.isNotBlank(line)) {
                            //System.out.println(line);
                            //多余输出不打印
                            if(line.startsWith("download_baihang:")){
                                log.info(line);
                            }
                        }
                    }
                    if (line.equals("++CMD LAST++")) {
                        break;
                    }
                }
                Thread.sleep(1000);
                log.info("shellUtils outCmdResult >>>>>>>inputStream end.");
            } catch (IOException e) {
                e.printStackTrace();
                log.error("shellUtils outCmdResult error IOException!", e);
            } catch (InterruptedException e) {
                e.printStackTrace();
                log.error("shellUtils outCmdResult error InterruptedException!", e);
            }

            return buff.toString();
        }
    }

    public String getResult() {
        synchronized (this.inputStream) {
            try {
                if (this.inputStream == null) {
                    this.inputStream = this.channelShell.getInputStream();
                }
            } catch (IOException e) {
                e.printStackTrace();
                log.error("shellUtils getResult error IOException!", e);
            }
        }
        synchronized (this.in) {
            StringBuffer buff = new StringBuffer();
            try {
                if (this.in == null) {
                    this.in = new BufferedReader(new InputStreamReader(this.inputStream, DEFAULT_CHART));
                }
                log.info("shellUtils getResult >>>>>>>inputStream start.");
                Thread.sleep(1000);
                while (in.ready()) {
                    String line = in.readLine();
                    //System.out.println(line);
                   /* if (line.startsWith("[") && line.contains("@") && line.contains("]# ")) {
                        //不打印
                    } else {
                        if (StringUtils.isNotBlank(line)) {
                            //多余日志不打印
                            //log.info(line);
                        }
                    }*/
                    if ("++CMD LAST++".equals(line)) {
                        break;
                    } else {
                        if (line.startsWith("{\"reqID\":")) {
                            if (buff.length() == 0) {
                                buff.append("[");
                                buff.append(line.trim());
                            } else {
                                buff.append(",");
                                buff.append(line.trim());
                            }
                        }
                    }
                }
                if (buff.toString().startsWith("[") && !buff.toString().endsWith("]")) {
                    buff.append("]");
                }
                Thread.sleep(1000);
                log.info("shellUtils getResult >>>>>>>inputStream end.");
            } catch (IOException e) {
                e.printStackTrace();
                log.error("shellUtils getResult error IOException!", e);
            } catch (InterruptedException e) {
                e.printStackTrace();
                log.error("shellUtils getResult error InterruptedException!", e);
            }
            return buff.toString();
        }
    }

}
