package cn.quantgroup.report.utils.dingtalk;


import cn.quantgroup.report.service.http.IHttpService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;

/**
 * @author ：dongjianhua
 * @date ：Created in 2019/11/1 10:34
 * @description：钉钉提醒
 * @modified By：
 * @version: 1.0
 */
@Component
@Slf4j
public class DingTalk {
    @Autowired
    private IHttpService iHttpService;
    public static final String talkUri = "https://alertserv-dataservice.quantgroup.cn/common/alert/dingtalk";
    public static final String webHook = "https://oapi.dingtalk.com/robot/send?access_token=ef3cafb299ec6cb7442b2795d4d0c48e940756f7f267cfa895dbb419adb00128";


    @Async
    public void talk(String alarmLevel, String msgTitle, String msgContent) {
        try{
            Map<String, String> param = new HashMap<>();
            param.put("webhook", webHook);
            param.put("alarmLevel", alarmLevel);//"Warn"
            param.put("msgTitle", "量化派2百行：" + msgTitle);
            param.put("msgContent", msgContent);
  //        param.put("toUsers", "15542661376,18612632691");
            String resp = iHttpService.post(talkUri, param);
            log.info("钉钉报警接口调用结束, resp: {} ", resp);
        }catch (Exception e){
            log.warn("钉钉报警接口调用异常! ",e);
        }
    }

    @Async
    public void talk(String alarmLevel, String msgTitle, Exception e) {
        try{
            if (e == null) {
                return;
            }
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            Map<String, String> param = new HashMap<>();
            param.put("webhook", webHook);
            param.put("alarmLevel", alarmLevel);//"Warn"
            param.put("msgTitle", "量化派2百行：" + msgTitle);
            param.put("msgContent", sw.toString().length() > 500 ? sw.toString().substring(0, 499) : sw.toString());
//        param.put("toUsers", "15542661376,18612632691");
            String resp = iHttpService.post(talkUri, param);
            log.info("测试钉钉报警接口结果!resp:{}", resp);
            log.info("钉钉报警接口调用结束, resp: {} ", resp);
        }catch (Exception e2){
            log.warn("钉钉报警接口调用异常! ",e2);
        }
    }

    @Async
    public void talk_ToUser(String msgContent) {
        try{
            Map<String, String> param = new HashMap<>();
            param.put("webhook", webHook);
            param.put("alarmLevel", "ERROE");//
            param.put("msgTitle", "量化派2百行：数据同步失败");
            param.put("msgContent", msgContent);
            param.put("toUsers", "18010105506");
            String resp = iHttpService.post(talkUri, param);
            log.info("钉钉报警接口调用结束, resp: {} ", resp);
        }catch (Exception e){
            log.warn("钉钉报警接口调用异常! ",e);
        }
    }

    @Async
    public void talk(String alarmLevel, String msgTitle, QgException e) {
        Map<String, String> param = new HashMap<>();
        param.put("webhook", webHook);
        param.put("alarmLevel", alarmLevel);//"Warn"
        param.put("msgTitle", "量化派2百行：" + msgTitle);
        param.put("msgContent", exceptionToString(e));
//        param.put("toUsers", "15542661376,18612632691");
        String resp = iHttpService.post(talkUri, param);
        log.info("测试钉钉报警接口结果!resp:{}", resp);
    }

    public String exceptionToString(QgException e) {
        return new StringBuffer()
                .append(e.alarm)
                .append(":")
                .append(e.message == null ? "" : (e.message.length() > 500 ? e.message.substring(0, 499) : e.message)).toString();
    }
}
