package cn.quantgroup.report.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * @Author fengjunkai
 * @Date 2019-03-27 14:28
 */
public class DateUtils {

    private static final Logger LOGGER = LoggerFactory.getLogger(DateUtils.class);

    private static final String[] monthStrArray = {"01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12"};


    /**
     * yyyy-MM-dd
     * @return
     */
    public static String getYesterdayDateStr() {

        Calendar cal = Calendar.getInstance();
        cal.add(Calendar.DATE, -1);

        DateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
        Date startDate = new Date(cal.getTimeInMillis());
        return sf.format(startDate);
    }


    /**
     * 获取下一年的年月字符串组合 eg:201701 201702 ...
     *
     * @return
     * @version 1.0
     */
    public static String[] getNextYearMonthStr() {
        String[] ret = new String[12];

        Calendar c = Calendar.getInstance();
        int nextYear = c.get(Calendar.YEAR) + 1;
        for (int i = 0; i < monthStrArray.length; i++) {
            ret[i] = nextYear + monthStrArray[i];
        }
        return ret;
    }

    /**
     * 获取当年的年月字符串组合 eg:201601 201602 ...
     *
     * @return
     * @version 1.0
     */
    public static String getCurrentYearMonthStr() {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMM");
        return format.format(new Date());
    }

    /**
     * 时间戳转化为时间格式
     * @param unixTime
     * @return
     */
    public static String convertToDateString(long unixTime) {
        DateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date startDate = new Date(unixTime);
        return sf.format(startDate);
    }

    /**
     * 获取当前时间对应昨天的日期
     *
     * @return
     */
    public static Date getYesterdayDate() {

        Calendar cal = Calendar.getInstance();
        cal.add(Calendar.DATE, -1);

        return cal.getTime();
    }

    /**
     * 获取昨天0点的日期
     *
     * @return
     */
    public static Date getYesterdayZeroDate() {

        Calendar cal = Calendar.getInstance();
        cal.add(Calendar.DATE, -1);
        cal.set(Calendar.HOUR_OF_DAY, 0);
        cal.set(Calendar.MINUTE, 0);
        cal.set(Calendar.SECOND, 0);
        cal.set(Calendar.MILLISECOND, 0);

        return cal.getTime();
    }

    /**
     * 获取从昨天起7天前的日期
     *
     * @return
     */
    public static Date getYesterday7DaysAgoZeroDate() {
        Calendar cal = Calendar.getInstance();
        cal.add(Calendar.DATE, -6);
        cal.set(Calendar.HOUR_OF_DAY, 0);
        cal.set(Calendar.MINUTE, 0);
        cal.set(Calendar.SECOND, 0);
        cal.set(Calendar.MILLISECOND, 0);

        return cal.getTime();
    }

    /**
     * 获取今天0点的日期
     *
     * @return
     */
    public static Date getTodayZeroDateII() {

        Calendar cal = Calendar.getInstance();

        cal.set(Calendar.HOUR_OF_DAY, 0);
        cal.set(Calendar.MINUTE, 0);
        cal.set(Calendar.SECOND, 0);
        cal.set(Calendar.MILLISECOND, 0);

        return cal.getTime();
    }

    /**
     * 获取今天23点的日期
     *
     * @return
     */
    public static Date getToday23Date() {

        Calendar cal = Calendar.getInstance();

        cal.set(Calendar.HOUR_OF_DAY, 23);
        cal.set(Calendar.MINUTE, 0);
        cal.set(Calendar.SECOND, 0);
        cal.set(Calendar.MILLISECOND, 0);

        return cal.getTime();
    }

    /**
     * 获取今天1点的日期
     *
     * @return
     */
    public static Date getTodayOneHourDate() {

        Calendar cal = Calendar.getInstance();

        cal.set(Calendar.HOUR_OF_DAY, 1);
        cal.set(Calendar.MINUTE, 0);
        cal.set(Calendar.SECOND, 0);
        cal.set(Calendar.MILLISECOND, 0);

        return cal.getTime();
    }

    /**
     * 获取给定日期的1点
     *
     * @param date
     * @return
     */
    public static Date getOneHourByDate(Date date) {
        Calendar cal = Calendar.getInstance();

        cal.setTime(date);

        cal.set(Calendar.HOUR_OF_DAY, 1);
        cal.set(Calendar.MINUTE, 0);
        cal.set(Calendar.SECOND, 0);
        cal.set(Calendar.MILLISECOND, 0);

        return cal.getTime();
    }

    /**
     * 给定日期7天前的1点
     *
     * @param date
     * @return
     */
    public static Date get7DayAgoOneHourByDate(Date date) {
        Calendar cal = Calendar.getInstance();

        if (date != null) {
            cal.setTime(date);
        }

        cal.add(Calendar.DATE, -7);
        cal.set(Calendar.HOUR_OF_DAY, 1);
        cal.set(Calendar.MINUTE, 0);
        cal.set(Calendar.SECOND, 0);
        cal.set(Calendar.MILLISECOND, 0);

        return cal.getTime();
    }

    /**
     * 获取昨天的前七天的零点
     * @return
     */
    public static Date get7DayAgo0HourByYesterday() {
        Calendar cal = Calendar.getInstance();
        cal.add(Calendar.DATE, -8);
        cal.set(Calendar.HOUR_OF_DAY, 0);
        cal.set(Calendar.MINUTE, 0);
        cal.set(Calendar.SECOND, 0);
        cal.set(Calendar.MILLISECOND, 0);

        return cal.getTime();
    }

    /**
     * 获取30天前的零点
     * @return
     */
    public static Date get30DayAgo0HourByYesterday() {
        Calendar cal = Calendar.getInstance();
        cal.add(Calendar.DATE, -31);
        cal.set(Calendar.HOUR_OF_DAY, 0);
        cal.set(Calendar.MINUTE, 0);
        cal.set(Calendar.SECOND, 0);
        cal.set(Calendar.MILLISECOND, 0);

        return cal.getTime();
    }

    /**
     * 获取给定日期的明天的0点日期
     *
     * @param date
     * @return
     */
    public static Date getTommowZeroHourByDate(Date date) {
        Calendar cal = Calendar.getInstance();

        if (date != null) {
            cal.setTime(date);
        }

        cal.add(Calendar.DATE, 1);
        cal.set(Calendar.HOUR_OF_DAY, 0);
        cal.set(Calendar.MINUTE, 0);
        cal.set(Calendar.SECOND, 0);
        cal.set(Calendar.MILLISECOND, 0);

        return cal.getTime();
    }

    /**
     * 获取给定日期的0点
     *
     * @param date
     * @return
     */
    public static Date getZeroHourByDate(Date date) {
        Calendar cal = Calendar.getInstance();

        if (date != null) {
            cal.setTime(date);
        }

        cal.set(Calendar.HOUR_OF_DAY, 0);
        cal.set(Calendar.MINUTE, 0);
        cal.set(Calendar.SECOND, 0);
        cal.set(Calendar.MILLISECOND, 0);

        return cal.getTime();
    }

    /**
     * 获取日期的小时数
     *
     * @param date
     * @return
     */
    public static int getHourFromDate(Date date) {
        Calendar cal = Calendar.getInstance();

        cal.setTime(date);
        return cal.get(Calendar.HOUR_OF_DAY);
    }

    /**
     * 获取给定日期的23点
     *
     * @param date
     * @return
     */
    public static Date get23HourByDate(Date date) {
        Calendar cal = Calendar.getInstance();

        cal.setTime(date);

        cal.set(Calendar.HOUR_OF_DAY, 23);
        cal.set(Calendar.MINUTE, 0);
        cal.set(Calendar.SECOND, 0);
        cal.set(Calendar.MILLISECOND, 0);

        return cal.getTime();
    }

    /**
     * 整点
     *
     * @return
     */
    public static Date getCurrentHour() {

        Calendar cal = Calendar.getInstance();

        cal.set(Calendar.MINUTE, 0);
        cal.set(Calendar.SECOND, 0);
        cal.set(Calendar.MILLISECOND, 0);

        int hour = cal.get(Calendar.HOUR_OF_DAY);
        if (hour == 0) {
            cal.add(Calendar.DATE, 1);
        }

        return cal.getTime();
    }

    /**
     * 当前小时的整点
     *
     * @return
     */
    public static Date getNowHour() {

        Calendar cal = Calendar.getInstance();

        cal.set(Calendar.MINUTE, 0);
        cal.set(Calendar.SECOND, 0);
        cal.set(Calendar.MILLISECOND, 0);

        return cal.getTime();
    }

    /**
     * 获取下一个整点的日期
     *
     * @return
     */
    public static Date getNextHourDate() {
        Calendar cal = Calendar.getInstance();

        cal.set(Calendar.MINUTE, 0);
        cal.set(Calendar.SECOND, 0);
        cal.set(Calendar.MILLISECOND, 0);

        cal.add(Calendar.HOUR_OF_DAY, 1);

        return cal.getTime();
    }

    /**
     * 获取前天0点日期
     *
     * @return
     */
    public static Date getDayBeforeYesterdayZeroDate() {
        Calendar cal = Calendar.getInstance();
        cal.add(Calendar.DATE, -2);
        cal.set(Calendar.HOUR_OF_DAY, 0);
        cal.set(Calendar.MINUTE, 0);
        cal.set(Calendar.SECOND, 0);
        cal.set(Calendar.MILLISECOND, 0);

        return cal.getTime();
    }

    /**
     * 获取当前时间到明天0:10的毫秒值差
     *
     * @return
     */
    public static long getNowToTomorrowZeroMillis() {
        // 当前时间毫秒数
        long current = System.currentTimeMillis();
        // 今天零点零分零秒的毫秒数
        long today = current / (1000 * 3600 * 24) * (1000 * 3600 * 24)
                - TimeZone.getDefault().getRawOffset();
        // 明天0:10的毫秒数
        long tomorrow = today + 24 * 60 * 60 * 1000 + 10 * 60 * 1000;
        return tomorrow - current;
    }

    /**
     * 获取当前时间到下个整点的毫秒值差
     *
     * @return
     */
    public static long getNowToNextZeroTimeMillis() {
        // 当前时间毫秒数
        long current = System.currentTimeMillis();
        // 下个整点的毫秒数
        Calendar cal = Calendar.getInstance();

        cal.add(Calendar.HOUR_OF_DAY, 1);
        cal.set(Calendar.MINUTE, 0);
        cal.set(Calendar.SECOND, 0);
        cal.set(Calendar.MILLISECOND, 0);

        long nextHour = cal.getTime().getTime();

        return nextHour - current;
    }

    /**
     * 当前时间到明天零点的毫秒差值
     *
     * @return
     */
    public static long getNowToTodayZeroDateMillis() {
        // 当前时间毫秒数
        long current = System.currentTimeMillis();
        // 明天零点毫秒数
        Calendar cal = Calendar.getInstance();

        cal.add(Calendar.DATE, 1);

        cal.set(Calendar.HOUR_OF_DAY, 0);
        cal.set(Calendar.MINUTE, 0);
        cal.set(Calendar.SECOND, 0);
        cal.set(Calendar.MILLISECOND, 0);

        long millis = cal.getTimeInMillis();

        return millis - current;
    }

    /**
     * 当天凌晨的日期
     *
     * @return
     */
    public static Date getTodayZeroDate() {
        // 当前时间毫秒数
        long current = System.currentTimeMillis();
        // 今天零点零分零秒的毫秒数
        long today = (current  + 3600 * 1000 * 8)/ (1000 * 3600 * 24) * (1000 * 3600 * 24)
                - TimeZone.getDefault().getRawOffset();
        return new Date(today);
    }

    /**
     * 格式化日期到整小时
     *
     * @param date
     * @return
     */
    public static Date formatDateToHour(Date date) {
        DateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:00:00");
        Date result = new Date();
        try {
            result = format.parse(format.format(date));
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return result;
    }

    /**
     * 获取昨天的当前时间的整点往前推n个小时的各个整点
     *
     * @param n
     * @return
     */
    public static List<Date> getYesterdayPreNHourTimeList(int n) {
        List<Date> result = new ArrayList<>();

        Calendar cal = Calendar.getInstance();
        cal.add(Calendar.DATE, -1);
        cal.set(Calendar.MINUTE, 0);
        cal.set(Calendar.SECOND, 0);
        cal.set(Calendar.MILLISECOND, 0);

        result.add(cal.getTime());

        for (int i = 0; i < n - 1; i++) {
            cal.add(Calendar.HOUR_OF_DAY, -1);
            result.add(cal.getTime());
        }
        return result;
    }

    /**
     * 获取今天的当前时间整点往前推n个小时的各个整点
     *
     * @param n
     * @return
     */
    public static List<Date> getTodayPreNHourTimeList(int n) {
        List<Date> result = new ArrayList<>();

        Calendar cal = Calendar.getInstance();
        cal.set(Calendar.MINUTE, 0);
        cal.set(Calendar.SECOND, 0);
        cal.set(Calendar.MILLISECOND, 0);

        result.add(cal.getTime());

        for (int i = 0; i < n - 1; i++) {
            cal.add(Calendar.HOUR_OF_DAY, -1);
            result.add(cal.getTime());
        }
        return result;
    }

    /**
     * 获取24小时字符串list
     *
     * @return
     */
    public static List<String> get24HoursStringList() {
        List<String> result = new ArrayList<>();

        Calendar cal = Calendar.getInstance();
        cal.set(Calendar.HOUR_OF_DAY, 0);
        cal.set(Calendar.MINUTE, 0);
        cal.set(Calendar.SECOND, 0);
        cal.set(Calendar.MILLISECOND, 0);

        DateFormat format = new SimpleDateFormat("HH:00");

        //0点
        result.add(format.format(cal.getTime()));
        for (int i = 1; i < 24; i++) {
            cal.add(Calendar.HOUR_OF_DAY, 1);
            result.add(format.format(cal.getTime()));
        }

        return result;
    }

    /**
     * 对当前日期进行判断<br>
     * 出现一种情况：整点执行的定时任务在前一小时xx:59:59执行
     */
    public static Date judgeCurrentDate() {
        Calendar cal = Calendar.getInstance();
        int minute = cal.get(Calendar.MINUTE);
        //当前的分时间是50分钟之后
        if (minute >= 50) {
            //把小时数+1
            cal.add(Calendar.HOUR_OF_DAY, 1);
        }
        cal.set(Calendar.MINUTE, 0);
        cal.set(Calendar.SECOND, 0);
        cal.set(Calendar.MILLISECOND, 0);

        return cal.getTime();
    }

    /**
     * 给定时间往前推24小时
     *
     * @param date
     * @return
     */
    public static Date getYesterdayDateByDate(Date date) {
        long current = date.getTime();
        long yesterday = current - 24 * 60 * 60 * 1000;
        return new Date(yesterday);
    }

    /**
     * 根据当前时间获取过去7天的同一时间段日期
     *
     * @return
     */
    public static List<Date> getPast7DayListByNow() {

        List<Date> result = new ArrayList<>();

        Calendar cal = Calendar.getInstance();

        cal.set(Calendar.MINUTE, 0);
        cal.set(Calendar.SECOND, 0);
        cal.set(Calendar.MILLISECOND, 0);

        int minute = cal.get(Calendar.MINUTE);
        if (minute > 30) {
            cal.add(Calendar.HOUR_OF_DAY, 1);
        }

        for (int i = 0; i < 7; i++) {
            cal.add(Calendar.DATE, -1);
            result.add(cal.getTime());
        }

        return result;
    }

    /**
     * 过去N天的零点日期(包括今天)
     *
     * @param n
     * @return
     */
    public static List<Date> getPastNDaysZeroTimeDateList(int n) {
        List<Date> result = new ArrayList<>();

        Calendar cal = Calendar.getInstance();

        cal.set(Calendar.HOUR_OF_DAY, 0);
        cal.set(Calendar.MINUTE, 0);
        cal.set(Calendar.SECOND, 0);
        cal.set(Calendar.MILLISECOND, 0);

        //今天
        result.add(cal.getTime());
        for (int i = 1; i < n; i++) {
            cal.add(Calendar.DATE, -1);
            result.add(cal.getTime());
        }

        return result;
    }

    /**
     * 过去N天的零点日期(不包括今天和昨天)
     *
     */
    public static List<Date> getPastNDaysZeroTimeDateListII(int start, int count) {
        List<Date> result = new ArrayList<>();

        Calendar cal = Calendar.getInstance();

        cal.set(Calendar.HOUR_OF_DAY, 0);
        cal.set(Calendar.MINUTE, 0);
        cal.set(Calendar.SECOND, 0);
        cal.set(Calendar.MILLISECOND, 0);

        for (int i = 1; i < count; i++) {
            cal.add(Calendar.DATE, -1);
            if (i <= start) {
                continue;
            }
            result.add(cal.getTime());
        }

        return result;
    }

    /**
     * 给定时间往后推24小时
     *
     * @param date
     * @return
     */
    public static Date getNext24HourDateByDate(Date date) {
        long current = date.getTime();
        long tomorrow = current + 24 * 60 * 60 * 1000;
        return new Date(tomorrow);
    }

    /**
     * 获取日期前24个小时的list
     *
     * @param n
     * @param date
     * @return
     */
    public static List<Date> getPreNHourListByDate(int n, Date date) {

        List<Date> result = new ArrayList<>(n);

        result.add(date);
        long timeMillis = date.getTime();
        for (int i = 1; i < n; i++) {
            timeMillis = timeMillis - 60 * 60 * 1000;
            result.add(new Date(timeMillis));
        }
        return result;
    }

    /**
     * 判断当前时间是否在某段小时区间内
     *
     * @param sHour
     * @param eHour
     * @return
     */
    public static boolean judgeNowBetweenPeriodOfHour(int sHour, int eHour) {
        Calendar cal = Calendar.getInstance();
        int hour = cal.get(Calendar.HOUR_OF_DAY);
        if (hour >= sHour && hour <= eHour) {
            return true;
        }
        return false;
    }

    public static boolean isTodayDate(Date date) {
        try {
            Date today = getTodayZeroDateII();
            if (date.getTime() >= today.getTime()) {
                return true;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

        return false;
    }

    public static boolean isTodayDate(String dateStr) {
        DateFormat format = new SimpleDateFormat("yyyy-MM-dd");

        try {
            Date date = format.parse(dateStr);
            return isTodayDate(date);
        } catch (ParseException e) {
            e.printStackTrace();
        }

        return false;
    }

    /**
     * 获取N天前的零点日期
     *
     * @param n
     * @return
     */
    public static Date getHistoryZeroDateByN(int n) {
        Calendar cal = Calendar.getInstance();

        cal.set(Calendar.HOUR_OF_DAY, 0);
        cal.set(Calendar.MINUTE, 0);
        cal.set(Calendar.SECOND, 0);
        cal.set(Calendar.MILLISECOND, 0);

        cal.add(Calendar.DATE, -n);

        return cal.getTime();
    }

    /**
     * 计算日期相差天数
     * @param date1
     * @param date2
     * @return
     */
    public static int differentDays(Date date1,Date date2) {
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date1);

        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(date2);
        int day1= cal1.get(Calendar.DAY_OF_YEAR);
        int day2 = cal2.get(Calendar.DAY_OF_YEAR);

        int year1 = cal1.get(Calendar.YEAR);
        int year2 = cal2.get(Calendar.YEAR);
        if(year1 != year2) {
            int timeDistance = 0 ;
            for(int i = year1 ; i < year2 ; i ++) {
                if(i%4==0 && i%100!=0 || i%400==0) {
                    timeDistance += 366;
                } else {
                    timeDistance += 365;
                }
            }
            return timeDistance + (day2-day1) ;
        } else {
            System.out.println("判断day2 - day1 : " + (day2-day1));
            return day2-day1;
        }
    }

    /**
     * 获取N个小时前的整点日期
     *
     * @param n
     * @return
     */
    public static Date getHistoryHourDateByN(int n) {

        Calendar cal = Calendar.getInstance();

        cal.add(Calendar.HOUR_OF_DAY, -n);
        cal.set(Calendar.MINUTE, 0);
        cal.set(Calendar.SECOND, 0);
        cal.set(Calendar.MILLISECOND, 0);

        return cal.getTime();
    }

    /**
     * 获取给定日期的昨天的日期并格式化
     *
     * @param date
     * @return
     */
    public static String getLastDayStringDateByDate(Date date) {
        DateFormat format = new SimpleDateFormat("MM-dd");

        Calendar cal = Calendar.getInstance();
        cal.setTime(date);

        cal.add(Calendar.DATE, -1);

        return format.format(cal.getTime());
    }

    /**
     * 获取昨天零点的前一秒
     * @return
     */
    public static Date getYesterdayBeforeOneSec() {

        Calendar cal = Calendar.getInstance();
        cal.add(Calendar.DATE, -1);
        cal.set(Calendar.HOUR_OF_DAY, 0);
        cal.set(Calendar.MINUTE, 0);
        cal.set(Calendar.SECOND, -1);
        cal.set(Calendar.MILLISECOND, 0);

        return cal.getTime();
    }

    /**
     * 获取指定时间的下一个整点（非零点时刻）
     * @param date
     * @return Date
     */
    public static Date getNextOneHourSpecifyTime(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int hour = c.get(Calendar.HOUR);
        if(hour != 0) {
            c.set(Calendar.HOUR, hour + 1);
        }
        return c.getTime();
    }

    public static String convertToTimeSlot(long unixTime) {
        long days = unixTime / (1000 * 60 * 60 * 24);
        long hours = (unixTime % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60);
        long minutes = (unixTime % (1000 * 60 * 60)) / (1000 * 60);
        long seconds = (unixTime % (1000 * 60)) / 1000;
        if (unixTime >= 1000 * 60 * 60 * 24) {
            return days + "天" + hours + "时" + minutes + "分" + seconds + "秒";
        } else if (unixTime >= 1000 * 60 * 60) {
            return hours + "时" + minutes + "分" + seconds + "秒";
        } else if (unixTime >= 1000 * 60) {
            return minutes + "分" + seconds + "秒";
        } else if (unixTime >= 1000) {
            return seconds + "秒";
        }
        return null;
    }

    /**
     * 获取给定日期的前N天
     */
    public static Date getPastNDayZeroHourByDate(Date date, int n) {
        Calendar instance = Calendar.getInstance();
        instance.setTime(date);
        instance.set(Calendar.DATE,instance.get(Calendar.DATE) - n);
        return instance.getTime();
    }

    /**
     * 计算两个日期相差的天数
     * @param date1
     * @param date2
     * @return
     */
    public static int differentDaysByMillisecond(Date date1,Date date2) {
        int days = (int) ((date2.getTime() - date1.getTime()) / (1000*3600*24));
        return days;
    }

    /**
     * 获取当天N点的毫秒值
     * @param hour
     * @return
     */
    public static long getTodayNHourMillisecond(int hour) {
        Calendar cal = Calendar.getInstance();
        cal.add(Calendar.DATE, 0);
        cal.set(Calendar.HOUR_OF_DAY, hour);
        cal.set(Calendar.MINUTE, 0);
        cal.set(Calendar.SECOND, 0);
        cal.set(Calendar.MILLISECOND, 0);
        return cal.getTime().getTime();
    }

    /**
     * 获取当前时间小时数(24小时制)
     * @return
     */
    public static int getCurrentTimeHour() {
        Calendar cal = Calendar.getInstance();
        return cal.get(Calendar.HOUR_OF_DAY);
    }

    /**
     * 获取指定时间小时数(24小时制)
     * @return
     */
    public static int getDesignTimeHour(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(Calendar.HOUR_OF_DAY);
    }

    public static Date parseDate(String dateStr) {
        Date parseDate = null;
        try {
            DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            parseDate = dateFormat.parse(dateStr);
            return parseDate;
        }catch (Exception e){
            LOGGER.error("日志解析失败", e);
        }
        return parseDate;
    }

    public static String formatDate(Date date, String format) {
        try {
            DateFormat dateFormat = new SimpleDateFormat(format);
            String dateStr = dateFormat.format(date);
            return dateStr;
        }catch (Exception e){
            LOGGER.error("日志解析失败", e);
            return "";
        }
    }


    public static String parse(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return format.format(date);
    }

    public static void main(String[] args) {
        DateFormat df = new SimpleDateFormat("MM-dd");
//        int currentTimeHour = getCurrentTimeHour();
//        System.out.println(currentTimeHour);
        Date startTime = DateUtils.getHistoryZeroDateByN(7);
        Date today = DateUtils.parseDate("2018-08-28");
        int num = DateUtils.differentDays(today, new Date());
        System.out.println(formatDate(new Date(), "yyyy-MM-dd"));
        System.out.println(DateUtils.getHistoryZeroDateByN(1));
        System.out.println(today);
        System.out.println(df.format(startTime));
    }

}
