package cn.quantgroup.report.job;

import cn.quantgroup.report.service.baihang.BaiHangZhuDaiService;
import cn.quantgroup.report.service.baihang.constant.Constant;
import cn.quantgroup.report.utils.dingtalk.DingTalk;
import com.google.common.base.Stopwatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.TimeUnit;


/**
 * -----------------------------------------------------------------------------<br>
 * 描述: 量化派助贷模式(非循环贷) -
 *      (贷款申请/放款/还款(逾期)三类实时批量数据)-To百行报送<br>
 *     每日凌晨5点报送 <br>
 * 作者：yanhui.Hao <br>
 * 时间：2019.10.25 <br>
 * 授权: (C) Copyright (c) 2017 <br>
 * 公司: 北京众信利民信息技术有限公司 <br>
 * -----------------------------------------------------------------------------
 */
@Component
public class QuantGroupZhuDaiReportToBaiHang {

    private static final Logger log = LoggerFactory.getLogger(QuantGroupZhuDaiReportToBaiHang.class);

    @Autowired
    private RedisTemplate<String,String> redisTemplate;

    @Autowired
    private BaiHangZhuDaiService baiHangZhuDaiService;

    @Autowired
    private SynLoanInfoHistoryTask synLoanInfoHistoryTask;

    @Autowired
    private DingTalk dingTalk;

    @Async
    //@Scheduled(cron = "0 0 5 * * ?")
    public void startZhuDaiReport(){
        if(increment()){
            redisTemplate.expire(Constant.QG_ZHU_DAI_REPORT_LOCK_KEY, 10, TimeUnit.SECONDS);

            Stopwatch stopwatch = Stopwatch.createStarted();

            boolean tableIsSyn = synLoanInfoHistoryTask.syn_historyAndplan_by_id();
            if(tableIsSyn){
                try{
                    //yyyy-MM-dd
                    String startnyr = LocalDateTime.now().plusDays(-1).format(DateTimeFormatter.ISO_DATE);
                    String endnyr = LocalDateTime.now().format(DateTimeFormatter.ISO_DATE);

                    log.info("量化派-助贷模式报送贷款信息开始, newTime: {} , startnyr: {} , endnyr: {} ", LocalDateTime.now(), startnyr, endnyr);

                    String msg_A1 = baiHangZhuDaiService.sendZhuDaiApplyToBaiHang(startnyr,endnyr);  //生产 助贷-贷款申请 报送T+1    暂时先不报送C1 因为百行还没有开放查询接口
                    String msg_D2 = baiHangZhuDaiService.sendZhuDaiLoanToBaiHang(startnyr,endnyr);        //生产 助贷-放款信息 报送T+1
                    String msg_D3 =baiHangZhuDaiService.sendZhuDaiRepaymentToBaiHang(startnyr,endnyr);      //生产 助贷-还款&逾期信息  报送T+1

                    log.info("量化派-助贷模式报送贷款信息结束, newTime: {}, 耗时: {} , msg: {} ", LocalDateTime.now(), stopwatch.stop().elapsed(TimeUnit.MILLISECONDS), (msg_A1 + msg_D2 + msg_D3));
                    dingTalk.talk("Info","报送贷款信息结束",msg_A1 + msg_D2 + msg_D3);

                }catch (Exception e){
                    log.error("量化派-助贷模式报送贷款信息异常, newTime: {}, 耗时: {} ", LocalDateTime.now(), stopwatch.stop().elapsed(TimeUnit.MILLISECONDS), e);
                    dingTalk.talk("Error","报送服务内部异常", e);
                    dingTalk.talk_ToUser("报送服务内部异常,请尽快手动处理!");
                }

            }else{
                log.error("量化派-助贷模式报送贷款信息失败, 原因是同步历史表数据返回false, 请尽快人工处理, newTime: {} ", LocalDateTime.now());
            }
        }
    }


    public Boolean increment(){
        Long increment = redisTemplate.opsForValue().increment(Constant.QG_ZHU_DAI_REPORT_LOCK_KEY, 1);
        return increment <= 1;
    }

}
