package cn.quantgroup.report.service.baihang;

import cn.quantgroup.report.domain.baihang.*;
import cn.quantgroup.report.mapper.baihang.ApplyLoanInfoMapper;
import cn.quantgroup.report.mapper.baihang.LoanInfoMapper;
import cn.quantgroup.report.mapper.baihang.RepaymentLoanInfoMapper;
import cn.quantgroup.report.mapper.master.LoanInfoDbMapper;
import cn.quantgroup.report.mapper.master.RepaymentLoanInfoDbMapper;
import cn.quantgroup.report.service.baihang.client.BhFileCreditApiClient;
import cn.quantgroup.report.service.baihang.client.BhInterfaceCreditApiClient;
import cn.quantgroup.report.service.baihang.request.FileUploadRequest;
import cn.quantgroup.report.service.baihang.request.FileUploadValidationRequest;
import cn.quantgroup.report.service.baihang.request.InterfaceUploadRequest;
import cn.quantgroup.report.service.baihang.request.InterfaceUploadValidationRequest;
import cn.quantgroup.report.service.baihang.response.FileUploadResponse;
import cn.quantgroup.report.service.baihang.response.FileUploadValidationResponse;
import cn.quantgroup.report.service.baihang.response.InterfaceUploadResponse;
import cn.quantgroup.report.service.baihang.response.InterfaceUploadValidationResponse;
import cn.quantgroup.report.service.baihang.util.BHRSAUtils;
import cn.quantgroup.report.service.baihang.util.Base64;
import cn.quantgroup.report.service.baihang.util.TuoMinUtils;
import cn.quantgroup.report.service.http.IHttpService;
import cn.quantgroup.report.utils.StringUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Stopwatch;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;
import java.io.File;
import java.io.IOException;
import java.security.PublicKey;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

/**
 * -----------------------------------------------------------------------------<br>
 * 描述: 百行-助贷模式报送 <br>
 * 作者：yanhui.Hao <br>
 * 时间：2019.10.23 <br>
 * 授权: (C) Copyright (c) 2017 <br>
 * 公司: 北京众信利民信息技术有限公司 <br>
 * -----------------------------------------------------------------------------
 */
@Service
public class BaiHangZhuDaiService {

    private static final Logger log = LoggerFactory.getLogger(BaiHangZhuDaiService.class);

    @Autowired
    public ApplyLoanInfoMapper applyLoanInfoMapper;

    @Autowired
    public LoanInfoMapper loanInfoMapper;

    @Autowired
    public RepaymentLoanInfoMapper repaymentLoanInfoMapper;

    @Autowired
    public LoanInfoDbMapper loanInfoDbMapper;

    @Autowired
    public RepaymentLoanInfoDbMapper repaymentLoanInfoDbMapper;


    @Autowired
    public IHttpService iHttpService;

    @Value("${baihang.zhudai.A1.data.url}")
    public String baihangHandA1DataUrl;
    @Value("${baihang.zhudai.D2.data.url}")
    public String baihangHandD2DataUrl;
    @Value("${baihang.zhudai.D3.data.url}")
    public String baihangHandD3DataUrl;


    @Value("${baihang.zhudai.applyloan.url}")
    public String baiHangApplyLoanInfoUrl;
    @Value("${baihang.zhudai.loaninfo.url}")
    public String baiHangLoanInfoUrl;
    @Value("${baihang.zhudai.repaymentloaninfo.url}")
    public String baiHangRepayMentLoanInfoUrl;


    @Value("${baihang.zhudai.account.name}")
    public String account;
    @Value("${baihang.zhudai.password}")
    public String password;

    //private DateFormat df_uploadTs = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @Value("${baihang.zhudai.cunliang.data.url}")
    public String zl_file_path_name; // = "D:\\JavaTeam\\baihang\\cunLiang\\";存量数据整理目录

    private static PublicKey baihang_zhudai_publickey = null;

    //测试环境报送，用户三要素需要脱敏
    private static Map<String,String> testBaoSongUserInfoTuoMingMap = new ConcurrentHashMap<>();

    //联合贷产品上线时间，上线后才有数据
    private static LocalDateTime liang_he_dai_start = LocalDateTime.parse("2019-10-25T00:00:00");

    private static AtomicBoolean A1_Stop = new AtomicBoolean(false);
    private static AtomicBoolean D2_Stop = new AtomicBoolean(false);
    private static AtomicBoolean D3_Stop = new AtomicBoolean(false);

    @PostConstruct
    public void init(){

        try{
            long log_stUtc1 = System.currentTimeMillis();
            baihang_zhudai_publickey = BHRSAUtils.readRSAPublicKey("/baihang/rsa_public_key.pem");
            log.info("初始化百行助贷PublicKey实例完成, 耗时: {} ",System.currentTimeMillis()-log_stUtc1);
        }catch(Exception e){
            log.error("初始化百行助贷PublicKey实例", e);
        }

        /*try{
            long log_stUtc2 = System.currentTimeMillis();
            List<String> contextList = FileUtils.readLines(new File(zl_file_path_name + "TEST_BS_USER_TM_201911061315.txt"), "utf-8");
            if(contextList!=null && contextList.size()>0){
                Map<String,String> tmpMap = new ConcurrentHashMap<>(contextList.size());
                for(String context: contextList){
                    String[] tmp = context.split("=");
                    tmpMap.put(tmp[0],tmp[1]);
                }
                testBaoSongUserInfoTuoMingMap = tmpMap;
            }
            log.info("初始化测试环境百行报送-用户三要素脱敏字典结束, 耗时: {} ",System.currentTimeMillis()-log_stUtc2);
        }catch(Exception e){
            log.error("初始化测试环境百行报送-用户三要素脱敏字典异常", e);
        }*/

    }

    private static PublicKey getBaihangZDPublickey(){
        if(baihang_zhudai_publickey==null){
            try{
                baihang_zhudai_publickey = BHRSAUtils.readRSAPublicKey("/baihang/rsa_public_key.pem");
                log.info("初始化百行助贷PublicKey实例完成");
            }catch(Exception e){
                log.error("初始化百行助贷PublicKey实例", e);
            }
        }
        return  baihang_zhudai_publickey;
    }



    //--------------------------------------Scheduled报送------------------------------------------------------------------------------
    /**
     * 助贷模式-实时批量报送用户贷款申请A1数据
     * Scheduled 贷款申请（百行征信报送）
     */
    public String sendZhuDaiApplyToBaiHang(String startnyr, String endnyr) {
        //yyyy-MM-dd
        Stopwatch queryWatch1 = Stopwatch.createStarted();
        BaiHangTimeRecord timeRecord = BaiHangTimeRecord.builder().startTime(startnyr).endTime(endnyr).build();
        List<ApplyLoanInfoZhuDai> applyLoanInfos = applyLoanInfoMapper.findRealTimeApplyLoanZhuDai(timeRecord);
        log.info("量化派助贷TO百行报送-非联合贷申请查询完成, 大小: {} , 耗时: {} ", (applyLoanInfos!=null?applyLoanInfos.size() : 0), (queryWatch1.stop().elapsed(TimeUnit.MILLISECONDS)/1000)+".s");

        Stopwatch queryWatch2 = Stopwatch.createStarted();
        List<ApplyLoanInfoZhuDai> applyLoanInfosLh = applyLoanInfoMapper.findRealTimeApplyLoanZhuDaiLh(timeRecord);
        log.info("量化派助贷TO百行报送-联合贷申请查询完成, 大小: {} , 耗时: {} ", (applyLoanInfosLh!=null?applyLoanInfosLh.size() : 0),  (queryWatch2.stop().elapsed(TimeUnit.MILLISECONDS)/1000)+".s");

        if(applyLoanInfos==null){
            applyLoanInfos = new ArrayList<ApplyLoanInfoZhuDai>();
        }
        if(applyLoanInfosLh!=null && applyLoanInfosLh.size()>0){
            applyLoanInfos.addAll(applyLoanInfosLh);
        }

        Stopwatch sendWatch = Stopwatch.createStarted();
        AtomicInteger atomicInteger = new AtomicInteger();
        for (int i = 0; i < applyLoanInfos.size(); i++) {
            String reqId_log = "";
            try {
                ApplyLoanInfoZhuDai applyLoanInfo = applyLoanInfos.get(i);
                reqId_log = applyLoanInfo.getReqID();
                applyLoanInfo.setName(interfaceUploadClient(applyLoanInfo.getName()));
                applyLoanInfo.setMobile(interfaceUploadClient(applyLoanInfo.getMobile()));
                applyLoanInfo.setPid(interfaceUploadClient(applyLoanInfo.getPid()));

                //邮箱有错误的就不传
                if(!TuoMinUtils.checkEmail(applyLoanInfo.getEmailAddress())){
                    applyLoanInfo.setEmailAddress(null);
                }
                String resultStr = iHttpService.postBaiHang(baiHangApplyLoanInfoUrl, getHeader(), JSON.toJSONString(applyLoanInfo));
                log.info("助贷贷款申请A1报送结果, param: {} , resultStr: {} ", JSON.toJSONString(applyLoanInfo), resultStr);
                //if (Objects.isNull(resultStr) || !(resultStr.contains("queryHistory") && resultStr.contains("nonRevolvingLoan") && resultStr.contains("revolvingLoan"))) {
                if (Objects.isNull(resultStr) || !"success".equalsIgnoreCase(JSON.parseObject(resultStr).getString("status"))) {
                    log.info("量化派助贷TO百行报送-贷款申请返回结果不正确, reqId_log: {} , applyId: {} ", reqId_log, applyLoanInfo.getApplyId());
                } else {
                    atomicInteger.getAndIncrement();
                }
            } catch (Exception e) {
                log.error("量化派助贷TO百行报送-贷款申请信息异常, reqId_log: {} ", reqId_log, e);
            }
        }
        log.info("量化派助贷TO百行报送-贷款申请报送完成, 实际大小: {} , 报送成功大小: {} , 耗时: {} ", applyLoanInfos.size(), atomicInteger.get(), (sendWatch.stop().elapsed(TimeUnit.MILLISECONDS)/1000)+".s");

        String resMsgTemp = "申请A1报送: 查询 %d条(联合贷%d条), 报送成功 %d条; ";
        return String.format(resMsgTemp, applyLoanInfos.size(), (applyLoanInfosLh!=null?applyLoanInfosLh.size():0),atomicInteger.get());
    }


    /**
     * 助贷模式-实时批量报送放款D2数据
     * Scheduled 实时放款数据（百行征信报送）
     */
    public String sendZhuDaiLoanToBaiHang(String startnyr, String endnyr) {
        //yyyy-MM-dd
        BaiHangTimeRecord timeRecord = BaiHangTimeRecord.builder().startTime(startnyr).endTime(endnyr).build();

        AtomicInteger atomicInteger = new AtomicInteger();
        List<LoanInfoZhuDai> loanInfos = new ArrayList<>();
        Stopwatch sendWatch = Stopwatch.createStarted();
        int loanInfosLhSize = 0;
        try{
            Stopwatch queryWatch1 = Stopwatch.createStarted();
            loanInfos = loanInfoMapper.findRealTimeLoanInfoZhuDai(timeRecord);
            log.info("量化派助贷TO百行报送-非联合贷放款申请报送开始, 大小: {} , 耗时: {} ", loanInfos.size(), (queryWatch1.stop().elapsed(TimeUnit.MILLISECONDS)/1000)+".s");

            Stopwatch queryWatch2 = Stopwatch.createStarted();
            List<LoanInfoZhuDai> loanInfosLh = loanInfoMapper.findRealTimeLoanInfoZhuDaiLh(timeRecord);

            loanInfosLhSize = loanInfosLh!=null ? loanInfosLh.size() : 0;
            log.info("量化派助贷TO百行报送-联合贷放款申请报送开始, 大小: {} , 耗时: {} ", loanInfosLhSize, (queryWatch2.stop().elapsed(TimeUnit.MILLISECONDS)/1000)+".s");

            if(loanInfos==null){
                loanInfos = new ArrayList<LoanInfoZhuDai>();
            }
            if(loanInfosLh!=null && loanInfosLh.size()>0){
                loanInfos.addAll(loanInfosLh);
            }

            for (int i = 0; i < loanInfos.size(); i++) {
                LoanInfoZhuDai loanInfozd_tmp = loanInfos.get(i);
                String id = "";
                try {
                    String loanInfoReqId = loanInfozd_tmp.getReqID();
                   /* if (loanInfozd_tmp.getTotalTerm() > 1) {
                        List<String> targetRepaymentDayList = loanInfoMapper.findTargetRepaymentDayList(loanInfoReqId);
                        loanInfozd_tmp.setTargetRepayDateList(String.join(",", targetRepaymentDayList));
                    }*/
                    List<String> targetRepaymentDayList = loanInfoMapper.findTargetRepaymentDayList(loanInfoReqId);
                    if(targetRepaymentDayList!=null && targetRepaymentDayList.size()>0){
                        loanInfozd_tmp.setTargetRepayDateList(String.join(",", targetRepaymentDayList));
                        //log.info("比较还款总期数&账单日列表totalTerm="+loanInfozd_tmp.getTotalTerm()+",targetRepaymentDayList size="+targetRepaymentDayList.size());
                    }else{
                        log.warn("比较还款总期数&账单日列表loanInfoReqId: {} , totalTerm: {} , targetRepaymentDayList is null!", loanInfoReqId, loanInfozd_tmp.getTotalTerm());
                    }

                    String relationID = loanInfozd_tmp.getRelationID();
                    if(relationID!=null){
                        if(relationID.length()>36){ //长度[1,36]
                            //lhp_1911049771615765816566b49a2db1c429
                            if(relationID.startsWith("lhp_")){
                                String tmp = relationID.substring(4,relationID.length());
                                if(tmp.length()>35){
                                    //lhp_1909279744718808613622e008da4c110000
                                    loanInfozd_tmp.setRelationID("H"+tmp.substring(0,35));
                                }else{
                                    loanInfozd_tmp.setRelationID("L"+tmp);
                                }
                            }else{
                                log.warn("量化派助贷TO百行报送-放款返回结果不正确, 发现其他类型的relationID并且长度大于36, relationID: {} , loanInfoReqId: {} ", relationID, loanInfoReqId);
                                //continue;
                                loanInfozd_tmp.setRelationID("X"+relationID.substring(0,35));
                            }
                        }
                    }

                    UUID loanInfoId = UUID.randomUUID();
                    id = loanInfoId.toString().replaceAll("-", "");
                    try{
                        loanInfozd_tmp.setRecordId(id);
                        loanInfoDbMapper.saveLoanInfoRecordLog(loanInfozd_tmp);
                    }catch(Exception e){
                        log.error("量化派助贷TO百行报送-放款申请保存记录失败, loanInfoReqId: {} , JSON: {} ", loanInfoReqId, JSON.toJSONString(loanInfozd_tmp), e);
                    }
                    loanInfozd_tmp.setRecordId(null);
                    loanInfozd_tmp.setReqID(id);

                    String jsonStr = JSONObject.toJSONString(loanInfozd_tmp);
                    LoanInfoZhuDaiVo loanInfo = JSONObject.parseObject(jsonStr, LoanInfoZhuDaiVo.class);
                    FinTechAgencyBusinessZhuDai finTechAgencyBusiness = JSONObject.parseObject(jsonStr, FinTechAgencyBusinessZhuDai.class);
                    loanInfo.setFinTechAgencyBusiness(finTechAgencyBusiness);

                    loanInfo.setName(interfaceUploadClient(loanInfo.getName()));
                    loanInfo.setPid(interfaceUploadClient(loanInfo.getPid()));
                    loanInfo.setMobile(interfaceUploadClient(loanInfo.getMobile()));

                    String resultStr = iHttpService.postBaiHang(baiHangLoanInfoUrl, getHeader(), JSON.toJSONString(loanInfo));
                    log.info("助贷放款用户报送结果, param: {} , resultStr: {} ", JSON.toJSONString(loanInfo), resultStr);
                    if (Objects.isNull(resultStr) || !"success".equalsIgnoreCase(JSON.parseObject(resultStr).getString("status"))) {
                        log.info("量化派助贷TO百行报送-放款返回结果不正确, loanInfoReqId:{} , recordId: {} , loanId: {} , bean: {} ", loanInfoReqId, id, loanInfo.getLoanId(), JSON.toJSONString(loanInfo));
                        loanInfoDbMapper.updateCurrentRecordEnableFalce(BaiHangUpDateRecord.builder().enable("0").recordId(id).build());
                    } else {
                        atomicInteger.getAndIncrement();
                    }
                } catch (Exception e) {
                    log.error("量化派助贷TO百行报送-放款信息异常, loanInfoReqId: {} , recordId: {} , loanId: {} ", loanInfozd_tmp.getReqID(), id, loanInfozd_tmp.getLoanId(), e);
                }
            }
        }catch(Exception e){
            log.error("量化派助贷TO百行报送-异常", e);
        }
        log.info("量化派助贷TO百行报送-放款申请完成, 实际大小: {} , 报送成功大小: {} , 耗时: {} ", loanInfos.size(), atomicInteger.get(), (sendWatch.stop().elapsed(TimeUnit.MILLISECONDS)/1000)+".s");

        String resMsgTemp = "放款D2报送: 查询 %d条(联合贷%d条), 报送成功 %d条; ";
        return String.format(resMsgTemp, loanInfos.size(), loanInfosLhSize, atomicInteger.get());
    }


    /**
     * 助贷模式-实时还款&实时逾期还款D3数据报送
     * Scheduled 还款&逾期（百行征信报送）
     */
    public String sendZhuDaiRepaymentToBaiHang(String startnyr, String endnyr) {
        //yyyy-MM-dd
        BaiHangTimeRecord timeRecord = BaiHangTimeRecord.builder().startTime(startnyr).endTime(endnyr).build();
        String resMsg = "";
        String temp_huanKuan = "还款D3报送: 查询 %d条(联合贷%d条), 实际 %d条, 跳过 %d条, 报送成功 %d条; ";
        String temp_yuQi = "逾期D3报送: 查询 %d条(联合贷%d条), 实际 %d条, 跳过 %d条, 报送成功 %d条; ";

        for (int j = 0; j < 2; j++) {
            Stopwatch sendWatch = Stopwatch.createStarted();
            try {
                List<RepaymentInfoZhuDai> repaymentLoanInfos = null;
                List<RepaymentInfoZhuDai> repaymentLoanInfosLh = null;
                if (j == 0) {
                    Stopwatch realTimeStopWatch1 = Stopwatch.createStarted();
                    repaymentLoanInfos = repaymentLoanInfoMapper.findRealTimeRepayMentInfo(timeRecord);
                    log.info("量化派助贷TO百行报送-非联合贷实时还款, startnyr: {} , endnyr: {} , 大小: {} , 耗时: {} ", startnyr, endnyr, repaymentLoanInfos.size(), (realTimeStopWatch1.stop().elapsed(TimeUnit.MILLISECONDS)/1000)+".s");

                    Stopwatch realTimeStopWatch2 = Stopwatch.createStarted();
                    repaymentLoanInfosLh = repaymentLoanInfoMapper.findRealTimeRepayMentInfoLh(timeRecord);
                    log.info("量化派助贷TO百行报送-联合贷实时还款, startnyr: {} , endnyr: {} , 大小: {} , 耗时: {} ", startnyr, endnyr, repaymentLoanInfosLh.size(), (realTimeStopWatch2.stop().elapsed(TimeUnit.MILLISECONDS)/1000)+".s");

                } else {
                    Stopwatch realTimeOverdueStopWatch3 = Stopwatch.createStarted();
                    repaymentLoanInfos = repaymentLoanInfoMapper.findRealTimeRepayMentOverdue(timeRecord);
                    log.info("量化派助贷TO百行报送-非联合贷实时还款逾期, startnyr: {} , endnyr: {} , 大小: {} , 耗时: {} ", startnyr, endnyr, repaymentLoanInfos.size(), (realTimeOverdueStopWatch3.stop().elapsed(TimeUnit.MILLISECONDS)/1000)+".s");

                    Stopwatch realTimeOverdueStopWatch4 = Stopwatch.createStarted();
                    repaymentLoanInfosLh = repaymentLoanInfoMapper.findRealTimeRepayMentOverdueLh(timeRecord);
                    log.info("量化派助贷TO百行报送-联合贷实时还款逾期, startnyr: {} , endnyr: {} , 大小: {} , 耗时: {} ", startnyr, endnyr, repaymentLoanInfosLh.size(), (realTimeOverdueStopWatch4.stop().elapsed(TimeUnit.MILLISECONDS)/1000)+".s");

                }

                if(repaymentLoanInfos==null){
                    repaymentLoanInfos = new ArrayList<RepaymentInfoZhuDai>();
                }
                if(repaymentLoanInfosLh!=null && repaymentLoanInfosLh.size()>0){
                    repaymentLoanInfos.addAll(repaymentLoanInfosLh);
                }

                AtomicInteger succ_atomicInt= new AtomicInteger();
                AtomicInteger totail_atomicInt = new AtomicInteger();
                AtomicInteger tg_atomicInt = new AtomicInteger();
                for (int i = 0; i < repaymentLoanInfos.size(); i++) {
                    RepaymentInfoZhuDai repaymentLoanInfo = repaymentLoanInfos.get(i);
                    String id = "";
                    String reqId_log = repaymentLoanInfo.getReqID();
                    try {
                        RepaymentInfoZhuDai repaymentLoanInfo1 = repaymentLoanInfoDbMapper.findLastOne(BaiHangRepayment.builder().loanId(repaymentLoanInfo.getLoanId()).termNo(repaymentLoanInfo.getTermNo()).build());
                        if (j > 0 && Objects.nonNull(repaymentLoanInfo1)) {
                            tg_atomicInt.getAndIncrement();
                            log.info("量化派助贷TO百行报送-实时还款逾期跳过报送, reqId_log: {} , loanId: {} , termNo: {} , startnyr: {} , endnyr: {} , bean: {} ", reqId_log, repaymentLoanInfo.getLoanId(), repaymentLoanInfo.getTermNo(), startnyr, endnyr, JSON.toJSONString(repaymentLoanInfo1));
                            continue;
                        }
                        totail_atomicInt.getAndIncrement();

                        id = UUID.randomUUID().toString().replaceAll("-", "");
                        try {
                            repaymentLoanInfo.setRecordId(id);
                            repaymentLoanInfoDbMapper.saveRepaymentLoanInfoLog(repaymentLoanInfo);
                        } catch (Exception e) {
                            log.error("量化派助贷TO百行报送-实时还款保存记录异常, reqId_log: {} , loanId: {} , termNo: {} , JSON: {} ", reqId_log, repaymentLoanInfo.getLoanId(), repaymentLoanInfo.getTermNo(), JSON.toJSONString(repaymentLoanInfo), e);
                        }
                        repaymentLoanInfo.setRecordId(null);
                        repaymentLoanInfo.setReqID(id);

                        repaymentLoanInfo.setPid(interfaceUploadClient(repaymentLoanInfo.getPid()));
                        repaymentLoanInfo.setName(interfaceUploadClient(repaymentLoanInfo.getName()));
                        repaymentLoanInfo.setMobile(interfaceUploadClient(repaymentLoanInfo.getMobile()));

                        String resultStr = iHttpService.postBaiHang(baiHangRepayMentLoanInfoUrl, getHeader(), JSON.toJSONString(repaymentLoanInfo));
                        log.info("助贷还款用户报送结果, param: {} , resultStr: {} ", JSON.toJSONString(repaymentLoanInfo), resultStr);
                        if (Objects.isNull(resultStr) || !"success".equalsIgnoreCase(JSON.parseObject(resultStr).getString("status"))) {
                            log.info("量化派助贷TO百行报送-还款返回结果不正确, 开始时间: {} , 结束时间: {} , reqId_log: {} , recordId: {} , loanId: {} , bean: {} ", startnyr, endnyr, reqId_log, id, repaymentLoanInfo.getLoanId(), JSON.toJSONString(repaymentLoanInfo));
                            repaymentLoanInfoDbMapper.updateCurrentRecordEnableFalse(BaiHangUpDateRecord.builder().enable("0").recordId(id).build());
                        } else {
                            succ_atomicInt.getAndIncrement();
                        }
                    } catch (Exception e) {
                        log.error("量化派助贷TO百行报送-还款信息异常, reqId_log: {} , recordId: {} , loanId: {} ", reqId_log, id, repaymentLoanInfo.getLoanId(), e);
                    }
                }

                if (j == 0) {
                    resMsg+=String.format(temp_huanKuan, repaymentLoanInfos.size(), (repaymentLoanInfosLh!=null ? repaymentLoanInfosLh.size() : 0), totail_atomicInt.get(), tg_atomicInt.get(), succ_atomicInt.get());
                }else{
                    resMsg+=String.format(temp_yuQi, repaymentLoanInfos.size(), (repaymentLoanInfosLh!=null ? repaymentLoanInfosLh.size() : 0), totail_atomicInt.get(), tg_atomicInt.get(), succ_atomicInt.get());
                }

                log.info("量化派助贷TO百行报送-还款申请完成 J: {} , 开始时间: {} , 结束时间: {} , list大小: {} , 实际大小: {} , 跳过: {} , 报送成功大小: {} , 耗时: {} ", j, startnyr, endnyr, repaymentLoanInfos.size(), totail_atomicInt.get(), tg_atomicInt.get(), succ_atomicInt.get(), (sendWatch.stop().elapsed(TimeUnit.MILLISECONDS)/1000)+".s");
            } catch (Exception e) {
                log.error("量化派助贷TO百行报送-异常 J: {} , 开始时间: {} , 结束时间: {} ", j, startnyr, endnyr, e);
            }
        }

        return resMsg;
    }


    //--------------------------------------手动重新报送------------------------------------------------------------------------------
    /**
     * 描述: 手动重新报送-部分申请A1逻辑问题数据 (手动报送A1) <br/>
     * 参数: []  <br/>
     * 返回值: void  <br/>
     * 创建人: yanhui.Hao  <br/>
     * 创建时间: 2019.10.29  <br/>
     */
    public void sendHandApplyToBaiHang(boolean isReadFile,List<String> paramJsonStr) throws Exception {
        Stopwatch sendWatch = Stopwatch.createStarted();
        List<String> handApplys = null;
        if(isReadFile){
            handApplys = FileUtils.readLines(new File(baihangHandA1DataUrl), "utf-8");
        }else{
            if(paramJsonStr==null || paramJsonStr.size()==0){
                log.warn("众信利民助贷模式TO百行手动报送贷款申请错误, paramJsonStr is Null , isReadFile: {} ",isReadFile);
                return;
            }else{
                handApplys = paramJsonStr;
            }
        }
        //log.info("百行征信助贷模式报送贷款申请数据, isReadFile: {} , handApplys: {} ", isReadFile, JSON.toJSONString(handApplys));
        for(int i=0;i<handApplys.size();i++){
            //try {
                ApplyLoanInfoZhuDai applyInfo = new Gson().fromJson(handApplys.get(i), new TypeToken<ApplyLoanInfoZhuDai>(){}.getType());
                log.info("众信利民助贷模式TO百行手动报送申请单个数据, {}", JSON.toJSONString(applyInfo));

                applyInfo.setName(interfaceUploadClient(applyInfo.getName()));
                applyInfo.setMobile(interfaceUploadClient(applyInfo.getMobile()));
                applyInfo.setPid(interfaceUploadClient(applyInfo.getPid()));

                //邮箱有错误的就不传
                if(!TuoMinUtils.checkEmail(applyInfo.getEmailAddress())){
                    applyInfo.setEmailAddress(null);
                }

                String resultStr = iHttpService.postBaiHang(baiHangApplyLoanInfoUrl, getHeader(), JSON.toJSONString(applyInfo));
                /*if (Objects.isNull(resultStr) || !(resultStr.contains("queryHistory") && resultStr.contains("nonRevolvingLoan") && resultStr.contains("revolvingLoan"))) {
                    log.info("量化派助贷TO百行报送-贷款申请返回结果不正确, loanId: {} ", applyInfo.getLoanId());
                }*/
                log.info("众信利民助贷模式TO百行手动报送贷款申请记录 json: {} , result: {} ", JSON.toJSONString(applyInfo),  resultStr);
            /*} catch (Exception e) {
                log.error("百行征信助贷模式手动报送贷款申请记录异常", e);
            }*/
        }
        log.info("众信利民助贷模式TO百行手动报送贷款申请结束, 大小: {} , 耗时: {} ", handApplys.size(),  ((sendWatch.stop().elapsed(TimeUnit.MILLISECONDS)/1000)+".s"));
    }

    /**
     * 描述: 手动重新报送-部分放款D2逻辑问题数据 (手动报送D2) <br/>
     * 参数: []  <br/>
     * 返回值: void  <br/>
     * 创建人: yanhui.Hao  <br/>
     * 创建时间: 2019.10.29  <br/>
     */
    @Deprecated
    public void sendHandLoaInfoReportToBaiHang(boolean isReadFile, List<String> paramJsonStr) throws Exception {
        Stopwatch sendWatch = Stopwatch.createStarted();
        List<String> handLoanInfos = null;
        if(isReadFile){
            handLoanInfos = FileUtils.readLines(new File(baihangHandD2DataUrl), "utf-8");
        }else{
            if(paramJsonStr==null || paramJsonStr.size()==0){
                log.warn("众信利民助贷模式TO百行手动报送放款数据错误, paramJsonStr is Null , isReadFile: {} ",isReadFile);
                return;
            }else{
                handLoanInfos = paramJsonStr;
            }
        }

        //log.info("众信利民助贷模式TO百行手动报送送放款数据, {}", JSON.toJSONString(handLoanInfos));
        for(int i=0;i<handLoanInfos.size();i++){
            LoanInfoZhuDai loanInfozd_tmp = new Gson().fromJson(handLoanInfos.get(i), new TypeToken<LoanInfoZhuDai>(){}.getType());
            log.info("众信利民助贷模式TO百行手动报送放款单个数据, {}", JSON.toJSONString(loanInfozd_tmp));
            String loanInfoReqId = loanInfozd_tmp.getReqID();

           /*if(loanInfozd_tmp.getTotalTerm() > 1){
                List<String> targetRepaymentDayList = loanInfoMapper.findTargetRepaymentDayList(loanInfoReqId);
                loanInfozd_tmp.setTargetRepayDateList(String.join(",", targetRepaymentDayList));
               System.out.println("比较还款总期数&账单日列表totalTerm="+loanInfozd_tmp.getTotalTerm()+",targetRepaymentDayList size="+targetRepaymentDayList.size());
            }else{
               System.err.println("比较还款总期数&账单日列表totalTerm="+loanInfozd_tmp.getTotalTerm());
           }*/
            List<String> targetRepaymentDayList = loanInfoMapper.findTargetRepaymentDayList(loanInfoReqId);
            if(targetRepaymentDayList!=null && targetRepaymentDayList.size()>0){
                loanInfozd_tmp.setTargetRepayDateList(String.join(",", targetRepaymentDayList));
                //log.info("比较还款总期数&账单日列表totalTerm="+loanInfozd_tmp.getTotalTerm()+",targetRepaymentDayList size="+targetRepaymentDayList.size());
            }else{
                log.warn("比较还款总期数&账单日列表totalTerm="+loanInfozd_tmp.getTotalTerm()+",targetRepaymentDayList is null.");
            }

            String relationID = loanInfozd_tmp.getRelationID();
            if(relationID!=null){
                if(relationID.length()>36){ //长度[1,36]
                    //lhp_1911049771615765816566b49a2db1c429
                    if(relationID.startsWith("lhp_")){
                        String tmp = relationID.substring(4,relationID.length());
                        if(tmp.length()>35){
                            //lhp_1909279744718808613622e008da4c110000
                            loanInfozd_tmp.setRelationID("H"+tmp.substring(0,35));
                        }else{
                            loanInfozd_tmp.setRelationID("L"+tmp);
                        }
                    }else{
                        log.warn("众信利民助贷模式TO百行手动报送-数据不正确, 发现其他类型的relationID并且长度大于36, relationID: {} , loanInfoReqId: {} ", relationID, loanInfoReqId);
                        //continue;
                        loanInfozd_tmp.setRelationID("X"+relationID.substring(0,35));
                    }
                }
            }

            try{
                loanInfozd_tmp.setRecordId(loanInfozd_tmp.getReqID());
                loanInfoDbMapper.saveLoanInfoRecordLog(loanInfozd_tmp);
            }catch(Exception e){
                log.error("众信利民助贷模式TO百行手动报送-放款申请保存记录失败, loanInfoReqId: {} , JSON: {} ", loanInfoReqId, JSON.toJSONString(loanInfozd_tmp), e);
            }
            loanInfozd_tmp.setRecordId(null);

            String jsonStr = JSONObject.toJSONString(loanInfozd_tmp);
            LoanInfoZhuDaiVo loanInfo = JSONObject.parseObject(jsonStr, LoanInfoZhuDaiVo.class);
            FinTechAgencyBusinessZhuDai finTechAgencyBusiness = JSONObject.parseObject(jsonStr, FinTechAgencyBusinessZhuDai.class);
            loanInfo.setFinTechAgencyBusiness(finTechAgencyBusiness);

            loanInfo.setMobile(interfaceUploadClient(loanInfo.getMobile()));
            loanInfo.setName(interfaceUploadClient(loanInfo.getName()));
            loanInfo.setPid(interfaceUploadClient(loanInfo.getPid()));

            String resultStr = iHttpService.postBaiHang(baiHangLoanInfoUrl, getHeader(), JSON.toJSONString(loanInfo));
            log.info("众信利民助贷模式TO百行手动报送放款记录 loanInfoReqId: {} , loanId: {} , bean: {} , result: {} ", loanInfoReqId, loanInfo.getLoanId(), JSON.toJSONString(loanInfo), resultStr);


            //存量测试手动整理
            /*loanInfozd_tmp.setRecordId(null);
            String jsonStr = JSONObject.toJSONString(loanInfozd_tmp);
            LoanInfoZhuDaiVo loanInfoZhuDaiVo = JSONObject.parseObject(jsonStr, LoanInfoZhuDaiVo.class);
            FinTechAgencyBusinessZhuDai finTechAgencyBusiness = JSONObject.parseObject(jsonStr, FinTechAgencyBusinessZhuDai.class);
            loanInfoZhuDaiVo.setFinTechAgencyBusiness(finTechAgencyBusiness);

            String id = UUID.randomUUID().toString().replaceAll("-", "");
            loanInfoZhuDaiVo.setReqID(id);
            try {
                FileUtils.write(new File("D:\\用户目录\\Downloads\\build_D2_01_M.txt"), JSON.toJSONString(loanInfoZhuDaiVo)+"\r\n", "UTF-8", true);
                //脱敏数据写一份
                testTuoMinFileWrite("D:\\用户目录\\Downloads\\build_D2_TEST_01_M.txt","20101113",null,loanInfoZhuDaiVo,null);
            } catch (Exception e) {
                log.error("放款存量数据处理异常, startTime: {} , endTime: {} , recordId: {} , loanId: {} ",null, null, id, loanInfoZhuDaiVo.getLoanId(), e);
            }*/
        }
        log.info("众信利民助贷模式TO百行手动报送放款记录结束, 大小: {} , 耗时: {} ", handLoanInfos.size(),  ((sendWatch.stop().elapsed(TimeUnit.MILLISECONDS)/1000)+".s"));
    }

    //D2手动报送，有账单日列表，和totalTerm
    public void sendHandLoaInfoReportToBaiHang2(boolean isReadFile, List<String> paramJsonStr) throws Exception {
        Stopwatch sendWatch = Stopwatch.createStarted();
        List<String> handLoanInfos = null;
        if(isReadFile){
            handLoanInfos = FileUtils.readLines(new File(baihangHandD2DataUrl), "utf-8");
        }else{
            if(paramJsonStr==null || paramJsonStr.size()==0){
                log.warn("众信利民助贷模式TO百行手动报送放款数据错误, paramJsonStr is Null , isReadFile: {} ",isReadFile);
                return;
            }else{
                handLoanInfos = paramJsonStr;
            }
        }

        for(int i=0;i<handLoanInfos.size();i++){
            LoanInfoZhuDai loanInfozd_tmp = new Gson().fromJson(handLoanInfos.get(i), new TypeToken<LoanInfoZhuDai>(){}.getType());
            log.info("众信利民助贷模式TO百行手动报送放款单个数据, {}", JSON.toJSONString(loanInfozd_tmp));
            String loanInfoReqId = loanInfozd_tmp.getReqID();

            /*List<String> targetRepaymentDayList = loanInfoMapper.findTargetRepaymentDayList(loanInfoReqId);
            if(targetRepaymentDayList!=null && targetRepaymentDayList.size()>0){
                loanInfozd_tmp.setTargetRepayDateList(String.join(",", targetRepaymentDayList));
                //log.info("比较还款总期数&账单日列表totalTerm="+loanInfozd_tmp.getTotalTerm()+",targetRepaymentDayList size="+targetRepaymentDayList.size());
            }else{
                log.warn("比较还款总期数&账单日列表totalTerm="+loanInfozd_tmp.getTotalTerm()+",targetRepaymentDayList is null.");
            }*/

            /*String relationID = loanInfozd_tmp.getRelationID();
            if(relationID!=null){
                if(relationID.length()>36){ //长度[1,36]
                    //lhp_1911049771615765816566b49a2db1c429
                    if(relationID.startsWith("lhp_")){
                        String tmp = relationID.substring(4,relationID.length());
                        if(tmp.length()>35){
                            //lhp_1909279744718808613622e008da4c110000
                            loanInfozd_tmp.setRelationID("H"+tmp.substring(0,35));
                        }else{
                            loanInfozd_tmp.setRelationID("L"+tmp);
                        }
                    }else{
                        log.warn("众信利民助贷模式TO百行手动报送-数据不正确, 发现其他类型的relationID并且长度大于36, relationID: {} , loanInfoReqId: {} ", relationID, loanInfoReqId);
                        //continue;
                        loanInfozd_tmp.setRelationID("X"+relationID.substring(0,35));
                    }
                }
            }*/

            try{
                if(loanInfozd_tmp.getRecordId()==null){
                    loanInfozd_tmp.setRecordId(UUID.randomUUID().toString().replaceAll("-", ""));
                }
                loanInfoDbMapper.saveLoanInfoRecordLog(loanInfozd_tmp);
            }catch(Exception e){
                log.error("众信利民助贷模式TO百行手动报送-放款申请保存记录失败, loanInfoReqId: {} , JSON: {} ", loanInfoReqId, JSON.toJSONString(loanInfozd_tmp), e);
            }
            loanInfozd_tmp.setRecordId(null);

            String jsonStr = JSONObject.toJSONString(loanInfozd_tmp);
            LoanInfoZhuDaiVo loanInfo = JSONObject.parseObject(jsonStr, LoanInfoZhuDaiVo.class);
            FinTechAgencyBusinessZhuDai finTechAgencyBusiness = JSONObject.parseObject(jsonStr, FinTechAgencyBusinessZhuDai.class);
            loanInfo.setFinTechAgencyBusiness(finTechAgencyBusiness);

            loanInfo.setMobile(interfaceUploadClient(loanInfo.getMobile()));
            loanInfo.setName(interfaceUploadClient(loanInfo.getName()));
            loanInfo.setPid(interfaceUploadClient(loanInfo.getPid()));

            String resultStr = iHttpService.postBaiHang(baiHangLoanInfoUrl, getHeader(), JSON.toJSONString(loanInfo));
            log.info("众信利民助贷模式TO百行手动报送放款记录 loanInfoReqId: {} , loanId: {} , bean: {} , result: {} ", loanInfoReqId, loanInfo.getLoanId(), JSON.toJSONString(loanInfo), resultStr);
        }
        log.info("众信利民助贷模式TO百行手动报送放款记录结束, 大小: {} , 耗时: {} ", handLoanInfos.size(),  ((sendWatch.stop().elapsed(TimeUnit.MILLISECONDS)/1000)+".s"));
    }

    /**
     * 描述: 手动重新报送-部分还款D3逻辑问题数据 (手动报送D3) <br/>
     * 参数: []  <br/>
     * 返回值: void  <br/>
     * 创建人: yanhui.Hao  <br/>
     * 创建时间: 2019.10.29  <br/>
     */
    public void sendHandRepaymentReportToBaiHang1(boolean isReadFile, List<String> paramJsonStr) throws Exception{
        Stopwatch sendWatch = Stopwatch.createStarted();
        List<String> repaymentLoanInfos = null;
        if(isReadFile){
            repaymentLoanInfos = FileUtils.readLines(new File(baihangHandD3DataUrl), "utf-8");
        }else{
            if(paramJsonStr==null || paramJsonStr.size()==0){
                log.warn("众信利民助贷模式TO百行手动报送还款数据错误, paramJsonStr is Null , isReadFile: {} ",isReadFile);
                return;
            }else{
                repaymentLoanInfos = paramJsonStr;
            }
        }

        //try {
            log.info("众信利民助贷模式TO百行报送还款数据, {}", JSON.toJSONString(repaymentLoanInfos));
            for(int i=0;i<repaymentLoanInfos.size();i++){
                RepaymentInfoZhuDai repaymentLoanInfo = new Gson().fromJson(repaymentLoanInfos.get(i), new TypeToken<RepaymentInfoZhuDai>(){}.getType());
                log.info("众信利民助贷模式TO百行手动报送还款数据单个数据, {}", JSON.toJSONString(repaymentLoanInfo));

                try {
                    ////repaymentLoanInfo.setRecordId(repaymentLoanInfo.getReqID());
                    if(repaymentLoanInfo.getRecordId()==null){
                        repaymentLoanInfo.setRecordId(UUID.randomUUID().toString().replaceAll("-", ""));
                    }
                    repaymentLoanInfoDbMapper.saveRepaymentLoanInfoLog(repaymentLoanInfo);
                } catch (Exception e) {
                    log.error("众信利民助贷模式TO百行手动报送还款保存记录异常, reqId_log: {} , loanId: {} , termNo: {} , JSON: {} ", repaymentLoanInfo.getReqID(), repaymentLoanInfo.getLoanId(), repaymentLoanInfo.getTermNo() ,JSON.toJSONString(repaymentLoanInfo), e);
                }
                repaymentLoanInfo.setRecordId(null);

                repaymentLoanInfo.setPid(interfaceUploadClient(repaymentLoanInfo.getPid()));
                repaymentLoanInfo.setName(interfaceUploadClient(repaymentLoanInfo.getName()));
                repaymentLoanInfo.setMobile(interfaceUploadClient(repaymentLoanInfo.getMobile()));

                String resultStr = iHttpService.postBaiHang(baiHangRepayMentLoanInfoUrl, getHeader(), JSON.toJSONString(repaymentLoanInfo));
                log.info("众信利民助贷模式TO百行手动报送还款记录 reqID: {} , result: {} ", repaymentLoanInfo.getReqID(), resultStr);
            }
        /*} catch (Exception e) {
            log.error("百行征信助贷模式手动报送还款异常", e);
        }*/
        log.info("众信利民助贷模式TO百行手动报送还款记录结束, 大小: {} , 耗时: {} ", repaymentLoanInfos.size(),  ((sendWatch.stop().elapsed(TimeUnit.MILLISECONDS)/1000)+".s"));
    }

    //-----------------------------------------------存量整理---------------------------------------------------------------------
    /**
     * 描述: http 百行-助贷申请A1存量数据 整理 <br/>
     * 参数: [strStartDate, noEndDate]  <br/>
     * 返回值: java.lang.String  <br/>
     * 创建人: yanhui.Hao  <br/>
     * 创建时间: 2019.10.23  <br/>
     */
    public String stockApplyLoanInfoZhuDai(String startDate, String noEndDate) {
        //"2019-05-07T00:00:00"
        if (StringUtils.isAnyBlank(startDate, noEndDate)) {
            log.warn("stockLoanInfoZhuDai日期格式有误, startDate : {} , noEndDate : {} ", startDate, noEndDate);
            return "日期格式有误";
        }
        if (startDate.length() != 19 || noEndDate.length() != 19 || !startDate.contains("T") || !noEndDate.contains("T")) {
            log.warn("stockLoanInfoZhuDai日期格式有误, startDate : {} , noEndDate : {} ", startDate, noEndDate);
            return "日期格式有误";
        }

        final String fileName = zl_file_path_name + "lhp_A1_" + startDate.substring(0, startDate.indexOf("T")).replace("-", "") + "_" + noEndDate.substring(0, noEndDate.indexOf("T")).replace("-", "");

        LocalDateTime erlyDate = LocalDateTime.parse(startDate);
        LocalDateTime endDate = LocalDateTime.parse(noEndDate);

        //2019.11.20 把标题加就去，以免忘记加
        try {
            FileUtils.write(new File(fileName+"_01.txt"), "#applyInfo\r\n", "UTF-8", true);
        }catch (Exception e){
            log.error("A1存量添加标题#applyInfo异常",e);
        }

        int counter = 0;
        log.info("开始>>百行-助贷申请存量数据整理, startDate : {} , noEndDate : {} ......", startDate, noEndDate);
        long sUtc1 = System.currentTimeMillis();

        while (true) {
            long sUtc2 = System.currentTimeMillis();
            if(A1_Stop.get()){
                log.error("All申请存量数据查询STOP, A1_Stop: {} , endTime: {} ",A1_Stop.get(), erlyDate.plusDays(counter).format(DateTimeFormatter.ISO_DATE));
                break;
            }
            counter++;
            if (erlyDate.plusDays(counter).compareTo(endDate) > 0) {
                break;
            }

            String starTime = erlyDate.plusDays(counter - 1).format(DateTimeFormatter.ISO_DATE);
            String endTime = erlyDate.plusDays(counter).format(DateTimeFormatter.ISO_DATE);
            BaiHangTimeRecord timeRecord = BaiHangTimeRecord.builder().startTime(starTime).endTime(endTime).build();

            /*List<ApplyLoanInfoZhuDai> applyLoanInfoList = applyLoanInfoMapper.queryStockApplyLoanInfoZhuDai(timeRecord);*/

            Stopwatch queryWatch1 = Stopwatch.createStarted();
            List<ApplyLoanInfoZhuDai> applyLoanInfoList = applyLoanInfoMapper.findRealTimeApplyLoanZhuDai(timeRecord);
            log.info("申请存量-非联合贷查询结束, 大小: {} , starTime: {} , 耗时: {} ", applyLoanInfoList.size(), starTime, (queryWatch1.stop().elapsed(TimeUnit.MILLISECONDS)/1000)+".s");

            List<ApplyLoanInfoZhuDai> applyLoanInfosLh = null;
            //联合贷产品上线时间，上线后才有数据
            if(erlyDate.plusDays(counter-1).compareTo(liang_he_dai_start) >= 0){
                Stopwatch queryWatch2 = Stopwatch.createStarted();
                applyLoanInfosLh = applyLoanInfoMapper.findRealTimeApplyLoanZhuDaiLh(timeRecord);
                log.info("申请存量-联合贷查询结束, 大小: {} , starTime: {} , 耗时: {} ", applyLoanInfosLh.size(), starTime, (queryWatch2.stop().elapsed(TimeUnit.MILLISECONDS)/1000)+".s");
            }

            if(applyLoanInfoList==null){
                applyLoanInfoList = new ArrayList<ApplyLoanInfoZhuDai>();
            }
            if(applyLoanInfosLh!=null && applyLoanInfosLh.size()>0){
                applyLoanInfoList.addAll(applyLoanInfosLh);
            }

            int listSize = applyLoanInfoList!=null ? applyLoanInfoList.size(): 0;
            log.info("All申请存量数据查询结束, listSize : {} , startTime: {} , endTime: {} , 耗时 : {} ", listSize, starTime, endTime, ((System.currentTimeMillis()-sUtc2)/1000)+".s");

            String upladTs = LocalDateTime.now().toString().substring(0, 19);
            for (int i = 0; i < applyLoanInfoList.size(); i++) {
                try {
                    ApplyLoanInfoZhuDai applyLoanInfo = applyLoanInfoList.get(i);
                    applyLoanInfo.setUploadTs(upladTs);
                    String uuid = UUID.randomUUID().toString().replaceAll("-", "");
                    log.info("history log A1 oldReqID="+applyLoanInfo.getReqID()+",newReqID="+uuid);
                    applyLoanInfo.setReqID(uuid);

                    //邮箱有错误的就不传
                    if(!TuoMinUtils.checkEmail(applyLoanInfo.getEmailAddress())){
                        applyLoanInfo.setEmailAddress(null);
                    }

                    //2019.11.18
                    if(applyLoanInfo.getApplyDate()!=null){
                        applyLoanInfo.setUploadTs(applyLoanInfo.getApplyDate());//applyDate
                    }

                    FileUtils.write(new File(fileName+"_01.txt"), JSON.toJSONString(applyLoanInfo)+"\r\n", "UTF-8", true);

                    //脱敏数据写一份
                    //testTuoMinFileWrite(fileName+"_TEST_01.txt",starTime,applyLoanInfo,null,null);

                } catch (Exception e) {
                    log.error("申请存量数据处理异常, startTime: {} , endTime: {} ",starTime, endTime, e);
                }
            }
        }

        log.info("结束<<百行-助贷申请整理, startTime : {} , endTime : {} , 总耗时: {} ......",startDate,noEndDate, ((System.currentTimeMillis()-sUtc1)/1000)+".s");
        return "百行-助贷申请整理结束";
    }


    /**
     * 描述: http 百行-助贷放款D2存量数据 整理 <br/>
     * 参数: [strStartDate, noEndDate]  <br/>
     * 返回值: java.lang.String  <br/>
     * 创建人: yanhui.Hao  <br/>
     * 创建时间: 2019.10.23  <br/>
     */
    public String stockLoanInfoZhuDai(String startDate, String noEndDate,String isNotHaveReqID) {
        //"2019-05-07T00:00:00"
        if(StringUtils.isAnyBlank(startDate,noEndDate)){
            log.warn("stockLoanInfoZhuDai日期格式有误, startDate : {} , noEndDate : {} ",startDate,noEndDate);
            return "日期格式有误";
        }
        if(startDate.length()!=19 || noEndDate.length()!=19 || !startDate.contains("T") || !noEndDate.contains("T")){
            log.warn("stockLoanInfoZhuDai日期格式有误, startDate : {} , noEndDate : {} ",startDate,noEndDate);
            return "日期格式有误";
        }
        final String fileName = zl_file_path_name+"lhp_D2_" + startDate.substring(0,startDate.indexOf("T")).replace("-","") + "_" + noEndDate.substring(0,noEndDate.indexOf("T")).replace("-","");

        LocalDateTime erlyDate = LocalDateTime.parse(startDate);
        LocalDateTime endDate = LocalDateTime.parse(noEndDate);

        boolean notHaveReqID = true;
        if(StringUtils.isNotEmpty(isNotHaveReqID) && "treu".equals(isNotHaveReqID)){
            notHaveReqID = false;
        }

        //2019.11.20 把标题加就去，以免忘记加
        try {
            FileUtils.write(new File(fileName+"_01.txt"), "#singleLoanAccountInfo\r\n", "UTF-8", true);
        }catch (Exception e){
            log.error("D2存量添加标题#singleLoanAccountInfo异常",e);
        }

        int counter = 0;
        log.info("开始>>百行-助贷放款存量数据整理, startDate : {} , noEndDate : {} ......",startDate,noEndDate);
        while (true) {
            if(D2_Stop.get()){
                log.error("All放款存量数据查询STOP, D2_Stop: {} , endTime: {} ",D2_Stop.get(), erlyDate.plusDays(counter).format(DateTimeFormatter.ISO_DATE));
                break;
            }

            counter++;
            if (erlyDate.plusDays(counter).compareTo(endDate) > 0) {
                break;
            }
            long sUtc1 = System.currentTimeMillis();
            String starTime = erlyDate.plusDays(counter-1).format(DateTimeFormatter.ISO_DATE);
            String endTime = erlyDate.plusDays(counter).format(DateTimeFormatter.ISO_DATE);
            BaiHangTimeRecord timeRecord = BaiHangTimeRecord.builder().startTime(starTime).endTime(endTime).build();

           /* List<LoanInfoZhuDai> loanInfozdList = loanInfoMapper.queryStockLoanInfoZhuDai(timeRecord);*/

            Stopwatch queryWatch1 = Stopwatch.createStarted();
            List<LoanInfoZhuDai> loanInfozdList = loanInfoMapper.findRealTimeLoanInfoZhuDai(timeRecord);
            log.info("放款存量-非联合贷查询结束, 大小: {} , starTime: {} , 耗时: {} ", loanInfozdList.size(), starTime, (queryWatch1.stop().elapsed(TimeUnit.MILLISECONDS)/1000)+".s");

            List<LoanInfoZhuDai> loanInfozdListLh = null;
            //联合贷产品上线时间，上线后才有数据
            if(erlyDate.plusDays(counter-1).compareTo(liang_he_dai_start) >= 0){
                Stopwatch queryWatch2 = Stopwatch.createStarted();
                loanInfozdListLh = loanInfoMapper.findRealTimeLoanInfoZhuDaiLh(timeRecord);
                log.info("放款存量-联合贷查询结束, 大小: {} , starTime: {} , 耗时: {} ", loanInfozdListLh.size(), starTime, (queryWatch2.stop().elapsed(TimeUnit.MILLISECONDS)/1000)+".s");

            }

            if(loanInfozdList==null){
                loanInfozdList = new ArrayList<LoanInfoZhuDai>();
            }
            if(loanInfozdListLh!=null && loanInfozdListLh.size()>0){
                loanInfozdList.addAll(loanInfozdListLh);
            }

            int listSize = loanInfozdList!=null ? loanInfozdList.size(): 0;
            log.info("All放款存量数据查询结束, listSize : {} , startTime: {} , endTime: {} , 耗时 : {} ", listSize, starTime, endTime, ((System.currentTimeMillis()-sUtc1)/1000)+".s");

            if(listSize>0){
                for (int i = 0; i < listSize; i++) {
                    LoanInfoZhuDai loanInfozd_tmp = loanInfozdList.get(i);

                    String relationID = loanInfozd_tmp.getRelationID();
                    if(relationID!=null){
                        if(relationID.length()>36){ //长度[1,36]
                            //lhp_1911049771615765816566b49a2db1c429
                            if(relationID.startsWith("lhp_")){
                                String tmp = relationID.substring(4,relationID.length());
                                if(tmp.length()>35){
                                    //lhp_1909279744718808613622e008da4c110000
                                    loanInfozd_tmp.setRelationID("H"+tmp.substring(0,35));
                                }else{
                                    loanInfozd_tmp.setRelationID("L"+tmp);
                                }
                            }else{
                                log.error("量化派助贷TO百行报送-放款返回结果不正确, 发现其他类型的relationID并且长度大于36,relationID: {} , startTime: {} , endTime: {} , loanId: {} ", relationID, starTime, endTime, loanInfozd_tmp.getLoanId());
                                //continue;
                                loanInfozd_tmp.setRelationID("X"+relationID.substring(0,35));
                            }
                        }
                    }

                    String jsonStr = JSONObject.toJSONString(loanInfozd_tmp);

                    LoanInfoZhuDaiVo loanInfoZhuDaiVo = JSONObject.parseObject(jsonStr, LoanInfoZhuDaiVo.class);
                    FinTechAgencyBusinessZhuDai finTechAgencyBusiness = JSONObject.parseObject(jsonStr, FinTechAgencyBusinessZhuDai.class);
                    loanInfoZhuDaiVo.setFinTechAgencyBusiness(finTechAgencyBusiness);

                    String id = UUID.randomUUID().toString().replaceAll("-", "");
                    try {
                        String loanInfoReqId = loanInfoZhuDaiVo.getReqID();
                        /*if (loanInfoZhuDaiVo.getTotalTerm() > 1) {
                            List<String> targetRepaymentDayList = loanInfoMapper.findTargetRepaymentDayList(loanInfoReqId);
                            loanInfoZhuDaiVo.setTargetRepayDateList(String.join(",", targetRepaymentDayList));
                        }*/
                        List<String> targetRepaymentDayList = loanInfoMapper.findTargetRepaymentDayList(loanInfoReqId);
                        if(targetRepaymentDayList!=null && targetRepaymentDayList.size()>0){
                            loanInfoZhuDaiVo.setTargetRepayDateList(String.join(",", targetRepaymentDayList));
                            //log.info("比较还款总期数&账单日列表totalTerm="+loanInfoZhuDaiVo.getTotalTerm()+",targetRepaymentDayList size="+targetRepaymentDayList.size());
                        }else{
                            log.warn("比较还款总期数&账单日列表totalTerm="+loanInfoZhuDaiVo.getTotalTerm()+",targetRepaymentDayList is null.");
                        }

                        if(notHaveReqID){//ReqID 替换为uuid
                            log.info("history log D2 oldReqID="+loanInfoZhuDaiVo.getReqID()+",newReqID="+id);
                            loanInfoZhuDaiVo.setReqID(id);
                        }

                        //2019.11.18
                        if(loanInfoZhuDaiVo.getIssueDate()!=null){
                            loanInfoZhuDaiVo.setUploadTs(loanInfoZhuDaiVo.getIssueDate()); //issueDate
                        }

                        FileUtils.write(new File(fileName+"_01.txt"), JSON.toJSONString(loanInfoZhuDaiVo)+"\r\n", "UTF-8", true);

                        //脱敏数据写一份
                        //testTuoMinFileWrite(fileName+"_TEST_01.txt",starTime,null,loanInfoZhuDaiVo,null);

                    } catch (Exception e) {
                        log.error("放款存量数据处理异常, startTime: {} , endTime: {} , recordId: {} , loanId: {} ",starTime, endTime, id, loanInfoZhuDaiVo.getLoanId(), e);
                    }
                }
            }
        }
        log.info("结束<<百行-助贷放款整理, startDate : {} , noEndDate : {} ......",startDate,noEndDate);
        return "百行-助贷放款整理结束";
    }



    /**
     * 描述: http 百行-助贷还款&逾期D3存量数据 整理 <br/>
     * 参数: [strStartDate, noEndDate]  <br/>
     * 返回值: java.lang.String  <br/>
     * 创建人: yanhui.Hao  <br/>
     * 创建时间: 2019.10.23  <br/>
     */
    public String  stockRepayMentInfoZhuDai(String startDate, String noEndDate, String d3Type,String isNotHaveReqID) {//d3Type=0 还款，type=1 逾期
        //"2019-05-07T00:00:00"
        if(StringUtils.isAnyBlank(startDate,noEndDate)){
            log.warn("stockRepayMentInfoZhuDai日期格式有误, startDate : {} , noEndDate : {} ",startDate,noEndDate);
            return "日期格式有误";
        }
        if(startDate.length()!=19 || noEndDate.length()!=19 || !startDate.contains("T") || !noEndDate.contains("T")){
            log.warn("stockRepayMentInfoZhuDai日期格式有误, startDate : {} , noEndDate : {} ",startDate,noEndDate);
            return "日期格式有误";
        }
        final String fileName = zl_file_path_name+"lhp_D3_" + startDate.substring(0,startDate.indexOf("T")).replace("-","") + "_" + noEndDate.substring(0,noEndDate.indexOf("T")).replace("-","");

        LocalDateTime erlyDate = LocalDateTime.parse(startDate);
        LocalDateTime endDate = LocalDateTime.parse(noEndDate);

        boolean notHaveReqID = true;
        if(StringUtils.isNotEmpty(isNotHaveReqID) && "treu".equals(isNotHaveReqID)){
            notHaveReqID = false;
        }

        //2019.11.20 把标题加就去，以免忘记加
        try {
            FileUtils.write(new File(fileName+"_01.txt"), "#singleLoanRepayInfo\r\n", "UTF-8", true);
        }catch (Exception e){
            log.error("D3存量添加标题#singleLoanRepayInfo异常",e);
        }

        int counter = 0;
        log.info("开始>>整理百行-助贷还款&逾期存量数据 startDate : {} , noEndDate : {} ......",startDate,noEndDate);

        StringBuffer  tmpWriteBuffer = null;
        while (true) {
            if(D3_Stop.get()){
                log.error("All还款&逾期存量数据查询STOP, D3_Stop: {} , endTime: {} ",D3_Stop.get(), erlyDate.plusDays(counter).format(DateTimeFormatter.ISO_DATE));
                break;
            }

            counter++;
            if (erlyDate.plusDays(counter).compareTo(endDate) > 0) {
                break;
            }

            List<RepaymentInfoZhuDai> repaymentInfoList = new ArrayList<>();
            List<RepaymentInfoZhuDai> repaymentLoanInfosLh = new ArrayList<>();

            String starTime = erlyDate.plusDays(counter-1).format(DateTimeFormatter.ISO_DATE);
            String endTime = erlyDate.plusDays(counter).format(DateTimeFormatter.ISO_DATE);
            log.info("整理百行-助贷还款&逾期 startTime: {} , endTime: {} ------------", starTime, endTime);
            BaiHangTimeRecord timeRecord = BaiHangTimeRecord.builder().startTime(starTime).endTime(endTime).build();

            for (int type = 0; type < 2; type++) {
                long log_stUtc = System.currentTimeMillis();
                try {
                    if (type == 0) {
                        if(StringUtils.isNotEmpty(d3Type) && d3Type.equals("1")){//只要逾期
                            continue;
                        }
                        //Stopwatch stopwatch = Stopwatch.createStarted();
                       /* repaymentInfoList = repaymentLoanInfoMapper.queryStockRepayMentInfoZhuDai(timeRecord);*/

                        Stopwatch realTimeStopWatch1 = Stopwatch.createStarted();
                        repaymentInfoList = repaymentLoanInfoMapper.findRealTimeRepayMentInfo(timeRecord);
                        log.info("还款存量-非联合贷查询结束, 大小: {} , starTime: {} , 耗时: {} ", repaymentInfoList.size(), starTime, (realTimeStopWatch1.stop().elapsed(TimeUnit.MILLISECONDS)/1000)+".s");

                        //联合贷产品上线时间，上线后才有数据
                        if(erlyDate.plusDays(counter-1).compareTo(liang_he_dai_start) >= 0){
                            Stopwatch realTimeStopWatch2 = Stopwatch.createStarted();
                            repaymentLoanInfosLh = repaymentLoanInfoMapper.findRealTimeRepayMentInfoLh(timeRecord);
                            log.info("还款存量-联合贷查询结束, 大小: {} , starTime: {} , 耗时: {} ", repaymentLoanInfosLh.size(), starTime, (realTimeStopWatch2.stop().elapsed(TimeUnit.MILLISECONDS)/1000)+".s");
                        }

                    } else {
                        if(StringUtils.isNotEmpty(d3Type) && d3Type.equals("0")){//只要还款
                            continue;
                        }

                        Stopwatch realTimeOverdueStopWatch3 = Stopwatch.createStarted();
                        repaymentInfoList = repaymentLoanInfoMapper.findRealTimeRepayMentOverdue(timeRecord);
                        log.info("逾期存量-非联合贷查询结束, 大小: {} , starTime: {} , 耗时: {} ", repaymentInfoList.size(), starTime, (realTimeOverdueStopWatch3.stop().elapsed(TimeUnit.MILLISECONDS)/1000)+".s");

                        //联合贷产品上线时间，上线后才有数据
                        if(erlyDate.plusDays(counter-1).compareTo(liang_he_dai_start) >= 0){
                            Stopwatch realTimeOverdueStopWatch4 = Stopwatch.createStarted();
                            repaymentLoanInfosLh = repaymentLoanInfoMapper.findRealTimeRepayMentOverdueLh(timeRecord);
                            log.info("逾期存量-联合贷查询结束, 大小: {} , starTime: {} , 耗时: {} ", repaymentLoanInfosLh.size(), starTime, (realTimeOverdueStopWatch4.stop().elapsed(TimeUnit.MILLISECONDS)/1000)+".s");
                        }
                    }

                    if(repaymentInfoList==null){
                        repaymentInfoList = new ArrayList<RepaymentInfoZhuDai>();
                    }
                    if(repaymentLoanInfosLh!=null && repaymentLoanInfosLh.size()>0){
                        repaymentInfoList.addAll(repaymentLoanInfosLh);
                    }

                    tmpWriteBuffer = new StringBuffer();
                    int buffCount = 0;
                    for (int j = 0; j < repaymentInfoList.size(); j++) {
                        RepaymentInfoZhuDai repaymentInfo = repaymentInfoList.get(j);
                        if(notHaveReqID){
                            String id = UUID.randomUUID().toString().replaceAll("-", "");
                            log.info("history log D3 oldReqID="+repaymentInfo.getReqID()+",newReqID="+id+",loanId="+repaymentInfo.getLoanId());
                            repaymentInfo.setReqID(id);
                        }

                        //2019.11.18
//                        if("normal".equals(repaymentInfo.getTermStatus().trim()) ){
//                            repaymentInfo.setUploadTs(repaymentInfo.getRealRepaymentDate());////realRepaymentDate  实际还款时间
//                        }else {
//                            //overdue
//                            repaymentInfo.setUploadTs(repaymentInfo.getStatusConfirmAt());//statusConfirmAt还款状态确认时间
//                        }
                        //“还款状态确认时间”应早于等于记录生成时间（uploadTs）
                        if(repaymentInfo.getStatusConfirmAt()!=null){
                            repaymentInfo.setUploadTs(repaymentInfo.getStatusConfirmAt());
                        }

                        //这么写太慢了
                        ///////FileUtils.write(new File(fileName+"_01.txt"), JSON.toJSONString(repaymentInfo)+"\r\n", "UTF-8", true);
                        //脱敏数据写一份
                        //testTuoMinFileWrite(fileName+"_TEST_01.txt",starTime,null,null,repaymentInfo);

                        tmpWriteBuffer.append(JSON.toJSONString(repaymentInfo)+"\r\n");
                        buffCount++;
                    }

                    FileUtils.write(new File(fileName+"_01.txt"), tmpWriteBuffer.toString(), "UTF-8", true);
                    log.info("批量写入文件结束, startTime: {} , type: {} , repaymentInfoList="+repaymentInfoList.size()+",buffCount="+buffCount+",Check Size="+(repaymentInfoList.size()==buffCount), starTime, type);
                    tmpWriteBuffer=null;
                    buffCount=0;

                } catch (Exception e) {
                    log.error("还款&逾期存量数据处理异常, startTime: {} , endTime: {} , type: {} ", starTime, endTime, type, e);
                    try{
                        String errMsgFlag = "Query Exception>>";//记录标识，用于补数据
                        if (type == 0) {
                            errMsgFlag+="还款整理,";
                        }else{
                            errMsgFlag+="逾期整理,";
                        }
                        errMsgFlag+="starTime="+starTime+",endTime="+endTime;
                        FileUtils.write(new File(fileName+"_01.txt"), errMsgFlag+"\r\n", "UTF-8", true);
                        //脱敏数据写一份
                        //testTuoMinFileWrite(fileName+"_TEST_01.txt",starTime,null,null,repaymentInfo);
                        ///FileUtils.write(new File(fileName+"_TEST_01.txt"), errMsgFlag+"\r\n", "UTF-8", true);
                    }catch (Exception e2){
                        log.error("还款&逾期写入文件异常, startTime: {} , endTime: {} , type: {} ", starTime, endTime, type, e2);
                    }
                }

                //打印日志
                if (type == 0) {
                    log.info("All还款整理结束, startTime: {} , endTime: {} , 大小: {} , 总耗时: {} ", starTime, endTime, repaymentInfoList.size(), ((System.currentTimeMillis()-log_stUtc)/1000)+".s");
                }else{
                    log.info("All逾期整理结束, startTime: {} , endTime: {} , 大小: {} , 总耗时: {} ", starTime, endTime, repaymentInfoList.size(), ((System.currentTimeMillis()-log_stUtc)/1000)+".s");
                }
            }
        }
        log.info("结束<<百行-助贷还款整理......");
        return "百行-助贷还款整理结束";
    }

    //-----------------------------------------------其他工具---------------------------------------------------------------------

    private Map<String, String> getHeader() {
        Map<String, String> headerMap = new HashMap<>();
        headerMap.put("Authorization", "Basic " + Base64.byteArrayToBase64((account + ":" + password).getBytes()));
        headerMap.put("Content-Type", "application/json");
        return headerMap;
    }

    private static String interfaceUploadClient(String param) throws Exception {
        InterfaceUploadRequest req = new InterfaceUploadRequest();
        List<String> datas = new ArrayList<String>();
        datas.add(param);
        //设置待加密的原始数据集合
        req.setData(datas);
        BhInterfaceCreditApiClient client = new BhInterfaceCreditApiClient();
        //初始化设置RSA公钥
        client.init(getBaihangZDPublickey());
        //执行加密操作
        InterfaceUploadResponse response = client.execute(req);
        if (response.isSuccess) {
            List<String> data = response.getEncryptData();
            return data.get(0);
        }
        throw new Exception();
    }

    /**
     * 解密
     *
     * @throws Exception
     */
    //public static void interfaceUploadValidationClient() throws Exception {
    private static void interfaceUploadValidationClient(String miwen) throws Exception {
        //RSA私钥文件路径（百行提供测试环境私钥文件）
//        String RSA_PRIVATE_KEY = "d:\\rsa_private_key.pem";

        InterfaceUploadValidationRequest req = new InterfaceUploadValidationRequest();
        List<String> datas = new ArrayList<String>();
        String name = "J6kssxkrOSWPOh4XHk5cZEAEKNEQyUQeY3VNNpFHQaBJhp4lxnx+PeHgWt3uSW9A/wZf3jd5rFpdw21C55BSHHob7kU41n00Tfbt4dFy8u6lS16UaFSdNdrvZ6Y8iokVujq54zd96jggbHPK258qlrW8rkvaWp0KIWBgJesp2UQ=";//加密后的密文
//        String pid = "CSdFOGhhZS1eX5NnPAIR6/vh3FzgMBRSvJVcgf4WI8d4zStBjXKUf7UfsjGfcdMjPLkPQ93sD0OqkF5XuMWaCSkt1gHkvQCmxvErBYDfaYKI6rMY4QdJ4BPxau/IStAo+hXNdlD9gGBZpIjEtickDIw1YYdLfqRw4mZdNuMkMXI=";//加密后的密文
//        String mobile= "B5F2ozIoPbXpv65rk7fStPsVmpF0xoB+wpTc++1EvWqoDYZ5epWGmBdtxCElgvdflBcWDzB0oPPM8PclG0p/EPmJcrbivkFHN65HViTvfk2Xxs+sss9IomhmuWiLS5BTpxyTlMsPnSPjmE8so6S16YiiW3ZVble2CijUKPV+Luk=";//加密后的密文

        //datas.add(name);
//        datas.add(pid);
//        datas.add(mobile);

        datas.add(miwen);

        //设置待解密的密文数据集合
        req.setData(datas);
        BhInterfaceCreditApiClient client = new BhInterfaceCreditApiClient();
        //初始化设置RSA私钥
        client.init(BHRSAUtils.readRSAPrivateKey("/baihang/rsa_private_key.pem"));
        //执行解密操作
        InterfaceUploadValidationResponse response = client.execute(req);
        if (response.isSuccess) {
            List<String> data = response.getDecryptData();
            for (int i = 0; i < data.size(); i++) {
                System.out.println(data.get(i));
            }
            System.out.println("decrypt success;decrypt data = " + response.getDecryptData());
        } else {
            System.out.println("decrypt fail;errorMessage = " + response.getErrorMessage());
        }
    }

    /**
     * 描述: 文件方式上报的客户端代码（文件加密） <br/>
     * 参数: []  <br/>
     * 返回值: void  <br/>
     * 创建人: yanhui.Hao  <br/>
     * 创建时间: 2019.11.05  <br/>
     */
    public static String fileUploadClient(String fileUrl) throws Exception {
        //fileUrl = "C:\\Users\\Administrator\\Desktop\\测试\\文件测试\\baihang\\all_data.txt";
        if (StringUtils.isBlank(fileUrl)) {
            return "fileUrl参数为空";
        }
        String writeFilePath = "";
        if(fileUrl.lastIndexOf("/")!=-1){//linux
            writeFilePath = fileUrl.substring(0,fileUrl.lastIndexOf("/"))+"/cry/";
        }else{//windows
            writeFilePath = fileUrl.substring(0,fileUrl.lastIndexOf("\\"))+"\\cry\\";
        }

        //RSA公钥文件路径（百行提供公钥文件）
        ////String RSA_PUBLIC_KEY = "/manualTool/rsa_public_key.pem";
        String RSA_PUBLIC_KEY = "/baihang/rsa_public_key.pem";

        //AES密钥（机构自行设置）
        String AES_KEY = "fc4c1cbca5a46840f60";

        FileUploadRequest req = new FileUploadRequest();
        //设置未作压缩加密前的原始数据文件路径
        req.setDataFile(fileUrl);

        //设置压缩加密后的密文文件输出路径(为空表示与原始数据文件同目录)
        req.setTargetFilePath(writeFilePath);

        BhFileCreditApiClient client = new BhFileCreditApiClient();
        //初始化设置AES密钥和RSA公钥
        client.init(BHRSAUtils.readRSAPublicKey(RSA_PUBLIC_KEY), AES_KEY);
        //执行压缩加密操作
        FileUploadResponse response = client.execute(req);
        String msg = "";
        if (response.isSuccess) {
            msg = "zip And encrypt success;fileName = " + response.getEncryptFilePath() + response.getEncryptFileName();
        } else {
            msg = "zip And encrypt fail;errorMessage = " + response.getErrorMessage();
        }
        log.info(msg);
        return msg;
    }


    /**
     * 描述: 文件方式上报的客户端本地测试代码（文件解密） <br/>
     * 参数: []  <br/>
     * 返回值: void  <br/>
     * 创建人: yanhui.Hao  <br/>
     * 创建时间: 2019.11.05  <br/>
     */
    public static String fileUploadValidationClient(String fileUrl) throws Exception {
        //fileUrl = "C:\\Users\\Administrator\\Desktop\\测试\\文件测试\\baihang\\all_data.cry";
        if (StringUtils.isBlank(fileUrl)) {
            return "fileUrl参数为空";
        }
        String writeFilePath = "";
        if(fileUrl.lastIndexOf("/")!=-1){//linux
            writeFilePath = fileUrl.substring(0,fileUrl.lastIndexOf("/"))+"/out/";
        }else{//windows
            writeFilePath = fileUrl.substring(0,fileUrl.lastIndexOf("\\"))+"\\out\\";
        }

        //RSA私钥文件路径（百行提供测试环境私钥文件）
        String RSA_PRIVATE_KEY = "/baihang/rsa_private_key.pem";
        ////String RSA_PRIVATE_KEY = "/manualTool/rsa_private_key.pem";

        FileUploadValidationRequest req = new FileUploadValidationRequest();
        //设置压缩加密后的数据文件路径
        req.setDataFile(fileUrl);
        req.setTargetFilePath(writeFilePath);

        BhFileCreditApiClient client = new BhFileCreditApiClient();
        //初始化设置RSA私钥
        client.init(BHRSAUtils.readRSAPrivateKey(RSA_PRIVATE_KEY));
        //执行解密解压操作
        FileUploadValidationResponse response = client.execute(req);
        String msg = "";
        if (response.isSuccess) {
            msg = "decrypt And unzip success;fileName = " + response.getDecryptFilePath() + response.getDecryptFileName();
        } else {
            msg = "decrypt And unzip fail;errorMessage = " + response.getErrorMessage();
        }
        log.info(msg);
        return msg;
    }


    //test2.接口测试 手动调用
    @Deprecated
    public String apiSend(String type,String startDate, String endDate) {
        //"2019-05-07T00:00:00"
        if(StringUtils.isAnyBlank(type,startDate,endDate)){
            return "参数为空";
        }
        if(startDate.length()!=19 || endDate.length()!=19 || !startDate.contains("T") || !endDate.contains("T")){
            log.warn("日期格式有误, startDate : {} , endDate : {} ",startDate,endDate);
            return "日期格式有误";
        }
        long sUtc1 = System.currentTimeMillis();

        String starTime = LocalDateTime.parse(startDate).format(DateTimeFormatter.ISO_DATE);
        String endTime = LocalDateTime.parse(endDate).format(DateTimeFormatter.ISO_DATE);

        if("A1".equalsIgnoreCase(type)){
            //贷款申请信息（A1）
            List<ApplyLoanInfoZhuDai> applyLoanInfos = applyLoanInfoMapper.queryStockApplyLoanInfoZhuDai(BaiHangTimeRecord.builder().startTime(starTime).endTime(endTime).build());
            int listSize = applyLoanInfos!=null ? applyLoanInfos.size(): 0;
            log.info("百行-助贷申请数据查询结束, listSize : {} , startTime: {} , endTime: {} , 耗时: {} ", listSize, starTime, endTime, (System.currentTimeMillis()-sUtc1));

            Stopwatch sendWatch = Stopwatch.createStarted();
            AtomicInteger atomicInteger = new AtomicInteger();
            for (int i = 0; i < applyLoanInfos.size(); i++) {
                try {
                    ApplyLoanInfoZhuDai applyLoanInfo = applyLoanInfos.get(i);
                    applyLoanInfo.setName(interfaceUploadClient(applyLoanInfo.getName()));
                    applyLoanInfo.setMobile(interfaceUploadClient(applyLoanInfo.getMobile()));
                    applyLoanInfo.setPid(interfaceUploadClient(applyLoanInfo.getPid()));
                    String resultStr = iHttpService.postBaiHang(baiHangApplyLoanInfoUrl, getHeader(), JSON.toJSONString(applyLoanInfo));
                    if (Objects.isNull(resultStr) || !(resultStr.contains("queryHistory") && resultStr.contains("nonRevolvingLoan") && resultStr.contains("revolvingLoan"))) {
                        log.info("量化派助贷TO百行报送-贷款申请返回结果不正确, applyId: {} ", applyLoanInfo.getApplyId());
                    } else {
                        atomicInteger.getAndIncrement();
                    }
                } catch (Exception e) {
                    log.error("量化派助贷TO百行报送-贷款申请信息异常", e);
                }
            }
            log.info("量化派助贷TO百行报送-贷款申请报送完成, 实际大小: {} , 报送成功大小: {} , 耗时: {} ", applyLoanInfos.size(), atomicInteger.get(), sendWatch.stop().elapsed(TimeUnit.MILLISECONDS));


        }else if("D2".equalsIgnoreCase(type)){
            //非循环贷款账户数据信息（D2）
            try{
                List<LoanInfoZhuDai> loanInfozdList = loanInfoMapper.queryStockLoanInfoZhuDai(BaiHangTimeRecord.builder().startTime(starTime).endTime(endTime).build());
                int listSize = loanInfozdList!=null ? loanInfozdList.size(): 0;
                log.info("百行-助贷放款数据查询结束, listSize : {} , startTime: {} , endTime: {} , 耗时 : {} ", listSize, starTime, endTime, ((System.currentTimeMillis()-sUtc1)/1000)+".s");

                AtomicInteger atomicInteger = new AtomicInteger();
                Stopwatch sendWatch = Stopwatch.createStarted();
                for (int i = 0; i < loanInfozdList.size(); i++) {
                    LoanInfoZhuDai loanInfo = loanInfozdList.get(i);
                    String id = "";
                    try {
                        String loanInfoReqId = loanInfo.getReqID();
                       /* if (loanInfo.getTotalTerm() > 1) {
                            List<String> targetRepaymentDayList = loanInfoMapper.findTargetRepaymentDayList(loanInfoReqId);
                            loanInfo.setTargetRepayDateList(String.join(",", targetRepaymentDayList));
                        }*/
                        List<String> targetRepaymentDayList = loanInfoMapper.findTargetRepaymentDayList(loanInfoReqId);
                        if(targetRepaymentDayList!=null && targetRepaymentDayList.size()>0){
                            loanInfo.setTargetRepayDateList(String.join(",", targetRepaymentDayList));
                            log.info("比较还款总期数&账单日列表totalTerm="+loanInfo.getTotalTerm()+",targetRepaymentDayList size="+targetRepaymentDayList.size());
                        }else{
                            log.warn("比较还款总期数&账单日列表totalTerm="+loanInfo.getTotalTerm()+",targetRepaymentDayList is null.");
                        }

                        /*UUID loanInfoId = UUID.randomUUID();
                        id = loanInfoId.toString().replaceAll("-", "");
                        loanInfo.setRecordId(id);
                        try{
                            loanInfoDbMapper.saveLoanInfoRecordLog(loanInfo);
                        }catch(Exception e){}
                        loanInfo.setRecordId(null);
                        loanInfo.setReqID(id);*/

                        UUID loanInfoId = UUID.randomUUID();
                        id = loanInfoId.toString().replaceAll("-", "");
                        try{
                            LoanInfoZhuDai record = new LoanInfoZhuDai();
                            BeanUtils.copyProperties(loanInfo, record);
                            record.setRecordId(id);
                            loanInfoDbMapper.saveLoanInfoRecordLog(record);
                        }catch(Exception e){
                            log.error("量化派助贷TO百行报送-放款申请保存记录失败" , e);
                        }
                        loanInfo.setReqID(id);

                        loanInfo.setName(interfaceUploadClient(loanInfo.getName()));
                        loanInfo.setPid(interfaceUploadClient(loanInfo.getPid()));
                        loanInfo.setMobile(interfaceUploadClient(loanInfo.getMobile()));
                        String resultStr = iHttpService.postBaiHang(baiHangLoanInfoUrl, getHeader(), JSON.toJSONString(loanInfo));
                        log.info("助贷放款用户报送结果, param: {} , resultStr: {} ", JSON.toJSONString(loanInfo), resultStr);
                        if (Objects.isNull(resultStr) || !"success".equalsIgnoreCase(JSON.parseObject(resultStr).getString("status"))) {
                            log.info("量化派助贷TO百行报送-放款返回结果不正确, recordId: {} , loanId: {} , bean: {} ", id, loanInfo.getLoanId(), JSON.toJSONString(loanInfo));
                            loanInfoDbMapper.updateCurrentRecordEnableFalce(BaiHangUpDateRecord.builder().enable("0").recordId(id).build());
                        } else {
                            atomicInteger.getAndIncrement();
                        }
                    } catch (Exception e) {
                        log.error("量化派助贷TO百行报送-放款信息异常, recordId: {} , loanId: {} ", id, loanInfo.getLoanId(), e);
                    }
                }
                log.info("量化派助贷TO百行报送-放款申请完成, 实际大小: {} , 报送成功大小: {} , 耗时: {} ", loanInfozdList.size(), atomicInteger.get(), sendWatch.stop().elapsed(TimeUnit.MILLISECONDS));

            }catch(Exception e){
                log.error("量化派助贷TO百行报送-异常", e);
            }

        }else if("D3".equalsIgnoreCase(type)){
            //非循环贷款贷后数据信息（D3）
                for (int j = 0; j < 2; j++) {
                    Stopwatch sendWatch = Stopwatch.createStarted();
                    try {
                        List<RepaymentInfoZhuDai> repaymentLoanInfos = null;
                        if (j == 0) {
                            Stopwatch stopwatch = Stopwatch.createStarted();
                            repaymentLoanInfos = repaymentLoanInfoMapper.queryStockRepayMentInfoZhuDai(BaiHangTimeRecord.builder().startTime(starTime).endTime(endTime).build());
                            log.info("百行-助贷还款查询结束, startTime: {} , endTime: {} , 大小: {} , 耗时: {} ", starTime, endTime, repaymentLoanInfos.size(), (stopwatch.stop().elapsed(TimeUnit.MILLISECONDS)/1000)+".s");
                        } else {
                            Stopwatch stopwatch = Stopwatch.createStarted();
                            repaymentLoanInfos = repaymentLoanInfoMapper.queryStockRepayMentInfoOverdueZhuDai(BaiHangTimeRecord.builder().startTime(starTime).endTime(endTime).build());
                            log.info("百行-助贷还款查询逾期结束, startTime: {} , endTime: {} , 大小: {} , 耗时: {} ", starTime, endTime, repaymentLoanInfos.size(), (stopwatch.stop().elapsed(TimeUnit.MILLISECONDS)/1000)+".s");

                        }

                        AtomicInteger atomicInteger = new AtomicInteger();
                        for (int i = 0; i < repaymentLoanInfos.size(); i++) {
                            RepaymentInfoZhuDai repaymentLoanInfo = repaymentLoanInfos.get(i);
                            String id = "";
                            try {
                                RepaymentInfoZhuDai repaymentLoanInfo1 = repaymentLoanInfoDbMapper.findLastOne(BaiHangRepayment.builder().loanId(repaymentLoanInfo.getLoanId()).termNo(repaymentLoanInfo.getTermNo()).build());
                                if (j > 0 && Objects.nonNull(repaymentLoanInfo1)) {
                                    log.info("量化派助贷TO百行报送-实时还款逾期跳过报送, startTime: {} , endTime: {} , bean: {} ", starTime, endTime, JSON.toJSONString(repaymentLoanInfo1));
                                    continue;
                                }

                                /*id = UUID.randomUUID().toString().replaceAll("-", "");
                                repaymentLoanInfo.setRecordId(id);
                                try {
                                    repaymentLoanInfoDbMapper.saveRepaymentLoanInfoLog(repaymentLoanInfo);
                                } catch (Exception e) {
                                }
                                repaymentLoanInfo.setReqID(id);
                                repaymentLoanInfo.setRecordId(null);*/

                                id = UUID.randomUUID().toString().replaceAll("-", "");
                                try {
                                    RepaymentInfoZhuDai record = new RepaymentInfoZhuDai();
                                    BeanUtils.copyProperties(repaymentLoanInfo, record);
                                    record.setRecordId(id);
                                    repaymentLoanInfoDbMapper.saveRepaymentLoanInfoLog(record);
                                } catch (Exception e) {
                                    log.error("量化派助贷TO百行报送-实时还款保存记录异常",e);
                                }
                                repaymentLoanInfo.setReqID(id);

                                repaymentLoanInfo.setPid(interfaceUploadClient(repaymentLoanInfo.getPid()));
                                repaymentLoanInfo.setName(interfaceUploadClient(repaymentLoanInfo.getName()));
                                repaymentLoanInfo.setMobile(interfaceUploadClient(repaymentLoanInfo.getMobile()));
                                String resultStr = iHttpService.postBaiHang(baiHangRepayMentLoanInfoUrl, getHeader(), JSON.toJSONString(repaymentLoanInfo));
                                log.info("助贷还款用户报送结果, param: {} , resultStr: {} ", JSON.toJSONString(repaymentLoanInfo), resultStr);
                                if (Objects.isNull(resultStr) || !"success".equalsIgnoreCase(JSON.parseObject(resultStr).getString("status"))) {
                                    log.info("量化派助贷TO百行报送-还款返回结果不正确, 开始时间: {} , 结束时间: {} , recordId: {} , loanId: {} , bean: {} ", starTime, endTime, id, repaymentLoanInfo.getLoanId(), JSON.toJSONString(repaymentLoanInfo));
                                    repaymentLoanInfoDbMapper.updateCurrentRecordEnableFalse(BaiHangUpDateRecord.builder().enable("0").recordId(id).build());
                                } else {
                                    atomicInteger.getAndIncrement();
                                }
                            } catch (Exception e) {
                                log.error("量化派助贷TO百行报送-还款信息异常, recordId: {} , loanId: {} ", id, repaymentLoanInfo.getLoanId(), e);
                            }
                        }
                        log.info("量化派助贷TO百行报送-还款申请完成 J: {} , 开始时间: {} , 结束时间: {} , 实际大小: {} , 报送成功大小: {} , 耗时: {} ", j, starTime, endTime, repaymentLoanInfos.size(), atomicInteger.get(), sendWatch.stop().elapsed(TimeUnit.MILLISECONDS));
                    } catch (Exception e) {
                        log.error("量化派助贷TO百行报送-异常 J: {} , 开始时间: {} , 结束时间: {} ", j, starTime, endTime, e);
                    }
                }

        }else{
            return "其他未知类型type="+type;
        }

        return type+"手动报送结束";
    }


    @Async
    public void zhuDaiStockSyn(String type, String startDate, String noEndDate, String d3Type,String isNotHaveReqID) {
        //"2019-05-07T00:00:00"
        if (StringUtils.isAnyBlank(type,startDate, noEndDate)) {
            log.warn("Async zhuDaiStockSyn 参数不能为空, startDate : {} , noEndDate : {} ", startDate, noEndDate);
            return;
        }
        if (startDate.length() != 19 || noEndDate.length() != 19 || !startDate.contains("T") || !noEndDate.contains("T")) {
            log.warn("Async zhuDaiStockSyn 日期格式有误, startDate : {} , noEndDate : {} ", startDate, noEndDate);
            return;
        }

        if("A1".equalsIgnoreCase(type)) {
            //贷款申请信息（A1）
            log.warn("Async zhuDaiStockSyn Start {}, {}, {}, ", type, startDate, noEndDate);
            stockApplyLoanInfoZhuDai(startDate,noEndDate);
        }else if("D2".equalsIgnoreCase(type)) {
            //非循环贷款账户数据信息（D2）

            stockLoanInfoZhuDai(startDate,noEndDate,isNotHaveReqID);
        } else if("D3".equalsIgnoreCase(type)) {
            //非循环贷款贷后数据信息（D3）
            stockRepayMentInfoZhuDai(startDate, noEndDate, d3Type,isNotHaveReqID);
        }else{
            log.warn("Async zhuDaiStockSyn 参数 type: {} 未知.", type);
        }
    }

    //用户三要素脱敏后数据写一份
    private void testTuoMinFileWrite(String fileName,String startDate, ApplyLoanInfoZhuDai bean_a1, LoanInfoZhuDaiVo bean_d2, RepaymentInfoZhuDai bean_d3) {
        String pid = null, mapVal = null, jsonContext = "";
        try {
            if (bean_a1 != null) {
                pid = bean_a1.getPid();
                mapVal = testBaoSongUserInfoTuoMingMap.get(pid);
                if (StringUtils.isNotEmpty(mapVal)) {
                    String[] arry = mapVal.split(",");//pid,mobile,name
                    bean_a1.setPid(arry[0]);
                    bean_a1.setMobile(arry[1]);
                    bean_a1.setName(arry[2]);
                } else {
                    //addUserMap(pid,mobile,name);
                    log.warn(" TEST FILE A1 发现其他不在字典中用户, startDate: {} , pid: {} ", startDate, pid);
                }
                jsonContext = JSON.toJSONString(bean_a1);

            } else if (bean_d2 != null) {
                pid = bean_d2.getPid();
                mapVal = testBaoSongUserInfoTuoMingMap.get(pid);
                if (StringUtils.isNotEmpty(mapVal)) {
                    String[] arry = mapVal.split(",");//pid,mobile,name
                    bean_d2.setPid(arry[0]);
                    bean_d2.setMobile(arry[1]);
                    bean_d2.setName(arry[2]);
                } else {
                    //addUserMap(pid,mobile,name);
                    log.warn(" TEST FILE D2 发现其他不在字典中用户, startDate: {} , pid: {} ", startDate, pid);
                }
                jsonContext = JSON.toJSONString(bean_d2);

            } else if (bean_d3 != null) {
                pid = bean_d3.getPid();
                mapVal = testBaoSongUserInfoTuoMingMap.get(pid);
                if (StringUtils.isNotEmpty(mapVal)) {
                    String[] arry = mapVal.split(",");//pid,mobile,name
                    bean_d3.setPid(arry[0]);
                    bean_d3.setMobile(arry[1]);
                    bean_d3.setName(arry[2]);
                } else {
                    //addUserMap(pid,mobile,name);
                    log.warn(" TEST FILE D3 发现其他不在字典中用户, startDate: {} , pid: {} ", startDate, pid);
                }
                jsonContext = JSON.toJSONString(bean_d3);

            } else {
                log.error(" TEST FILE testTuoMinFileWrite()实体对象都为空, startDate: {} ",startDate);
                return;
            }

            FileUtils.write(new File(fileName), jsonContext+"\r\n", "UTF-8", true);

        } catch (Exception e) {
            log.error(" TEST FILE testTuoMinFileWrite()写入文件异常, startDate: {} , pid: {} ", startDate, pid, e);
        }
    }


    private String addUserMap(String pid, String mobile, String name) {
        log.warn(" find other user: {} , {} , {} ", pid, mobile, name);
        synchronized (testBaoSongUserInfoTuoMingMap) {
            if (testBaoSongUserInfoTuoMingMap.containsKey(pid)) {
                return testBaoSongUserInfoTuoMingMap.get(pid); //pid,mobile,name
            } else {
                String mapValue = TuoMinUtils.random_idcard(pid) + "," + TuoMinUtils.random_mobile(mobile) + "," + TuoMinUtils.random_name(name);
                testBaoSongUserInfoTuoMingMap.put(pid, mapValue);
                return mapValue;
            }
        }
    }

    public String zhuDaiStockStop(String type,boolean value) {
        if("A1".equalsIgnoreCase(type)) {
            //贷款申请信息（A1）
            A1_Stop.set(value);
            return "A1_Stop="+A1_Stop.get();
        }else if("D2".equalsIgnoreCase(type)) {
            //非循环贷款账户数据信息（D2）
            D2_Stop.set(value);
            return "D2_Stop="+D2_Stop.get();
        } else if("D3".equalsIgnoreCase(type)) {
            //非循环贷款贷后数据信息（D3）
            D3_Stop.set(value);
            return "D3_Stop="+D3_Stop.get();
        }else{
            log.warn("Async zhuDaiStockStop 参数 type: {} 未知.", type);
            return "未知type="+type;
        }
    }


    public String build_stockRepayMentInfoZhuDai(String jsonFile) throws IOException {
        String sourceStr = FileUtils.readFileToString(new File(jsonFile), "utf-8");
        JSONObject sourceJson = JSON.parseObject(sourceStr);
        JSONArray recordsJsonArr = sourceJson.getJSONArray("RECORDS");
        System.out.println("总条数:" + recordsJsonArr.size());

        //RepaymentInfoZhuDai repaymentLoanInfo = new Gson().fromJson(repaymentLoanInfos.get(i), new TypeToken<RepaymentInfoZhuDai>(){}.getType());
        //log.info("众信利民助贷模式TO百行手动报送还款数据单个数据, {}", JSON.toJSONString(repaymentLoanInfo));

        String name = "";
        if(jsonFile.lastIndexOf("/")!=-1){//linux
            name = jsonFile.substring(jsonFile.lastIndexOf("/")+1, jsonFile.length());
        }else{//windows
            name = jsonFile.substring(jsonFile.lastIndexOf("\\")+1, jsonFile.length());
        }
        name = name.substring(0,name.lastIndexOf("."));

        final String fileName = zl_file_path_name + name;
        long log_stUtc = System.currentTimeMillis();
        try {
            for (int j = 0; j < recordsJsonArr.size(); j++) {
                String tmpStr = recordsJsonArr.getJSONObject(j).toJSONString();
                RepaymentInfoZhuDai repaymentInfo = new Gson().fromJson(tmpStr, new TypeToken<RepaymentInfoZhuDai>() {}.getType());
                String id = UUID.randomUUID().toString().replaceAll("-", "");
                repaymentInfo.setReqID(id);
                FileUtils.write(new File(fileName + "_01.txt"), JSON.toJSONString(repaymentInfo) + "\r\n", "UTF-8", true);

                //脱敏数据写一份
                testTuoMinFileWrite(fileName + "_TEST_01.txt", "shoudongBuild", null, null, repaymentInfo);
            }
        } catch (Exception e) {
            log.error("还款&逾期存量数据处理异常,", e);
        }

        //打印日志
        log.info("All还款||逾期整理结束, 大小: {} , 总耗时: {} ", recordsJsonArr.size(), ((System.currentTimeMillis() - log_stUtc) / 1000) + ".s");
        return "百行-助贷还款整理结束";
    }

    public void build_A1(List<String> lineList) throws IOException {
        log.info("lineList:"+lineList.size());
        for(int i=0;i<lineList.size();i++){
            String str = lineList.get(i);
            if(str.startsWith("----------")){
                log.info(str);
                continue;
            }

            ApplyLoanInfoZhuDai applyInfo = new Gson().fromJson(str, new TypeToken<ApplyLoanInfoZhuDai>(){}.getType());
            log.info("众信利民助贷模式TO百行手动报送申请单个数据, {}", JSON.toJSONString(applyInfo));
            String emailAddress = applyInfo.getEmailAddress();
            if(TuoMinUtils.checkEmail(emailAddress)){
                log.error("emailAddress="+emailAddress+" is ok.");
            }else{
                applyInfo.setEmailAddress("");
                log.warn("emailAddress="+emailAddress+" is error.");
            }
            try {
                FileUtils.write(new File("D:\\用户目录\\Downloads\\build_A1_TEST_01_M.txt"), JSON.toJSONString(applyInfo)+"\r\n", "UTF-8", true);

                //脱敏数据写一份
                //testTuoMinFileWrite("D:\\用户目录\\Downloads\\build_A1_TEST_01_M.txt",null,applyInfo,null,null);

            } catch (Exception e) {
                log.error("申请存量数据处理异常, startTime: {} , endTime: {} ",null, null, e);
            }
        }
        log.info("处理A1结束");
    }
}
