package cn.quantgroup.report.controller;

import cn.quantgroup.report.response.GlobalResponse;
import cn.quantgroup.report.service.cache.CacheService;
import cn.quantgroup.report.service.DataSourceCacheConfigService;
import cn.quantgroup.report.service.common.CommonQueryService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Slf4j
@RestController
@RequestMapping(value = "/cache")
public class CacheController {
  @Autowired
  private CacheService cacheService;
  @Autowired
  private DataSourceCacheConfigService cacheConfigService;
  @Autowired
  private CommonQueryService commonQueryService;
  @Autowired
  private RedisTemplate redisTemplate;

  @RequestMapping("/clear_huadao_token")
  public GlobalResponse clearHuadaoToken(){
    try{
      redisTemplate.delete("NEW_HUADAO_QUERY_TOKEN_KEY");
      log.info("清除华道缓存token成功");
      return GlobalResponse.generate("清除华道缓存token成功");
    }catch(Exception e){
      log.info("清除华道缓存token异常");
      return GlobalResponse.generate("清除华道缓存token异常");
    }
  }

  @RequestMapping("/get_huadao_token")
  public GlobalResponse getHuadaoToken(){
      try{
          String token = String.valueOf(redisTemplate.opsForValue().get("NEW_HUADAO_QUERY_TOKEN_KEY"));
          log.info("获取华道缓存token结果, token : {} ", token);
          return GlobalResponse.generate(token);
      }catch(Exception e){
          log.info("获取华道缓存token异常");
          return GlobalResponse.generate("获取华道缓存token异常");
      }
  }

  @RequestMapping("/reload")
  public GlobalResponse reload(){
    try{
      cacheConfigService.init();
      log.info("刷新数据源缓存时间完成");
      return GlobalResponse.generate("Ok");
    }catch(Exception e){
      log.info("刷新数据源缓存时间异常", e);
      return GlobalResponse.generate(e.getMessage());
    }
  }

  @RequestMapping("/config/clear")
  public GlobalResponse clearConfigCache(String configName) {
    try{
      cacheService.clearCache(configName);
      log.info("刷新缓存配置成功, configName: {} ", configName);
      return GlobalResponse.generate("OK");
    }catch (Exception e){
      log.error("刷新缓存异常, {} , {} , {} ", configName, e.getMessage(), e);
      return GlobalResponse.generate(e.getMessage());
    }
  }

  @RequestMapping("/lock/clear")
  public GlobalResponse clearLock(String lockName) {
    try{
      cacheService.clearLock(lockName);
      return GlobalResponse.generate("OK");
    }catch (Exception e){
      log.error("{}", e.getMessage(), e);
      return GlobalResponse.generate(e.getMessage());
    }
  }

}
