package cn.quantgroup.report.service.interceptor;

import cn.quantgroup.report.utils.ConverterCacheUtils;
import com.alibaba.fastjson.JSONObject;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;

import java.io.IOException;

public class CommonInterceptor implements Interceptor {
  private JSONObject defaultParamMap;

  public CommonInterceptor(Object object) {
    defaultParamMap = ConverterCacheUtils.convertedFromObject(object);
  }

  @Override
  public Response intercept(Interceptor.Chain chain) throws IOException {
    Request oldRequest = chain.request();
    if (StringUtils.equalsIgnoreCase("post", oldRequest.method())) {
      return chain.proceed(oldRequest);
    }
    // 添加新的参数
    HttpUrl.Builder authorizedUrlBuilder = oldRequest.url()
      .newBuilder()
      .scheme(oldRequest.url().scheme())
      .host(oldRequest.url().host());
    if (!defaultParamMap.isEmpty()) {
      defaultParamMap.forEach((k, v) -> {
        authorizedUrlBuilder.addQueryParameter(k, v.toString());
      });
    }
    // 新的请求
    Request newRequest = oldRequest.newBuilder()
      .method(oldRequest.method(), oldRequest.body())
      .url(authorizedUrlBuilder.build())
      .build();

    return chain.proceed(newRequest);
  }
}