package cn.quantgroup.report.interceptor;

import cn.quantgroup.report.error.QGException;
import cn.quantgroup.report.error.QGExceptionType;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


@Slf4j
public class AuthHandlerInterceptorAdapter extends HandlerInterceptorAdapter {
  public static final String KEY = "key";
  protected boolean ignore;

  public AuthHandlerInterceptorAdapter(boolean ignore) {
    super();
    this.ignore = ignore;
  }

  public boolean preHandle(HttpServletRequest arg0, HttpServletResponse arg1, Object arg2) throws Exception {
//    log.info("ip:{},path:{}", arg0.getRemoteAddr(), arg0.getRequestURI());
//    if (ignore || StringUtils.equalsIgnoreCase("b5140fb2-2c85-4b5a-abcf-3e97528014db", getKey(arg0)) || StringUtils.equals("/ex/91zhengxin/call", arg0.getRequestURI()) || StringUtils.equals("/ex/dianhuabang/callBack", arg0.getRequestURI())) {
//      return true;
//    }
//    throw new QGException(QGExceptionType.COMMON_AUTH_ERROR);
    return true;
  }

  private String getKey(HttpServletRequest arg0) {
    String key = arg0.getParameter(KEY);
    if (StringUtils.isNoneBlank(key)) {
      return key;
    }
    key = arg0.getHeader(KEY);
    if (StringUtils.isNoneBlank(key)) {
      return key;
    }
    Cookie[] cookies = arg0.getCookies();
    if (cookies != null && cookies.length > 0) {
      for (Cookie cookie : cookies) {
        if (StringUtils.equalsIgnoreCase(cookie.getName(), KEY)) {
          return cookie.getValue();
        }
      }
    }
    return null;
  }

  /**
   * 在controller执行之后的DispatcherServlet之后执行
   */
  public void postHandle(HttpServletRequest arg0, HttpServletResponse arg1, Object arg2, ModelAndView arg3)
    throws Exception {
  }

  /**
   * 在页面渲染完成返回给客户端之前执行
   */
  public void afterCompletion(HttpServletRequest arg0, HttpServletResponse arg1, Object arg2, Exception arg3)
    throws Exception {
  }

}
