package cn.quantgroup.report.service;

import cn.quantgroup.report.domain.master.DataSourceCacheConfig;
import cn.quantgroup.report.mapper.master.DataSourceCacheConfigMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

/**
 * 数据源缓存配置
 *
 * @Author fengjunkai
 * @Date 2019-06-19 14:53
 */
@Slf4j
@Service
public class DataSourceCacheConfigService {

    private Map<String, Integer> allDataSourceCacheConfigMap = new ConcurrentHashMap();
    private Map<String, Integer> allDataSourceTestCacheConfigMap = new ConcurrentHashMap();

    @Autowired
    private DataSourceCacheConfigMapper dataSourceCacheConfigMapper;

    @PostConstruct
    private void initDataSourceCacheConfig() {
        init();
    }

    public void init() {
        allDataSourceCacheConfigMap.clear();
        allDataSourceTestCacheConfigMap.clear();
        List<DataSourceCacheConfig> allCacheConfig = dataSourceCacheConfigMapper.findAllCacheConfig();
        allDataSourceCacheConfigMap = allCacheConfig.stream().collect(Collectors.toMap(DataSourceCacheConfig::getProductType, DataSourceCacheConfig::getProductCacheTime));
        allDataSourceTestCacheConfigMap = allCacheConfig.stream().collect(Collectors.toMap(DataSourceCacheConfig::getProductType, DataSourceCacheConfig::getProductTestCacheTime));

    }

    public Integer getCacheTime(String productType) {
        Integer cacheTime = allDataSourceCacheConfigMap.get(productType);
        return cacheTime == null ? 1 : cacheTime;
    }

    public Integer getTestCacheTime(String productType) {
        Integer testCacheTime = allDataSourceTestCacheConfigMap.get(productType);
        return testCacheTime == null ? 1 : testCacheTime;
    }


}
