package cn.quantgroup.report.utils.dingtalk;

import java.io.PrintWriter;
import java.io.StringWriter;

/**
 * @author ：dongjianhua
 * @date ：Created in 2019/11/4 10:38
 * @description：异常类
 * @modified By：
 * @version: 1.0
 */
public class QgException extends RuntimeException {
    //提醒标题
    public String alarm;
    //堆栈信息 或者报错信息
    public String message;

    public QgException(String exMsg) {
        alarm = exMsg;
    }

    public QgException(String exMsg, String message) {
        super(message,null);
        alarm = exMsg;
        this.message = message;
    }

    public QgException(String exMsg, Exception e) {
        super(e);
        alarm = exMsg;
        message = getStackTrace(e);
    }

    public static String getStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        try {
            t.printStackTrace(pw);
            return sw.toString();
        } finally {
            pw.close();
        }
    }
}


