package cn.quantgroup.report.config.datasource.master;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

import javax.sql.DataSource;

/**
 * Desc:
 * User: HaiNan.Wang
 * Date: 2017/5/2
 */
@Import(RiskDatasourceProperties.class)
@Configuration
@MapperScan(basePackages = RiskDataSourceConfig.PACKAGE, sqlSessionFactoryRef = "masterSqlSessionFactory")
public class RiskDataSourceConfig {
  static final String PACKAGE = "cn.quantgroup.report.mapper.master";
  @Value("${master.mapper-locations}")
  private String mapperLocations;
  @Value("${master.type-aliases-package}")
  private String typeAliasesPackage;
  @Value("${config-location}")
  private String configLocation;
  @Value("${db.driver:com.mysql.jdbc.Driver}")
  private String driverClass;

  @Autowired
  private RiskDatasourceProperties repaymentPlanProperties;

  @Bean(name = "masterDataSource")
  public DataSource masterDataSource() {
    HikariConfig config = new HikariConfig();
    config.setJdbcUrl(repaymentPlanProperties.getRiskDatasourceJdbcUrl());
    config.setPassword(repaymentPlanProperties.getRiskDatasourcePassword());
    config.setUsername(repaymentPlanProperties.getRiskDatasourceUsername());
    config.setMaximumPoolSize(repaymentPlanProperties.getMaxPoolSize());
    config.setMinimumIdle(repaymentPlanProperties.getMinPoolSize());
    config.addDataSourceProperty("cachePrepStmts", "true");
    config.addDataSourceProperty("prepStmtCacheSize", "250");
    config.addDataSourceProperty("prepStmtCacheSqlLimit", "2048");
    return new HikariDataSource(config);
  }

  @Bean(name = "masterTransactionManager")
  public DataSourceTransactionManager repaymentPlanDataSourceTransactionManager(@Qualifier("masterDataSource") DataSource dataSource) {
    return new DataSourceTransactionManager(dataSource);
  }

  @Bean(name = "masterSqlSessionFactory")
  public SqlSessionFactory masterSqlSessionFactory(@Qualifier("masterDataSource") DataSource masterDataSource) throws Exception {
    final SqlSessionFactoryBean sessionFactory = new SqlSessionFactoryBean();
    sessionFactory.setDataSource(masterDataSource);
    sessionFactory.setMapperLocations(new PathMatchingResourcePatternResolver()
      .getResources(mapperLocations));
    sessionFactory.setTypeAliasesPackage(typeAliasesPackage);
    sessionFactory.setConfigLocation(new PathMatchingResourcePatternResolver()
      .getResource(configLocation));
    return sessionFactory.getObject();
  }

  @Bean(name = "masterSqlSessionTemplate")
  public SqlSessionTemplate masterSqlSessionTemplate(@Qualifier("masterSqlSessionFactory") SqlSessionFactory sqlSessionFactory) throws Exception {
    return new SqlSessionTemplate(sqlSessionFactory);
  }

  @Bean(name = "riskDatasourceJdbcTemplate")
  public JdbcTemplate primaryJdbcTemplate(@Qualifier("masterDataSource") DataSource dataSource) {
    return new JdbcTemplate(dataSource);
  }
}
