/*
 * Copyright 2014-present Miyou tech inc. All Rights Reserved.
 */

package cn.quantgroup.report.error;

import lombok.extern.slf4j.Slf4j;

/**
 * 系统使用Exception来进行Error Code处理。如果LogType为Error，
 * 代表这种Error不应该返回给客户端，应该统一打印出服务器端错误；
 * 如果是WARNING的话，就将对应的Exception Text返回给客户端。
 */
@Slf4j
public enum QGExceptionType {
  COMMON_SERVER_ERROR(1001, "系统异常，请稍后再试"),
  COMMON_ILLEGAL_STATE(1002, "断言错误"),
  COMMON_ILLEGAL_PARAM_TOAST(1003, "参数异常", "%s"),
  COMMON_AUTH_ERROR(1004, "系统异常，请稍后再试"),
  COMMON_ILLEGAL_PARAM(1010, "参数异常"),
  COMMON_THIRD_PARTY_TIMEOUT(1011, "第三方服务超时"),
  COMMON_INVALID_PARAM(1012, "参数错误"),
  COMMON_ID_INVALID(1013, "id数据非法"),
  COMMON_STRING_PARAM_GREATER_THAN_LENGTH(1014, "参数的长度过长", "%s的长度不能大于%s"),
  COMMON_STRING_PARAM_IS_ALL_NULL(1015, "参数不能为空", "%s不能为空"),
  COMMON_STRING_PARAM_IS_NULL(1016, "参数不能同时为空", "%s不能同时为空"),
  COMMON_THIRD_PARTY_ERROR(1017, "第三方服务报错", "第三方服务报错,错误编码:%s,错误提示:%s"),


  COMMON_QIAN_HAI_API_INNER_ERROR(1023, "前海服务接口出错", "%s"),
  COMMON_QIAN_HAI_API_CALL_FAIL(1024, "前海服务调用失败", "%s"),
  //1025
//  COMMON_JD_API_CALL_FAIL(1026, "jd服务调用失败"),
  COMMON_JD_API_RET_ERROR(1027, "jd服务调用失败", "错误编码:%s,错误提示:%s"),
  COMMON_TIMES_GREATER_THAN_MAX_IN_TIME_QUANTUM(1028, "操作频率太快了", "一定时间[%s]秒内,[%s]的操作次数过多,当前为%s,允许的最大值为%s"),
  COMMON_TIMES_GREATER_THAN_ONE_TIME_IN_TIME_QUANTUM(1029, "指定时间内操作重复", "一定时间[%s]秒内,[%s]被重复操作,当前为操作次数%s"),
  COMMON_DISALLOW_CONCURRENT_EXECUTION(1030, "操作重复", "[%s]被重复操作,当前为操作次数%s"),
  COMMON_BAI_RONG_API_CALL_FAIL(1031, "百融服务调用失败", "百融服务调用失败,错误编码:%s,错误提示:%s"),
  COMMON_BAI_RONG_LOGIN_FAIL(1033, "百融授权失败", "%s"),
  COMMON_CREDIT_X_API_CALL_FAIL(1034, "CreditX服务调用失败", "CreditX服务调用失败,错误编码:%s,错误提示:%s"),
  COMMON_SHU_MEI_API_CALL_FAIL(1035, "数美服务调用失败", "数美服务调用失败,错误编码:%s,错误提示:%s"),
//  COMMON_Q_CLOUD_API_CALL_FAIL(1036, "qcloud服务调用失败"),
  COMMON_91_ZHENG_XIN_API_CALL_FAIL(1037, "91征信服务调用失败"),
  COMMON_91_OPERATION_BEYOND_LIMIT(1038, "91征信服务调用过于频繁失败"),
  COMMON_GE_TUI_UUID_INVALID(1039, "uuid不能为空"),
  COMMON_GE_TUI_UUID_INFO_NOT_EXIST(1040, "用户设备信息不存在"),
  COMMON_GE_TUI_API_CALL_FAIL(1041, "个推服务调用失败"),
  COMMON_GE_TUI_AUTH_CALL_FAIL(1042, "个推授权调用失败"),
  COMMON_HAO_AN_API_CALL_FAIL(1043,"号安服务调用失败", "%s"),
  COMMON_BAI_DU_API_CALL_FAIL(1044,"百度服务调用失败"),
  COMMON_INTELLI_CREDIT_API_CALL_FAIL(1045,"中智信服务调用失败", "%s"),
  COMMON_INTELLI_CREDIT_LOAN_ID_NOT_NULL(1046, "借款id不能为空"),
  COMMON_INTELLI_CREDIT_USER_INVALID(1047, "用户不存在"),
  COMMON_INTELLI_CREDIT_USER_DETAIL_INVALID(1048, "用户详情信息不存在"),
  COMMON_BAI_QI_SHI_API_CALL_FAIL(1049,"白骑士服务调用失败"),
  COMMON_THIRD_PART_CALL_FAIL(1050,"第三方服务调用失败"),
  COMMON_RONG360_API_CALL_FAIL(1051,"融360服务调用失败", "%s"),
  COMMON_CHENGAN_API_CALL_FAIL(1052,"诚安服务调用失败"),
  COMMON_SHENGDUN_API_CALL_FAIL(1053,"晟顿服务调用失败", "%s"),
  COMMON_XINYAN_API_CALL_FAIL(1054,"新顏服务调用失败", "%s"),
  COMMON_TIANXINGHUI_API_CALL_FAIL(1055,"天行汇服务调用失败", "%s"),
  COMMON_ZHONGCHENGXIN_API_CALL_FAIL(1056,"中诚信服务调用失败"),
  COMMON_DIAN_HUA_BANG_API_CALL_FAIL(1057,"电话邦服务调用失败", "%s"),
  COMMON_BLACK_APPID_IS_NULL(1058,"黑名单appid不能为空"),
  COMMON_BLACK_APPID_IS_WRONG(1059,"黑名单appid不正确"),
  COMMON_BLACK_TIMESTAMP_IS_NULL(1060,"黑名单timeunit为空"),
  COMMON_BLACK_TIMESTAMP_IS_INVALID(1061,"黑名单timeunit超时"),
  COMMON_BLACK_PHONE_IS_NULL(1062,"黑名单手机号为空"),
  COMMON_BLACK_TOKEN_IS_NULL(1063,"黑名单token为空"),
  COMMON_BLACK_TOKEN_IS_INVALID(1064,"黑名单token无效"),
  COMMON_CHANNEL_IS_INVALID(1065,"无效的来源渠道"),
  COMMON_BLACK_APPID_IS_INVALID(1066,"APPID无效"),
  COMMON_USER_CENTER_NOT_FOUND(1067,"用户中心未查询到当前用户", "用户中心未查询到当前用户: %s"),
  COMMON_FA_HAI_RESULT_ERROR(1068,"法海服务返回结果异常当前用户","法海服务返回结果异常当前用户：%s"),
  COMMON_JI_AO_API_CALL_FAIL(1069,"集奥服务调用失败","%s"),
  COMMON_JI_AO_API_RET_ERROR(1070,"集奥服务调用结果异常", "错误编码:%s,错误提示:%s"),
  COMMON_TIAN_CHUANG_API_CALL_FAIL(1071,"天创服务调用失败", "%s"),
  COMMON_TIAN_CHUANG_API_RET_ERROR(1072,"天创服务调用结果异常", "错误编码:%s,错误提示:%s"),
  COMMON_SHU_CHUANG_API_CALL_FAIL(1073,"数创服务调用失败", "%s"),
  COMMON_SHU_CHUANG_API_RET_ERROR(1074,"数创服务调用结果异常", "错误编码:%s,错误提示:%s"),
  COMMON_ELEVEN_BEI_API_CALL_FAIL(1075,"十一呗服务调用失败"),
  COMMON_ELEVEN_BEI_API_RET_ERROR(1076,"十一呗服务调用结果异常", "错误编码:%s,错误提示:%s"),
  COMMON_HAO_AN_API_RET_ERROR(1077,"号安服务调用结果异常", "错误编码:%s,错误提示:%s"),
  COMMON_TONG_DUN_API_CALL_FAIL(1078,"同盾服务调用失败", "%s"),
  COMMON_TONG_DUN_API_RET_ERROR(1079,"号安服务调用结果异常", "错误编码:%s,错误提示:%s"),
  COMMON_XIN_YAN_API_CALL_FAIL(1080,"新颜服务调用失败"),
  COMMON_XIN_YAN_API_RET_ERROR(1081,"新颜服务调用结果异常", "错误编码:%s,错误提示:%s"),
  COMMON_DIAN_HUA_BANG_API_RET_ERROR(1082,"电话邦服务调用结果异常", "错误编码:%s,错误提示:%s"),
  COMMON_BAI_RONG_PERC_API_CALL_FAIL(1083,"百融个人资质服务调用失败", "%s"),
  COMMON_BAI_RONG_PERC_API_RET_ERROR(1084,"百融个人资质调用结果异常", "错误编码:%s,错误提示:%s"),
  COMMON_BAI_RONG_RULE_APPLY_API_CALL_FAIL(1085,"百融个人资质服务调用失败", "%s"),
  COMMON_BAI_RONG_RULE_APPLY_API_RET_ERROR(1086,"百融个人资质调用结果异常", "错误编码:%s,错误提示:%s"),
  COMMON_BAI_RONG_WHITE_LIST_API_CALL_FAIL(1087,"百融白名单服务调用失败", "%s"),
  COMMON_BAI_RONG_WHITE_LIST_API_RET_ERROR(1088,"百融白名单服务调用结果异常", "错误编码:%s,错误提示:%s"),
  COMMON_KA_NIU_WHITE_LIST_API_CALL_FAIL(1089,"卡牛服务调用失败", "%s"),
  COMMON_KA_NIU_WHITE_LIST_API_RET_ERROR(1090,"卡牛服务调用结果异常", "错误编码:%s,错误提示:%s"),
  COMMON_TIANXINGHUI_API_RET_ERROR(1091,"天行汇服务调用结果异常", "错误编码:%s,错误提示:%s"),
  COMMON_QIAN_HAI_API_RET_ERROR(1092,"前海服务调用结果异常", "错误编码:%s,错误提示:%s"),
  COMMON_SHENG_DUN_API_RET_ERROR(1093,"晟顿服务调用结果异常", "错误编码:%s,错误提示:%s"),
  COMMON_Q_CLOUD_API_CALL_ERROR(1094, "qcloud服务调用异常", "错误编码:%s,错误提示:%s"),
  COMMON_Q_CLOUD_API_CALL_RESULT_ERROR(1095, "qcloud服务调用结果异常", "错误编码:%s,错误提示:%s"),
  COMMON_BING_JIAN_API_CALL_FAIL(1096,"冰鉴服务调用失败","接口:%s ;%s"),
  COMMON_BING_JIAN_API_RET_ERROR(1097,"冰鉴服务调用结果异常", "接口:%s ;错误编码:%s,错误提示:%s"),
  COMMON_BAI_RONG_STRATEGY_API_CALL_FAIL(1098,"百融服务调用失败", "接口:%s ;%s"),
  COMMON_BAI_RONG_STRATEGY_API_RET_ERROR(1099,"百融调用结果异常", "接口:%s ;错误编码:%s,错误提示:%s"),
  //1100
  COMMON_AN_LIANG_API_CALL_FAIL(1101,"安粮服务调用失败", "接口:%s ;%s"),
  COMMON_AN_LIANG_API_RET_ERROR(1102,"安粮调用结果异常", "接口:%s ;错误编码:%s,错误提示:%s"),
  COMMON_ZHI_SHU_API_CALL_FAIL(1103,"智数服务调用失败", "接口:%s ;%s"),
  COMMON_ZHI_SHU_API_RET_ERROR(1104,"智数调用结果异常", "接口:%s ;错误编码:%s,错误提示:%s"),
  COMMON_GE_TUI_NEW_API_CALL_FAIL(1105,"个推服务调用失败", "接口:%s ;%s"),
  COMMON_GE_TUI_NEW_API_RET_ERROR(1106,"个推调用结果异常", "接口:%s ;错误编码:%s,错误提示:%s"),
  COMMON_FICO_API_CALL_FAIL(1107,"FICO服务调用失败", "接口:%s ;%s"),
  COMMON_FICO_API_RET_ERROR(1108,"FICO调用结果异常", "接口:%s ;错误编码:%s,错误提示:%s"),
  COMMON_QICHACHA_API_CALL_FAIL(1109,"企查查服务调用失败", "接口:%s ;%s"),
  COMMON_QICHACHA_API_RET_ERROR(1110,"企查查调用结果异常", "接口:%s ;错误编码:%s,错误提示:%s"),
  COMMON_JI_GUANG_API_CALL_FAIL(1111,"极光服务调用失败", "接口:%s ;%s"),
  COMMON_JI_GUANG_API_RET_ERROR(1112,"极光调用结果异常", "接口:%s ;错误编码:%s,错误提示:%s"),
  COMMON_TAN_ZHI_API_RET_ERROR(1113,"探知数据报告服务调用结果异常", "错误编码:%s,错误提示:%s"),
  COMMON_ANLIANG_RESULT_DATA_NULL_RET_ERROR(1114,"安粮返回结果为空", "错误编码:%s,错误提示:%s"),
  COMMON_ZHONGCHENGXIN_PHONECHECK_API_CALL_FAIL(1115,"中诚信手机实名校验服务调用失败"),
  COMMON_ZHONGCHENGXIN_BANKCARDCHECK_API_CALL_FAIL(1116,"中诚信银行卡四要素校验服务调用失败"),


  COMMON_ZHICHENGAFU_API_CALL_FAIL(1117,"至诚阿福欺诈甄别", "错误编码:%s, 错误提示:%s"),
  COMMON_LIANGJINGJING_V2_API_CALL_FAIL(1118,"量京京V2联合建模"),
  COMMON_MOXIERISK_API_CALL_FAIL(1119,"魔蝎申请准入报告查询异常", "错误编码:%s, 错误提示:%s"),
  COMMON_MOXIERISK_API_RESULT_UNKNOW(1120,"魔蝎申请准入报告返回结果查询异常", "错误编码:%s, 错误提示:%s"),
  COMMON_SUANHUARISK_API_CALL_FAIL(1121,"算话风险过滤服务调用失败", "错误编码:%s, 错误提示:%s"),
  ////COMMON_PINTAI_API_CALL_FAIL(1061,"品钛线上现金分期场景分服务调用失败", "错误编码:%s, 错误提示:%s"),
  COMMON_TONGDUNLOAN_API_CALL_FAIL(1122,"同盾信贷保镖智信分查询异常", "错误编码:%s, 错误提示:%s"),
  COMMON_MOXIERISK_API_V2_CALL_FAIL(1123,"魔蝎申请准入报告查询异常", "错误编码:%s, 错误提示:%s"),
  COMMON_JI_AO_API_REGISTER_TIME_ERROR(1124,"集奥手机号在网时长查询异常", "错误编码:%s, 错误提示:%s"),
  COMMON_JI_AO_API_STOP_ENGINE_TIME_ERROR(1125,"集奥近3个月停机次数查询异常", "错误编码:%s, 错误提示:%s"),
  COMMON_JI_AO_API_IS_IN_BLACK_LIST_ERROR(1126,"集奥手机号是否在黑名单查询异常", "错误编码:%s, 错误提示:%s"),
  COMMON_PAIPAIXIN_CASH_LOAN_ERROR(1127,"拍拍贷-拍拍信现金分期模型查询异常", "错误编码:%s, 错误提示:%s"),
  ////COMMON_PINTAI_CREDIT_V1_API_CALL_FAIL(1128,"品钛信用评估分V1服务调用失败", "错误编码:%s, 错误提示:%s"),
  ////COMMON_PINTAI_CREDIT_V2_API_CALL_FAIL(1068,"品钛信用评估分V2服务调用失败", "错误编码:%s, 错误提示:%s"),
  COMMON_SUANHUARISK_API_CALL_RESULT_IS_NULL_FAIL(1129,"算话风险过滤服务返回结果为空" ),
  COMMON_PAIPAIXIN_CASH_LOAN_RESULT_IS_NULL_ERROR(1130,"拍拍贷-拍拍信现金分期模型返回结果为空"),
  COMMON_YOUMENG_LOAN_SCORE_ERROR(1131,"友盟小额分", "错误编码:%s, 错误提示:%s"),
  COMMON_FAHAI_ERROR(1132,"法海司法", "错误编码:%s, 错误提示:%s"),
  COMMON_JINRONG_360_CREDIT_SCORE_ERROR(1133,"360金融统一信用分调用失败", "错误编码:%s, 错误提示:%s"),
  COMMON_BAIHANG_CREDIT_REPORT_ERROR(1134,"百行征信查询失败", "错误编码:%s, 错误提示:%s"),
  COMMON_HUADAO_MODEL_ERROR(1135,"华道联合建模", "错误编码:%s, 错误提示:%s"),
  COMMON_HUADAO_MODEL_GET_QUERY_TOKEN_ERROR(1136,"华道联合建模获取请求token失败", "错误编码:%s, 错误提示:%s"),
  ////COMMON_TENCENT_AUDIFRAUD_RISK_SCORE_RESULT_ERROR(1137,"腾讯天御反欺诈风险分请求结果异常", "错误编码:%s, 错误提示:%s"),
  ////COMMON_DIANHUABANG_THREEELEMENTS_CHECK_RESULT_ERROR(1077,"电话邦三要素核验异常", "错误编码:%s, 错误提示:%s"),
  COMMON_CASH_LOAN_SCORE_RESULT_ERROR(1138,"集奥线上现金分期评分异常", "错误编码:%s, 错误提示:%s"),
  COMMON_ZHONGCHENGXIN_PHONE_REGISTER_TIME_API_CALL_FAIL(1139,"中诚信手机号在网时长服务调用失败"),
  //  xyqb user
  XYQB_USER_NOT_EXSIT(2001, "用户不存在"),
  XYQB_USER_NOT_MATCH(2002, "用户不匹配"),
  COMMON_THIRD_PART_CALL_EXCEPTION(3001,"第三方服务调用异常", "异常信息:%s"),
  //

  COMMON_MI_GUAN_API_CALL_FAIL(1140,"获取蜜罐报告接口调用失败","%s"),
  COMMON_MI_GUAN_API_RET_ERROR(1141,"获取蜜罐报告接口调用结果异常", "错误编码:%s,错误提示:%s"),

  COMMON_FACEID_API_CALL_FAIL(1142,"FaceID风控多头API调用失败","%s"),
  COMMON_FACEID_API_RET_ERROR(1143,"FaceID风控多头API调用结果异常", "错误编码:%s,错误提示:%s"),

  COMMON_MuJin_API_CALL_FAIL(1144,"木槿科技借贷风险名单API调用失败","%s"),
  COMMON_MuJin_API_RET_ERROR(1145,"木槿科技借贷风险名单API调用结果异常", "错误编码:%s,错误提示:%s"),

  COMMON_RongHui_API_CALL_FAIL(1146,"融慧量化派定制化模型API调用失败","%s"),
  COMMON_RongHui_API_RET_ERROR(1147,"融慧量化派定制化模型API调用结果异常", "错误编码:%s,错误提示:%s"),

  COMMON_DIANHUABANG_THREEELEMENTS_CHECK_RESULT_FAIL(1148,"电话邦三要素核验调用失败","%s"),
  COMMON_DIANHUABANG_THREEELEMENTS_CHECK_RESULT_ERROR(1149,"电话邦三要素核验异常", "错误编码:%s, 错误提示:%s"),

  COMMON_DIANHUABANG_CALLACCNETDURTIME_THREEELEMENTS_API_CALL_FAIL(1150,"电话邦手机号在网时长调用失败","%s"),
  COMMON_DIANHUABANG_CALLACCNETDURTIME_THREEELEMENTS_API_RET_ERROR(1151,"电话邦手机号在网时长异常", "错误编码:%s, 错误提示:%s"),

  COMMON_PINTAI_API_CALL_FAIL(1152,"品钛线上现金分期场景分服务调用失败", "%s"),
  COMMON_PINTAI_API_RET_ERROR(1153,"品钛线上现金分期场景分服务调用异常", "错误编码:%s, 错误提示:%s"),

  COMMON_PINTAI_CREDIT_V2_API_CALL_FAIL(1154,"品钛信用评估分V2服务调用失败", "%s"),
  COMMON_PINTAI_CREDIT_V2_API_RET_ERROR(1155,"品钛信用评估分V2服务调用异常", "错误编码:%s, 错误提示:%s"),

  COMMON_PengRui_API_CALL_FAIL(1156,"鹏芮风控黑名单调用失败","%s"),
  COMMON_PengRui_API_RET_ERROR(1157,"鹏芮风控黑名单调用结果异常", "错误编码:%s,错误提示:%s"),

  COMMON_LhpBlackListLevel_FAIL(1158,"量化派数据产品输出黑名等级查询失败","%s"),
  COMMON_LhpBlackListLevel_ERROR(1159,"量化派数据产品输出黑名等级查询异常", "错误编码:%s,错误提示:%s"),

  COMMON_TENCENT_AUDIFRAUD_RISK_SCORE_RESULT_FAIL(1160,"腾讯天御反欺诈风险分请求失败","%s"),
  COMMON_TENCENT_AUDIFRAUD_RISK_SCORE_RESULT_ERROR(1161,"腾讯天御反欺诈风险分请求结果异常", "错误编码:%s, 错误提示:%s"),

  COMMON_PINTAI_CREDIT_V1_API_CALL_FAIL(1166,"品钛信用评估分V1服务调用失败", "%s"),
  COMMON_PINTAI_CREDIT_V1_API_ERROR(1167,"品钛信用评估分V1服务调用结果异常", "错误编码:%s, 错误提示:%s"),

  COMMON_ZhongHuJinThreeElement_API_FAIL(1162,"中互金运营商三要素核验API调用失败","%s"),
  COMMON_ZhongHuJinThreeElement_API_ERROR(1163,"中互金运营商三要素核验API调用结果异常", "错误编码:%s,错误提示:%s"),

  COMMON_ZhongHuJinWholeIn_API_FAIL(1164,"中互金在网时长核验API调用失败","%s"),
  COMMON_ZhongHuJinWholeIn_API_ERROR(1165,"中互金在网时长核验API调用结果异常", "错误编码:%s,错误提示:%s"),

  /** !!!!!!!!!!!!!!!!备注：以后code增加依次类推，请不要重复!!!!!!!!!!!!!! */
  ;

  public int code;
  public String text;
  public String frontEndToastTemplate;

  QGExceptionType(int code, String text) {
    this.code = code;
    this.text = text;
    this.frontEndToastTemplate = text;
  }

  QGExceptionType(int code, String text, String frontEndToastTemplate) {
    this.code = code;
    this.text = text;
    this.frontEndToastTemplate = frontEndToastTemplate;
  }


  public static QGExceptionType fromCode(int code) {
    for (QGExceptionType exceptionType : QGExceptionType.values()) {
      if (exceptionType.code == code) {
        return exceptionType;
      }
    }
    return null;
  }

  @Override
  public String toString() {
    return "error_code: " + code + ", text: " + text + ", frontEndToastTemplate: " + frontEndToastTemplate;
  }
}
