package cn.quantgroup.report;

import cn.quantgroup.report.job.QuantGroupZhuDaiReportToBaiHang;
import cn.quantgroup.report.service.repair.RepairService;
import com.google.common.base.Stopwatch;
import lombok.extern.slf4j.Slf4j;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

import java.util.concurrent.TimeUnit;

@Slf4j
@RunWith(SpringRunner.class)
@SpringBootTest(classes = BaihangReportApplication.class)
public class BaihangReportApplicationTests {

	@Autowired
	QuantGroupZhuDaiReportToBaiHang  repoter;
	@Autowired
	RepairService service;

	@Test
	public void contextLoads() {
		repoter.startZhuDaiReport();
	}

	@Test
	public void testRepair(){
		Stopwatch stopwatch = Stopwatch.createStarted();
		doRepair("normal_lh");
		doRepair("overdue_lh");
		doRepair("normal");
		doRepair("overdue");
		log.info("本次测试总耗时 {}",stopwatch.elapsed(TimeUnit.MILLISECONDS));
	}

	private void doRepair(String type) {
		Stopwatch stopwatch = Stopwatch.createStarted();
		log.info("开始报送 {}",type);
		boolean flag = true;
		int i=0;
		while (flag){
			try {
				flag = service.doRepair(i,type);
			} catch (Exception e) {
				log.info("overdue_lh 第 {} 页 异常",i,e);
				continue;
			}
			i++;
		}
		log.info("本次测试 {} 总耗时 {}",type,stopwatch.elapsed(TimeUnit.MILLISECONDS));
	}

}
