package cn.quantgroup.report.service.baihang;

import cn.quantgroup.report.config.aop.Monitor;
import cn.quantgroup.report.config.aop.MonitorType;
import cn.quantgroup.report.constant.TransactionCodeEnum;
import cn.quantgroup.report.enums.RequestUrlType;
import cn.quantgroup.report.error.QGException;
import cn.quantgroup.report.error.QGExceptionType;
import cn.quantgroup.report.mapper.baihang.ApplyLoanInfoMapper;
import cn.quantgroup.report.response.GlobalResponse;
import cn.quantgroup.report.service.CommonSuperService;
import cn.quantgroup.report.service.baihang.client.BhInterfaceCreditApiClient;
import cn.quantgroup.report.service.baihang.request.InterfaceUploadRequest;
import cn.quantgroup.report.service.baihang.response.InterfaceUploadResponse;
import cn.quantgroup.report.service.baihang.util.BHRSAUtils;
import cn.quantgroup.report.service.baihang.util.Base64;
import cn.quantgroup.report.service.thirdpartymonitor.ThirdpartyApiMonitorService;
import cn.quantgroup.report.config.aop.DistributedLock;
import cn.quantgroup.report.domain.baihang.ApplyLoanInfo;
import cn.quantgroup.report.service.AbstractBaseService;
import cn.quantgroup.report.service.http.IHttpService;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Stopwatch;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

/**
 * @Author fengjunkai
 * @Date 2019-07-11 18:01
 */
@Slf4j
@Service
public class BaiHangQueryService extends AbstractBaseService implements CommonSuperService {

    @Value("${baihang.C1.account.name}")
    private String baiHangC1QueryAccountName;
    @Value("${baihang.C1.password}")
    private String haiHangC1Password;

    @Value("${baihang.zhudai.applyloan.url}")
    public String baihangHandC1DataUrl;

    @Autowired
    public IHttpService iHttpService;
    @Autowired
    public ApplyLoanInfoMapper applyLoanInfoMapper;

    @Autowired
    private ThirdpartyApiMonitorService thirdpartyApiMonitorService;

    @Monitor({MonitorType.EXCEPTION, MonitorType.FEE, MonitorType.HIT, MonitorType.RESULT})
    @DistributedLock
    public GlobalResponse queryBaiHangPersionCreditReport(String transactionId, String identity, String phone, String name, String uuid, boolean isReadCache) {
        RequestUrlType requestUrlType = RequestUrlType.BaiHangPersionalCreditReport;

        Integer cacheTime = isReadCache? cacheConfigService.getTestCacheTime(requestUrlType.name()):cacheConfigService.getCacheTime(requestUrlType.name());

        if(isReadCache){

            String responseInHBase = thirdpartyApiMonitorService.loadInHBaseAndCheckTimeOut(requestUrlType, uuid, cacheTime);
            if(StringUtils.isNotBlank(responseInHBase)){
                log.info("百行个人征信报告(测试查询缓存)hbase查询到结果, transactionId: {} , urlType : {}, uuid: {} , name: {} , idNo: {} , phoneNo: {} , isReadCache: {} , cacheTime: {} ",
                        transactionId, requestUrlType, uuid, name, identity, phone, isReadCache, cacheTime);
                return GlobalResponse.builder(transactionId, JSON.parseObject(responseInHBase)).addUuid(uuid).addTransactionResult(requestUrlType, TransactionCodeEnum.HitInHbase);
            }else if("".equals(responseInHBase)){
                log.info("百行个人征信报告(测试查询缓存)hbase查询到空字符串, ttransactionId: {} , urlType : {}, uuid: {} , name: {} , idNo: {} , phoneNo: {} , isReadCache: {} , cacheTime: {} ",
                        transactionId, requestUrlType, uuid, name, identity, phone, isReadCache, cacheTime);
                return GlobalResponse.builder(transactionId, null).addUuid(uuid).addTransactionResult(requestUrlType, TransactionCodeEnum.SuccessAndMiss);
            }else {
                log.info("百行个人征信报告(测试查询缓存)hbase未查询到结果, transactionId: {} , urlType : {}, uuid: {} , name: {} , idNo: {} , phoneNo: {} , isReadCache: {} , cacheTime: {} ",
                        transactionId, requestUrlType, uuid, name, identity, phone, isReadCache, cacheTime);
                return GlobalResponse.builder(transactionId, null).addUuid(uuid).addTransactionResult(requestUrlType, TransactionCodeEnum.Fail);
            }

        }else{

            if(cacheTime>0){
                String responseInHBase = thirdpartyApiMonitorService.loadInHBaseAndCheckTimeOut(requestUrlType, uuid, cacheTime);
                if (responseInHBase != null) {
                    log.info("百行个人征信报告从hbase拿到数据, transactionId : {} urlType : {},uuid: {}", transactionId, requestUrlType, uuid);
                    if (StringUtils.isBlank(responseInHBase)) {
                        return GlobalResponse.builder(transactionId, null).addUuid(uuid).addTransactionResult(requestUrlType, TransactionCodeEnum.HitInHbase);
                    } else {
                        return GlobalResponse.builder(transactionId, JSON.parseObject(responseInHBase)).addUuid(uuid).addTransactionResult(requestUrlType, TransactionCodeEnum.HitInHbase);
                    }
                }
            }

        }

        String isbilling = "1";
        TransactionCodeEnum transCode = null;
        Long startTime = System.currentTimeMillis();
        Long endTime = System.currentTimeMillis();
        String code = "0001";
        String msg = "查询异常";
        String msg2 = "查询异常";
        try{
            ApplyLoanInfo applyLoanInfo = new ApplyLoanInfo();
            applyLoanInfo.setName(interfaceUploadClient(name));
            applyLoanInfo.setMobile(interfaceUploadClient(phone));
            applyLoanInfo.setPid(interfaceUploadClient(identity));
            applyLoanInfo.setApplyAmount("-1");
            applyLoanInfo.setCustomType("99");
            applyLoanInfo.setGuaranteeType("1");
            applyLoanInfo.setLoanPurpose("1");
            applyLoanInfo.setQueryReason("1");
            Stopwatch stopwatch = Stopwatch.createStarted();
            String resultStr = iHttpService.postBaiHang(baihangHandC1DataUrl, getHeader(), JSON.toJSONString(applyLoanInfo));
            log.info("百行个人征信报告查询结果, transactionId: {} , uuid: {} , phone: {} , name: {} , idCard: {} , result: {} , time: {}",
                    transactionId, uuid, phone, name, identity, resultStr, stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));

            JSONObject resultJson = JSON.parseObject(resultStr);

            if(StringUtils.isNotBlank(resultStr) && resultStr.contains("errorCode") && resultStr.contains("errorMessage")){
                String errorCode = resultJson.getString("errorCode");
                if(StringUtils.equalsAny(errorCode, "ERR_30001", "ERR_30002", "ERR_30003")){
                    thirdpartyApiMonitorService.saveInHBase(requestUrlType, uuid, JSON.toJSONString(applyLoanInfo), "");
                    return GlobalResponse.builder(transactionId, null).addUuid(uuid).addTransactionResult(requestUrlType, TransactionCodeEnum.SuccessAndMiss);
                }
                code = errorCode;
                msg = resultJson.getString("errorMessage");
                msg2 = resultJson.getString("errorMessage");
                return GlobalResponse.builder(transactionId, new QGException(QGExceptionType.COMMON_BAIHANG_CREDIT_REPORT_ERROR, code, msg)).addUuid(uuid).addTransactionResult(requestUrlType, TransactionCodeEnum.Fail);
            }

            JSONObject reportHeaderJson = resultJson.getJSONObject("reportHeader");
            Integer queryResult = reportHeaderJson.getInteger("queryResult");

            //modify 2019.09.17 调用日志的msg中记录reportId|reportTime|pid
            String reportId = "",reportTime="",pid="";
            try{
                reportId = reportHeaderJson.getString("reportId")!=null ? reportHeaderJson.getString("reportId") : "";
                reportTime = reportHeaderJson.getString("reportTime") !=null ? reportHeaderJson.getString("reportTime") : "";
                JSONObject person = resultJson.getJSONObject("personalProfile");
                if(person!=null){
                    pid = person.getString("pid")!=null ?  person.getString("pid") : "";
                }
            }catch (Exception e){
                log.warn("百行个人征信报告获取reportId|reportTime|pid异常, transactionId: {} , uuid: {} , reportId: {} , reportTime: {} , pid: {} ", transactionId, uuid, reportId, reportTime, pid, e);
            }
            //----------end-------------

            if(1==queryResult){
                isbilling = "0";
                code = "0000";
                msg = "命中结果";
                //modify 2019.09.17 调用日志的msg中记录reportId|reportTime|pid
                msg2 = "命中结果|"+reportId+"|"+reportTime+"|"+pid;
                thirdpartyApiMonitorService.saveInHBase(requestUrlType, uuid, JSON.toJSONString(applyLoanInfo), JSON.toJSONString(resultJson));
                return GlobalResponse.builder(transactionId, resultJson).addUuid(uuid).addTransactionResult(requestUrlType, TransactionCodeEnum.SuccessAndHit).isBilling(true);

            }else if(0==queryResult){
                isbilling = "0";
                code = "0000";
                msg = "未命中结果";
                //modify 2019.09.17 调用日志的msg中记录reportId|reportTime|pid
                msg2 = "未命中结果|"+reportId+"|"+reportTime+"|"+pid;
                thirdpartyApiMonitorService.saveInHBase(requestUrlType, uuid, JSON.toJSONString(applyLoanInfo), "");
                return GlobalResponse.builder(transactionId, null).addUuid(uuid).addTransactionResult(requestUrlType, TransactionCodeEnum.SuccessAndMiss);

            }

        }catch(Exception e){
            log.error("百行个人征信报告查询异常, transactionId: {} , uuid: {} , idCard: {} , name: {} , phone: {} ",
                    transactionId, uuid, identity, name, phone, e);
        }finally {
            //thirdpartyApiMonitorService.create(uuid, requestUrlType, isbilling, msg, (int) (endTime - startTime), code);
            thirdpartyApiMonitorService.create(uuid, requestUrlType, isbilling, msg2, (int) (endTime - startTime), code);
        }

        return GlobalResponse.builder(transactionId, new QGException(QGExceptionType.COMMON_BAIHANG_CREDIT_REPORT_ERROR, code, msg)).addUuid(uuid).addTransactionResult(requestUrlType, TransactionCodeEnum.Fail);

    }

    public Map<String, String> getHeader() {
        Map<String, String> headerMap = new HashMap<>();
        headerMap.put("Authorization", "Basic " + Base64.byteArrayToBase64((baiHangC1QueryAccountName + ":" + haiHangC1Password).getBytes()));
        headerMap.put("Content-Type", "application/json");
        return headerMap;
    }

    public static String interfaceUploadClient(String param) throws Exception {

        InterfaceUploadRequest req = new InterfaceUploadRequest();
        List<String> datas = new ArrayList<String>();
        datas.add(param);
        //设置待加密的原始数据集合
        req.setData(datas);
        BhInterfaceCreditApiClient client = new BhInterfaceCreditApiClient();
        //初始化设置RSA公钥
        client.init(BHRSAUtils.readRSAPublicKey("/baihang/rsa_public_key.pem"));
        //执行加密操作
        InterfaceUploadResponse response = client.execute(req);
        if (response.isSuccess) {
            List<String> data = response.getEncryptData();
            return data.get(0);
        }
        throw new Exception();
    }

}
