package cn.quantgroup.report.service.repair;

import cn.quantgroup.report.domain.baihang.BaiHangRepayment;
import cn.quantgroup.report.domain.baihang.RepaymentInfoZhuDai;
import cn.quantgroup.report.domain.baihang.RepairDataPO;
import cn.quantgroup.report.domain.master.RepaymentLoanWhiteList;
import cn.quantgroup.report.mapper.baihang.RepairDataPOMapper;
import cn.quantgroup.report.mapper.baihang.RepaymentLoanInfoMapper;
import cn.quantgroup.report.mapper.baihang.RepaymentLoanInfoSycMapper;
import cn.quantgroup.report.mapper.master.RepaymentLoanInfoDbMapper;
import cn.quantgroup.report.mapper.master.RepaymentLoanWhiteListMapper;
import cn.quantgroup.report.service.CommonSuperService;
import cn.quantgroup.report.service.baihang.BaiHangZhuDaiService;
import cn.quantgroup.report.service.baihang.util.Base64;
import cn.quantgroup.report.service.http.IHttpService;
import com.alibaba.fastjson.JSON;
import com.google.common.base.Stopwatch;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.io.File;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * @author jian.zheng
 * @date 2021/3/2 - 18:46
 **/
@Service
@Slf4j
public class RepairService implements CommonSuperService {

    @Value("${baihang.zhudai.repaymentloaninfo.url}")
    public String baiHangRepayMentLoanInfoUrl;
    @Value("${baihang.zhudai.account.name}")
    public String account;
    @Value("${baihang.zhudai.password}")
    public String password;
    @Autowired
    RepairDataPOMapper mapper;
    @Autowired
    RepaymentLoanInfoDbMapper writeMapper;
    @Autowired
    IHttpService iHttpService;
    @Autowired
    RepaymentLoanWhiteListMapper repaymentLoanWhiteListMapper;
    @Autowired
    RepaymentLoanInfoMapper repaymentLoanInfoMapper;
    @Autowired
    RepaymentLoanInfoSycMapper findMapper;

    private static Integer[] fundingIds = {420, 520, 580, 650, 670, 810, 240, 640, 700};
//    private static Integer[] fundingIds = {580};
    private static Integer[] fundingIdsLh = {880, 890};

    private static final String logFilePath = "C:\\Users\\Administrator\\Desktop\\data\\";

    public static final String errorLog = "C:\\Users\\Administrator\\Desktop\\data\\error.txt";

    public void doRepair(String type) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        log.info("开始报送 {}",type);
        boolean flag = true;
        int i=0;
        while (flag){
            try {
                flag = doRepair(i,type);
            } catch (Exception e) {
                log.info("overdue_lh 第 {} 页 异常",i,e);
                continue;
            }
            i++;
        }
        log.info("本次测试 {} 总耗时 {}",type,stopwatch.elapsed(TimeUnit.MILLISECONDS));
    }

    private boolean doRepair(int pageNo,String type) throws Exception{
        final int size = 5000;
        Stopwatch stopwatch = Stopwatch.createStarted();
        Integer[] currentFundingIds;
        if ("normal".equals(type) || "overdue".equals(type)){
            currentFundingIds = fundingIds;
        }else {
            currentFundingIds = fundingIdsLh;
        }
        Map<Integer,Boolean> finishFlag = new HashMap<>();
        for (Integer fundId : currentFundingIds){
            List<RepaymentInfoZhuDai> addList = new ArrayList<>();
            List<RepaymentInfoZhuDai> modifyList = new ArrayList<>();
            List<RepairDataPO> newDataEmptyList = new ArrayList<>();
            List<RepairDataPO> oldDataEmptyList = new ArrayList<>();
            List<RepairDataPO> list = pageFind(pageNo,size,fundId);
            log.info("本次查询RepairData fundId : {} page : {} size : {} time : {}",fundId,pageNo,list.size(),stopwatch.elapsed(TimeUnit.MILLISECONDS));
            if (CollectionUtils.isEmpty(list)){
                log.info("当前资方 {} 已完成 第 {} 页跳过",fundId,pageNo);
                finishFlag.put(fundId,true);
                if (finishFlag.size() == currentFundingIds.length && !finishFlag.containsValue(false)){
                    return false;
                }else {
                    continue;
                }
            }else {
                finishFlag.put(fundId,false);
            }
            stopwatch.reset();
            stopwatch.start();
            List<Long> planIds = list.stream().collect(ArrayList::new,(l,i)->l.add(i.getPlanId()),ArrayList::addAll);
            List<RepaymentInfoZhuDai> newList = findNewData(planIds,type,fundId);
            log.info("本次查询newList fundId : {} size : {} time : {}",fundId,newList.size(),stopwatch.elapsed(TimeUnit.MILLISECONDS));
            stopwatch.reset();
            stopwatch.start();
            if (CollectionUtils.isEmpty(newList)){
                throw new RuntimeException("当前type无数据补报");
            }
            Map<Long,RepaymentInfoZhuDai> newMap = newList.stream().collect(Collectors.toMap(i->Long.parseLong(i.getReqID()),i->i));
            for (RepairDataPO po : list){
                RepaymentInfoZhuDai newData = newMap.get(po.getPlanId());//等建刚的SQL
                RepaymentInfoZhuDai oldData = findMapper.findLastOne(BaiHangRepayment.builder().loanId(po.getLoanId()).termNo(Integer.parseInt(po.getTermNo().toString())).build());
                if (newData == null){
                    newDataEmptyList.add(po);
                    continue;
                }else if (oldData == null){
                    String id = UUID.randomUUID().toString().replaceAll("-", "");
                    newData.setRecordId(id);
                    addList.add(newData);
                    oldDataEmptyList.add(po);
                }else {
                    boolean flag = compareRepaymentInfo(newData,oldData);
                    if (!flag){
                        newData.setOpCode("M");
                        newData.setRecordId(oldData.getRecordId());
                        modifyList.add(newData);
                    }
                }
                writeMapper.saveRepaymentLoanInfoLog(newData);
            }
            log.info("本次查询旧数据并对比写入报送日志表 fundId : {} page : {} size : {} time : {}",fundId,pageNo,size,stopwatch.elapsed(TimeUnit.MILLISECONDS));
            stopwatch.reset();
            stopwatch.start();
            try {
                log.info("开始报送 新增 {} 条,修复 {}  条 总计 {} 条",addList.size(),modifyList.size(),modifyList.size() + addList.size());
                report(addList);
                report(modifyList);
                File newEmpty = new File(logFilePath+"newEmpty-"+fundId+"-"+pageNo+type+".txt");
                File oldEmpty = new File(logFilePath+"oldEmpty-"+fundId+"-"+pageNo+type+".txt");
                FileUtils.write(newEmpty,JSON.toJSONString(newDataEmptyList));
                FileUtils.write(oldEmpty,JSON.toJSONString(oldDataEmptyList));
                log.info("本次上报数据 : {} size : {} time : {}",pageNo,addList.size() + modifyList.size(),stopwatch.elapsed(TimeUnit.MILLISECONDS));
            } catch (Exception e) {
                log.error("第 {} 次 {} 报送发生异常",pageNo,type,e);
            }
        }
        return true;
    }

    private void report(List<RepaymentInfoZhuDai> addList) throws Exception {
        int successCount = 0;
        if (CollectionUtils.isEmpty(addList)){
            return;
        }
        int jumpCount = 0;
        for (RepaymentInfoZhuDai info : addList){
            if (info.getTermStatus() != null && "overdue".equals(info.getTermStatus())) {
                String newnyr = LocalDateTime.now().format(DateTimeFormatter.ISO_DATE);
                String bakFileName = "whiteList_" + newnyr + ".json";
                if (checkOverdueInWhiteList(info, 2, bakFileName)) {
                    log.info("众信利民助贷模式TO百行手动报送还款在白名单跳过报送, reqId: {} , loanId: {} , termNo: {} , newnyr: {} ", info.getReqID(), info.getLoanId(), info.getTermNo(), newnyr);
                    jumpCount ++;
                    continue;
                }
            }
            info.setReqID(info.getRecordId());
            info.setRecordId(null);
            info.setPid(BaiHangZhuDaiService.interfaceUploadClient(info.getPid()));
            info.setName(BaiHangZhuDaiService.interfaceUploadClient(info.getName()));
            info.setMobile(BaiHangZhuDaiService.interfaceUploadClient(info.getMobile()));
            String resultStr = iHttpService.postBaiHang(baiHangRepayMentLoanInfoUrl, getHeader(), JSON.toJSONString(info));
            Thread.sleep(120L);
            log.info("众信利民助贷模式TO百行手动报送还款记录 reqID: {} , bean: {} , result: {} ", info.getReqID(), JSON.toJSONString(info), resultStr);
            if (Objects.isNull(resultStr) || "success".equalsIgnoreCase(JSON.parseObject(resultStr).getString("status"))) {
                successCount++;
            }else {
                File file = new File(errorLog);
                List<String> logs = FileUtils.readLines(file,"utf-8");
                logs.add(JSON.toJSONString(resultStr));
                FileUtils.writeLines(file,logs);
            }
        }
        log.info("报送成功 {} 条, 失败 {} 条 , 跳过 {} 条",successCount,addList.size() - successCount,jumpCount);
    }

    private boolean compareRepaymentInfo(RepaymentInfoZhuDai newData, RepaymentInfoZhuDai oldData) {
        boolean finalFlag = true;
        if (!newData.getTermStatus().equals(oldData.getTermStatus())){
            finalFlag = false;
        }
        if (!newData.getRealRepaymentDate().equals(oldData.getRealRepaymentDate())){
            finalFlag = false;
        }
        if (!newData.getTargetRepayment().equals(oldData.getTargetRepayment())){
            finalFlag = false;
        }
        if (!newData.getRealRepayment().equals(oldData.getRealRepayment())){
            finalFlag = false;
        }
        if (!newData.getRealRepayment().equals(oldData.getRealRepayment())){
            finalFlag = false;
        }
        if (!newData.getOverdueStatus().equals(oldData.getOverdueStatus())){
            finalFlag = false;
        }
        if (!newData.getOverdueAmount().equals(oldData.getOverdueAmount())){
            finalFlag = false;
        }
        if (!newData.getRemainingAmount().equals(oldData.getRemainingAmount())){
            finalFlag = false;
        }
        if (newData.getLoanStatus()!=oldData.getLoanStatus()){
            finalFlag = false;
        }
//        log.info("本次对比存在差异 newData : {} oldDataId : {}",JSON.toJSONString(newData),oldData.getReqID());
        return finalFlag;
    }

    private Map<String, String> getHeader() {
        Map<String, String> headerMap = new HashMap<>();
        headerMap.put("Authorization", "Basic " + Base64.byteArrayToBase64((account + ":" + password).getBytes()));
        headerMap.put("Content-Type", "application/json");
        return headerMap;
    }

    private List<RepairDataPO> pageFind(int pageNo,int size,Integer fundingId){
        return mapper.findByPage(pageNo*size,size,fundingId);
    }

    private List<RepaymentInfoZhuDai> findNewData(List<Long> planIds, String type,Integer fundId) {
        if ("normal".equals(type)){
            return repaymentLoanInfoMapper.repairNormal(planIds,fundId);
        }else if ("overdue".equals(type)){
            return repaymentLoanInfoMapper.repairOverdue(planIds,fundId);
        }else if ("normal_lh".equals(type)){
            return repaymentLoanInfoMapper.repairNormalLH(planIds);
        }else if ("overdue_lh".equals(type)){
            return repaymentLoanInfoMapper.repairOverdueLH(planIds);
        }else {
            log.info("type : {} 不在定义中",type);
            throw new RuntimeException("错误的type");
        }
    }

    private boolean checkOverdueInWhiteList(RepaymentInfoZhuDai repaymentLoanInfo, int type, String bakFileName) {
        try {
            RepaymentLoanWhiteList object = repaymentLoanWhiteListMapper.findRepaymentLoanWhiteListOne(repaymentLoanInfo.getLoanId(), type);
            if (object != null && object.getPid() != null && object.getPid().equals(repaymentLoanInfo.getPid())) {

                try {
                    FileUtils.write(new File("/home/quant_group/baihang-report/data/baihang/D3/yuqi_tg/" + bakFileName),
                            JSON.toJSONString(repaymentLoanInfo) + "\r\n", "UTF-8", true);
                } catch (Exception e) {
                    log.error("量化派助贷TO百行报送-逾期还款在白名单跳过报送, Json数据保存文件异常, bean: {} ", JSON.toJSONString(repaymentLoanInfo), e);
                }

                return true;
            }
        } catch (Exception e) {
            log.error("检测逾期还款是在在白名单异常,", e);
        }
        return false;
    }

}
