package cn.quantgroup.report.config.datasource.baihang;


import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import lombok.extern.slf4j.Slf4j;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

import javax.sql.DataSource;

@Import(BaiHangDataSourcePreperties.class)
@Configuration
@Slf4j
@MapperScan(basePackages = BaiHangDataSourceConfig.PACKAGE, sqlSessionFactoryRef = "baihangSqlSessionFactory")
public class BaiHangDataSourceConfig {


    static final String PACKAGE = "cn.quantgroup.report.mapper.baihang";

    @Value("${baihang.mapper-locations}")
    private String mapperLocations;
    @Value("${baihang.type-aliases-package}")
    private String typeAliasesPackage;
    @Value("${config-location}")
    private String configLocation;

    @Autowired
    private BaiHangDataSourcePreperties baiHangDataSourcePreperties;

    @Bean(name = "baihangDataSource")
    @Primary
    public DataSource baihangDataSource() {
        HikariConfig config = new HikariConfig();
        config.setJdbcUrl("jdbc:mysql://172.30.5.27:7434?useUnicode=true&characterEncoding=UTF8&useSSL=false");
        config.setPassword("AHvVRT3eOGsm3tHS");
        config.setUsername("jian.zheng");
        log.info("百行征信数据库地址:{}", "jdbc:mysql://172.30.5.27:7434?useUnicode=true&characterEncoding=UTF8&useSSL=false");
        config.setMaximumPoolSize(baiHangDataSourcePreperties.getMaxPoolSize());
        config.setMinimumIdle(baiHangDataSourcePreperties.getMinPoolSize());
        config.addDataSourceProperty("cachePrepStmts", "true");
        config.addDataSourceProperty("prepStmtCacheSize", "250");
        config.addDataSourceProperty("prepStmtCacheSqlLimit", "2048");
        return new HikariDataSource(config);
    }

    @Bean(name = "baihangTransactionManager")
    @Primary
    public DataSourceTransactionManager baihangTransactionManager(@Qualifier("baihangDataSource") DataSource baihangDataSource) {
        return new DataSourceTransactionManager(baihangDataSource);
    }

    @Bean(name = "baihangSqlSessionFactory")
    @Primary
    public SqlSessionFactory baihangSqlSessionFactory(@Qualifier("baihangDataSource") DataSource baihangDataSource) throws Exception {
        final SqlSessionFactoryBean sessionFactory = new SqlSessionFactoryBean();
        sessionFactory.setDataSource(baihangDataSource);
        sessionFactory.setMapperLocations(new PathMatchingResourcePatternResolver()
                .getResources(mapperLocations));
        sessionFactory.setTypeAliasesPackage(typeAliasesPackage);
        sessionFactory.setConfigLocation(new PathMatchingResourcePatternResolver()
                .getResource(configLocation));
        return sessionFactory.getObject();
    }

    @Bean(name = "baihangSqlSessionTemplate")
    @Primary
    public SqlSessionTemplate baihangSqlSessionTemplate(@Qualifier("baihangSqlSessionFactory") SqlSessionFactory baihangSqlSessionFactory) throws Exception {
        return new SqlSessionTemplate(baihangSqlSessionFactory);
    }


}
