package cn.quantgroup.report.config.datasource.xyqbuser;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import lombok.extern.slf4j.Slf4j;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

import javax.sql.DataSource;

/**
 * Desc:
 * User: HaiNan.Wang
 * Date: 2017/5/2
 */
@Import(XyqbUserDatasourceProperties.class)
@Configuration
@Slf4j
@MapperScan(basePackages = XyqbUserDataSourceConfig.PACKAGE, sqlSessionFactoryRef = "xyqbUserSqlSessionFactory")
public class XyqbUserDataSourceConfig {
  static final String PACKAGE = "cn.quantgroup.report.mapper.xyqbuser";
  @Value("${xyqb_user.mapper-locations}")
  private String mapperLocations;
  @Value("${xyqb_user.type-aliases-package}")
  private String typeAliasesPackage;
  @Value("${config-location}")
  private String configLocation;

  @Autowired
  private XyqbUserDatasourceProperties xyqbUserDatasourceProperties;

  @Bean(name = "xyqbUserDataSource")
  public DataSource xyqbUserDataSource() {
    HikariConfig config = new HikariConfig();
    config.setJdbcUrl("jdbc:mysql://172.30.5.27:7434/xyqb_user?useUnicode=true&characterEncoding=UTF8&useSSL=false");
    config.setPassword("AHvVRT3eOGsm3tHS");
    config.setUsername("jian.zheng");
    log.info("数据库地址:{}", xyqbUserDatasourceProperties.getJdbcUrl());
    config.setMaximumPoolSize(xyqbUserDatasourceProperties.getMaxPoolSize());
    config.setMinimumIdle(xyqbUserDatasourceProperties.getMinPoolSize());
    config.addDataSourceProperty("cachePrepStmts", "true");
    config.addDataSourceProperty("prepStmtCacheSize", "250");
    config.addDataSourceProperty("prepStmtCacheSqlLimit", "2048");
    return new HikariDataSource(config);
  }

  @Bean(name = "xyqbUserTransactionManager")
  public DataSourceTransactionManager xyqbUserTransactionManager(@Qualifier("xyqbUserDataSource") DataSource xyqbUserDataSource) {
    return new DataSourceTransactionManager(xyqbUserDataSource);
  }

  @Bean(name = "xyqbUserSqlSessionFactory")
  public SqlSessionFactory xyqbUserSqlSessionFactory(@Qualifier("xyqbUserDataSource") DataSource xyqbUserDataSource) throws Exception {
    final SqlSessionFactoryBean sessionFactory = new SqlSessionFactoryBean();
    sessionFactory.setDataSource(xyqbUserDataSource);
    sessionFactory.setMapperLocations(new PathMatchingResourcePatternResolver()
      .getResources(mapperLocations));
    sessionFactory.setTypeAliasesPackage(typeAliasesPackage);
    sessionFactory.setConfigLocation(new PathMatchingResourcePatternResolver()
      .getResource(configLocation));
    return sessionFactory.getObject();
  }

  @Bean(name = "xyqbUserSqlSessionTemplate")
  public SqlSessionTemplate xyqbUserSqlSessionTemplate(@Qualifier("xyqbUserSqlSessionFactory") SqlSessionFactory xyqbUserSqlSessionFactory) throws Exception {
    return new SqlSessionTemplate(xyqbUserSqlSessionFactory);
  }
}
