package cn.quantgroup.report.domain.baihang;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 放款用户信息
 *
 * @Author fengjunkai
 * @Date 2019-03-26 14:49
 */
@Data
public class LoanInfoZhuDai extends FinTechAgencyBusinessZhuDai implements Serializable {

    private static final long serialVersionUID = 7293591774673907983L;

    private String reqID;  //记录唯一ID
    private String opCode;  //操作代码A-增加  M-修改
    private String uploadTs; //记录生成时间    ISO 8601格式  LocalDateTime生成 2016-03-08T10:03:10

    //businessOrgCreditCod 业务发生机构代码  Y/N  实际开展本信贷业务的机构的代码。

    private String name; //姓名
    private String pid;  //身份证好
    private String mobile; //手机号
    private String loanId; //贷款编号

    //originalLoanId
    private int guaranteeType; //贷款担保类型
    private int loanPurpose; //借款用途
    private String applyDate;// 贷款申请时间
    private String accountOpenDate;  //账户开立时间
    private String issueDate; //贷款放款时间
    private String dueDate;  //贷款到期日期  YYYY-MM-DD
    private BigDecimal loanAmount; //贷款金额
    private int totalTerm; //还款总期数
    private int targetRepayDateType;  //账单日类型
    private int termPeriod;//每期还款周期
    private String firstRepaymentDate; //首次应还款日期  YYYY-MM-DD
    private int gracePeriod; //宽限日

    private String targetRepayDateList; //账单日列表


    private String recordId;

}
