package cn.quantgroup.report.mapper.baihang;

import cn.quantgroup.report.domain.baihang.BaiHangTimeRecord;
import cn.quantgroup.report.domain.baihang.LoanInfoZhuDai;
import cn.quantgroup.report.domain.baihang.RepairDataOfLoanAccountExt;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 放款信息查询
 *
 * @Author fengjunkai
 * @Date 2019-03-26 15:26
 */
@Repository
public interface LoanInfoMapper {

    //报送实时放款数据（广达百行征信报送）
    //List<LoanInfoZhuDai> findLoanInfo();
    //List<LoanInfoZhuDai> findLoanInfoByTime(BaiHangTimeRecord baiHangTimeRecord);
    //List<LoanInfoZhuDai> stockLoanInfo();

    /**
     * 描述: 根据loan_application_history_id查询xyqb_i_repayment_plan表最晚还款日 <br/>
     * 参数:  loan_application_history_id <br/>
     * 返回值:   <br/>
     * 创建人: yanhui.Hao  <br/>
     * 创建时间: 2019.11.06  <br/>
     */
    List<String> findTargetRepaymentDayList(String reqId);


    /**
     * 描述:  根据order_no查询 loan_application_history_id   <br/>
     * 参数:   orderNoArray<br/>
     * 返回值:  String <br/>
     * 创建人: yanhui.Hao  <br/>
     * 创建时间: 2019.09.24  <br/>
     */
    List<String> findHistoryIdByOrderNo(String[] orderNoArray);


    /**
     * 描述:  根据loan_application_history_id查询手动报送的bean <br/>
     * 参数:   loanApplicationHistoryId <br/>
     * 返回值:  LoanInfoZhuDai <br/>
     * 创建人: yanhui.Hao  <br/>
     * 创建时间: 2019.09.25  <br/>
     */
    LoanInfoZhuDai findLoanInfoD2ByHistoryId(String loanApplicationHistoryId);




    /**
     * 描述: 百行-助贷放款存量数据 <br/>
     * 参数:  日期 BaiHangTimeRecord: startTime和endsTime <br/>
     * 返回值:   <br/>
     * 创建人: yanhui.Hao  <br/>
     * 创建时间: 2019.10.23  <br/>
     */
    List<LoanInfoZhuDai> queryStockLoanInfoZhuDai(BaiHangTimeRecord baiHangTimeRecord);


    /**
     * 描述: 2.1百行助贷-非联合贷 实时放款数据 <br/>
     * 参数:  <br/>
     * 返回值:   <br/>
     * 创建人: yanhui.Hao  <br/>
     * 创建时间: 2019.10.28  <br/>
     */
    List<LoanInfoZhuDai> findRealTimeLoanInfoZhuDai(BaiHangTimeRecord timeRecord);


    /**
     * 描述: 2.2百行助贷-联合贷 实时放款数据 <br/>
     * 参数:  <br/>
     * 返回值:   <br/>
     * 创建人: yanhui.Hao  <br/>
     * 创建时间: 2019.10.28  <br/>
     */
    List<LoanInfoZhuDai> findRealTimeLoanInfoZhuDaiLh(BaiHangTimeRecord timeRecord);


    List<RepairDataOfLoanAccountExt> findRepairDataOfLoanAccountExt(String loanApplicationHistoryId);


}
