package cn.quantgroup.report.job;

import cn.quantgroup.report.service.baihang.BaiHangZhuDaiService;
import cn.quantgroup.report.service.baihang.constant.Constant;
import com.google.common.base.Stopwatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.TimeUnit;


/**
 * -----------------------------------------------------------------------------<br>
 * 描述: 量化派助贷模式(非循环贷) -
 *      (贷款申请/放款/还款(逾期)三类实时批量数据)-To百行报送<br>
 *     每日凌晨5点报送 <br>
 * 作者：yanhui.Hao <br>
 * 时间：2019.10.25 <br>
 * 授权: (C) Copyright (c) 2017 <br>
 * 公司: 北京众信利民信息技术有限公司 <br>
 * -----------------------------------------------------------------------------
 */
@Component
public class QuantGroupZhuDaiReportToBaiHang {

    private static final Logger log = LoggerFactory.getLogger(QuantGroupZhuDaiReportToBaiHang.class);

    @Autowired
    private RedisTemplate<String,String> redisTemplate;

    @Autowired
    private BaiHangZhuDaiService baiHangZhuDaiService;

    @Async
   /* @Scheduled(cron = "0 0 5 * * ?")*/
    public void startZhuDaiReport(){
        if(increment()){
            redisTemplate.expire(Constant.QG_ZHU_DAI_REPORT_LOCK_KEY, 10, TimeUnit.SECONDS);

            Stopwatch stopwatch = Stopwatch.createStarted();
            //yyyy-MM-dd
            String startnyr = LocalDateTime.now().plusDays(-1).format(DateTimeFormatter.ISO_DATE);
            String endnyr = LocalDateTime.now().format(DateTimeFormatter.ISO_DATE);

            log.info("量化派-助贷模式报送贷款信息开始, newTime: {} , startnyr: {} , endnyr: {} ", LocalDateTime.now(), startnyr, endnyr);

            baiHangZhuDaiService.sendZhuDaiApplyToBaiHang(startnyr,endnyr);  //生产 助贷-贷款申请 报送T+1    暂时先不报送C1 因为百行还没有开放查询接口

            baiHangZhuDaiService.sendZhuDaiLoanToBaiHang(startnyr,endnyr);        //生产 助贷-放款信息 报送T+1

            baiHangZhuDaiService.sendZhuDaiRepaymentToBaiHang(startnyr,endnyr);      //生产 助贷-还款&逾期信息  报送T+1

            log.info("量化派-助贷模式报送贷款信息息结束, endTime: {}, 耗时: {} ", LocalDateTime.now(), stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
        }
    }


    public Boolean increment(){
        Long increment = redisTemplate.opsForValue().increment(Constant.QG_ZHU_DAI_REPORT_LOCK_KEY, 1);
        return increment <= 1;
    }

}
