package cn.quantgroup.report.service.http;

import java.util.Map;

/**
 * @author guowei.wei
 * @time 2018-05-30 10:11
 */
public interface IHttpService {

    /**
     * Http Get
     *
     * @param uri
     * @return
     */
    String get(String uri);
    Map<String,String> getMap(String uri,String interfaceType, Object... args);
    String get(String uri, int timeOut);

    <T> T get(String uri, Class<T> classOfT);

    /**
     * Http Get
     *
     * @param uri
     * @param parameters
     * @return
     */
    String get(String uri, Map<String, String> parameters);

    /**
     * Http Get
     *
     * @param uri
     * @param headers
     * @param parameters
     * @return
     */
    String get(String uri, Map<String, String> headers, Map<String, String> parameters);

    /**
     * Http GetMap
     * @param uri
     * @param headers
     * @param parameters
     * @param interfaceType
     * @return
     */
    Map<String,String> getMap(String uri, Map<String, String> headers, Map<String, String> parameters,String interfaceType, Object... args);
    /**
     * Http Post
     *
     * @param uri
     * @return
     */
    String post(String uri);

    /**
     * Http Post
     *
     * @param uri
     * @param parameters
     * @return
     */
    String post(String uri, Map<String, String> parameters);

    /**
     * Http Post
     *
     * @param uri
     * @param headers
     * @param parameters
     * @return
     */
    String post(String uri, Map<String, String> headers, Map<String, String> parameters);
    public String post(String uri, Map<String, String> parameters, boolean isLog);
    
    public String postCommon(String uri, Map<String, String> headers, String jsonParams, Map<String, String> responseHeaders, String interfaceType) ;
    public Map<String,String> postJsonMap(String uri, Map<String, String> headers, String jsonParams,Map<String, String> responseHeaders,String interfaceType, Object... args) ;
    public String postObj(String uri, Map<String, Object> parameters);
    public String postObj(String uri, Map<String, String> headers, Map<String, Object> parameters) ;
    /**
     * 不需要返回结果的请求
     * @param url
     * @param parameters
     * @return
     */
    public int postNoResponse(String url, Map<String, String> parameters);
    public void exceptionAlarm(String interfaceType,String uri,String exception, Object... args);
    public void timeOutAndCodeAlarm(long startTime,long endTime,String interfaceType,String uri,String statusCode,String reason, Object... args);

    public void alarm(long startTime,long endTime,String interfaceType,String uri,String statusCode,String reason, Object... args);

    String postCommon(String uri, Map<String, String> headers, String json);
    String postCommonAllResult(String uri, Map<String, String> headers, String json);
    String postCommonAllResultSoap(String uri, Map<String, String> headers, String json);

    String postBaiHang(String uri, Map<String, String> headers, String json);
}
