package cn.quantgroup.report.job;

import cn.quantgroup.report.constant.BaiHangHistoryConstant;
import cn.quantgroup.report.service.baihang.constant.Constant;
import cn.quantgroup.report.utils.dingtalk.DingTalk;
import com.google.common.base.Stopwatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;


/**
 * -----------------------------------------------------------------------------<br>
 * 描述: 量化派助贷模式(非循环贷) -
 *      (贷款申请/放款/还款(逾期)三类实时批量数据)-To百行报送<br>
 *     每日凌晨5点报送 <br>
 * 作者：yanhui.Hao <br>
 * 时间：2019.10.25 <br>
 * 授权: (C) Copyright (c) 2017 <br>
 * 公司: 北京众信利民信息技术有限公司 <br>
 * -----------------------------------------------------------------------------
 */
@Component
public class SynLoanInfoHistoryTask {

    private static final Logger log = LoggerFactory.getLogger(SynLoanInfoHistoryTask.class);

    @Autowired
    private RedisTemplate<String,String> redisTemplate;


    @Autowired
    private JdbcTemplate xyqbHistoryJdbcTemplate;

    @Autowired
    private DingTalk dingTalk;

    private static AtomicBoolean SYN_Stop = new AtomicBoolean(false);

    @Async
    /*@Scheduled(cron = "0 0 05 * * ?")*/  //2019.11.15 15:25
    public void startHistoryDateCopy(){
        if(increment()){
            redisTemplate.expire(Constant.XYQB_HISTORY_DAI_REPORT_LOCK_KEY, 10, TimeUnit.SECONDS);

            Stopwatch stopwatch = Stopwatch.createStarted();
            //yyyy-MM-dd
            //String startnyr = LocalDateTime.now().plusDays(-1).format(DateTimeFormatter.ISO_DATE);
            //String endnyr = LocalDateTime.now().format(DateTimeFormatter.ISO_DATE);

            log.info("量化派-同步表xyqb_i_loan_application_manifest_history数据开始, newTime: {} ", LocalDateTime.now());

            //将xyqb_i_loan_application_manifest_history表的数据，同步到xyqb_i_repayment_plan_bak
            //syn_history_by_CreatedAt();

            //将xyqb_i_repayment_plan表的数据，同步到xyqb_i_loan_a_m_history_bak
            //syn_plan_by_CreatedAt();

            syn_historyAndplan_by_id();

            ////syn_history_p2p_bak();
            ////syn_plan_p2p_bak();

            log.info("量化派-同步表xyqb_i_loan_application_manifest_history数据结束, endTime: {}, 耗时: {} ", LocalDateTime.now(), stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
        }
    }


    private Boolean increment(){
        Long increment = redisTemplate.opsForValue().increment(Constant.XYQB_HISTORY_DAI_REPORT_LOCK_KEY, 1);
        return increment <= 1;
    }


    public void syn_history_by_CreatedAt(){
        LocalDateTime erlyDate = LocalDateTime.parse("2016-08-23T00:00:00");//created_at=2016-08-23T16:29:10  updated_at=2016-08-23 16:34:43
        LocalDateTime endDate = LocalDateTime.parse("2020-06-02T00:00:00");//
        int counter = 0;
        while (true) {
            Stopwatch startwatch = Stopwatch.createStarted();

            if (SYN_Stop.get()) {
                log.error("同步xyqb_i_loan_application_manifest_history数据查询STOP, D3_Stop: {} , endTime: {} ", SYN_Stop.get(), erlyDate.plusDays(counter).format(DateTimeFormatter.ISO_DATE));
                break;
            }
            counter++;
            if (erlyDate.plusDays(counter).compareTo(endDate) > 0) {
                break;
            }

            String starTime = erlyDate.plusDays(counter - 1).format(DateTimeFormatter.ISO_DATE);
            String endTime = erlyDate.plusDays(counter).format(DateTimeFormatter.ISO_DATE);
            try {
                String tmp_sql = BaiHangHistoryConstant.SQL_COMMONE_TEMPLATE_HISTORY;
                tmp_sql = tmp_sql.replace("##STARTTIME##",starTime);
                tmp_sql = tmp_sql.replace("##ENDTIME##",endTime);

                int upCount = xyqbHistoryJdbcTemplate.update(tmp_sql);
                log.info("同步xyqb_i_loan_application_manifest_history数据结束,startTime: {} , 耗时:{} , updateCount: {} ", starTime, startwatch.stop().elapsed(TimeUnit.MILLISECONDS)+".ms", upCount);

            }catch (Exception e){
                log.error("同步xyqb_i_loan_application_manifest_history数据异常, startTime: {} , endTime: {} , counter: {} ", starTime, endTime,counter, e);
            }
        }
    }


    public void syn_plan_by_CreatedAt(){
        LocalDateTime erlyDate = LocalDateTime.parse("2016-08-23T00:00:00");//created_at=2016-08-23T16:29:10  updated_at=2016-08-23 16:34:43
        LocalDateTime endDate = LocalDateTime.parse("2020-06-02T00:00:00");//
        int counter = 0;
        while (true) {
            Stopwatch startwatch = Stopwatch.createStarted();

            if (SYN_Stop.get()) {
                log.error("同步xyqb_i_repayment_plan数据查询STOP, D3_Stop: {} , endTime: {} ", SYN_Stop.get(), erlyDate.plusDays(counter).format(DateTimeFormatter.ISO_DATE));
                break;
            }
            counter++;
            if (erlyDate.plusDays(counter).compareTo(endDate) > 0) {
                break;
            }

            String starTime = erlyDate.plusDays(counter - 1).format(DateTimeFormatter.ISO_DATE);
            String endTime = erlyDate.plusDays(counter).format(DateTimeFormatter.ISO_DATE);
            try {
                String tmp_sql = BaiHangHistoryConstant.SQL_COMMONE_TEMPLATE_PLAN;
                tmp_sql = tmp_sql.replace("##STARTTIME##",starTime);
                tmp_sql = tmp_sql.replace("##ENDTIME##",endTime);

                int upCount = xyqbHistoryJdbcTemplate.update(tmp_sql);
                log.info("同步xyqb_i_repayment_plan数据结束,startTime: {} , 耗时:{} , updateCount: {} ", starTime, startwatch.stop().elapsed(TimeUnit.MILLISECONDS)+".ms", upCount);

            }catch (Exception e){
                log.error("同步xyqb_i_repayment_plan数据异常, startTime: {} , endTime: {} , counter: {} ", starTime, endTime,counter, e);
            }
        }
    }


    private boolean syn_history_by_id(long bakMaxId,long newMaxId){
        String count_sql = BaiHangHistoryConstant.SQL_COMMONE_TEMPLATE_HISTORY_SYN_COUNT;
        count_sql = count_sql.replace("##BAKMAXID##",""+bakMaxId);
        count_sql = count_sql.replace("##NEWMAXID##",""+newMaxId);//防止查询的过程中再增长
        Integer count = xyqbHistoryJdbcTemplate.queryForObject(count_sql,Integer.class);
        if(count==null){
            log.error("表xyqb_i_loan_application_manifest_history查询增量count为Null.");
            dingTalk.talk("Warn","同步[借款清单]数据失败","查询增量count为Null,请尽快处理!"+" bakMaxId: "+bakMaxId+", newMaxId: "+newMaxId);
            dingTalk.talk_ToUser("借款清单同步失败", "同步[借款清单]表查询增量count为Null,停止T+1报送！发现问题，请及时处理！");
            return false;
        }

        //小于2万条，可以commit
        if(count.intValue() <= BaiHangHistoryConstant.MAX_COMMIT_COUT){
            Stopwatch startwatch = Stopwatch.createStarted();
            String inset_sql = BaiHangHistoryConstant.SQL_COMMONE_TEMPLATE_HISTORY_SYN_DATA;
            inset_sql = inset_sql.replace("##STARTID##",""+bakMaxId);

            int update = xyqbHistoryJdbcTemplate.update(inset_sql);
            log.info("增量同步xyqb_i_loan_application_manifest_history表结束, bakMaxId: {} , count: {} , 插入条数: {} , 耗时: {} ", bakMaxId, count, update, startwatch.stop().elapsed(TimeUnit.MILLISECONDS)+".ms");
            dingTalk.talk("Info","同步[借款清单]数据成功","实际条数: "+update +", bakMaxId: "+bakMaxId+", newMaxId: "+newMaxId);
            return true;
        }else{
        //大于2万条会报事务太长，需要分页插入
            int id_limit_count = (int) (newMaxId - bakMaxId);
            int page = id_limit_count / BaiHangHistoryConstant.MAX_COMMIT_COUT;
            int mode = id_limit_count % BaiHangHistoryConstant.MAX_COMMIT_COUT;
            if(mode!=0){
                page = page+1;
            }

            int totalUpdate = 0;
            for (int p=0 ; p < page; p++){
                Stopwatch startwatch = Stopwatch.createStarted();
                long startId = bakMaxId + p * BaiHangHistoryConstant.MAX_COMMIT_COUT;
                long endId = bakMaxId + (p+1) * BaiHangHistoryConstant.MAX_COMMIT_COUT;
                if( endId > newMaxId){
                    endId = newMaxId;
                }
                String tmpInsertSql = BaiHangHistoryConstant.SQL_COMMONE_TEMPLATE_HISTORY_SYN_DATA;
                tmpInsertSql = tmpInsertSql.replace("##STARTID##",""+startId);
                tmpInsertSql = tmpInsertSql + (" AND b.id <="+endId+" ;");

                int update = xyqbHistoryJdbcTemplate.update(tmpInsertSql);

                totalUpdate+=update;
                log.info("增量同步xyqb_i_loan_application_manifest_history表页数page["+p+"], startId: {} , endId: {} , 插入条数: {} , 耗时: {} ", startId, endId, update, startwatch.stop().elapsed(TimeUnit.MILLISECONDS)+".ms");
            }
            log.info("增量同步xyqb_i_loan_application_manifest_history表结束, bakMaxId: {} , newMaxId: {} , ID差: {} , count: {} , totalUpdate: {} , page: {} , mode: {} ", bakMaxId, newMaxId, (newMaxId-bakMaxId), count, totalUpdate, page, mode);

            if(totalUpdate==count){
                dingTalk.talk("Info","同步[借款清单]数据成功","实际条数(分页): "+totalUpdate+", bakMaxId: "+bakMaxId+", newMaxId: "+newMaxId);
                return true;
            }else{
                dingTalk.talk("Warn","同步[借款清单]数据失败","查询条数: "+count+",实际条数="+totalUpdate+", bakMaxId: "+bakMaxId+", newMaxId: "+newMaxId);
                dingTalk.talk_ToUser("借款清单同步异常", "同步[借款清单]数据失败,停止T+1报送！发现问题，请及时处理！");
                return false;
            }
        }
    }


    private boolean syn_plan_by_id(long bakMaxId,long newMaxId){
        String count_sql = BaiHangHistoryConstant.SQL_COMMONE_TEMPLATE_PLAN_SYN_COUNT;
        count_sql = count_sql.replace("##BAKMAXID##",""+bakMaxId);
        count_sql = count_sql.replace("##NEWMAXID##",""+newMaxId);//防止查询的过程中再增长
        Integer count = xyqbHistoryJdbcTemplate.queryForObject(count_sql,Integer.class);
        if(count==null){
            log.error("表xyqb_i_repayment_plan查询增量count为Null.");
            dingTalk.talk("Warn","同步[还款计划]数据失败","查询增量count为Null,请尽快处理!" + ", bakMaxId: "+bakMaxId+", newMaxId: "+newMaxId);
            dingTalk.talk_ToUser("还款计划同步失败", "同步[还款计划]表查询增量count为Null,停止T+1报送！发现问题，请及时处理！");
            return false;
        }

        //小于2万条，可以commit
        if(count.intValue() <= BaiHangHistoryConstant.MAX_COMMIT_COUT){
            Stopwatch startwatch = Stopwatch.createStarted();
            String inset_sql = BaiHangHistoryConstant.SQL_COMMONE_TEMPLATE_PLAN_SYN_DATA;
            inset_sql = inset_sql.replace("##STARTID##",""+bakMaxId);

            int update = xyqbHistoryJdbcTemplate.update(inset_sql);
            log.info("增量同步xyqb_i_repayment_plan表结束, bakMaxId: {} , count: {} , 插入条数: {} , 耗时: {} ", bakMaxId, count, update, startwatch.stop().elapsed(TimeUnit.MILLISECONDS)+".ms");
            dingTalk.talk("Info","同步[还款计划]数据成功","实际条数: "+update +", bakMaxId: "+bakMaxId+", newMaxId: "+newMaxId);
            return true;
        }else{
            //大于2万条会报事务太长，需要分页插入
            //xyqb_i_repayment_plan表目前发现有24期的，也就是说xyqb_i_loan_a_m_history_bak关联最大会出现24条
            int PLAN_MAX_COMMIT_COUT =  BaiHangHistoryConstant.MAX_COMMIT_COUT / 24;

            int id_limit_count = (int) (newMaxId - bakMaxId);
            int page = id_limit_count / PLAN_MAX_COMMIT_COUT;
            int mode = id_limit_count % PLAN_MAX_COMMIT_COUT;
            if(mode!=0){
                page = page+1;
            }

            int totalUpdate = 0;
            for (int p=0 ; p < page; p++){
                Stopwatch startwatch = Stopwatch.createStarted();
                long startId = bakMaxId + p * PLAN_MAX_COMMIT_COUT;
                long endId = bakMaxId + (p+1) * PLAN_MAX_COMMIT_COUT;
                if( endId > newMaxId){
                    endId = newMaxId;
                }
                String tmpInsertSql = BaiHangHistoryConstant.SQL_COMMONE_TEMPLATE_PLAN_SYN_DATA;
                tmpInsertSql = tmpInsertSql.replace("##STARTID##",""+startId);
                tmpInsertSql = tmpInsertSql + (" AND b.id <="+endId+" ;");

                int update = xyqbHistoryJdbcTemplate.update(tmpInsertSql);

                totalUpdate+=update;
                log.info("增量同步xyqb_i_repayment_plan表页数page["+p+"], startId: {} , endId: {} , 插入条数: {} , 耗时: {} ", startId, endId, update, startwatch.stop().elapsed(TimeUnit.MILLISECONDS)+".ms");
            }
            log.info("增量同步xyqb_i_repayment_plan表结束, bakMaxId: {} , newMaxId: {} , ID差: {} , count: {} , totalUpdate: {} , page: {} , mode: {} ", bakMaxId, newMaxId, (newMaxId-bakMaxId), count, totalUpdate, page, mode);

            if(totalUpdate==count){
                dingTalk.talk("Info","同步[还款计划]数据成功","实际条数(分页): "+totalUpdate + ", bakMaxId: "+bakMaxId+", newMaxId: "+newMaxId);
                return true;
            }else{
                dingTalk.talk("Warn","同步[还款计划]数据失败","查询条数: "+count+",实际条数="+totalUpdate + ", bakMaxId: "+bakMaxId+", newMaxId: "+newMaxId);
                dingTalk.talk_ToUser("还款计划同步异常", "同步[还款计划]数据失败,停止T+1报送！发现问题，请及时处理！");
                return false;
            }


        }
    }

    public boolean syn_historyAndplan_by_id(){
        Stopwatch startwatch = Stopwatch.createStarted();
        try {
            String tmp_sql1 = BaiHangHistoryConstant.SQL_COMMONE_TEMPLATE_HISTORY_BAK_MAX_ID;
            Long bakMaxId = xyqbHistoryJdbcTemplate.queryForObject(tmp_sql1,Long.class);

            String tmp_sql2 = BaiHangHistoryConstant.SQL_COMMONE_TEMPLATE_HISTORY_MAX_ID;
            Long newMaxId = xyqbHistoryJdbcTemplate.queryForObject(tmp_sql2,Long.class);

            //2019.11.15 13:37  bakMaxId: 1857710 , newMaxId: 13732716 , count: 1062175 , 差:11875006 , 总插入条数: 1062174 , page: 594
            //bakMaxId = 1857710L;
            //newMaxId = 13732716L;

            if(bakMaxId!=null && bakMaxId.longValue() >= 0L && newMaxId!=null && newMaxId.longValue() >= 0L){

                //同步到xyqb_i_loan_a_m_history_bak表-------------------------------
               boolean table_history = syn_history_by_id(bakMaxId.longValue(), newMaxId.longValue());
               if(table_history){
                   //同步到xyqb_i_repayment_plan_bak表
                  boolean table_plan = syn_plan_by_id(bakMaxId.longValue(), newMaxId.longValue());
                   if(table_plan){
                       log.info("ALL增量同步history&plan表数据结束, nowTime: {} ", LocalDateTime.now(), startwatch.stop().elapsed(TimeUnit.MILLISECONDS)+".ms");
                       return true;
                   }else{
                       log.error("All增量同步[xyqb_i_repayment_plan_bak]表数据失败,请尽快处理! nowTime: {} , bakMaxId: {} , newMaxId: {} ",LocalDateTime.now(), bakMaxId, newMaxId);
                       ////dingTalk.talk("Warn","同步[还款计划]数据失败","同步xyqb_i_repayment_plan_bak表数据失败,请尽快处理! newMaxId:"+newMaxId+",newMaxId="+newMaxId);
                   }

               }else{
                   log.error("增量同步[xyqb_i_loan_a_m_history_bak]表数据失败,请尽快处理! nowTime: {} , bakMaxId: {} , newMaxId: {} ",LocalDateTime.now(), bakMaxId, newMaxId);
                   ////dingTalk.talk("Warn","同步[借款清单]数据失败","同步xyqb_i_loan_a_m_history_bak表数据失败,请尽快处理! newMaxId:"+newMaxId+",newMaxId="+newMaxId);
               }
               //-------------------------------

            }else {
                log.error("增量同步xyqb_i_repayment_plan数据-历史id为空,停止同步! nowTime: {} , bakMaxId: {} , newMaxId: {} ",LocalDateTime.now(), bakMaxId, newMaxId);
                dingTalk.talk("Warn","同步临时表数据失败","查询数据历史bakMaxId或newMaxId为空.");
                dingTalk.talk_ToUser("数据同步异常2", "查询数据历史bakMaxId或newMaxId为空,停止T+1报送！发现问题，请及时处理！");
            }
        }catch (Exception e){
            log.error("增量同步history和plan表数据异常, nowTime: {} ", LocalDateTime.now(), e);
            dingTalk.talk("Error","同步history和plan表数据异常",e);
            dingTalk.talk_ToUser("数据同步异常1", "同步history和plan表数据异常,停止T+1报送！发现问题，请及时处理！");
        }

        return false;
    }


    /**
     * 描述: 将xyqb_i_loan_application_manifest_history表的数据
     *      同步到xyqb_i_loan_a_m_history_p2p_bak表<br/>
     * 参数: []  <br/>
     * 返回值: boolean  <br/>
     * 创建人: yanhui.Hao  <br/>
     * 创建时间: 2019.12.17  <br/>
     */
    private void syn_history_p2p_bak(){
        LocalDateTime erlyDate = LocalDateTime.parse("2016-11-01T00:00:00");
        LocalDateTime endDate = LocalDateTime.parse("2019-01-01T00:00:00");
        int counter = 0;
        while (true) {
            Stopwatch startwatch = Stopwatch.createStarted();
            counter++;
            if (erlyDate.plusDays(counter).compareTo(endDate) > 0) {
                break;
            }

            String starTime = erlyDate.plusDays(counter - 1).format(DateTimeFormatter.ISO_DATE);
            String endTime = erlyDate.plusDays(counter).format(DateTimeFormatter.ISO_DATE);
            try {
                String tmp_sql = BaiHangHistoryConstant.SQL_TEMPLATE_HISTORY_P2P;
                tmp_sql = tmp_sql.replace("##STARTTIME##",starTime);
                tmp_sql = tmp_sql.replace("##ENDTIME##",endTime);

                int upCount = xyqbHistoryJdbcTemplate.update(tmp_sql);
                log.info("同步xyqb_i_loan_a_m_history_p2p_bak数据结束, startTime: {} , 耗时: {} , updateCount: {} ", starTime, startwatch.stop().elapsed(TimeUnit.MILLISECONDS)+".ms", upCount);

            }catch (Exception e){
                log.error("同步xyqb_i_loan_a_m_history_p2p_bak数据异常, startTime: {} , endTime: {} , counter: {} ", starTime, endTime,counter, e);
            }
        }
    }

    /**
     * 描述: 将xyqb_i_repayment_plan表的数据同步到xyqb_i_repayment_plan_p2p_bak表 <br/>
     * 参数: []  <br/>
     * 返回值: void  <br/>
     * 创建人: yanhui.Hao  <br/>
     * 创建时间: 2019.12.17  <br/>
     */
    private void syn_plan_p2p_bak(){
        LocalDateTime erlyDate = LocalDateTime.parse("2016-11-01T00:00:00");
        LocalDateTime endDate = LocalDateTime.parse("2019-10-25T00:00:00");
        int counter = 0;
        while (true) {
            Stopwatch startwatch = Stopwatch.createStarted();
            counter++;
            if (erlyDate.plusDays(counter).compareTo(endDate) > 0) {
                break;
            }

            String starTime = erlyDate.plusDays(counter - 1).format(DateTimeFormatter.ISO_DATE);
            String endTime = erlyDate.plusDays(counter).format(DateTimeFormatter.ISO_DATE);
            try {
                String tmp_sql = BaiHangHistoryConstant.SQL_TEMPLATE_PLAN_P2P;
                tmp_sql = tmp_sql.replace("##STARTTIME##",starTime);
                tmp_sql = tmp_sql.replace("##ENDTIME##",endTime);

                int upCount = xyqbHistoryJdbcTemplate.update(tmp_sql);
                log.info("同步xyqb_i_repayment_plan_p2p_bak数据结束, startTime: {} , 耗时: {} , updateCount: {} ", starTime, startwatch.stop().elapsed(TimeUnit.MILLISECONDS)+".ms", upCount);

            }catch (Exception e){
                log.error("同步xyqb_i_repayment_plan_p2p_bak数据异常, startTime: {} , endTime: {} , counter: {} ", starTime, endTime,counter, e);
            }
        }
    }



}
