package cn.quantgroup.report.mapper.baihang;

import cn.quantgroup.report.domain.baihang.ApplyLoanInfo;
import cn.quantgroup.report.domain.baihang.ApplyLoanInfoZhuDai;
import cn.quantgroup.report.domain.baihang.BaiHangThreeElements;
import cn.quantgroup.report.domain.baihang.BaiHangTimeRecord;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 贷款申请信息查询mapper
 *
 * @Author fengjunkai
 * @Date 2019-03-26 15:25
 */
@Repository
public interface ApplyLoanInfoMapper {

    //广达小贷-申请实时
    List<ApplyLoanInfo> findApplyLoanInfo();

    ApplyLoanInfo findApplyLoanInfoByThreeElements(BaiHangThreeElements baiHangThreeElements);

    //广达小贷-申请存量
    List<ApplyLoanInfo> findStockApplyLoanInfo();




    /**
     * 描述: 百行-助贷申请存量数据 <br/>
     * 参数:  日期 BaiHangTimeRecord: startTime和endsTime <br/>
     * 返回值:   <br/>
     * 创建人: yanhui.Hao  <br/>
     * 创建时间: 2019.10.23  <br/>
     */
    List<ApplyLoanInfoZhuDai> queryStockApplyLoanInfoZhuDai(BaiHangTimeRecord baiHangTimeRecord);


    /**
     * 描述: 1.1百行助贷-非联合贷 实时申请 <br/>
     * 参数:  日期 BaiHangTimeRecord: startTime和endsTime <br/>
     * 返回值:   <br/>
     * 创建人: yanhui.Hao  <br/>
     * 创建时间: 2019.10.28  <br/>
     */
    List<ApplyLoanInfoZhuDai> findRealTimeApplyLoanZhuDai();

    /**
     * 描述: 1.2百行助贷-联合贷 实时申请 <br/>
     * 参数:  日期 BaiHangTimeRecord: startTime和endsTime <br/>
     * 返回值:   <br/>
     * 创建人: yanhui.Hao  <br/>
     * 创建时间: 2019.10.28  <br/>
     */
    List<ApplyLoanInfoZhuDai> findRealTimeApplyLoanZhuDaiLh();


}
