package cn.quantgroup.report.config.web;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

/**
 * @Author fengjunkai
 */
@Configuration
public class WebMvcConfigure extends WebMvcConfigurerAdapter {

    @Value("${isDebug}")
    private Boolean isDebug;

    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor(new AuthHandlerInterceptorAdapter(isDebug))
                .addPathPatterns("/ex/**")
                .addPathPatterns("/manualtool/**")
                .addPathPatterns("/cache/**");
    }

}
