package cn.quantgroup.report.service.manualTool;


import cn.quantgroup.report.ApplicationContextHolder;
import cn.quantgroup.report.config.aop.DistributedLock;
import cn.quantgroup.report.config.aop.MonitorType;
import cn.quantgroup.report.domain.baihang.RepaymentLoanInfoVo;
import cn.quantgroup.report.mapper.baihang.LoanInfoMapper;
import cn.quantgroup.report.response.GlobalResponse;
import cn.quantgroup.report.service.CommonSuperService;
import cn.quantgroup.report.utils.*;
import cn.quantgroup.report.utils.commonutil.MD5Util;
import cn.quantgroup.report.config.aop.Monitor;
import cn.quantgroup.report.domain.baihang.LoanInfoVo;
import cn.quantgroup.report.mapper.master.RepaymentLoanInfoDbMapper;
import cn.quantgroup.report.utils.commonutil.AesCrypto;
import cn.quantgroup.report.utils.commonutil.Base64;
import cn.quantgroup.report.utils.commonutil.RSAEncrypt;
import cn.quantgroup.report.utils.http.HttpRequestUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * -----------------------------------------------------------------------------<br>
 * 描述: <br>
 * 作者: Administrator <br>
 * 时间: 2019.09.24 10:34 <br>
 * 授权: (C) Copyright (c) 2017 <br>
 * 公司: 北京众信利民信息技术有限公司 <br>
 * -----------------------------------------------------------------------------
 */
@Slf4j
@Service
public class ManualToolService implements CommonSuperService {

    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");

    @Autowired
    private RepaymentLoanInfoDbMapper repaymentLoanInfoDbMapper;

    @Autowired
    private LoanInfoMapper loanInfoMapper;

    //@Autowired
    //private PinTaiCreditScoreService pinTaiCreditScoreService;


    private ShellUtils executeCommand = null;
    private static final String P1_48MD5_01 = "120a97b4b73c440413933351a2db2512fc7698f157b5c60d";
    private static final String P1_48MD5_02 = "85b61d877f6ce41c4cc72413f6766ae6876405f06b607b02";
    private static final String P2_48MD5 = "d4893490905d534e6fc1512ba6619d14df8c312362589342";
    private static final String P3_48MD5 = "57971a003213360c6fa09f4b257d5eb5441ba97a5450aa63";

    private static String RSA_PRIVATEKEY = null;

    static {
        RSA_PRIVATEKEY = readRSAPrivateKey("/manualTool/rsa_private_key.pem");
    }


    @Monitor({MonitorType.EXCEPTION, MonitorType.FEE, MonitorType.HIT, MonitorType.RESULT})
    @DistributedLock
    public GlobalResponse sendBaiHangData(String p1, String p2, String p3, String p4, String p5, String secretKey, String isSend,String errorCode) {
        StringBuffer resultMsg = new StringBuffer();
        log.info("ManualToolService.sendBaiHangData Start>>>>>>");
        String base_path = "/home/quant_group/risk-datasource/data";
        String base_url = "http://172.20.1.92:9020/ex/re_send";

        if (StringUtils.isBlank(RSA_PRIVATEKEY)) {
            return new GlobalResponse("1012", "参数错误");
        }
        if (StringUtils.isBlank(secretKey)) {
            return new GlobalResponse("1012", "参数错误");
        }
        if (StringUtils.isAnyBlank(p1, p2, p3)) {
            return new GlobalResponse("1012", "参数错误");
        }

        try {
            String aes_key = RSAEncrypt.decrypt(secretKey, RSA_PRIVATEKEY);//"!QAZ@WSX3edc4rfv"
            //p1:host, p2:name, p3:pass, p4:forword, p5:date, p6:根路径
            //p1,p2,p3 做AES和base64加密
            //p1为127.0.0.1时p4必须是ip，且和172.20.1.92的MDd一致校验
            p1 = AesCrypto.decrypt(Base64.decode(p1.trim()), aes_key).trim();
            if (!(MD5Util.verify48Md5(p1, P1_48MD5_01) || MD5Util.verify48Md5(p1, P1_48MD5_02))) {
                return new GlobalResponse("1012", "参数错误");
            }
            p2 = AesCrypto.decrypt(Base64.decode(p2.trim()), aes_key).trim();
            if (!MD5Util.verify48Md5(p2, P2_48MD5)) {
                return new GlobalResponse("1012", "参数错误");
            }
            p3 = AesCrypto.decrypt(Base64.decode(p3.trim()), aes_key).trim();
            if (!MD5Util.verify48Md5(p3, P3_48MD5)) {
                return new GlobalResponse("1012", "参数错误");
            }
            //不是127.0.0.1时,p4不能为空
            if (MD5Util.verify48Md5(p1, P1_48MD5_01)) {
                if (StringUtils.isBlank(p4)) {
                    return new GlobalResponse("1012", "参数错误");
                } else {
                    p4 = AesCrypto.decrypt(Base64.decode(p4.trim()), aes_key).trim();
                }
            }
        } catch (Exception e) {
            log.error("参数解析错误.");
            return new GlobalResponse("1012", "参数错误");
        }

        if (StringUtils.isEmpty(p5)) {
            p5 = sdf.format(System.currentTimeMillis());
        }
        boolean httpSend = false;
        if (StringUtils.isNotEmpty(isSend) && "true".equals(isSend)) {
            httpSend = true;
        }

        if (StringUtils.isEmpty(errorCode)) {
            /*"errorCode":"D2_009"
            "errorCode":"D3_035"
            "errorCode":"D3_036"
            "errorCode":"D3_041"
            "errorCode":"G_001"*/
            errorCode = "D3_035";
        }

        //还款信息D3,opCode:A>>>M,多条信息就回车存多行,中间不用逗号
        String json_hk_D3 = "";
        //放款信息D2,多条信息就回车存多行,中间不用逗号
        String json_fk_D2 = "";

        try {
            if (initShellConnect(executeCommand, p1, p2, p3)) {
                //获取远程日志中reqID
                String jsaonResult = getReqIdByRemoteLog(executeCommand, p4, p5, base_path);
                if (StringUtils.isNotBlank(jsaonResult)) {
                    List<String> reqIDList = new ArrayList<>();
                    List<String> loanIdList = new ArrayList<String>();

                    JSONArray jsonArray = JSONArray.parseArray(jsaonResult);
                    resultMsg.append("getReqIdByRemoteLog size=" + (jsonArray!=null ? jsonArray.size() : "null") );
                    resultMsg.append("|");
                    for (int i = 0; i < jsonArray.size(); i++) {
                        JSONObject jsonObj = jsonArray.getJSONObject(i);
                        boolean flag = false;
                        try{
                            JSONArray errorDetailArry = jsonObj.getJSONArray("errorDetail");
                            if(errorDetailArry!=null && errorDetailArry.size()>0){
                                JSONObject error = errorDetailArry.getJSONObject(0);
                                if(error.get("errorCode")!=null && errorCode.contains(error.getString("errorCode"))){ //D3_035,D3_036
                                    flag = true;
                                    reqIDList.add(jsonObj.getString("reqID"));
                                }
                            }
                        }catch (Exception e){
                            log.error("deal with reqIdByRemoteLog error!",e);
                        }finally {
                            if(!flag){
                                resultMsg.append("\n##OTHER ERRORCODE:" + jsonObj.toJSONString()+"##");
                                log.info("ManualToolService OTHER ERRORCODE:" + jsonObj.toJSONString());
                            }
                        }
                    }
                    resultMsg.append("\n|reqIDList size=" + reqIDList.size() );

                    if (reqIDList.size() > 0) {//还款
                        String[] recordIdArray = reqIDList.toArray(new String[reqIDList.size()]);
                        log.info("RepaymentLoanInfoDbMapper getReqIdByRemoteLog reqID to D3:" + JSON.toJSONString(recordIdArray));
                        List<RepaymentLoanInfoVo> repaymentLoanInfoList = repaymentLoanInfoDbMapper.findByRecordId(recordIdArray);

                        for (RepaymentLoanInfoVo bean : repaymentLoanInfoList) {
                            bean.setOpCode("M");
                            if (bean.getOverdueStatus() == null) {
                                bean.setOverdueStatus("");
                            }
                            loanIdList.add(bean.getLoanId());
                        }
                        resultMsg.append("|");
                        resultMsg.append("D3 List size=" + repaymentLoanInfoList.size());
                        json_hk_D3 = JSONArray.toJSONString(repaymentLoanInfoList);
                        json_hk_D3 = json_hk_D3.replace("[", "");
                        json_hk_D3 = json_hk_D3.replace("]", "");
                        json_hk_D3 = json_hk_D3.replace("},", "}\n");
                    }


                    if (loanIdList.size() > 0) {
                        List<LoanInfoVo> loanInfoVoList = new ArrayList<LoanInfoVo>();
                        String[] orderNoArray = loanIdList.toArray(new String[loanIdList.size()]);
                        List<String> loanApplicationHistoryIdList = loanInfoMapper.findHistoryIdByOrderNo(orderNoArray);

                        for (String historyId : loanApplicationHistoryIdList) {
                            LoanInfoVo infoVo = loanInfoMapper.findLoanInfoVoByHistoryId(historyId);
                            loanInfoVoList.add(infoVo);
                        }
                        resultMsg.append("|");
                        resultMsg.append("D2 List size=" + loanInfoVoList.size());
                        if (loanInfoVoList.size() > 0) {
                            json_fk_D2 = JSONArray.toJSONString(loanInfoVoList);
                            json_fk_D2 = json_fk_D2.replace("[", "");
                            json_fk_D2 = json_fk_D2.replace("]", "");
                            json_fk_D2 = json_fk_D2.replace("},", "}\n");
                        }
                    }


                    if (StringUtils.isNotBlank(json_fk_D2)) {
                        //ReadOrWriteTxt.writeTxt(base_path+"/baihang/D2/data.txt",json_fk_D2);
                        String cmd_res = writeJsonFileOnRemote(executeCommand, base_path + "/baihang/D2/data.txt", json_fk_D2);
                        log.info("RepaymentLoanInfoDbMapper.sendBaiHangData writ remote file ...baihang/D2/data.txt END,r:" + cmd_res);
                        resultMsg.append("|");
                        resultMsg.append("write D2 end.");
                        if (httpSend) {
                            Map<String, Object> params = new HashMap<String, Object>();
                            params.put("key", "b5140fb2-2c85-4b5a-abcf-3e97528014db");
                            String http_res = HttpRequestUtil.mySelfDoGet(base_url + "/mainLoanInfoSend", params);
                            log.info("RepaymentLoanInfoDbMapper.sendBaiHangData http request D2>>>mainLoanInfoSend END,r:" + http_res);
                            resultMsg.append("|");
                            resultMsg.append(http_res);
                        }
                    }else{
                        resultMsg.append("|");
                        resultMsg.append("放款D2 json_fk_D2 isEmpty.");
                    }
                    if (StringUtils.isNotBlank(json_hk_D3)) {
                        //ReadOrWriteTxt.writeTxt(base_path+"/baihang/D3/data.txt",json_hk_D3);
                        String cmd_res = writeJsonFileOnRemote(executeCommand, base_path + "/baihang/D3/data.txt", json_hk_D3);
                        log.info("RepaymentLoanInfoDbMapper.sendBaiHangData writ remote file ...baihang/D3/data.txt END,r:" + cmd_res);
                        resultMsg.append("|");
                        resultMsg.append("write D3 end.");
                        if (httpSend) {
                            Map<String, Object> params = new HashMap<String, Object>();
                            params.put("key", "b5140fb2-2c85-4b5a-abcf-3e97528014db");
                            String http_res = HttpRequestUtil.mySelfDoGet(base_url + "/mainRepaymentLoanInfo", params);
                            log.info("RepaymentLoanInfoDbMapper.sendBaiHangData http request D3>>>mainRepaymentLoanInfo END,r:" + http_res);
                            resultMsg.append("|");
                            resultMsg.append(http_res);
                        }

                    }else {
                        resultMsg.append("|");
                        resultMsg.append("还款D3 json_hk_D3 isEmpty.");
                    }
                    //退出登录
                    List<String> cmdList = new ArrayList<String>();
                    cmdList.add("echo '++CMD LAST++' \n\r");
                    cmdList.add("exit \n\r");
                    cmdList.add("exit \n\r");
                    executeCommand.execute(cmdList, false);

                    return GlobalResponse.generate(resultMsg);
                } else {
                    log.info("RepaymentLoanInfoDbMapper.getReqIdByRemoteLog redult isEmpty.");
                    return GlobalResponse.generate("百行征信手动报送,获取日志为空");
                }
            }
        } catch (Exception e) {
            log.error("ManualToolService.sendBaiHangData Error,", e);
            return new GlobalResponse("1001", "百行征信手动报送异常," + e.getMessage());
        } finally {
            if (executeCommand != null) {
                executeCommand.ioclose();
                executeCommand.closeChannelShell();
                executeCommand = null;
            }
            try {
                ShellUtils.LOCK.unlock();
            } catch (IllegalMonitorStateException e) {
                log.warn("锁已释放,无需重复释放." + e);
            }
        }
        log.info("ManualToolService.sendBaiHangData All END<<<<<<");
        return new GlobalResponse("1000", "百行征信手动报送失败");
    }

    /**
     * 描述: 初始化 ShellUtils  <br/>
     * 参数: [p1:host, p2:name, p3:pass]  <br/>
     * 返回值: java.lang.String  <br/>
     * 创建人: yanhui.Hao  <br/>
     * 创建时间: 2019.09.25  <br/>
     */
    private boolean initShellConnect(ShellUtils executeCommand, String p1, String p2, String p3) {
        try {
            ShellUtils.LOCK.lock();
            if (executeCommand == null) {
                executeCommand = new ShellUtils(p1, p2, p3);
                if (executeCommand.login()) {
                    executeCommand.initChannel(ShellUtils.CHANNEL_TYPE_SHELL);
                    this.executeCommand = executeCommand;
                    return true;
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
            log.error("ManualToolService.initShellConnect Error," + e.getMessage());
        } finally {
            ShellUtils.LOCK.unlock();
        }
        return false;
    }

    /**
     * 描述: 获取远程服务器的日志信息  <br/>
     * 参数: [p4:forword, p5:date, p6:根路径]  <br/>
     * 返回值: java.lang.String  <br/>
     * 创建人: yanhui.Hao  <br/>
     * 创建时间: 2019.09.25  <br/>
     */
    private String getReqIdByRemoteLog(ShellUtils executeCommand, String p4, String p5, String p6) {
        String result = null;
        try {
            ShellUtils.LOCK.lock();
            if (executeCommand != null) {
                log.info(".......>>>>start deal with cmd:1 outputStream execute Start.......");
                List<String> cmdList = new ArrayList<>();
                cmdList.add("ssh " + p4 + " \n\r");
                cmdList.add("/sbin/ifconfig  |grep \"inet addr\" \n\r");
                cmdList.add("cd " + p6 + " \n\r");
                cmdList.add("sh download_baihang_error_log.sh " + Integer.parseInt(p5) + " \n\r");
                executeCommand.execute(cmdList, true);
                //打印执行结果
                executeCommand.outCmdResult();
                log.info(".......>>>>start deal with cmd:1 inputStream getResult End.......");
                ShellUtils.LOCK.unlock();

                ShellUtils.LOCK.lock();
                cmdList = new ArrayList<>();
                log.info(".......>>>>start deal with cmd:2 outputStream execute Start.......");
                cmdList.add("cd " + p6 + "/" + p5 + " \n\r");
                cmdList.add("cat *_logicerror.log \n\r");
                executeCommand.execute(cmdList, true);
                //获取reqID结果
                result = executeCommand.getResult();
                log.info(".......>>>>start deal with cmd:2 inputStream getResult End.......result:\n" + result);
                ShellUtils.LOCK.unlock();
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            try {
                ShellUtils.LOCK.unlock();
            } catch (IllegalMonitorStateException e) {
                log.warn("锁已释放,无需重复释放." + e);
            }
        }
        return result;
    }


    /**
     * 描述: 往远程服务器写文件 <br/>
     * 参数: [p4:forword, p5:date, p6:根路径]  <br/>
     * 返回值: java.lang.String  <br/>
     * 创建人: yanhui.Hao  <br/>
     * 创建时间: 2019.09.25  <br/>
     */
    private String writeJsonFileOnRemote(ShellUtils executeCommand, String filePath, String context) {
        String result = null;
        try {
            ShellUtils.LOCK.lock();
            if (executeCommand != null) {
                log.info(".......>>>>start deal with cmd:3 outputStream execute Start.......");
                List<String> cmdList = new ArrayList<>();
                String path = filePath.substring(0, filePath.lastIndexOf("/"));
                cmdList.add("cd " + path + " \n\r");
                cmdList.add("pwd \n\r");
                cmdList.add("printf '" + context + "' >./data.txt \n\r");
                cmdList.add("cat data.txt |wc -l \n\r");
                executeCommand.execute(cmdList, true);
                //打印执行结果
                executeCommand.outCmdResult();
                log.info(".......>>>>start deal with cmd:3 inputStream getResult End.......");
                result = "写入成功:" + filePath;
                ShellUtils.LOCK.unlock();
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            try {
                ShellUtils.LOCK.unlock();
            } catch (IllegalMonitorStateException e) {
                log.warn("锁已释放,无需重复释放." + e);
            }
        }
        return result;
    }

    /**
     * 描述: 读取私钥 <br/>
     * 参数: [fileName]  <br/>
     * 返回值: java.lang.String  <br/>
     * 创建人: yanhui.Hao  <br/>
     * 创建时间: 2019.09.26  <br/>
     */
    private static String readRSAPrivateKey(String fileName) {
        InputStream isr = ManualToolService.class.getResourceAsStream(fileName);
        BufferedReader br = new BufferedReader(new InputStreamReader(isr));
        StringBuilder builder = new StringBuilder();
        try {
            boolean inKey = false;
            for (String line = br.readLine(); line != null; line = br.readLine()) {
                line = line.trim();
                if (!inKey) {
                    if (line.contains("BEGIN PUBLIC KEY")) {
                        inKey = true;
                    }
                    continue;
                } else {
                    if (line.contains("END PUBLIC KEY")) {
                        inKey = false;
                        break;
                    }
                    builder.append(line);
                }
            }
            br.close();
            isr.close();
        } catch (IOException e) {
            e.printStackTrace();
            log.error("读取:" + fileName + "异常", e);
        }
        return builder.toString();
    }



    @Monitor({MonitorType.EXCEPTION, MonitorType.FEE, MonitorType.HIT, MonitorType.RESULT})
    @DistributedLock
    public GlobalResponse buildLoanInfoD2(String jsonFile) {
        StringBuffer resultMsg = new StringBuffer();
        if(StringUtils.isEmpty(jsonFile)){
            return new GlobalResponse("1000", "百行征信手动报送失败");
        }
        //jsonFile = "C:\\Users\\Administrator\\Desktop\\百行历史数据报送实时放款数据D2(历史百行征信报送).json";
        String context = ReadOrWriteTxt.readTxt(jsonFile);

        JSONObject jSONObject = JSON.parseObject(context);
        JSONArray jsonArray = jSONObject.getJSONArray("RECORDS");
        for (int i = 0; i < jsonArray.size() ; i++) {
            JSONObject object = jsonArray.getJSONObject(i);
            Object reqID = object.get("reqID");
            if(reqID!=null){
                List<String> list = loanInfoMapper.findTargetRepaymentDayList(reqID.toString());
                if(list!=null && list.size()>0){
                    String[] strArry = list.toArray(new String[list.size()]);
                    object.put("targetRepayDateList",strArry);
                }else{
                    object.put("targetRepayDateList",new String[0]);
                }
            }
        }

        String json_fk_D2 = JSONArray.toJSONString(jsonArray);
        //json_fk_D2 = json_fk_D2.replace("[", "");
        //json_fk_D2 = json_fk_D2.replace("]", "");
        json_fk_D2 = json_fk_D2.replace("},", "}\n");


        String writeName = jsonFile.substring(0,jsonFile.lastIndexOf("\\"))+"\\d2.txt";
        ReadOrWriteTxt.writeTxt(writeName,json_fk_D2);
        System.out.print("放款信息 D2 写入文件OK:"+writeName);
        return new GlobalResponse("0", "放款信息 D2 写入文件OK:"+writeName);
    }


    @Monitor({MonitorType.EXCEPTION, MonitorType.FEE, MonitorType.HIT, MonitorType.RESULT})
    @DistributedLock
    public GlobalResponse testPTCreditScoreV1(String filePath,String p3,String secretKey) {
        StringBuffer resultMsg = new StringBuffer();
        if (StringUtils.isAnyBlank(RSA_PRIVATEKEY,filePath,p3,secretKey)) {
            return new GlobalResponse("1012", "参数错误");
        }
        try {
            String aes_key = RSAEncrypt.decrypt(secretKey, RSA_PRIVATEKEY);//"!QAZ@WSX3edc4rfv"
            String tmp = AesCrypto.decrypt(Base64.decode(p3.trim()), aes_key).trim();
            if (!MD5Util.verify48Md5(tmp, P3_48MD5)) {
                return new GlobalResponse("1012", "参数错误");
            }
        } catch (Exception e) {
            log.error("参数解析错误.");
            return new GlobalResponse("1012", "参数错误");
        }
        long start = System.currentTimeMillis();
        List<String> contextList = ReadOrWriteTxt.readTxtList(filePath);
        StringBuffer resultBuff = new StringBuffer();
        if(contextList!=null && contextList.size()>0){
            for(int i =0; i<contextList.size(); i++){
                long startUtc = System.currentTimeMillis();
                String context = contextList.get(i);
                String value = "";
                try{
                    //唯一ID|name|id_no|phone
                    String[] strArry = context.split("[|]");
                    String transactionId = IdUtils.getUuid();
                    CommonSuperService superService = ApplicationContextHolder.getBean("pinTaiCreditScoreService");
                    Object resultObject = superService.getClass().getMethod("pinTaiCreditScoreV1Query", String.class, String.class, String.class, String.class, String.class, boolean.class)
                            .invoke(superService, transactionId, strArry[0], strArry[1],strArry[2],strArry[3], false);
                    GlobalResponse globalResponse = (GlobalResponse) resultObject;
                   //// GlobalResponse globalResponse = pinTaiCreditScoreService.pinTaiCreditScoreV1Query(transactionId, strArry[0], strArry[1], strArry[2], strArry[3], false);
                    Object object = globalResponse.getBody();

                    if(object!=null){
                        JSONObject jsonObject = ((JSONObject) object).getJSONObject("content");
                        if(jsonObject!=null && jsonObject.containsKey("S2070101")){
                            value = jsonObject.getString("S2070101");
                        }
                    }
                    resultBuff.append(context.replace("|","\t"));
                    resultBuff.append("\t");
                    resultBuff.append(value);
                    resultBuff.append("\n");

                    Thread.sleep(1000);

                }catch (Exception e){
                    log.error("品钛高德分查询异常,context="+context,e);
                }
                log.info("查询"+i+":value="+value+",cost="+(System.currentTimeMillis()-startUtc));
            }
        }
        String writeName = filePath.substring(0,filePath.lastIndexOf("\\"))+"\\result.txt";
        ReadOrWriteTxt.writeTxt(writeName,resultBuff.toString());
        log.info("品钛高德分测试数据写入文件OK, total cost="+(System.currentTimeMillis()-start)+", writeName="+writeName);

        return GlobalResponse.generate("品钛高德分测试数据写入文件OK, total cost="+(System.currentTimeMillis()-start)+", writeName="+writeName);
    }


    //@Monitor({MonitorType.EXCEPTION, MonitorType.FEE, MonitorType.HIT, MonitorType.RESULT})
    //@DistributedLock
    public boolean checkSecretKey(String p3,String secretKey) {
        StringBuffer resultMsg = new StringBuffer();
        if (StringUtils.isAnyBlank(RSA_PRIVATEKEY,p3,secretKey)) {
            return false;
        }
        try {
            String aes_key = RSAEncrypt.decrypt(secretKey, RSA_PRIVATEKEY);//"!QAZ@WSX3edc4rfv"
            String tmp = AesCrypto.decrypt(Base64.decode(p3.trim()), aes_key).trim();
            if (!MD5Util.verify48Md5(tmp, P3_48MD5)) {
                return false;
            }
        } catch (Exception e) {
            log.error("参数解析错误.");
            return false;
        }
        return true;
    }


}
