package cn.quantgroup.report.job;

import cn.quantgroup.report.service.baihang.BaiHangService;
import cn.quantgroup.report.service.baihang.constant.Constant;
import com.google.common.base.Stopwatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.util.concurrent.TimeUnit;

/**
 * 广达小贷定时批量报送非循环贷（贷款申请信息/放款信息/还款信息三类数据）
 * 每日凌晨2点报送
 *
 * @Author fengjunkai
 * @Date 2019-03-26 14:24
 */
@Deprecated  //2019.10.29
@Component
public class QuantGroupLoanInfoReportToBaiHang {

    private static final Logger log = LoggerFactory.getLogger(QuantGroupLoanInfoReportToBaiHang.class);

    @Autowired
    private BaiHangService baiHangService;

    @Autowired
    private RedisTemplate<String,String> redisTemplate;

    @Async
//    @Scheduled(cron = "0 0 0 */1 * ?")
    /*@Scheduled(cron = "0 0 6 * * ?")*/
//    @Scheduled(cron = "*/2 * * * * ?")
    public void startReport(){

        if(increment()){
            redisTemplate.expire(Constant.QG_LOAN_INFO_REPORT_LOCK_KEY, 10, TimeUnit.SECONDS);

            Stopwatch stopwatch = Stopwatch.createStarted();
            log.info("量化派报送广大小贷贷款信息开始, startTime: {} ", LocalDateTime.now());

//            baiHangService.sendApplyLoanInfoReportToBaiHang();  //生产广达小贷非循环贷贷款申请报送T+1    暂时先不报送C1 因为百行还没有开放查询接口
            baiHangService.sendLoaInfoReportToBaiHang();        //生产广达小贷非循环贷放款信息报送T+1
            baiHangService.sendRepaymentReportToBaiHang();      //生产广达小贷非循环贷还款信息报送T+1

            log.info("量化派报送广大小贷贷款信息结束, endTime: {}, 耗时: {} ", LocalDateTime.now(), stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));

        }

    }

    public Boolean increment(){

        Long increment = redisTemplate.opsForValue().increment(Constant.QG_LOAN_INFO_REPORT_LOCK_KEY, 1);

        return increment <= 1;

    }

}
