package cn.quantgroup.report.controller.external;

import cn.quantgroup.report.domain.baihang.*;
import cn.quantgroup.report.response.GlobalResponse;
import cn.quantgroup.report.service.baihang.BaiHangZhuDaiService;
import com.alibaba.fastjson.JSON;
import com.google.common.base.Stopwatch;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

/**
 * 百行征信报送出现错误的贷款记录信息重新报送
 *
 * @Author fengjunkai
 * @Date 2019-04-15 17:27
 */
@RestController
@RequestMapping("/zhudai/re_send")
public class ExZhuDaiBaiHangReSendController {

    private static final Logger log = LoggerFactory.getLogger(ExZhuDaiBaiHangReSendController.class);

    //@Autowired
   //private BaiHangService baiHangService;

    //@Autowired
    //private ReSendBaiHangService reSendBaiHangService;

    @Autowired
    BaiHangZhuDaiService baiHangZhuDaiService;

    /**
     * 根据时间短重新报送实时放款数据
     * @param startTime
     * @param endTime
     * @return
     */
    /*@RequestMapping("/reSendLoanInfoByTime")
    public GlobalResponse reSendLoanInfoByTime(String startTime, String endTime){
        try{
            reSendBaiHangService.sendLoaInfoReportToBaiHang(startTime, endTime);
            return GlobalResponse.generate("重新报送实时放款数据成功");
        }catch(Exception e){
            log.error("重新报送实时放款数据异常", e);
            return GlobalResponse.generate("重新报送实时放款数据成功");
        }
    }*/

    /**
     * 根据时间段重新报送实时还款数据
     * @param startTime
     * @param endTime
     * @return
     */
   /* @RequestMapping("/reSendRepaymentInfoByTime")
    public GlobalResponse reSendRepaymentInfoByTime(String startTime, String endTime){
        try{
            reSendBaiHangService.sendRepaymentReportToBaiHang(startTime, endTime);
            return GlobalResponse.generate("重新报送实时还款数据成功");
        }catch(Exception e){
            log.error("重新报送实时还款数据异常", e);
            return GlobalResponse.generate("重新报送实时还款数据异常");
        }
    }*/


    /**
     * 存量申请用户数据清洗
     * @return
     */
    /*@RequestMapping("/stockApplyInfo")
    public GlobalResponse stockApplyInfo(){
        baiHangService.stockApplyLoanInfo();
        return GlobalResponse.generate("存量申请数据整理完毕");
    }*/

    /**
     * 存量还款数据清洗
     * @return
     */
   /* @RequestMapping("/stockRepaymentLoanInfo")
    public GlobalResponse stockRepaymentLooanInfo(){
        baiHangService.stockRepaymentLoanInfo();
        return GlobalResponse.generate("存量还款数据整理完毕");
    }*/

    /**
     * 存量放款数据报送
     * @return
     */
    /*@RequestMapping("/stockLoanInfo")
    public GlobalResponse stockLooanInfo(){
        baiHangService.stockLoanInfo();
        return GlobalResponse.generate("存量放款数据整理完毕");
    }*/

   /* @RequestMapping("/baihang_data")
    public GlobalResponse baihangData(String readName, String writeName){
        baiHangService.baihangData(readName, writeName);
        return GlobalResponse.generate("成功");
    }*/





    /**
     * 描述: 百行-助贷放款存量数据 整理 <br/>
     * 参数: [startDate, noEndDate] 格式"2019-05-07T00:00:00" startDate是包括， noEndDate是不包括的 <br/>
     * 返回值: cn.quantgroup.risk.datasource.response.GlobalResponse  <br/>
     * 创建人: yanhui.Hao  <br/>
     * 创建时间: 2019.10.23  <br/>
     */
    @RequestMapping("/manual/build/zhudai/stockLoanInfo")
    public GlobalResponse stockLoanInfoZhuDai(String startDate, String noEndDate){
        String msg = baiHangZhuDaiService.stockLoanInfoZhuDai(startDate,noEndDate);
        return GlobalResponse.generate(msg);
    }

    /**
     * 描述: 百行-助贷还款&逾期存量数据 整理 <br/>
     * 参数: [startDate, noEndDate] 格式"2019-05-07T00:00:00" startDate是包括， noEndDate是不包括的 <br/>
     * 返回值: cn.quantgroup.risk.datasource.response.GlobalResponse  <br/>
     * 创建人: yanhui.Hao  <br/>
     * 创建时间: 2019.10.23  <br/>
     */
    @RequestMapping("/manual/build/zhudai/stockRepayMentInfo")
    public GlobalResponse stockRepayMentInfoZhuDai(String startDate, String noEndDate){
        String msg = baiHangZhuDaiService.stockRepayMentInfoZhuDai(startDate,noEndDate);
        return GlobalResponse.generate(msg);
    }

    /**
     * 描述: 百行-助贷申请存量数据 整理 <br/>
     * 参数: [startDate, noEndDate] 格式"2019-05-07T00:00:00" startDate是包括， noEndDate是不包括的 <br/>
     * 返回值: cn.quantgroup.risk.datasource.response.GlobalResponse  <br/>
     * 创建人: yanhui.Hao  <br/>
     * 创建时间: 2019.10.28  <br/>
     */
    @RequestMapping("/manual/build/zhudai/stockApplyInfo")
    public GlobalResponse stockApplyInfoZhuDai(String startDate, String noEndDate){
        String msg = baiHangZhuDaiService.stockApplyLoanInfoZhuDai(startDate,noEndDate);
        return GlobalResponse.generate(msg);
    }

    //---------------------------------------------------------------------

    /**
     * 描述: 手动重新报送部分放款D2逻辑问题数据 <br/>
     * 参数: []  <br/>
     * 返回值: cn.quantgroup.report.response.GlobalResponse  <br/>
     * 创建人: yanhui.Hao  <br/>
     * 创建时间: 2019.10.29  <br/>
     */
    @RequestMapping("/manual/mainApplySend")
    public GlobalResponse mainApplySend(){
        try{
            baiHangZhuDaiService.sendHandApplyToBaiHang();
            return GlobalResponse.generate("百行征信助贷模式手动报送D2数据成功");
        }catch(Exception e){
            log.error("百行征信助贷模式手动报送申请异常", e);
            return GlobalResponse.generate("百行征信助贷模式手动报送A1数据失败");
        }
    }

    /**
     * 描述: 手动重新报送部分放款D2逻辑问题数据 <br/>
     * 参数: []  <br/>
     * 返回值: cn.quantgroup.report.response.GlobalResponse  <br/>
     * 创建人: yanhui.Hao  <br/>
     * 创建时间: 2019.10.29  <br/>
     */
    @RequestMapping("/manual/mainLoanInfoSend")
    public GlobalResponse mainLoanInfoSend(){
        try{
            baiHangZhuDaiService.sendHandLoaInfoReportToBaiHang();
            return GlobalResponse.generate("百行征信助贷模式手动报送D2数据成功");
        }catch(Exception e){
            log.error("百行征信助贷模式报送放款异常", e);
            return GlobalResponse.generate("百行征信助贷模式手动报送D2数据失败");
        }
    }

    /**
     * 描述: 手动报送部分还款D3逻辑问题数据 <br/>
     * 参数: []  <br/>
     * 返回值: cn.quantgroup.report.response.GlobalResponse  <br/>
     * 创建人: yanhui.Hao  <br/>
     * 创建时间: 2019.10.29  <br/>
     */
    @RequestMapping("/manual/mainRepaymentLoanInfo")
    public GlobalResponse mainRepaymentLoanInfo(){
        try{
            baiHangZhuDaiService.sendHandRepaymentReportToBaiHang1();
            return GlobalResponse.generate("百行征信助贷模式手动报送D3数据成功");
        }catch(Exception e){
            log.error("百行征信助贷模式报送还款异常", e);
            return GlobalResponse.generate("百行征信助贷模式手动报送D3数据失败");
        }
    }

    //---------------------------------------------------------------------------

    //test1.场景测试 数据进行脱敏
/*    @RequestMapping("/test/dataTuoMin")
    public String dataTuoMin(String type,String jsonFilePath) {
        try{
            return baiHangZhuDaiService.dataTuoMin(type,jsonFilePath);
        }catch (Exception e){
            log.error("dataTuoMin异常, {} , {} ", e.getMessage(), e);
            return e.getMessage();
        }
    }*/

    //test2.接口测试 手动调用
    @RequestMapping("/test/apiSend")
    public String apiSend(String type,String startDate, String endDate) {
        try{
            return baiHangZhuDaiService.apiSend(type,startDate,endDate);
        }catch (Exception e){
            log.error("dataTuoMin异常, {} , {} ", e.getMessage(), e);
            return e.getMessage();
        }
    }

    //test3.接口测试 手动调用
    @RequestMapping("/test/apiSend2")
    public String apiSend2(String type, String startDate, String endDate) {
        try {
            //"2019-05-07T00:00:00"
            if (StringUtils.isAnyBlank(type, startDate, endDate)) {
                return "参数为空";
            }
            if (startDate.length() != 19 || endDate.length() != 19 || !startDate.contains("T") || !endDate.contains("T")) {
                log.warn("日期格式有误, startDate : {} , endDate : {} ", startDate, endDate);
                return "日期格式有误";
            }

            String startnyr = LocalDateTime.parse(startDate).format(DateTimeFormatter.ISO_DATE);
            String endnyr = LocalDateTime.parse(endDate).format(DateTimeFormatter.ISO_DATE);

            if ("A1".equalsIgnoreCase(type)) {
                //贷款申请信息（A1）
                baiHangZhuDaiService.sendZhuDaiApplyToBaiHang(startnyr, endnyr);

            } else if ("D2".equalsIgnoreCase(type)) {
                //非循环贷款账户数据信息（D2）
                baiHangZhuDaiService.sendZhuDaiLoanToBaiHang(startnyr, endnyr);

            } else if ("D3".equalsIgnoreCase(type)) {
                //非循环贷款贷后数据信息（D3）
                baiHangZhuDaiService.sendZhuDaiRepaymentToBaiHang(startnyr, endnyr);

            } else {
                return "其他未知类型type=" + type;
            }
        } catch (Exception e) {
            log.error("dataTuoMin异常, {} , {} ", e.getMessage(), e);
            return e.getMessage();
        }
        return type + "手动报送结束";
    }

    //test3.接口测试 手动调用
    @RequestMapping("/manual/dealWithFileCry")
    public String dealWithFileCry(String filePath, String type) {
        try {
            //"2019-05-07T00:00:00"
            if (StringUtils.isAnyBlank(filePath,type)) {
                return "参数为空";
            }

            if ("zip".equalsIgnoreCase(type)) {
                return baiHangZhuDaiService.fileUploadClient(filePath);

            } else if ("unzip".equalsIgnoreCase(type)) {
                return  baiHangZhuDaiService.fileUploadValidationClient(filePath);

            } else {
                return "其他未知类型type=" + type;
            }
        } catch (Exception e) {
            log.error("dealWithFileCry异常, {} , {} ", e.getMessage(), e);
            return e.getMessage();
        }
    }
}
