package cn.quantgroup.report.utils.commonutil;

import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;

/**
 * -----------------------------------------------------------------------------<br>
 * 描述： hmacSha1加密工具类<br>
 * 作者： Haoyanhui <br>
 * 时间：2019.09.11 15:12 <br>
 * 授权: (C) Copyright (c) 2017 <br>
 * 公司: 北京众信利民信息技术有限公司 <br>
 * -----------------------------------------------------------------------------
 */
public class MyHmacSha1 {

    /**
     * @描述  hmacSha1加密
     * @参数  [data:字符串, key]
     * @返回值  byte[]
     * @创建人  yanhui.Hao
     * @创建时间  2019.09.11
     */
    public static byte[] hmacSha1(String data, byte[] key) {//String[] datas, byte[] key
        SecretKeySpec signingKey = new SecretKeySpec(key, "HmacSHA1");
        Mac mac = null;
        try {
            mac = Mac.getInstance("HmacSHA1");
            mac.init(signingKey);
        } catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e.getMessage(), e);
        } catch (InvalidKeyException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        try {
            mac.update(data.getBytes(Charset.forName("utf-8")));
        } catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return mac.doFinal();
    }

    /**
     * @描述  hmacSha1加密
     * @参数  [dataArry:字符串数组, key]
     * @返回值  byte[]
     * @创建人  yanhui.Hao
     * @创建时间  2019.09.11
     */
    public static byte[] hmacSha1(String[] dataArry, byte[] key) {
        SecretKeySpec signingKey = new SecretKeySpec(key, "HmacSHA1");
        Mac mac = null;
        try {
            mac = Mac.getInstance("HmacSHA1");
            mac.init(signingKey);
        } catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e.getMessage(), e);
        } catch (InvalidKeyException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        try {
            for (String data : dataArry) {
                mac.update(data.getBytes(Charset.forName("utf-8")));
            }
        } catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return mac.doFinal();
    }


    public static String byte2hex(final byte[] b) {
        String hs = "";
        for (int n = 0; n < b.length; n++) {
            String stmp = (java.lang.Integer.toHexString(b[n] & 0xFF));
            if (stmp.length() == 1)
                hs = hs + "0" + stmp;
            else
                hs = hs + stmp;
        }
        return hs;
    }
}
