package cn.quantgroup.report.controller;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.ImmutableMap;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

/**
 * @Author fengjunkai
 */
@Slf4j
@RestController
@RequestMapping("/")
public class CheckController {

    private static Map<String,String> map = new ConcurrentHashMap<>();

    @ResponseBody
    @RequestMapping(value="check")
    public ResponseEntity<String> check(){
        if(map!=null && map.size()>0){
            return new ResponseEntity<String>(HttpStatus.NOT_FOUND);
        }else{
            return new ResponseEntity<String>(HttpStatus.OK);
        }
    }

    @ResponseBody
    @RequestMapping(value="/online")
    public Map<String, String> online(){
        log.info("应用上线，流量开始切入....");
        map.clear();
        return responseOk();
    }

    @ResponseBody
    @RequestMapping(value="/offline")
    public Map<String, String> offline(){
        log.info("应用下线，流量不再切入....");
        map.put("status", "offline");
        return responseOk();
    }

    @ResponseBody
    @RequestMapping(value="/test")
    public Map<String, String> test() {
        log.info("CheckController测试!map = {}", map);
        return ImmutableMap.of("code", "0", "msg", JSON.toJSONString(map));
    }
    public static Map<String, String> responseOk() {
        return ImmutableMap.of("code", "0", "msg", "ok");
    }

    @RequestMapping("/getuuid")
    public String getUuid(String param){
        return UUID.nameUUIDFromBytes(param.getBytes()).toString();
    }


}
