package cn.quantgroup.report.mapper.baihang;

import cn.quantgroup.report.domain.baihang.*;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 还款信息查询
 *
 * @Author fengjunkai
 * @Date 2019-03-26 15:27
 */
@Repository
public interface RepaymentLoanInfoMapper {

    //实时还款（百行征信报送）
    List<RepaymentLoanInfo> findRepayMentLoanInfo(BaiHangTimeRecord baiHangTimeRecord);

    //实时逾期还款（百行征信报送）
    List<RepaymentLoanInfo> findRepayMentLoanInfoOverdue(BaiHangTimeRecord baiHangTimeRecord);

    List<RepaymentLoanInfo> findStockRepayMentLoanInfo(BaiHangTimeRecord baiHangTimeRecord);
    List<RepaymentLoanInfo> findStockRepayMentLoanInfoOverdue(BaiHangTimeRecord baiHangTimeRecord);

    BaiHangNameResult findName(BaiHangName baiHangName);


    /**
     * 描述: 百行-助贷逾期还款存量数据 整理 <br/>
     * 参数:  日期 BaiHangTimeRecord: startTime和endsTime <br/>
     * 返回值:   <br/>
     * 创建人: yanhui.Hao  <br/>
     * 创建时间: 2019.10.23  <br/>
     */
    List<RepaymentInfoZhuDai> queryStockRepayMentInfoOverdueZhuDai(BaiHangTimeRecord baiHangTimeRecord);


    /**
     * 描述: 百行-助贷还款存量数据 整理 <br/>
     * 参数:  日期 BaiHangTimeRecord: startTime和endsTime <br/>
     * 返回值:   <br/>
     * 创建人: yanhui.Hao  <br/>
     * 创建时间: 2019.10.23  <br/>
     */
    List<RepaymentInfoZhuDai> queryStockRepayMentInfoZhuDai(BaiHangTimeRecord baiHangTimeRecord);



    /**
     * 描述: 3.1百行助贷-非联合贷 实时还款 <br/>
     * 参数:  日期 BaiHangTimeRecord: startTime和endsTime <br/>
     * 返回值:   <br/>
     * 创建人: yanhui.Hao  <br/>
     * 创建时间: 2019.10.28  <br/>
     */
    List<RepaymentInfoZhuDai> findRealTimeRepayMentInfo(BaiHangTimeRecord baiHangTimeRecord);

    /**
     * 描述: 3.2百行助贷-联合贷 实时还款 <br/>
     * 参数:  日期 BaiHangTimeRecord: startTime和endsTime <br/>
     * 返回值:   <br/>
     * 创建人: yanhui.Hao  <br/>
     * 创建时间: 2019.10.28  <br/>
     */
    List<RepaymentInfoZhuDai> findRealTimeRepayMentInfoLh(BaiHangTimeRecord baiHangTimeRecord);


    /**
     * 描述: 4.1百行助贷-非联合贷 实时逾期还款 <br/>
     * 参数:  日期 BaiHangTimeRecord: startTime和endsTime <br/>
     * 返回值:   <br/>
     * 创建人: yanhui.Hao  <br/>
     * 创建时间: 2019.10.28  <br/>
     */
    List<RepaymentInfoZhuDai> findRealTimeRepayMentOverdue(BaiHangTimeRecord baiHangTimeRecord);

    /**
     * 描述: 4.2百行助贷-联合贷 实时逾期还款 <br/>
     * 参数:  日期 BaiHangTimeRecord: startTime和endsTime <br/>
     * 返回值:   <br/>
     * 创建人: yanhui.Hao  <br/>
     * 创建时间: 2019.10.28  <br/>
     */
    List<RepaymentInfoZhuDai> findRealTimeRepayMentOverdueLh(BaiHangTimeRecord baiHangTimeRecord);

}
