package cn.quantgroup.report.service.http.impl;

import cn.quantgroup.report.cmpt.CommonAlarmCmpt;
import cn.quantgroup.report.error.QGException;
import cn.quantgroup.report.error.QGExceptionType;
import cn.quantgroup.report.service.http.IHttpService;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Predicates;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.CharEncoding;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.io.UnsupportedEncodingException;
import java.util.*;

/**
 * @author guowei.wei
 * @time 2018-05-30 10:11
 */
@Service
public class HttpServiceImpl implements IHttpService {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpServiceImpl.class);

    private static final int TIME_OUT_60 = 60 * 1000;
    private static final int TIME_OUT_20 = 20 * 1000;
    private static final int TIME_OUT_15 = 15 * 1000;
    public static final String responseContentKey = "responseContentKey";
    public static final String statusCodeKey = "statusCodeKey";
    public static final String consumeTimeKey = "consumeTimeKey";

    @Autowired
    @Qualifier("httpClient")
    private CloseableHttpClient httpClient;
    @Autowired
    private CommonAlarmCmpt commonAlarmCmpt;
    @Override
    public String get(String uri) {
        return get(uri, null, null);
    }
    @Override
    public Map<String,String> getMap(String uri,String interfaceType, Object... args) {
        return getMap(uri, null, null,interfaceType,args);
    }
    @Override
    public String get(String uri,int timeOut) {
        return doHttp(RequestBuilder.get(), uri, null, null,true,timeOut);
    }

    @Override
    public <T> T get(String uri, Class<T> classOfT) {
        String s = get(uri, null, null);
        return new Gson().fromJson(s,classOfT);
    }

    @Override
    public String get(String uri, Map<String, String> parameters) {
        return get(uri, null, parameters);
    }

    @Override
    public String get(String uri, Map<String, String> headers, Map<String, String> parameters) {
        return doHttp(RequestBuilder.get(), uri, headers, parameters,true,TIME_OUT_20);
    }
    @Override
    public Map<String,String> getMap(String uri, Map<String, String> headers, Map<String, String> parameters,String interfaceType, Object... args) {
        return doHttpMap(RequestBuilder.get(), uri, headers, parameters,false,TIME_OUT_20,interfaceType,args);
    }
    @Override
    public String post(String uri) {
        return post(uri, null, null);
    }

    @Override
    public String post(String uri, Map<String, String> parameters) {
        return post(uri, null, parameters);
    }

    @Override
    public String post(String uri, Map<String, String> parameters,boolean isLog) {
        return doHttp(RequestBuilder.post(), uri, null, parameters,isLog,TIME_OUT_20);
    }

    @Override
    public String post(String uri, Map<String, String> headers, Map<String, String> parameters) {
        return doHttp(RequestBuilder.post(), uri, headers, parameters,true,TIME_OUT_20);
    }
    @Override
   	public String postCommon(String uri, Map<String, String> headers, String jsonParams, Map<String, String> responseHeaders, String interfaceType) {
   		return doJsonHttp(RequestBuilder.post(),uri,headers,jsonParams,responseHeaders,interfaceType);
   	}
    @Override
    public Map<String,String> postJsonMap(String uri, Map<String, String> headers, String jsonParams,Map<String, String> responseHeaders,String interfaceType, Object... args) {
        return doJsonHttpMap(RequestBuilder.post(),uri,headers,jsonParams,responseHeaders,interfaceType,args);
    }
    @Override
    public String postObj(String uri, Map<String, Object> parameters) {
        return postObj(uri, null, parameters);
    }
    @Override
   	public String postObj(String uri, Map<String, String> headers, Map<String, Object> parameters) {
   		return doObjectHttp(RequestBuilder.post(),uri,headers,parameters);
   	}
    @Override
    public int postNoResponse(String url, Map<String, String> parameters){
    	return doHttpNoResponse(RequestBuilder.post(),url,null,parameters);
    }
    
    private int doHttpNoResponse(RequestBuilder requestBuilder,String uri, Map<String, String> headers, Map<String, String> parameters){
    	HttpEntity httpEntity = null;
        CloseableHttpResponse httpResponse = null;
        try {
            requestBuilder.setUri(uri);
            this.setConfig(requestBuilder,TIME_OUT_15);
            this.setHeader(requestBuilder, headers);
            this.setParameter(requestBuilder, parameters);
            httpResponse = httpClient.execute(requestBuilder.build());
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if(statusCode==200){
            	 httpEntity = httpResponse.getEntity();
            }else{
            	 LOGGER.info("HTTP请求失败, uri:{},parameters:{},响应码:{}", uri,parameters,statusCode);
            }
            return statusCode;
        } catch (Exception e) {
            LOGGER.error("HTTP请求异常, uri:{},parameters:{}", uri,parameters, e);
        } finally {
            EntityUtils.consumeQuietly(httpEntity);
            IOUtils.closeQuietly(httpResponse);
        }
        return 808;
    }

    /**
     * Send Http
     *
     * @param requestBuilder
     * @param uri
     * @param headers
     * @param parameters
     * @return
     */
    public String doHttp(RequestBuilder requestBuilder, String uri, Map<String, String> headers, Map<String, String> parameters,boolean isLog,int timeOut) {
        String method = requestBuilder.getMethod();
        HttpEntity httpEntity = null;
        CloseableHttpResponse httpResponse = null;
        try {
            requestBuilder.setUri(uri);
            this.setConfig(requestBuilder,timeOut);
            this.setHeader(requestBuilder, headers);
            this.setParameter(requestBuilder, parameters);
            long startTime = System.currentTimeMillis();
            httpResponse = httpClient.execute(requestBuilder.build());
            long endTime = System.currentTimeMillis();
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            String response = null;
            try{
            	 httpEntity = httpResponse.getEntity();
                 response = EntityUtils.toString(httpEntity, "UTF-8");
            }catch (Exception e){}
            if(isLog)
                LOGGER.info("{}, uri:{},parameters:{},response:{},statusCode:{}", method, uri, parameters,response,statusCode);
            return response;
        } catch (Exception e) {
            LOGGER.error("{}, uri:{}, parameters:{}", method, uri, parameters, e);
            throw new QGException(QGExceptionType.COMMON_THIRD_PART_CALL_EXCEPTION, e.toString() + ";url: "+uri);
        } finally {
            EntityUtils.consumeQuietly(httpEntity);
            IOUtils.closeQuietly(httpResponse);
        }
    }

    public String postCommon(RequestBuilder requestBuilder, String uri, Map<String, String> headers, String parameters, boolean isLog, int timeOut) {
        String method = requestBuilder.getMethod();
        HttpEntity httpEntity = null;
        CloseableHttpResponse httpResponse = null;
        try {
            requestBuilder.setUri(uri);
            this.setConfig(requestBuilder,timeOut);
            this.setHeader(requestBuilder, headers);
            this.setParameter(requestBuilder, parameters);
            httpResponse = httpClient.execute(requestBuilder.build());
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            String response = null;
            if(statusCode==200){
            	 httpEntity = httpResponse.getEntity();
                 response = EntityUtils.toString(httpEntity, "UTF-8");
            }
            if(isLog)
                LOGGER.info("{}, uri:{},parameters:{},response:{},statusCode:{}", method, uri, parameters,response,statusCode);
            return response;
        } catch (Exception e) {
            LOGGER.error("{}, uri:{}, parameters:{}", method, uri, parameters, e);
            throw new QGException(QGExceptionType.COMMON_THIRD_PART_CALL_EXCEPTION, e.toString() + ";url: "+uri);
        } finally {
            EntityUtils.consumeQuietly(httpEntity);
            IOUtils.closeQuietly(httpResponse);
        }
    }

    public String postCommonAllResult(RequestBuilder requestBuilder, String uri, Map<String, String> headers, String parameters, boolean isLog, int timeOut) {
        String method = requestBuilder.getMethod();
        HttpEntity httpEntity = null;
        CloseableHttpResponse httpResponse = null;
        try {
            requestBuilder.setUri(uri);
            this.setConfig(requestBuilder,timeOut);
            this.setHeader(requestBuilder, headers);
            this.setParameter(requestBuilder, parameters);
            httpResponse = httpClient.execute(requestBuilder.build());
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            String response = null;
//            if(statusCode==200){
                httpEntity = httpResponse.getEntity();
                response = EntityUtils.toString(httpEntity, "UTF-8");
//            }
            if(isLog)
                LOGGER.info("{}, uri:{},parameters:{},response:{},statusCode:{}", method, uri, parameters,response,statusCode);
            return response;
        } catch (Exception e) {
            LOGGER.error("第三方API请求异常 {}, uri:{}, parameters:{}", method, uri, parameters, e);
            throw new QGException(QGExceptionType.COMMON_THIRD_PART_CALL_EXCEPTION, e.toString() + ";url: "+uri);
        } finally {
            EntityUtils.consumeQuietly(httpEntity);
            IOUtils.closeQuietly(httpResponse);
        }
    }


    public String postCommonAllResultSoap(RequestBuilder requestBuilder, String uri, Map<String, String> headers, String parameters, boolean isLog, int timeOut) {
        String method = requestBuilder.getMethod();
        HttpEntity httpEntity = null;
        CloseableHttpResponse httpResponse = null;
        try {
            requestBuilder.setUri(uri);
            this.setConfig(requestBuilder,timeOut);
            this.setHeader(requestBuilder, headers);
            this.setParameter(requestBuilder, parameters);
            httpResponse = httpClient.execute(requestBuilder.build());
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            String response = null;
//            if(statusCode==200){
            httpEntity = httpResponse.getEntity();
            response = EntityUtils.toString(httpEntity, "UTF-8");
//            }
            if(isLog)
                LOGGER.info("{}, uri:{},parameters:{},response:{},statusCode:{}", method, uri, parameters,response,statusCode);
            return response;
        } catch (Exception e) {
            LOGGER.error("{}, uri:{}, parameters:{}", method, uri, parameters, e);
            throw new QGException(QGExceptionType.COMMON_THIRD_PART_CALL_EXCEPTION, e.toString() + ";url: "+uri);
        } finally {
            EntityUtils.consumeQuietly(httpEntity);
            IOUtils.closeQuietly(httpResponse);
        }
    }

    /**
     * Send Http
     *
     * @param requestBuilder
     * @param uri
     * @param headers
     * @param parameters
     * @return
     */
    public Map<String,String> doHttpMap(RequestBuilder requestBuilder, String uri, Map<String, String> headers, Map<String, String> parameters,boolean isLog,int timeOut,String interfaceType, Object... args) {
        Map<String,String> map = new LinkedHashMap<>();
        String method = requestBuilder.getMethod();
        HttpEntity httpEntity = null;
        CloseableHttpResponse httpResponse = null;
        try {
            requestBuilder.setUri(uri);
            this.setConfig(requestBuilder,timeOut);
            this.setParameter(requestBuilder, parameters);
            this.setHeader(requestBuilder, headers);
            long startTime = System.currentTimeMillis();
            httpResponse = httpClient.execute(requestBuilder.build());
            long endTime = System.currentTimeMillis();
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            String response = null;
            String params = "";
            if(args.length > 0){
                params = ";参数:"+Arrays.toString(args);
            }
            if(statusCode==200){
                httpEntity = httpResponse.getEntity();
                response = EntityUtils.toString(httpEntity, "UTF-8");
            } else {
                //状态码不为200,报警
                commonAlarmCmpt.alarm("Warn", "三方数据源"+interfaceType+"请求异常", ";地址:"+uri+";状态码:"+statusCode+params);
            }
            long consumeTime = endTime - startTime;
            //超过10秒,报警
            if(consumeTime >TIME_OUT_15){
                commonAlarmCmpt.alarm("Warn", "三方数据源"+interfaceType+"请求耗时"+consumeTime/1000+"秒", ";地址:"+uri+";状态码:"+statusCode+params);
            }
            map.put(statusCodeKey,statusCode+"");
            map.put(responseContentKey,response);
            map.put(consumeTimeKey,(endTime-startTime)+"");
//            if(isLog)
//                LOGGER.info("{}, uri:{},parameters:{},response:{},statusCode:{}", method, uri, parameters,response,statusCode);
            return map;
        } catch (Exception e) {
            if(parameters == null || parameters.size() == 0){
                commonAlarmCmpt.alarm("Warn", "三方数据源"+interfaceType+"请求异常", ";地址:"+uri+";异常信息:"+e.getMessage()+";参数:"+ Arrays.toString(args));
                LOGGER.error("{}, uri:{}, parameters:{}", method, uri, Arrays.toString(args), e);
            } else {
                commonAlarmCmpt.alarm("Warn", "三方数据源"+interfaceType+"请求异常", ";地址:"+uri+";异常信息:"+e.getMessage()+";参数:"+ JSONObject.toJSONString(parameters));
                LOGGER.error("{}, uri:{}, parameters:{}", method, uri, parameters, e);
            }
            return null;
        } finally {
            EntityUtils.consumeQuietly(httpEntity);
            IOUtils.closeQuietly(httpResponse);
        }
    }
    /**
     * Send Http
     *
     * @param requestBuilder
     * @param uri
     * @param headers
     * @param parameters
     * @return
     */
    public String doObjectHttp(RequestBuilder requestBuilder, String uri, Map<String, String> headers, Map<String, Object> parameters) {
        String method = requestBuilder.getMethod();
        HttpEntity httpEntity = null;
        CloseableHttpResponse httpResponse = null;
        try {
            requestBuilder.setUri(uri);
            this.setConfig(requestBuilder,TIME_OUT_20);
            this.setHeader(requestBuilder, headers);
            this.setParameter2(requestBuilder, parameters);
            httpResponse = httpClient.execute(requestBuilder.build());
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            String response = null;
            if(statusCode==200){
            	 httpEntity = httpResponse.getEntity();
                 response = EntityUtils.toString(httpEntity, "UTF-8");
            }
            LOGGER.info("{}, uri:{}, parameters:{},response:{}", method, uri, parameters,response);
            return response;
        } catch (Exception e) {
            LOGGER.error("{}, uri:{}, parameters:{}", method, uri, parameters, e);
            return null;
        } finally {
            EntityUtils.consumeQuietly(httpEntity);
            IOUtils.closeQuietly(httpResponse);
        }
    }
    /**
     * Send Http
     *
     * @param requestBuilder
     * @param uri
     * @param headers
     * @param jsonParams
     * @return
     */
    public String doJsonHttp(RequestBuilder requestBuilder, String uri, Map<String, String> headers, String jsonParams,Map<String, String> responseHeaders,String interfaceType) {
        String method = requestBuilder.getMethod();
        HttpEntity httpEntity = null;
        CloseableHttpResponse httpResponse = null;
        try {
            requestBuilder.setUri(uri);
            this.setConfig(requestBuilder,TIME_OUT_20);
            this.setParameter(requestBuilder, jsonParams);
            this.setHeader(requestBuilder, headers);
            if(responseHeaders != null && responseHeaders.size() > 0){
                for(Map.Entry<String,String> resHea : responseHeaders.entrySet()){
                    httpResponse.setHeader(resHea.getKey(),resHea.getValue());
                }
            }
            long startTime = System.currentTimeMillis();
            httpResponse = httpClient.execute(requestBuilder.build());
            long endTime = System.currentTimeMillis();
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            String response = null;
            if(statusCode==200){
                httpEntity = httpResponse.getEntity();
                response = EntityUtils.toString(httpEntity, CharEncoding.UTF_8);
            } else {
                response = statusCode+"";
            }
            return response;
        } catch (Exception e) {
            LOGGER.error("{}, uri:{}, ", method, uri, e);
            return null;
        } finally {
            EntityUtils.consumeQuietly(httpEntity);
            IOUtils.closeQuietly(httpResponse);
        }
    }
    /**
     * Send Http
     *
     * @param requestBuilder
     * @param uri
     * @param headers
     * @param jsonParams
     * @return
     */
    public Map<String,String> doJsonHttpMap(RequestBuilder requestBuilder, String uri, Map<String, String> headers, String jsonParams,Map<String, String> responseHeaders,String interfaceType,Object... args) {
        Map<String,String> map = new LinkedHashMap<>();
        String method = requestBuilder.getMethod();
        HttpEntity httpEntity = null;
        CloseableHttpResponse httpResponse = null;
        String params = "";
        if(args.length > 0){
            params = ";参数:"+Arrays.toString(args);
        }
        try {
            requestBuilder.setUri(uri);
            this.setConfig(requestBuilder,TIME_OUT_20);
            this.setParameter(requestBuilder, jsonParams);
            this.setHeader(requestBuilder, headers);
//            if(responseHeaders != null && responseHeaders.size() > 0){
//                for(Map.Entry<String,String> resHea : responseHeaders.entrySet()){
//                    httpResponse.addHeader(resHea.getKey(),resHea.getValue());
//                }
//            }
            long startTime = System.currentTimeMillis();
            httpResponse = httpClient.execute(requestBuilder.build());
            long endTime = System.currentTimeMillis();
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            String response = null;
            if(statusCode==200){
                httpEntity = httpResponse.getEntity();
                response = EntityUtils.toString(httpEntity, CharEncoding.UTF_8);
            } else {
                //状态码不为200,报警
                commonAlarmCmpt.alarm("Warn", "三方数据源"+interfaceType+"请求异常", ";地址:"+uri+";状态码:"+statusCode+params);
            }
            long consumeTime = endTime - startTime;
            //超过10秒,报警
            if(consumeTime >TIME_OUT_15){
                commonAlarmCmpt.alarm("Warn", "三方数据源"+interfaceType+"请求耗时"+consumeTime/1000+"秒", ";地址:"+uri+";状态码:"+statusCode+params);
            }
            map.put(statusCodeKey,statusCode+"");
            map.put(responseContentKey,response);
            map.put(consumeTimeKey,(endTime-startTime)+"");
            return map;
        } catch (Exception e) {
            commonAlarmCmpt.alarm("Warn", "三方数据源"+interfaceType+"请求异常", ";地址:"+uri+";异常信息:"+e.getMessage()+params);
            LOGGER.error("{}, uri:{}, params:{}", method, uri,params, e);
            return null;
        } finally {
            EntityUtils.consumeQuietly(httpEntity);
            IOUtils.closeQuietly(httpResponse);
        }
    }
    /**
     * Set Parameter
     *
     * @param requestBuilder
     * @param parameters
     */
    private void setParameter(RequestBuilder requestBuilder, Map<String, String> parameters) {
        if (MapUtils.isNotEmpty(parameters)) {
            parameters = Maps.filterValues(parameters, Predicates.notNull());

            Set<Map.Entry<String, String>> entrys = parameters.entrySet();
            /************** Get 请求 **************/
            if (requestBuilder.getMethod().equalsIgnoreCase(HttpGet.METHOD_NAME)) {
                for (Map.Entry<String, String> entry : entrys) {
                    requestBuilder.addParameter(entry.getKey(), entry.getValue());
                }
            }
            /************** Post 请求 **************/
            else {
                List<NameValuePair> valuePairs = new ArrayList<>();
                for (Map.Entry<String, String> entry : entrys) {
                    valuePairs.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
                }
				try {
					requestBuilder.setEntity(new UrlEncodedFormEntity(valuePairs, "UTF-8"));
				} catch (UnsupportedEncodingException e) {
					e.printStackTrace();
				}
            }
        }
    }
    
    /**
     * Set Parameter
     *
     * @param requestBuilder
     * @param parameters Map<String, Object>
     */
    private void setParameter2(RequestBuilder requestBuilder, Map<String, Object> parameters) {
        if (MapUtils.isNotEmpty(parameters)) {
            parameters = Maps.filterValues(parameters, Predicates.notNull());

            Set<Map.Entry<String, Object>> entrys = parameters.entrySet();
            /************** Get 请求 **************/
            if (requestBuilder.getMethod().equalsIgnoreCase(HttpGet.METHOD_NAME)) {
                for (Map.Entry<String, Object> entry : entrys) {
                    requestBuilder.addParameter(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
                }
            }
            /************** Post 请求 **************/
            else {
                List<NameValuePair> valuePairs = new ArrayList<>();
                for (Map.Entry<String, Object> entry : entrys) {
                    valuePairs.add(new BasicNameValuePair(String.valueOf(entry.getKey()), String.valueOf(entry.getValue())));
                }
				try {
					requestBuilder.setEntity(new UrlEncodedFormEntity(valuePairs, "UTF-8"));
				} catch (UnsupportedEncodingException e) {
					e.printStackTrace();
				}
            }
        }
    }
    /**
     * Set Parameter
     *
     * @param requestBuilder
     * @param jsonParams
     */
    private void setParameter(RequestBuilder requestBuilder, String jsonParams) {
        if (StringUtils.isNotEmpty(jsonParams)) {
        	StringEntity stringEntity = new StringEntity(jsonParams, CharEncoding.UTF_8);
        	stringEntity.setContentType("application/json; charset=utf-8");
            requestBuilder.setEntity(stringEntity);
        }
    }
    /**
     * Set Header
     *
     * @param requestBuilder
     * @param headers
     */
    private void setHeader(RequestBuilder requestBuilder, Map<String, String> headers) {
        requestBuilder.setHeader("User-Agent", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/42.0.2311.135 Safari/537.36")
                .setHeader("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8")
                .setHeader("Accept-Language", "zh-CN,zh;q=0.8,en;q=0.6")
                .setHeader("Connection", "keep-alive");

        if (MapUtils.isNotEmpty(headers)) {
            headers = Maps.filterValues(headers, Predicates.notNull());

            Set<Map.Entry<String, String>> entrys = headers.entrySet();
            for (Map.Entry<String, String> entry : entrys) {
                requestBuilder.addHeader(entry.getKey(), entry.getValue());
            }
        }
    }
    /**
     * Request config
     *
     * @return
     */
    private void setConfig(RequestBuilder requestBuilder,int timeOut) {
        RequestConfig config = RequestConfig.custom()
                .setConnectTimeout(timeOut)
                .setSocketTimeout(timeOut)
                .setConnectionRequestTimeout(timeOut)
                .build();
        requestBuilder.setConfig(config);
    }
    @Override
    public void exceptionAlarm(String interfaceType,String uri,String exception, Object... args) {
        try {
            if(StringUtils.isNotBlank(exception)){
                String params = "";
                if(args.length > 0){
                    params = ";参数:"+Arrays.toString(args);
                }
                String name = uri.startsWith("http") ? "地址:" : "接口:";
                commonAlarmCmpt.alarm("Warn", "三方数据源"+interfaceType+"请求异常",name+uri+";异常原因:"+exception+params);
            }
        } catch (Exception e) {
            LOGGER.error("报警异常, interfaceType:{},uri:{}",interfaceType, uri, e);
        }
    }
    @Override
    public void timeOutAndCodeAlarm(long startTime,long endTime,String interfaceType,String uri,String statusCode,String reason, Object... args) {
        try {
            String name = uri.startsWith("http") ? "地址:" : "接口:";
            String params = "";
            if(args.length > 0){
                params = ";参数:"+Arrays.toString(args);
            }
            long consumeTime = endTime - startTime;
            //超过10秒,报警
            String statusC =  StringUtils.isBlank(statusCode) ? "" : ";状态码:"+statusCode;
            if(consumeTime >TIME_OUT_15){
                commonAlarmCmpt.alarm("Warn", "三方数据源"+interfaceType+"请求耗时"+consumeTime/1000+"秒", name+uri+statusC+params);
            }
            if(StringUtils.isNotBlank(statusCode) && !"200".equals(statusCode)){
                commonAlarmCmpt.alarm("Warn", "三方数据源"+interfaceType+"请求异常", name+uri+statusC+params);
            }
            if(StringUtils.isNotBlank(reason)){
                commonAlarmCmpt.alarm("Warn", "三方数据源"+interfaceType+"请求失败", name+uri+";返回内容"+reason+params);
            }
        } catch (Exception e) {
            LOGGER.error("报警异常, interfaceType:{},uri:{}",interfaceType, uri, e);
        }
    }
    @Override
    public void alarm(long startTime,long endTime,String interfaceType,String uri,String statusCode,String reason, Object... args) {
        try {
            String name = uri.startsWith("http") ? "地址:" : "接口:";
            String params = "";
            if(args.length > 0){
                params = ";参数:"+Arrays.toString(args);
            }
            long consumeTime = endTime - startTime;
            String statusC =  StringUtils.isBlank(statusCode) ? "" : ";状态码:"+statusCode+",";
            //请求异常
            commonAlarmCmpt.alarm("Warn", "三方数据源"+interfaceType, name+uri+params+statusC+reason+";耗时:"+consumeTime/1000+"秒");
        } catch (Exception e) {
            LOGGER.error("报警异常, interfaceType:{},uri:{}",interfaceType, uri, e);
        }
    }

    @Override
    public String postCommon(String uri, Map<String, String> headers, String json) {
        return postCommon(RequestBuilder.post(), uri, headers, json,true,TIME_OUT_20);
    }

    @Override
    public String postCommonAllResult(String uri, Map<String, String> headers, String json) {
        return postCommonAllResult(RequestBuilder.post(), uri, headers, json,true,TIME_OUT_60);
    }

    @Override
    public String postCommonAllResultSoap(String uri, Map<String, String> headers, String json) {
        return postCommonAllResultSoap(RequestBuilder.post(), uri, headers, json,true,TIME_OUT_20);
    }

    @Override
    public String postBaiHang(String uri, Map<String, String> headers, String json) {
        return postBaiHangComm(RequestBuilder.post(), uri, headers, json,true,TIME_OUT_20 );
    }

    public String postBaiHangComm(RequestBuilder requestBuilder, String uri, Map<String, String> headers, String parameters, boolean isLog, int timeOut){
        String method = requestBuilder.getMethod();
        HttpEntity httpEntity = null;
        CloseableHttpResponse httpResponse = null;
        try {
            requestBuilder.setUri(uri);
            this.setConfig(requestBuilder,timeOut);
            this.setHeader(requestBuilder, headers);
            this.setParameter(requestBuilder, parameters);
            httpResponse = httpClient.execute(requestBuilder.build());
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            String response = null;
//            if(statusCode==200){
                httpEntity = httpResponse.getEntity();
                response = EntityUtils.toString(httpEntity, "UTF-8");
//            }
            if(isLog)
                LOGGER.info("{}, uri:{},parameters:{},response:{},statusCode:{}", method, uri, parameters,response,statusCode);
            return response;
        } catch (Exception e) {
            LOGGER.error("{}, uri:{}, parameters:{}", method, uri, parameters, e);
            throw new QGException(QGExceptionType.COMMON_THIRD_PART_CALL_EXCEPTION, e.toString() + ";url: "+uri);
        } finally {
            EntityUtils.consumeQuietly(httpEntity);
            IOUtils.closeQuietly(httpResponse);
        }
    }
}
