package cn.quantgroup.report.mapper.baihang;

import cn.quantgroup.report.domain.baihang.BaiHangTimeRecord;
import cn.quantgroup.report.domain.baihang.RepaymentInfoZhuDai;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 还款信息查询
 *
 * @Author fengjunkai
 * @Date 2019-03-26 15:27
 */
@Repository
public interface RepaymentLoanInfoMapper {

    //实时还款（广达百行征信报送）
    //List<RepaymentInfoZhuDai> findRepayMentLoanInfo(BaiHangTimeRecord baiHangTimeRecord);
    //实时逾期还款（广达百行征信报送）
    //List<RepaymentInfoZhuDai> findRepayMentLoanInfoOverdue(BaiHangTimeRecord baiHangTimeRecord);
    ///List<RepaymentInfoZhuDai> findStockRepayMentLoanInfo(BaiHangTimeRecord baiHangTimeRecord);
    //List<RepaymentInfoZhuDai> findStockRepayMentLoanInfoOverdue(BaiHangTimeRecord baiHangTimeRecord);
    //BaiHangNameResult findName(BaiHangName baiHangName);


    /**
     * 描述: 百行-助贷逾期还款存量数据 整理 <br/>
     * 参数:  日期 BaiHangTimeRecord: startTime和endsTime <br/>
     * 返回值:   <br/>
     * 创建人: yanhui.Hao  <br/>
     * 创建时间: 2019.10.23  <br/>
     */
    @Deprecated
    List<RepaymentInfoZhuDai> queryStockRepayMentInfoOverdueZhuDai(BaiHangTimeRecord baiHangTimeRecord);


    /**
     * 描述: 百行-助贷还款存量数据 整理 <br/>
     * 参数:  日期 BaiHangTimeRecord: startTime和endsTime <br/>
     * 返回值:   <br/>
     * 创建人: yanhui.Hao  <br/>
     * 创建时间: 2019.10.23  <br/>
     */
    @Deprecated
    List<RepaymentInfoZhuDai> queryStockRepayMentInfoZhuDai(BaiHangTimeRecord baiHangTimeRecord);



    /**
     * 描述: 3.1百行助贷-非联合贷 实时还款 <br/>
     * 参数:  日期 BaiHangTimeRecord: startTime和endsTime <br/>
     * 返回值:   <br/>
     * 创建人: yanhui.Hao  <br/>
     * 创建时间: 2019.10.28  <br/>
     */
    List<RepaymentInfoZhuDai> findRealTimeRepayMentInfo(BaiHangTimeRecord baiHangTimeRecord);

    /* 2020.06.18
      和findRealTimeRepayMentInfo方法查询功能一样，但是findRealTimeRepayMentInfo用 funding_corp_id in (420,520,580,650,670,810,240,640,700)
      已经慢的查不出来，改用funding_corp_id=xxx， 查多次
     */
    List<RepaymentInfoZhuDai> findRealTimeRepayMentInfo_byFCId(BaiHangTimeRecord baiHangTimeRecord);

    /**
     * 描述: 3.2百行助贷-联合贷 实时还款 <br/>
     * 参数:  日期 BaiHangTimeRecord: startTime和endsTime <br/>
     * 返回值:   <br/>
     * 创建人: yanhui.Hao  <br/>
     * 创建时间: 2019.10.28  <br/>
     */
    List<RepaymentInfoZhuDai> findRealTimeRepayMentInfoLh(BaiHangTimeRecord baiHangTimeRecord);


    /**
     * 描述: 4.1百行助贷-非联合贷 实时逾期还款 <br/>
     * 参数:  日期 BaiHangTimeRecord: startTime和endsTime <br/>
     * 返回值:   <br/>
     * 创建人: yanhui.Hao  <br/>
     * 创建时间: 2019.10.28  <br/>
     */
    List<RepaymentInfoZhuDai> findRealTimeRepayMentOverdue(BaiHangTimeRecord baiHangTimeRecord);
    /* 2020.06.18
      和findRealTimeRepayMentOverdue方法查询功能一样，但是findRealTimeRepayMentOverdue用 funding_corp_id in (420,520,580,650,670,810,240,640,700)
      已经慢的查不出来，改用funding_corp_id=xxx， 查多次
     */
    List<RepaymentInfoZhuDai> findRealTimeRepayMentOverdue_byFCId(BaiHangTimeRecord baiHangTimeRecord);

    /**
     * 描述: 4.2百行助贷-联合贷 实时逾期还款 <br/>
     * 参数:  日期 BaiHangTimeRecord: startTime和endsTime <br/>
     * 返回值:   <br/>
     * 创建人: yanhui.Hao  <br/>
     * 创建时间: 2019.10.28  <br/>
     */
    List<RepaymentInfoZhuDai> findRealTimeRepayMentOverdueLh(BaiHangTimeRecord baiHangTimeRecord);


    List<RepaymentInfoZhuDai> repairOverdue(@Param("planIds")List<Long> planIds,@Param("fundId")Integer fundId);

    List<RepaymentInfoZhuDai> repairNormal(@Param("planIds")List<Long> planIds,@Param("fundId")Integer fundId);

    List<RepaymentInfoZhuDai> repairOverdueLH(@Param("planIds")List<Long> planIds);

    List<RepaymentInfoZhuDai> repairNormalLH(@Param("planIds")List<Long> planIds);

}
