package cn.quantgroup.report.service.manualTool;

import cn.quantgroup.report.domain.master.CallRecord1;
import cn.quantgroup.report.domain.master.TransactionLogPO;
import cn.quantgroup.report.domain.tidbrisk.CallRecord3;
import cn.quantgroup.report.utils.JdbcUtils;
import cn.quantgroup.report.utils.ReadOrWriteTxt;
import com.alibaba.fastjson.JSON;
import com.google.common.base.Stopwatch;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import javax.sql.DataSource;
import java.io.File;
import java.io.IOException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;


/**
 * -----------------------------------------------------------------------------<br>
 * 描述: <br>
 * 作者：yanhui.Hao <br>
 * 时间：2019.12.31 <br>
 * 授权: (C) Copyright (c) 2017 <br>
 * 公司: 北京众信利民信息技术有限公司 <br>
 * -----------------------------------------------------------------------------
 */
@Slf4j
@Service
public class CleanningTransactionLogService {

    @Autowired
    private JdbcTemplate riskDatasourceJdbcTemplate;

    @Autowired
    private JdbcTemplate tidbRiskJdbcTemplate;

    @Autowired
    @Qualifier("tidbRiskDataSource")
    private DataSource tidbRiskDataSource;

   /* @Resource(name = "tidbRiskDataSource")
    private DataSource tidbRiskDataSource2;*/

    public static void main(String[] args) {
//        LocalDateTime now = LocalDateTime.now();
        try {
            Stopwatch stopwatch = Stopwatch.createStarted();
            Map<String, String> map = new HashMap<>();
            Map<String, String> map1 = new HashMap<>();
            for (int i = 0; i < 500000; i++) {
                map.put(new StringBuffer(String.valueOf(i)).append(String.valueOf(i)).append(String.valueOf(i)).append(String.valueOf(i)).toString(), String.valueOf(i));
            }

            for (int i = 0; i < 500000; i++) {
                map1.put(new StringBuffer(String.valueOf(i)).append(String.valueOf(i)).append(String.valueOf(i)).append(String.valueOf(i)).toString(), String.valueOf(i));
            }


            System.out.println(stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

   /* @Async
    public void start() {

        try {
            String tmpTime = "2019-11-23";
            SimpleDateFormat simpleDateFormat1 = new SimpleDateFormat("yyyy-MM-dd");
            LocalDateTime now = new Timestamp(simpleDateFormat1.parse(tmpTime).getTime()).toLocalDateTime();
            for (int i = 0; i < 800; i++) {
                String startTime = now.minusDays(i).format(DateTimeFormatter.ISO_DATE);
                String endTime = now.minusDays(i + 1).format(DateTimeFormatter.ISO_DATE);
                String sql = "select * from transaction_log where time_created > '" + endTime + "' and time_created < '" + startTime + "'";
                Stopwatch queryStopwatch = Stopwatch.createStarted();
                List<TransactionLogPO> transactionLogPOList = riskDatasourceJdbcTemplate.query(sql, new BeanPropertyRowMapper<>(TransactionLogPO.class));
                log.info("transactionLog查询数据结束, startTime: {} , endTime: {} , size: {} , sql: {} , 耗时: {} ", startTime, endTime, CollectionUtils.isEmpty(transactionLogPOList) ? 0 : transactionLogPOList.size(), sql, queryStopwatch.stop().elapsed(TimeUnit.MILLISECONDS));

                if (CollectionUtils.isEmpty(transactionLogPOList)) {
                    log.info("查询数据为空跳过");
                    continue;
                }

                Map<String, TransactionLogPO> transactionLogPOMap = new HashMap<>();
                Map<String, CallRecord1> callRecord1Map = new HashMap<>();

                Stopwatch stopwatch = Stopwatch.createStarted();
                for (int tran = 0; tran < transactionLogPOList.size(); tran++) {
                    TransactionLogPO transactionLogPO = transactionLogPOList.get(tran);
                    String format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(transactionLogPO.getTimeCreated());
                    String key = new StringBuffer(transactionLogPO.getTransactionId()).append(StringUtils.isNotBlank(transactionLogPO.getUuid()) ? transactionLogPO.getUuid() : "").append(transactionLogPO.getUrlType()).append(transactionLogPO.getCode()).append(format).toString();
//                    System.out.println(key);
                    transactionLogPOMap.put(key, transactionLogPO);
                }
                log.info("transactionLog 组装数据完成 查询大小: {} , 组装后大小: {} , 耗时: {} ", transactionLogPOList.size(), transactionLogPOMap.size(), stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));


                Stopwatch callRStopwatch = Stopwatch.createStarted();
                String sql1 = "select * from call_record where created_at > '" + endTime + "' and created_at < '" + startTime + "' order by created_at desc;";
                List<CallRecord1> queryResult = riskDatasourceJdbcTemplate.query(sql1, new BeanPropertyRowMapper<>(CallRecord1.class));
                log.info("callRecord查询数据结束, startTime: {} , endTime: {} , size: {} , sql: {} , 耗时: {} ", startTime, endTime, CollectionUtils.isEmpty(queryResult) ? 0 : queryResult.size(), sql1, callRStopwatch.stop().elapsed(TimeUnit.MILLISECONDS));

                if (CollectionUtils.isNotEmpty(queryResult)) {
                    Stopwatch callStopwatch = Stopwatch.createStarted();
                    for (int call = 0; call < queryResult.size(); call++) {
                        CallRecord1 callRecord1 = queryResult.get(call);
                        String format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(callRecord1.getCreated_at().getTime()));
                        String key = new StringBuffer(callRecord1.getTransactionId()).append(StringUtils.isNotBlank(callRecord1.getUuid()) ? callRecord1.getUuid() : "").append(callRecord1.getUrlType()).append(callRecord1.getCode()).append(format).toString();
                        callRecord1Map.put(key, callRecord1);
                    }
                    log.info("callRecord 组装数据完成 查询大小: {} , 组装后大小: {} , 耗时: {} ", queryResult.size(), callRecord1Map.size(), callStopwatch.stop().elapsed(TimeUnit.MILLISECONDS));

                    Stopwatch delStopwatch = Stopwatch.createStarted();
                    Iterator<Map.Entry<String, TransactionLogPO>> iterator = transactionLogPOMap.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<String, TransactionLogPO> next = iterator.next();
                        String key = next.getKey();
                        if (callRecord1Map.containsKey(key)) {
                            iterator.remove();
                        }
                    }
                    log.info("去重 组装数据完成 查询大小: {} , 组装后大小: {} , 耗时: {} ", queryResult.size(), transactionLogPOMap.size(), delStopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
                }
                if (transactionLogPOMap.size()>0) {
                    List<CallRecord1> callRecord1s = new ArrayList<>();
                    Stopwatch stopwatch1222 = Stopwatch.createStarted();
                    transactionLogPOMap.forEach((k, v)->{
                        TransactionLogPO transactionLogPO = v;
                        CallRecord1 callRecord1 = new CallRecord1();
                        callRecord1.setCode(String.valueOf(transactionLogPO.getCode()));
                        callRecord1.setUrlType(transactionLogPO.getUrlType());
                        callRecord1.setTransactionId(transactionLogPO.getTransactionId());
                        callRecord1.setUuid(transactionLogPO.getUuid());
                        Timestamp time = new Timestamp(transactionLogPO.getTimeCreated().getTime());
                        callRecord1.setCreated_at(time);
                        callRecord1.setUpdated_at(time);

                        callRecord1s.add(callRecord1);
                        if (callRecord1s.size() > 0 && callRecord1s.size() % 1000 == 0) {
                            Stopwatch stopwatch1 = Stopwatch.createStarted();
                            JdbcUtils.prepareBatchUpdateExecuteTransactionid("INSERT INTO `call_record` (`transaction_id`, `uuid`, `url_type`, `code`, `created_at`, `updated_at`) VALUES (?, ?, ?, ?, ?, ?)", callRecord1s);
                            callRecord1s.clear();
                            log.info("插入数据完成, 耗时： {}", stopwatch1.stop().elapsed(TimeUnit.MILLISECONDS));
                        }
                    });
                    if (callRecord1s.size() > 0) {
                        JdbcUtils.prepareBatchUpdateExecuteTransactionid("INSERT INTO `call_record` (`transaction_id`, `uuid`, `url_type`, `code`, `created_at`, `updated_at`) VALUES (?, ?, ?, ?, ?, ?)", callRecord1s);
                    }
                    log.info("一天数据插入完成, 大小: {} , 耗时: {} ", transactionLogPOMap.size(), stopwatch1222.stop().elapsed(TimeUnit.MILLISECONDS));
                }
            }
            log.info("完事");
        } catch (Exception e) {
            log.error("清洗数据异常", e);
        }
    }*/

//    @Async
//    public void start() {
//
//        try {
//            String tmpTime = "2019-12-21";
//            SimpleDateFormat simpleDateFormat1 = new SimpleDateFormat("yyyy-MM-dd");
//            LocalDateTime now = new Timestamp(simpleDateFormat1.parse(tmpTime).getTime()).toLocalDateTime();
//            for (int i = 0; i < 800; i++) {
//                String startTime = now.minusDays(i).format(DateTimeFormatter.ISO_DATE);
//                String endTime = now.minusDays(i + 1).format(DateTimeFormatter.ISO_DATE);
//                String sql = "select * from transaction_log where time_created > '"+ endTime +"' and time_created < '"+startTime+"'";
//                Stopwatch queryStopwatch = Stopwatch.createStarted();
//                List<TransactionLogPO> transactionLogPOList = riskDatasourceJdbcTemplate.query(sql, new BeanPropertyRowMapper<>(TransactionLogPO.class));
//                log.info("查询数据结束, startTime: {} , endTime: {} , size: {} , sql: {} , 耗时: {} ", startTime, endTime, CollectionUtils.isEmpty(transactionLogPOList)?0:transactionLogPOList.size(), sql, queryStopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
//                if(CollectionUtils.isEmpty(transactionLogPOList)){
//                    log.info("查询数据为空跳过");
//                    continue;
//                }
//                Stopwatch oneStopwatch = Stopwatch.createStarted();
//                List<CallRecord1> callRecord1s = new ArrayList<>();
//                for (int j = 0; j < transactionLogPOList.size(); j++) {
//                    try{
//                        TransactionLogPO transactionLogPO = transactionLogPOList.get(j);
//                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
//                        String d = simpleDateFormat.format(transactionLogPO.getTimeCreated());
//                        String sql1 = "";
//                        if(StringUtils.isNotBlank(transactionLogPO.getUuid())){
//                            sql1 = "select * from call_record where transaction_id = '"+transactionLogPO.getTransactionId()+"' and uuid = '" + transactionLogPO.getUuid() + "' and url_type = '" + transactionLogPO.getUrlType() + "' and code = '" + transactionLogPO.getCode() + "' and created_at = '"+d+"';";
//                        }else{
//                            sql1 = "select * from call_record where transaction_id = '"+transactionLogPO.getTransactionId()+"' and url_type = '" + transactionLogPO.getUrlType() + "' and code = '" + transactionLogPO.getCode() + "' and created_at = '"+d+"';";;
//                        }
//                        List<CallRecord1> queryResult = riskDatasourceJdbcTemplate.query(sql1, new BeanPropertyRowMapper<>(CallRecord1.class));
//                        if(CollectionUtils.isEmpty(queryResult)){
////                            log.info("查询结果不为空，重新插入 sql: {} , resutl: {} ", sql1, JSON.toJSONString(queryResult));
//                            CallRecord1 callRecord1 = new CallRecord1();
//                            callRecord1.setCode(String.valueOf(transactionLogPO.getCode()));
//                            callRecord1.setUrlType(transactionLogPO.getUrlType());
//                            callRecord1.setTransactionId(transactionLogPO.getTransactionId());
//                            callRecord1.setUuid(transactionLogPO.getUuid());
//                            Timestamp time = new Timestamp(transactionLogPO.getTimeCreated().getTime());
//                            callRecord1.setCreated_at(time);
//                            callRecord1.setUpdated_at(time);
//
//                            callRecord1s.add(callRecord1);
//                            if(callRecord1s.size()>0 && callRecord1s.size()%1000==0){
//                                Stopwatch stopwatch = Stopwatch.createStarted();
//                                JdbcUtils.prepareBatchUpdateExecuteTransactionid("INSERT INTO `call_record` (`transaction_id`, `uuid`, `url_type`, `code`, `created_at`, `updated_at`) VALUES (?, ?, ?, ?, ?, ?)", callRecord1s);
//                                callRecord1s.clear();
//                                log.info("插入数据完成, 耗时： {}", stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
//                            }
//                        }else{
//                            log.info("命中原有数据不插入");
//                        }
//
//                    }catch(Exception e){
//                        log.error("清洗插入callRecord异常", e);
//                    }
//
//                }
//                if(callRecord1s.size()>0){
//                    JdbcUtils.prepareBatchUpdateExecuteTransactionid("INSERT INTO `call_record` (`transaction_id`, `uuid`, `url_type`, `code`, `created_at`, `updated_at`) VALUES (?, ?, ?, ?, ?, ?)", callRecord1s);
//                    log.info("插入数据完成1, startTime: {} , endTime: {} ,  大小: {} , 耗时: {} ", startTime, endTime, transactionLogPOList.size(), oneStopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
//                }
//
//            }
//            log.info("完事");
//        } catch (Exception e) {
//            log.error("清洗数据异常", e);
//        }
//    }

    /*
    @Async
    public void synCallRecord(String newYnrTime) {//yyyy-MM-dd
        try {
            SimpleDateFormat simpleDateFormat1 = new SimpleDateFormat("yyyy-MM-dd");
            LocalDateTime now = new Timestamp(simpleDateFormat1.parse(newYnrTime).getTime()).toLocalDateTime();

            //开始时间 2018-10-17 11:30:39
            //结束时间 2019-12-31 10:36:34
            //相差440天
            for (int i = 0; i < 500; i++) {
                String startTime = now.minusDays(i+1).format(DateTimeFormatter.ISO_DATE);
                String endTime = now.minusDays(i).format(DateTimeFormatter.ISO_DATE);

                String TRANSACTION_SQL = "select transaction_id, uuid, url_type, code, time_created " +
                        " from transaction_log where time_created >= '" + startTime + "' and time_created < '" + endTime + "'";

                Stopwatch queryStopwatch = Stopwatch.createStarted();
                List<TransactionLogPO> transactionLogPOList = riskDatasourceJdbcTemplate.query(TRANSACTION_SQL, new BeanPropertyRowMapper<>(TransactionLogPO.class));
                log.info("transactionLog查询数据结束, startTime: {} , endTime: {} , size: {} , sql: {} , 耗时: {} ", startTime, endTime, CollectionUtils.isEmpty(transactionLogPOList) ? 0 : transactionLogPOList.size(), TRANSACTION_SQL, queryStopwatch.stop().elapsed(TimeUnit.MILLISECONDS));

                if (CollectionUtils.isEmpty(transactionLogPOList)) {
                    log.info("查询数据为空跳过, startTime: {} , endTime: {} ",startTime, endTime);
                    continue;
                }

                Map<String, TransactionLogPO> transactionLogPOMap = new HashMap<>();
                Stopwatch stopwatch = Stopwatch.createStarted();
                for (int tran = 0; tran < transactionLogPOList.size(); tran++) {
                    TransactionLogPO transactionLogPO = transactionLogPOList.get(tran);
                    String format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(transactionLogPO.getTimeCreated());
                    String key = new StringBuffer(transactionLogPO.getTransactionId())
                            .append(StringUtils.isNotBlank(transactionLogPO.getUuid()) ? transactionLogPO.getUuid() : "")
                            .append(transactionLogPO.getUrlType())
                            .append(transactionLogPO.getCode())
                            .append(format).toString();
                    transactionLogPOMap.put(key, transactionLogPO);
                }
                log.info("transactionLog组装数据完成, startTime: {} , 查询大小: {} , 组装后大小: {} , 耗时: {} ", startTime, transactionLogPOList.size(), transactionLogPOMap.size(), stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));


                Stopwatch callRStopwatch = Stopwatch.createStarted();
                String CALL_SQL = "select request_url, channel_type, channel_id, transaction_id, uuid, url_type, code, created_at, updated_at " +
                        " from call_record where created_at >= '" + startTime + "' and created_at < '" + endTime + "' order by created_at desc;";
                List<CallRecord1> queryResult = riskDatasourceJdbcTemplate.query(CALL_SQL, new BeanPropertyRowMapper<>(CallRecord1.class));
                log.info("callRecord查询数据结束, startTime: {} , endTime: {} , size: {} , sql: {} , 耗时: {} ", startTime, endTime, CollectionUtils.isEmpty(queryResult) ? 0 : queryResult.size(), CALL_SQL, callRStopwatch.stop().elapsed(TimeUnit.MILLISECONDS));

                Map<String, CallRecord1> callRecord1Map = new HashMap<>();

                if (CollectionUtils.isNotEmpty(queryResult)) {
                    Stopwatch callStopwatch = Stopwatch.createStarted();
                    for (int call = 0; call < queryResult.size(); call++) {
                        CallRecord1 callRecord1 = queryResult.get(call);
                        String format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(callRecord1.getCreated_at().getTime()));
                        String key = new StringBuffer(callRecord1.getTransactionId())
                                .append(StringUtils.isNotBlank(callRecord1.getUuid()) ? callRecord1.getUuid() : "")
                                .append(callRecord1.getUrlType())
                                .append(callRecord1.getCode())
                                .append(format).toString();
                        callRecord1Map.put(key, callRecord1);
                    }
                    log.info("callRecord组装数据完成, startTime: {} , 查询大小: {} , 组装后大小: {} , 耗时: {} ", startTime, queryResult.size(), callRecord1Map.size(), callStopwatch.stop().elapsed(TimeUnit.MILLISECONDS));

                    Stopwatch delStopwatch = Stopwatch.createStarted();
                    Iterator<Map.Entry<String, TransactionLogPO>> iterator = transactionLogPOMap.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<String, TransactionLogPO> next = iterator.next();
                        String key = next.getKey();
                        if (callRecord1Map.containsKey(key)) {
                            iterator.remove();
                        }
                    }
                    log.info("去重组装数据完成, startTime: {} , callRecord查询大小: {} , 组装后transactionLogPOMap大小: {} , 耗时: {} ", startTime, queryResult.size(), transactionLogPOMap.size(), delStopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
                }

                if (transactionLogPOMap.size()>0) {
                    List<CallRecord1> callRecord1s = new ArrayList<>();
                    Stopwatch stopwatch1222 = Stopwatch.createStarted();

                    transactionLogPOMap.forEach((k, v)->{
                        TransactionLogPO transactionLogPO = v;
                        //c.request_url, c.channel_type, c.channel_id
                        CallRecord1 callRecord1 = new CallRecord1();
                        callRecord1.setCode(String.valueOf(transactionLogPO.getCode()));
                        callRecord1.setUrlType(transactionLogPO.getUrlType());
                        callRecord1.setTransactionId(transactionLogPO.getTransactionId());
                        callRecord1.setUuid(transactionLogPO.getUuid());

                        Timestamp time = new Timestamp(transactionLogPO.getTimeCreated().getTime());
                        callRecord1.setCreated_at(time);
                        callRecord1.setUpdated_at(time);

                        callRecord1s.add(callRecord1);
                        if (callRecord1s.size() > 0 && callRecord1s.size() % 1000 == 0) {
                            Stopwatch stopwatch1 = Stopwatch.createStarted();
                            JdbcUtils.prepareBatchUpdateExecuteTransactionid("INSERT INTO `call_record` (`transaction_id`, `uuid`, `url_type`, `code`, `created_at`, `updated_at`) VALUES (?, ?, ?, ?, ?, ?)", callRecord1s);
                            callRecord1s.clear();
                            log.info("插入数据完成, 耗时： {}", stopwatch1.stop().elapsed(TimeUnit.MILLISECONDS));
                        }
                    });
                    if (callRecord1s.size() > 0) {
                        JdbcUtils.prepareBatchUpdateExecuteTransactionid("INSERT INTO `call_record` (`transaction_id`, `uuid`, `url_type`, `code`, `created_at`, `updated_at`) VALUES (?, ?, ?, ?, ?, ?)", callRecord1s);
                    }
                    log.info("一天数据插入完成, 大小: {} , 耗时: {} ", transactionLogPOMap.size(), stopwatch1222.stop().elapsed(TimeUnit.MILLISECONDS));
                }
            }
            log.info("完事");
        } catch (Exception e) {
            log.error("清洗数据异常", e);
        }
    }
    */

    @Async
    public void synCallRecordNew(String newYnrTime, String isExecuteOnce) {//yyyy-MM-dd
        try {
            boolean executeOnce = false;
            if(StringUtils.isNotEmpty(isExecuteOnce) && "true".equals(isExecuteOnce)){
                executeOnce = true;
            }

            SimpleDateFormat simpleDateFormat1 = new SimpleDateFormat("yyyy-MM-dd");
            LocalDateTime now = new Timestamp(simpleDateFormat1.parse(newYnrTime).getTime()).toLocalDateTime();

            //开始时间 2018-10-17 11:30:39
            //结束时间 2019-12-31 10:36:34
            //相差440天
            for (int i = 0; i < 500; i++) {
                String startTime = now.minusDays(i+1).format(DateTimeFormatter.ISO_DATE);
                String endTime = now.minusDays(i).format(DateTimeFormatter.ISO_DATE);

                String TRANSACTION_SQL = "select request_url, channel_type, channel_id, transaction_id, uuid, url_type, code, created_at, updated_at " +
                        " from call_record where created_at >= '" + startTime + "' and created_at < '" + endTime + "'";

                Stopwatch queryStopwatch = Stopwatch.createStarted();
                List<CallRecord3> transactionLogPOList = riskDatasourceJdbcTemplate.query(TRANSACTION_SQL, new BeanPropertyRowMapper<>(CallRecord3.class));
                log.info("transactionLog查询数据结束, startTime: {} , endTime: {} , size: {} , sql: {} , 耗时: {} ", startTime, endTime, CollectionUtils.isEmpty(transactionLogPOList) ? 0 : transactionLogPOList.size(), TRANSACTION_SQL, queryStopwatch.stop().elapsed(TimeUnit.MILLISECONDS));

                if (CollectionUtils.isEmpty(transactionLogPOList)) {
                    log.info("查询数据为空跳过, startTime: {} , endTime: {} ",startTime, endTime);
                    continue;
                }

                Map<String, CallRecord3> transactionLogPOMap = new HashMap<>();
                Stopwatch stopwatch = Stopwatch.createStarted();
                for (int tran = 0; tran < transactionLogPOList.size(); tran++) {
                    CallRecord3 transactionLogPO = transactionLogPOList.get(tran);
                    String format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(transactionLogPO.getCreatedAt());

                    String key = new StringBuffer(transactionLogPO.getTransactionId())
                            .append(StringUtils.isNotBlank(transactionLogPO.getUuid()) ? transactionLogPO.getUuid() : "")
                            .append(transactionLogPO.getUrlType())
                            .append(transactionLogPO.getCode())
                            .append(format).toString();
                    transactionLogPOMap.put(key, transactionLogPO);
                }
                log.info("transactionLog组装数据完成, startTime: {} , 查询大小: {} , 组装后大小: {} , 耗时: {} ", startTime, transactionLogPOList.size(), transactionLogPOMap.size(), stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));

                Stopwatch callRStopwatch = Stopwatch.createStarted();
                String CALL_SQL = "select transaction_id, uuid, url_type, code, created_at " +
                        " from call_record where created_at >= '" + startTime + "' and created_at < '" + endTime + "' order by created_at desc;";
                List<CallRecord1> queryResult = tidbRiskJdbcTemplate.query(CALL_SQL, new BeanPropertyRowMapper<>(CallRecord1.class));
                log.info("callRecord查询数据结束, startTime: {} , endTime: {} , size: {} , sql: {} , 耗时: {} ", startTime, endTime, CollectionUtils.isEmpty(queryResult) ? 0 : queryResult.size(), CALL_SQL, callRStopwatch.stop().elapsed(TimeUnit.MILLISECONDS));

                Map<String, CallRecord1> callRecord1Map = new HashMap<>();

                if (CollectionUtils.isNotEmpty(queryResult)) {
                    Stopwatch callStopwatch = Stopwatch.createStarted();
                    for (int call = 0; call < queryResult.size(); call++) {
                        CallRecord1 callRecord1 = queryResult.get(call);
                        String format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(callRecord1.getCreated_at().getTime()));
                        String key = new StringBuffer(callRecord1.getTransactionId())
                                .append(StringUtils.isNotBlank(callRecord1.getUuid()) ? callRecord1.getUuid() : "")
                                .append(callRecord1.getUrlType())
                                .append(callRecord1.getCode())
                                .append(format).toString();
                        callRecord1Map.put(key, callRecord1);
                    }
                    log.info("callRecord组装数据完成, startTime: {} , 查询大小: {} , 组装后大小: {} , 耗时: {} ", startTime, queryResult.size(), callRecord1Map.size(), callStopwatch.stop().elapsed(TimeUnit.MILLISECONDS));

                    Stopwatch delStopwatch = Stopwatch.createStarted();
                    Iterator<Map.Entry<String, CallRecord3>> iterator = transactionLogPOMap.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<String, CallRecord3> next = iterator.next();
                        String key = next.getKey();
                        if (callRecord1Map.containsKey(key)) {
                            iterator.remove();
                        }
                    }
                    log.info("去重组装数据完成, startTime: {} , callRecord查询大小: {} , 组装后transactionLogPOMap大小: {} , 耗时: {} ", startTime, queryResult.size(), transactionLogPOMap.size(), delStopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
                }

                if (transactionLogPOMap.size()>0) {
                    List<CallRecord3> callRecord3List = new ArrayList<>();
                    Stopwatch stopwatch1222 = Stopwatch.createStarted();

                    AtomicInteger pageNum = new AtomicInteger();
                    String INSERT_SQL = "INSERT INTO `call_record` (`request_url`, `channel_type`, `channel_id`, `transaction_id`, `uuid`, `url_type`, `code`, `created_at`, `updated_at`) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?) ";
                    transactionLogPOMap.forEach((k, v)->{
                        callRecord3List.add(v);

                        if (callRecord3List.size() > 0 && callRecord3List.size() % 1000 == 0) {
                            Stopwatch stopwatch1 = Stopwatch.createStarted();

                            JdbcUtils.batchUpdateExecuteCallRecord(tidbRiskDataSource,INSERT_SQL, callRecord3List);
                            callRecord3List.clear();
                            pageNum.getAndIncrement();

                            log.info("插入数据完成, pageNum: {} , 耗时: {} ", pageNum.get(), stopwatch1.stop().elapsed(TimeUnit.MILLISECONDS));
                        }
                    });
                    if (callRecord3List.size() > 0) {
                        JdbcUtils.batchUpdateExecuteCallRecord(tidbRiskDataSource,INSERT_SQL, callRecord3List);
                        pageNum.getAndIncrement();
                    }
                    log.info("一天数据插入完成, startTime: {} , pageNum: {} , 大小: {} , 耗时: {} ",startTime, pageNum.get(), transactionLogPOMap.size(), stopwatch1222.stop().elapsed(TimeUnit.MILLISECONDS));
                }else{
                    log.info("一天数据插入完成, startTime: {} , transactionLogPOMap size is Empty!",startTime);
                }

                if(executeOnce){
                    log.info("一天数据插入完成, newYnrTime: {} , isExecuteOnce: {} , startTime: {} , endTime: {} ,",newYnrTime, isExecuteOnce, startTime, endTime);
                    break;
                }
            }
            log.info("----All清洗数据结束----");
        } catch (Exception e) {
            log.error("清洗数据异常", e);
        }
    }


    /**
     * 描述: 检测tidb的call_record表数据是否有重复数据 <br/>
     * 参数: [newYnrTime, isExecuteOnce]  <br/>
     * 返回值: void  <br/>
     * 创建人: yanhui.Hao  <br/>
     * 创建时间: 2020.01.02  <br/>
     */
    @Async
    public void checkCallRecordCF(String newYnrTime, String isExecuteOnce) { //yyyy-MM-dd
        try {
            boolean executeOnce = false;
            if(StringUtils.isNotEmpty(isExecuteOnce) && "true".equals(isExecuteOnce)){
                executeOnce = true;
            }

            SimpleDateFormat simpleDateFormat1 = new SimpleDateFormat("yyyy-MM-dd");
            LocalDateTime now = new Timestamp(simpleDateFormat1.parse(newYnrTime).getTime()).toLocalDateTime();

            //开始时间 2018-10-17 11:30:39
            //结束时间 2019-12-31 10:36:34
            //相差440天
            for (int i = 0; i < 500; i++) {
                String startTime = now.minusDays(i+1).format(DateTimeFormatter.ISO_DATE);
                String endTime = now.minusDays(i).format(DateTimeFormatter.ISO_DATE);

                Stopwatch callRStopwatch = Stopwatch.createStarted();
                String CALL_SQL = "select transaction_id, uuid, url_type, code, created_at " +
                        " from call_record where created_at >= '" + startTime + "' and created_at < '" + endTime + "'";
                List<CallRecord1> queryResult = tidbRiskJdbcTemplate.query(CALL_SQL, new BeanPropertyRowMapper<>(CallRecord1.class));
                log.info("checkCallRecordCF检测重复callRecord查询数据结束, startTime: {} , endTime: {} , size: {} , sql: {} , 耗时: {} ", startTime, endTime, CollectionUtils.isEmpty(queryResult) ? 0 : queryResult.size(), CALL_SQL, callRStopwatch.stop().elapsed(TimeUnit.MILLISECONDS));

                Map<String, Integer> callRecord1Map = new HashMap<>();

                if (CollectionUtils.isNotEmpty(queryResult)) {
                    Stopwatch callStopwatch = Stopwatch.createStarted();
                    for (int call = 0; call < queryResult.size(); call++) {
                        CallRecord1 callRecord1 = queryResult.get(call);
                        String format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(callRecord1.getCreated_at().getTime()));
                        String key = new StringBuffer(callRecord1.getTransactionId()).append(",")
                                .append(StringUtils.isNotBlank(callRecord1.getUuid()) ? callRecord1.getUuid() : "").append(",")
                                .append(callRecord1.getUrlType()).append(",")
                                .append(callRecord1.getCode()).append(",")
                                .append(format).toString();

                        if(callRecord1Map.containsKey(key)){
                            callRecord1Map.put(key, callRecord1Map.get(key).intValue()+1);
                        }else{
                            callRecord1Map.put(key, 1);
                        }
                    }
                    log.info("checkCallRecordCF检测重复callRecord组装数据完成, startTime: {} , 查询List大小: {} , 组装后Map大小: {} , 耗时: {} ", startTime, queryResult.size(), callRecord1Map.size(), callStopwatch.stop().elapsed(TimeUnit.MILLISECONDS));

                    Stopwatch delStopwatch = Stopwatch.createStarted();
                    Iterator<Map.Entry<String, Integer>> iterator = callRecord1Map.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<String, Integer> next = iterator.next();
                        String key = next.getKey();
                        Integer value = next.getValue();
                        if (value!=null && value.intValue() >1 ) {
                            log.info("checkCallRecordCF检测重复发现有重复数据, startTime: {} , 重复次数value: {} , key: {} ", startTime, value, key);
                        }else{
                            iterator.remove();
                        }
                    }
                    log.info("checkCallRecordCF检测重复数据结束, startTime: {} , 查询List大小: {} , 过滤后callRecord1Map大小: {} , 耗时: {} ", startTime, queryResult.size(), callRecord1Map.size(), delStopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
                }

                if(executeOnce){
                    log.info("checkCallRecordCF检测重复一天数据完成, newYnrTime: {} , isExecuteOnce: {} , startTime: {} , endTime: {} ,",newYnrTime, isExecuteOnce, startTime, endTime);
                    break;
                }
            }
            log.info("----checkCallRecordCF---All检测重复数据结束----");
        } catch (Exception e) {
            log.error("checkCallRecordCF检测重复数据异常", e);
        }
    }


    @Async
    public void checkTransactionLogCF(String newYnrTime, String isExecuteOnce) { //yyyy-MM-dd
        try {
            boolean executeOnce = false;
            if(StringUtils.isNotEmpty(isExecuteOnce) && "true".equals(isExecuteOnce)){
                executeOnce = true;
            }

            SimpleDateFormat simpleDateFormat1 = new SimpleDateFormat("yyyy-MM-dd");
            LocalDateTime now = new Timestamp(simpleDateFormat1.parse(newYnrTime).getTime()).toLocalDateTime();

            //开始时间 2018-10-17 11:30:39
            //结束时间 2019-12-31 10:36:34
            //相差440天
            for (int i = 0; i < 500; i++) {
                String startTime = now.minusDays(i+1).format(DateTimeFormatter.ISO_DATE);
                String endTime = now.minusDays(i).format(DateTimeFormatter.ISO_DATE);

                Stopwatch callRStopwatch = Stopwatch.createStarted();
                String CALL_SQL = "select transaction_id, uuid, url_type, code, time_created " +
                        " from transaction_log t where t.time_created >= '" + startTime + "' and t.time_created < '" + endTime + "'";
                List<TransactionLogPO> queryResult = riskDatasourceJdbcTemplate.query(CALL_SQL, new BeanPropertyRowMapper<>(TransactionLogPO.class));
                log.info("checkTransactionLogCF检测重复transaction_log查询数据结束, startTime: {} , endTime: {} , size: {} , sql: {} , 耗时: {} ", startTime, endTime, CollectionUtils.isEmpty(queryResult) ? 0 : queryResult.size(), CALL_SQL, callRStopwatch.stop().elapsed(TimeUnit.MILLISECONDS));

                Map<String, Integer> callRecord1Map = new HashMap<>();

                if (CollectionUtils.isNotEmpty(queryResult)) {
                    Stopwatch callStopwatch = Stopwatch.createStarted();
                    for (int call = 0; call < queryResult.size(); call++) {
                        TransactionLogPO callRecord1 = queryResult.get(call);
                        String format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(callRecord1.getTimeCreated());
                        String key = new StringBuffer(callRecord1.getTransactionId()).append(",")
                                .append(StringUtils.isNotBlank(callRecord1.getUuid()) ? callRecord1.getUuid() : "").append(",")
                                .append(callRecord1.getUrlType()).append(",")
                                .append(callRecord1.getCode()).append(",")
                                .append(format).toString();

                        if(callRecord1Map.containsKey(key)){
                            callRecord1Map.put(key, callRecord1Map.get(key).intValue()+1);
                        }else{
                            callRecord1Map.put(key, 1);
                        }
                    }
                    log.info("checkTransactionLogCF检测重复transaction组装数据完成, startTime: {} , 查询List大小: {} , 组装后Map大小: {} , 耗时: {} ", startTime, queryResult.size(), callRecord1Map.size(), callStopwatch.stop().elapsed(TimeUnit.MILLISECONDS));

                    Stopwatch delStopwatch = Stopwatch.createStarted();
                    Iterator<Map.Entry<String, Integer>> iterator = callRecord1Map.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<String, Integer> next = iterator.next();
                        String key = next.getKey();
                        Integer value = next.getValue();
                        if (value!=null && value.intValue() >1 ) {
                            log.info("checkTransactionLogCF检测重复发现有重复数据, startTime: {} , 重复次数value: {} , key: {} ", startTime, value, key);
                        }else{
                            iterator.remove();
                        }
                    }
                    log.info("checkTransactionLogCF检测重复数据结束, startTime: {} , 查询List大小: {} , 过滤后transaction Map大小: {} , 耗时: {} ", startTime, queryResult.size(), callRecord1Map.size(), delStopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
                }

                if(executeOnce){
                    log.info("checkTransactionLogCF检测重复一天数据完成, newYnrTime: {} , isExecuteOnce: {} , startTime: {} , endTime: {} ,",newYnrTime, isExecuteOnce, startTime, endTime);
                    break;
                }
            }
            log.info("----checkTransactionLogCF---All检测重复数据结束----");
        } catch (Exception e) {
            log.error("checkTransactionLogCF检测重复数据异常", e);
        }
    }

    @Async
    public void checkCallRecordCFByTransactionLog(String newYnrTime, String isExecuteOnce) {//yyyy-MM-dd
        try {
            boolean executeOnce = false;
            if(StringUtils.isNotEmpty(isExecuteOnce) && "true".equals(isExecuteOnce)){
                executeOnce = true;
            }

            SimpleDateFormat simpleDateFormat1 = new SimpleDateFormat("yyyy-MM-dd");
            LocalDateTime now = new Timestamp(simpleDateFormat1.parse(newYnrTime).getTime()).toLocalDateTime();

            //开始时间 2018-10-17 11:30:39
            //结束时间 2019-12-31 10:36:34
            //相差440天
            for (int i = 0; i < 500; i++) {
                String startTime = now.minusDays(i+1).format(DateTimeFormatter.ISO_DATE);
                String endTime = now.minusDays(i).format(DateTimeFormatter.ISO_DATE);

                String TRANSACTION_SQL = "select transaction_id, uuid, url_type, code, time_created " +
                        " from transaction_log where time_created >= '" + startTime + "' and time_created < '" + endTime + "'";

                Stopwatch queryStopwatch = Stopwatch.createStarted();
                List<TransactionLogPO> transactionLogPOList = riskDatasourceJdbcTemplate.query(TRANSACTION_SQL, new BeanPropertyRowMapper<>(TransactionLogPO.class));
                log.info("transactionLog查询数据结束, startTime: {} , endTime: {} , size: {} , sql: {} , 耗时: {} ", startTime, endTime, CollectionUtils.isEmpty(transactionLogPOList) ? 0 : transactionLogPOList.size(), TRANSACTION_SQL, queryStopwatch.stop().elapsed(TimeUnit.MILLISECONDS));

                if (CollectionUtils.isEmpty(transactionLogPOList)) {
                    log.info("查询数据为空跳过, startTime: {} , endTime: {} ",startTime, endTime);
                    continue;
                }

                Map<String, TransactionLogPO> transactionLogPOMap = new HashMap<>();
                Stopwatch stopwatch = Stopwatch.createStarted();
                for (int tran = 0; tran < transactionLogPOList.size(); tran++) {
                    TransactionLogPO transactionLogPO = transactionLogPOList.get(tran);
                    String format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(transactionLogPO.getTimeCreated());

                    String key = new StringBuffer(transactionLogPO.getTransactionId()).append(",")
                            .append(StringUtils.isNotBlank(transactionLogPO.getUuid()) ? transactionLogPO.getUuid() : "").append(",")
                            .append(transactionLogPO.getUrlType()).append(",")
                            .append(transactionLogPO.getCode()).append(",")
                            .append(format).toString();
                    transactionLogPOMap.put(key, transactionLogPO);
                }
                log.info("transactionLog组装数据完成, startTime: {} , 查询大小: {} , 组装后大小: {} , 耗时: {} ", startTime, transactionLogPOList.size(), transactionLogPOMap.size(), stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));

                Stopwatch callRStopwatch = Stopwatch.createStarted();
                String CALL_SQL = "select transaction_id, uuid, url_type, code, created_at " +
                        " from call_record where created_at >= '" + startTime + "' and created_at < '" + endTime + "' order by created_at desc;";
                List<CallRecord1> queryResult = tidbRiskJdbcTemplate.query(CALL_SQL, new BeanPropertyRowMapper<>(CallRecord1.class));
                log.info("callRecord查询数据结束, startTime: {} , endTime: {} , size: {} , sql: {} , 耗时: {} ", startTime, endTime, CollectionUtils.isEmpty(queryResult) ? 0 : queryResult.size(), CALL_SQL, callRStopwatch.stop().elapsed(TimeUnit.MILLISECONDS));

                Map<String, CallRecord1> callRecord1Map = new HashMap<>();

                if (CollectionUtils.isNotEmpty(queryResult)) {
                    Stopwatch callStopwatch = Stopwatch.createStarted();
                    for (int call = 0; call < queryResult.size(); call++) {
                        CallRecord1 callRecord1 = queryResult.get(call);
                        String format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(callRecord1.getCreated_at().getTime()));
                        String key = new StringBuffer(callRecord1.getTransactionId()).append(",")
                                .append(StringUtils.isNotBlank(callRecord1.getUuid()) ? callRecord1.getUuid() : "").append(",")
                                .append(callRecord1.getUrlType()).append(",")
                                .append(callRecord1.getCode()).append(",")
                                .append(format).toString();
                        callRecord1Map.put(key, callRecord1);
                    }
                    log.info("callRecord组装数据完成, startTime: {} , 查询大小: {} , 组装后大小: {} , 耗时: {} ", startTime, queryResult.size(), callRecord1Map.size(), callStopwatch.stop().elapsed(TimeUnit.MILLISECONDS));

                    Stopwatch delStopwatch = Stopwatch.createStarted();
                    Iterator<Map.Entry<String, TransactionLogPO>> iterator = transactionLogPOMap.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<String, TransactionLogPO> next = iterator.next();
                        String key = next.getKey();
                        if (callRecord1Map.containsKey(key)) {
                            iterator.remove();
                        }
                    }
                    log.info("去重组装数据完成, startTime: {} , callRecord查询大小: {} , 组装后transactionLogPOMap大小: {} , 耗时: {} ", startTime, queryResult.size(), transactionLogPOMap.size(), delStopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
                }

                if (transactionLogPOMap.size()>0) {
                    Stopwatch stopwatch1222 = Stopwatch.createStarted();
                    AtomicInteger countNum = new AtomicInteger();

                    transactionLogPOMap.forEach((k, v)->{
                        countNum.getAndIncrement();
                        log.info("检测transactionLogPOMap不为空, startTime: {} , ST: {} , mapkey: {} ",startTime, countNum.get(), k);
                    });

                    log.info("一天数据插入完成, startTime: {} , countNum: {} , Map大小: {} , 耗时: {} ",startTime, countNum.get(), transactionLogPOMap.size(), stopwatch1222.stop().elapsed(TimeUnit.MILLISECONDS));
                }else{
                    log.info("一天数据插入完成, startTime: {} , transactionLogPOMap size is Empty!",startTime);
                }


                if(executeOnce){
                    log.info("一天数据插入完成, newYnrTime: {} , isExecuteOnce: {} , startTime: {} , endTime: {} ,",newYnrTime, isExecuteOnce, startTime, endTime);
                    break;
                }
            }
            log.info("----All清洗数据结束----");
        } catch (Exception e) {
            log.error("清洗数据异常", e);
        }
    }


    @Async
    public void checkCallRecordCFByTransactionLog2(String newYnrTime, String isExecuteOnce) {//yyyy-MM-dd
        try {
            boolean executeOnce = false;
            if(StringUtils.isNotEmpty(isExecuteOnce) && "true".equals(isExecuteOnce)){
                executeOnce = true;
            }

            SimpleDateFormat simpleDateFormat1 = new SimpleDateFormat("yyyy-MM-dd");
            LocalDateTime now = new Timestamp(simpleDateFormat1.parse(newYnrTime).getTime()).toLocalDateTime();

            //开始时间 2018-10-17 11:30:39
            //结束时间 2019-12-31 10:36:34
            //相差440天
            for (int i = 0; i < 500; i++) {
                String startTime = now.minusDays(i+1).format(DateTimeFormatter.ISO_DATE);
                String endTime = now.minusDays(i).format(DateTimeFormatter.ISO_DATE);

                String TRANSACTION_SQL = "select transaction_id, uuid, url_type, code, time_created " +
                        " from transaction_log where time_created >= '" + startTime + "' and time_created < '" + endTime + "'";

                Stopwatch queryStopwatch = Stopwatch.createStarted();
                List<TransactionLogPO> transactionLogPOList = riskDatasourceJdbcTemplate.query(TRANSACTION_SQL, new BeanPropertyRowMapper<>(TransactionLogPO.class));
                log.info("transactionLog查询数据结束CCFByT, startTime: {} , endTime: {} , size: {} , 耗时: {} ", startTime, endTime, CollectionUtils.isEmpty(transactionLogPOList) ? 0 : transactionLogPOList.size(), queryStopwatch.stop().elapsed(TimeUnit.MILLISECONDS));

                if (CollectionUtils.isEmpty(transactionLogPOList)) {
                    log.info("查询数据为空跳过CCFByT, startTime: {} , endTime: {} ",startTime, endTime);
                    continue;
                }

                Map<String, TransactionLogPO> transactionLogPOMap = new HashMap<>();
                Stopwatch stopwatch = Stopwatch.createStarted();
                for (int tran = 0; tran < transactionLogPOList.size(); tran++) {
                    TransactionLogPO transactionLogPO = transactionLogPOList.get(tran);
                    String format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(transactionLogPO.getTimeCreated());

                    String key = new StringBuffer(transactionLogPO.getTransactionId()).append(",")
                            .append(StringUtils.isNotBlank(transactionLogPO.getUuid()) ? transactionLogPO.getUuid() : "").append(",")
                            .append(transactionLogPO.getUrlType()).append(",")
                            .append(transactionLogPO.getCode()).append(",")
                            .append(format).toString();
                    transactionLogPOMap.put(key, transactionLogPO);
                }
                log.info("transactionLog REMOVE数据完成CCFByT, startTime: {} , 查询大小: {} , 组装后大小: {} , 耗时: {} ", startTime, transactionLogPOList.size(), transactionLogPOMap.size(), stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));

                Stopwatch callRStopwatch = Stopwatch.createStarted();
                String CALL_SQL = "select transaction_id, uuid, url_type, code, created_at " +
                        " from call_record where created_at >= '" + startTime + "' and created_at < '" + endTime + "' order by created_at desc;";
                List<CallRecord1> queryResult = tidbRiskJdbcTemplate.query(CALL_SQL, new BeanPropertyRowMapper<>(CallRecord1.class));
                log.info("callRecord查询数据结束CCFByT, startTime: {} , endTime: {} , size: {} , 耗时: {} ", startTime, endTime, CollectionUtils.isEmpty(queryResult) ? 0 : queryResult.size(), callRStopwatch.stop().elapsed(TimeUnit.MILLISECONDS));

                Map<String, CallRecord1> callRecord1Map = new HashMap<>();

                if (CollectionUtils.isNotEmpty(queryResult)) {
                    Stopwatch callStopwatch = Stopwatch.createStarted();
                    for (int call = 0; call < queryResult.size(); call++) {
                        CallRecord1 callRecord1 = queryResult.get(call);
                        String format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(callRecord1.getCreated_at().getTime()));
                        String key = new StringBuffer(callRecord1.getTransactionId()).append(",")
                                .append(StringUtils.isNotBlank(callRecord1.getUuid()) ? callRecord1.getUuid() : "").append(",")
                                .append(callRecord1.getUrlType()).append(",")
                                .append(callRecord1.getCode()).append(",")
                                .append(format).toString();
                        callRecord1Map.put(key, callRecord1);
                    }
                    log.info("callRecord组装数据完成CCFByT, startTime: {} , 查询大小: {} , 组装后大小: {} , 耗时: {} ", startTime, queryResult.size(), callRecord1Map.size(), callStopwatch.stop().elapsed(TimeUnit.MILLISECONDS));

                    Stopwatch delStopwatch = Stopwatch.createStarted();
                    Iterator<Map.Entry<String, TransactionLogPO>> iterator = transactionLogPOMap.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<String, TransactionLogPO> next = iterator.next();
                        String key = next.getKey();
                        if (callRecord1Map.containsKey(key)) {
                            iterator.remove();
                            callRecord1Map.remove(key);
                        }
                    }
                    log.info("去相同据完成CCFByT, startTime: {} , callRecord1Map大小: {} , transactionLogPOMap大小: {} , 耗时: {} ", startTime, callRecord1Map.size(), transactionLogPOMap.size(), delStopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
                }

                String path = "/home/quant_group/baihang-report/logs/transaction_call/";
                if (transactionLogPOMap.size()>0) {
                    Stopwatch stopwatch1222 = Stopwatch.createStarted();
                    AtomicInteger countNum = new AtomicInteger();
                    transactionLogPOMap.forEach((k, v)->{
                        countNum.getAndIncrement();
                        try {
                            FileUtils.write(new File(path +"transaction_start_"+startTime+".txt"), k+"\r\n", "UTF-8", true);
                        } catch (IOException e) {
                            e.printStackTrace();
                        }
                    });
                    log.info("写入transaction_log多出的数据结束CCFByT, startTime: {} , countNum: {} , Map大小: {} , 耗时: {} ",startTime, countNum.get(), transactionLogPOMap.size(), stopwatch1222.stop().elapsed(TimeUnit.MILLISECONDS));
                }else{
                    log.info("写入transaction_log多出的数据结束CCFByT, startTime: {} , transactionLogPOMap size is Empty!",startTime);
                }

                if (callRecord1Map.size()>0) {
                    Stopwatch stopwatch3 = Stopwatch.createStarted();
                    AtomicInteger countNum3 = new AtomicInteger();
                    callRecord1Map.forEach((key, v)->{
                        countNum3.getAndIncrement();
                        try {
                            FileUtils.write(new File(path +"callRecord_start_"+startTime+".txt"), key+"\r\n", "UTF-8", true);
                        } catch (IOException e) {
                            e.printStackTrace();
                        }
                    });
                    log.info("写入call_record多出的数据结束CCFByT, startTime: {} , countNum: {} , Map大小: {} , 耗时: {} ",startTime, countNum3.get(), callRecord1Map.size(), stopwatch3.stop().elapsed(TimeUnit.MILLISECONDS));
                }else{
                    log.info("写入call_record多出的数据结束CCFByT, startTime: {} , transactionLogPOMap size is Empty!",startTime);
                }


                if(executeOnce){
                    log.info("比较数据完成CCFByT, newYnrTime: {} , isExecuteOnce: {} , startTime: {} , endTime: {} ,",newYnrTime, isExecuteOnce, startTime, endTime);
                    break;
                }
            }
            log.info("----All比较数据完成CCFByT----");
        } catch (Exception e) {
            log.error("比较数据异常CCFByT", e);
        }
    }


    @Async
    public void deleteTidbCallRecordCF(String cfFileName, String bakFileName) {
        try {
            List<String> tidbCallRecordCFList = ReadOrWriteTxt.readTxtList(cfFileName);
            log.info("读取文件cfFileName: {} , tidbCallRecordCFList大小:{} ",cfFileName,tidbCallRecordCFList.size());

            for (int i = 0; i < tidbCallRecordCFList.size(); i++) {
                //ee86810a076d45d58a5d87d7cfc60e8f,032f14da-b905-4a1c-9c38-9db3dd0b1304,ZhiChengAFuAntiFraud,1004,2019-12-24 21:48:53
                log.info("删除重复数据ST:"+i);
                String[] arry = tidbCallRecordCFList.get(i).trim().split(",");
                Stopwatch callRStopwatch = Stopwatch.createStarted();

                String DELETE_CALL_SQL = "delete from call_record where id=##ID## AND transaction_id ='##TRANSACTION_ID##';";

                String CALL_SQL = "select * from call_record where transaction_id ='" + arry[0] + "' and uuid ='" + arry[1] +"'"
                        +" and url_type ='" + arry[2] + "' and code ='" +arry[3]+ "'; ";
                List<CallRecord3> queryResult = tidbRiskJdbcTemplate.query(CALL_SQL, new BeanPropertyRowMapper<>(CallRecord3.class));

                int size = (queryResult!=null ? queryResult.size(): 0);

                if(queryResult!=null && queryResult.size()==2){
                    CallRecord3 bean1 = queryResult.get(0);
                    CallRecord3 bean2 = queryResult.get(1);
                    int second = Math.abs(bean1.getCreatedAt().compareTo(bean2.getCreatedAt()));
                    if(second <=3){
                        if(StringUtils.isEmpty(bean1.getRequestUrl()) && StringUtils.isEmpty(bean1.getChannelId())
                                && ( StringUtils.isNotEmpty(bean2.getRequestUrl()) || StringUtils.isNotEmpty(bean2.getChannelId())
                                || StringUtils.isNotEmpty(bean2.getChannelType())
                        )){
                            String sql = DELETE_CALL_SQL.replace("##ID##", ""+bean1.getId());
                            sql = sql.replace("##TRANSACTION_ID##", bean1.getTransactionId());
                            try {
                                FileUtils.write(new File(bakFileName), JSON.toJSONString(bean1)+"\r\n", "UTF-8", true);
                                int update =tidbRiskJdbcTemplate.update(sql);
                                log.info("删除bean1成功, sql: {} ,update: {} ",sql,update);
                            } catch (Exception e) {
                                log.error("删除bean1数据是不, sql: {} ",sql, e);
                            }

                        }else if(StringUtils.isEmpty(bean2.getRequestUrl()) && StringUtils.isEmpty(bean2.getChannelId())
                                && (StringUtils.isNotEmpty(bean1.getRequestUrl()) || StringUtils.isNotEmpty(bean1.getChannelId())
                                || StringUtils.isNotEmpty(bean1.getChannelType())
                        )){
                            String sql = DELETE_CALL_SQL.replace("##ID##", ""+bean2.getId());
                            sql = sql.replace("##TRANSACTION_ID##", bean2.getTransactionId());
                            try {
                                FileUtils.write(new File(bakFileName), JSON.toJSONString(bean2)+"\r\n", "UTF-8", true);
                                int update = tidbRiskJdbcTemplate.update(sql);
                                log.info("删除bean2成功, sql: {} , update: {} ",sql,update);
                            } catch (Exception e) {
                                log.error("删除bean2数据是不, sql: {} ",sql, e);
                            }

                        }else {
                            log.info("查询call_record表,发现其他情况, param: {} , List: {} ", tidbCallRecordCFList.get(i), (queryResult!=null ? JSON.toJSONString(queryResult): "null") );
                        }

                    }else{
                        log.info("查询call_record表,相差时间大于3秒, param: {} , List: {} ", tidbCallRecordCFList.get(i), (queryResult!=null ? JSON.toJSONString(queryResult): "null") );
                    }
                }else{
                    log.info("查询call_record表,list大小不为2, param: {} , size: {} , List: {} ", tidbCallRecordCFList.get(i), size, (queryResult!=null ? JSON.toJSONString(queryResult): "null") );
                }
            }
            log.info("----删除bean数据完成----");

        } catch (Exception e) {
            log.error("删除bean数据异常", e);
        }
    }

}
