package cn.quantgroup.report.domain.master;

import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;

@Data
@NoArgsConstructor
public class IntelliCreditRequestEvent {
  private Long id;

  private String uuid;

  private Date timeCreated;

  private Integer httpCode;

  private String responseMessage;

  private Integer mills;

  @Builder
  public IntelliCreditRequestEvent(Long id, String uuid, Integer httpCode, String responseMessage, Integer mills) {
    this.uuid = uuid;
    this.id = id;
    this.httpCode = httpCode;
    this.responseMessage = responseMessage;
    this.mills = mills;
    this.timeCreated = new Date();
  }
}